/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadPools {
    public static ExecutorService newExecutorService(int coreSize, int maxSize, int queueSize, int keepAlive, final String nameTemplate) {
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(queueSize);
        final ThreadGroup tg = new ThreadGroup(nameTemplate);
        tg.setDaemon(true);
        ThreadFactory fac = new ThreadFactory(){
            private int index = 0;

            public Thread newThread(Runnable r) {
                long stackSize = 262144L;
                String tn = nameTemplate + "_" + this.index++;
                Thread t = new Thread(tg, r, tn, stackSize);
                t.setDaemon(true);
                return t;
            }
        };
        ThreadPoolExecutor tp = new ThreadPoolExecutor(coreSize, maxSize, (long)keepAlive, TimeUnit.SECONDS, queue, fac);
        tp.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return tp;
    }

    public static ScheduledExecutorService newScheduledExecutorService(int coreSize, final String nameTemplate) {
        final ThreadGroup tg = new ThreadGroup(nameTemplate);
        tg.setDaemon(true);
        ThreadFactory fac = new ThreadFactory(){
            private int index = 0;

            public Thread newThread(Runnable r) {
                long stackSize = 262144L;
                String tn = nameTemplate + "_" + this.index++;
                Thread t = new Thread(tg, r, tn, stackSize);
                t.setDaemon(true);
                return t;
            }
        };
        ScheduledThreadPoolExecutor te = new ScheduledThreadPoolExecutor(coreSize, fac);
        te.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return te;
    }

    public static void sleep(long millis) {
        try {
            Thread.currentThread();
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ThreadPools() {
    }
}

