/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.util;

import com.tcbj.util.Beans;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xmls {
    private Xmls() {
    }

    public static Map toMap(String xml) {
        ByteArrayInputStream sin = new ByteArrayInputStream(xml.getBytes());
        return Xmls.toMap(sin);
    }

    public static Map toMap(InputStream in) {
        try {
            SAXReader reader = new SAXReader();
            reader.setValidation(false);
            reader.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
            Document doc = reader.read(in);
            return Xmls.toMap(doc.getRootElement());
        }
        catch (Exception ex) {
            throw new RuntimeException("\u89e3\u6790xml\u6210map\u5bf9\u8c61\u5f02\u5e38", ex);
        }
    }

    public static Map toMap(Element elem) {
        if (null == elem) {
            throw new IllegalArgumentException("\u65e0\u6548XML Element \u5bf9\u8c61, \u4e0d\u80fd\u4e3anull");
        }
        List elems = elem.elements();
        Map<String, Object> tar = Xmls.getAttributt(elem);
        for (Element item : elems) {
            Xmls.generateMap(tar, item);
        }
        return tar;
    }

    private static Map generateMap(Map container, Element elem) {
        String name = elem.getName();
        Object obj = container.get(name);
        if (null != obj) {
            if (!List.class.isInstance(obj)) {
                LinkedList newBean = new LinkedList();
                newBean.add(obj);
                container.put(name, newBean);
                Xmls.generateMap(container, elem);
            } else {
                List bean = (List)obj;
                if (elem.isTextOnly()) {
                    Map<String, Object> attrs = Xmls.getAttributt(elem);
                    if (!Beans.isEmpty(attrs)) {
                        attrs.put("_v", elem.getText());
                        bean.add(attrs);
                    } else {
                        bean.add(elem.getStringValue());
                    }
                } else {
                    List subs = elem.elements();
                    Map<String, Object> nodes = Xmls.getAttributt(elem);
                    bean.add(nodes);
                    for (Element item : subs) {
                        Xmls.generateMap(nodes, item);
                    }
                }
            }
            return container;
        }
        if (elem.isTextOnly()) {
            Map<String, Object> attrs = Xmls.getAttributt(elem);
            if (!Beans.isEmpty(attrs)) {
                attrs.put("_v", elem.getText());
                container.put(elem.getName(), attrs);
            } else {
                container.put(name, elem.getStringValue());
            }
        } else {
            List subs = elem.elements();
            Map<String, Object> nodes = Xmls.getAttributt(elem);
            container.put(name, nodes);
            for (Element item : subs) {
                Xmls.generateMap(nodes, item);
            }
        }
        return container;
    }

    private static Map<String, Object> getAttributt(Element e) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List attrs = e.attributes();
        if (!Beans.isEmpty(attrs)) {
            for (Attribute a : attrs) {
                map.put(a.getName(), a.getValue());
            }
        }
        return map;
    }

    public static void main(String[] args) throws Exception {
        File f = new File("e:\\Ability.hbm.xml");
        FileInputStream is = new FileInputStream(f);
        Map map = Xmls.toMap(is);
        System.out.println(map);
    }

    private static class IgnoreDTDEntityResolver
    implements EntityResolver {
        private IgnoreDTDEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
        }
    }
}

