/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.abilityreport;

import com.tcbj.crm.ability.AbilityService;
import com.tcbj.crm.abilityreport.AbilityReportCondition;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Ability;
import com.tcbj.crm.entity.AbilityRule;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.lob.SerializableClob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="abilityReportService")
public class AbilityReportService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private AbilityService abilityService;
    @Autowired
    private PersonnelService personnelService;

    private Map<String, Object> convertArrayToMap(String[] keys, Object[] array) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            Object value = null;
            if (array.length > i) {
                value = array[i];
            }
            map.put(key, value);
            ++i;
        }
        return map;
    }

    private Ability getAbility(String abilityId, List<Ability> abilitys) {
        if (StringUtils.isEmpty(abilityId)) {
            return null;
        }
        for (Ability ability : abilitys) {
            if (!ability.getId().equals(abilityId)) continue;
            return ability;
        }
        return null;
    }

    private Double calculateScore(Double value, Ability ability, List<AbilityRule> rules) {
        String abilityId = ability.getId();
        for (AbilityRule rule : rules) {
            if (!rule.getAbilityId().equals(abilityId) || !(value < rule.getToValue()) || !(value >= rule.getFromValue())) continue;
            return rule.getScore();
        }
        return 0.0;
    }

    private void calculateAbility(Map<String, Object> data, List<Ability> abilitys, List<AbilityRule> rules) {
        String _abilityIds = null;
        String _values = null;
        Object ids_tmp = data.get("abilityIds");
        Object vals_tmp = data.get("values");
        if (ids_tmp instanceof SerializableClob) {
            _abilityIds = StringUtils.getClob((SerializableClob)ids_tmp);
            data.put("abilityIds", _abilityIds);
        } else {
            _abilityIds = (String)ids_tmp;
        }
        if (vals_tmp instanceof SerializableClob) {
            _values = StringUtils.getClob((SerializableClob)vals_tmp);
            data.put("values", _values);
        } else {
            _values = (String)vals_tmp;
        }
        String[] blankArray = new String[]{};
        String[] abilityIds = _abilityIds == null ? blankArray : _abilityIds.split(",");
        String[] values = _values == null ? blankArray : _values.split(",");
        Double totalScore = 0.0;
        int i = 0;
        while (i < abilitys.size()) {
            Ability ability = abilitys.get(i);
            Double value = null;
            int j = 0;
            while (j < abilityIds.length) {
                if (ability.getId().equals(abilityIds[j]) && values.length > j) {
                    try {
                        value = Double.valueOf(values[j]);
                    }
                    catch (Exception exception) {}
                }
                ++j;
            }
            if (value != null) {
                data.put("value_" + i, value);
                Double score = this.calculateScore(value, ability, rules);
                totalScore = totalScore + ability.getRate() * score / 100.0;
                data.put("score_" + i, score);
                data.put("rate_" + i, ability.getRate());
            }
            ++i;
        }
        data.put("applyerName", Cache.getApplyerName((String)data.get("applyerId")));
        data.put("totalScore", totalScore);
    }

    public Page report(AbilityReportCondition condition, int pageno, int rowsize) {
        List<Ability> abilitys = this.abilityService.getAbilitys(condition.getPartnerId(), condition.getYear());
        List<AbilityRule> rules = this.abilityService.getAbilityRule(condition.getPartnerId(), condition.getYear());
        this.personnelService.getFRegionsByUserId(condition.getEmployeeId());
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        sb.append("select data.applyer_id, data.year, wm_concat(data.ability_id), wm_concat(data.value) ");
        sb.append(" from cx_ability_data data,CX_AWK_PRTNR_ACCOUNTLIST_VIEW customer where ");
        sb.append(" data.partner_id = ? ");
        sb.append(" and data.year = ? ");
        sb.append(" and data.applyer_id = customer.PARTNERID ");
        args.add(condition.getPartnerId());
        args.add(condition.getYear());
        if (StringUtils.isNotEmpty(condition.getApplyerName())) {
            sb.append(" and customer.PartnerName like ? ");
            args.add("%" + condition.getApplyerName() + "%");
        }
        String areaIds = null;
        if (StringUtils.isNotEmpty(condition.getAreaId())) {
            areaIds = "'" + condition.getAreaId() + "'";
        } else if (StringUtils.isNotEmpty(condition.getBigAreaId())) {
            areaIds = this.personnelService.getFRegionsById(condition.getPartnerId(), condition.getChannelId(), condition.getBigAreaId());
        } else if (StringUtils.isNotEmpty(condition.getChannelId())) {
            areaIds = this.personnelService.getFRegionsById(condition.getPartnerId(), condition.getChannelId(), null);
        }
        if (StringUtils.isNotEmpty(areaIds)) {
            sb.append(" and customer.REGIONID in ( ");
            sb.append(areaIds);
            sb.append(" )");
        }
        sb.append(" group by data.applyer_id, data.year ");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Page page = this.baseDao.searchBySql(sb.toString(), args.toArray(), rowsize, pageno, null);
        for (Object tmp : page.getList()) {
            String[] keys = new String[]{"applyerId", "year", "abilityIds", "values"};
            Map<String, Object> data = this.convertArrayToMap(keys, (Object[])tmp);
            this.calculateAbility(data, abilitys, rules);
            list.add(data);
        }
        page.setList(list);
        return page;
    }
}

