/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.account;

import com.tcbj.crm.account.AccountCondition;
import com.tcbj.crm.account.AccountService;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.EasCustAmountV;
import com.tcbj.crm.view.EasCustDocDetailV;
import com.tcbj.crm.view.EasCustDocSummaryV;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Arith;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/account"})
public class AccountController
extends BaseController {
    @Autowired
    AccountService accountService;
    @Autowired
    ClientService clientService;
    @Autowired
    ProductService productService;

    @RequestMapping(value={"/myList.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String myList(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, AccountCondition condition, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        List<Partner> tempList = this.clientService.getSuppliers(e.getCurrentPartner().getId());
        Page page = this.accountService.getMyAccountList(pageno, condition, e);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("partner", (Object)e.getCurrentPartner());
        if (tempList.size() > 0) {
            model.addAttribute("defaulSupplierId", (Object)tempList.get(0).getId());
        } else {
            model.addAttribute("defaulSupplierId", (Object)"");
        }
        return "account/myList.ftl";
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, AccountCondition condition, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        Page page = this.accountService.getListByPage(pageno, condition, e);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("partner", (Object)e.getCurrentPartner());
        return "account/list.ftl";
    }

    @RequestMapping(value={"/viewItme.do"}, method={RequestMethod.GET})
    public String viewItme(AccountCondition condition, Model model, HttpServletRequest request) {
        EmployeePartner partner = this.getCurrentEmployee().getCurrentPartner();
        List<EasCustDocSummaryV> easDetailList = this.accountService.getEasCustDocSummaryVList(condition);
        Double amt = this.loadDetail(condition, model);
        for (EasCustDocSummaryV detail : easDetailList) {
            if ("\u6536\u6b3e\u5355".equals(detail.getDocType())) {
                amt = Arith.sub((double)amt, (double)detail.getDocAmt());
            } else if ("\u9500\u552e\u53d1\u7968".equals(detail.getDocType())) {
                amt = Arith.add((double)detail.getDocAmt(), (double)amt);
            }
            detail.setEndAmount(amt);
        }
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("easDetailList", easDetailList);
        return "account/viewItmes.ftl";
    }

    private Double loadDetail(AccountCondition condition, Model model) {
        Customer customer = this.clientService.getCustomer(condition.getSupplierId(), condition.getApplyerId());
        condition.setCustomer(customer);
        EasCustAmountV easCustAmountV = this.accountService.getEasCustAmountV(condition);
        model.addAttribute("account", (Object)easCustAmountV);
        model.addAttribute("condition", (Object)condition);
        return easCustAmountV.getBeginningAmt();
    }

    @RequestMapping(value={"/viewProductItem.do"}, method={RequestMethod.GET})
    public String viewProductItem(AccountCondition condition, Model model, HttpServletRequest request) {
        EmployeePartner partner = this.getCurrentEmployee().getCurrentPartner();
        List<EasCustDocDetailV> easDetailList = this.accountService.getEasCustDocDetailVList(condition);
        this.loadDetail(condition, model);
        Double sumary = 0.0;
        for (EasCustDocDetailV detail : easDetailList) {
            sumary = Arith.add((double)sumary, (double)detail.getLineAmount());
        }
        model.addAttribute("sumary", (Object)sumary);
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("easDetailList", easDetailList);
        return "account/viewProductItem.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add(AccountCondition condition, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        this.accountService.saveHistory(condition, me);
        if ("1".equals(condition.getDi())) {
            return this.redirect("/account/myList.do");
        }
        return this.redirect("/account/list.do");
    }

    @RequestMapping(value={"/accountHistory.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String accountHistory(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, AccountCondition condition, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        Page page = this.accountService.getAccountList(pageno, condition, e);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("partner", (Object)e.getCurrentPartner());
        return "account/history.ftl";
    }
}

