/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.account;

import com.tcbj.crm.account.AccountCondition;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.AmountRead;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.EasCustAmountV;
import com.tcbj.crm.view.EasCustDocDetailV;
import com.tcbj.crm.view.EasCustDocSummaryV;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Arith;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="accountService")
public class AccountService {
    private static final Object EasCustAmountV = null;
    @Autowired
    BaseDao baseDao;
    @Autowired
    ClientService clientService;
    @Autowired
    ProductService productService;
    @Autowired
    PersonnelService personnelService;

    public Page getMyAccountList(int pageno, AccountCondition condition, Employee me) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)me.getCurrentPartner().getId()));
        hql.append(" from EasCustAmountV e, Customer c  where  e.applyerId = c.applyerId  ");
        hql.append(" and e.applyerId=? ");
        args.add(partner.getId());
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            hql.append(" and e.supplierId=? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getYearMounth())) {
            hql.append(" and e.yearMonth= ? ");
            args.add(condition.getYearMounth());
        }
        hql.append(" order by e.yearMonth desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        ArrayList<EasCustAmountV> tempList = new ArrayList<EasCustAmountV>();
        int i = 0;
        while (i < page.getList().size()) {
            Object[] obj = (Object[])page.getList().get(i);
            EasCustAmountV eas = (EasCustAmountV)obj[0];
            Customer customer = (Customer)obj[1];
            eas.setLeftAmt(Arith.sub((double)eas.getCurYearReceiveAmt(), (double)eas.getCurYearPaidInAmt()));
            eas.setCustomer(customer);
            tempList.add(eas);
            ++i;
        }
        page.setList(tempList);
        return page;
    }

    public List<Object[]> getAreaAmountVListByMonth(String type, String month) {
        List<Object[]> allList = this.getFactBackAmountByMonth(type, month);
        return allList;
    }

    private List<Object[]> getGiftAndMaterAmountByMonth(String type, String month) {
        String select = "";
        String group = "";
        if ("area".equals(type)) {
            select = " , cu.REGIONID ";
            group = " group by cu.REGIONID ";
        } else if ("bigArea".equals(type)) {
            select = " , cu.DISTRICTID ";
            group = " group by cu.DISTRICTID ";
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select sum(c.DOC_AMT) ");
        sql.append(select);
        sql.append(" from ");
        sql.append(" CX_EAS_CUST_DOC_SUMMARY_V c , ");
        sql.append(" CX_AWK_PRTNR_ACCOUNTLIST_VIEW cu, ");
        sql.append(" CX_EAS_CUST_DOC_DETAIL_V p, ");
        sql.append(" CX_AWK_PRODLIST_VIEW v ");
        sql.append(" where ");
        sql.append(" c.doc_num = p.doc_num and c.CUSTOMER_NUMBER = cu.PartnerId and ");
        sql.append(" v.row_id = p.product_id and ");
        sql.append(" c.doc_type = '\u6536\u6b3e\u5355'  and ");
        sql.append(" ( v.OrderProdType = 'GIFT' OR v.OrderProdType = 'NMATERIAL' ) and ");
        sql.append(" c.DOC_YYYYMM = ? ");
        sql.append(group);
        sql.append(" order by c.DOC_YYYYMM desc ");
        List list = this.baseDao.findBySql(sql.toString(), new Object[]{month});
        return list;
    }

    private List<Object[]> getFactBackAmountByMonth(String type, String month) {
        StringBuilder hql = new StringBuilder();
        hql.append(" select sum(e.CURRENT_PAID_IN_AMT) ");
        String select = "";
        String group = "";
        if ("area".equals(type)) {
            select = " , c.REGIONID ";
            group = " group by c.REGIONID ";
        } else if ("bigArea".equals(type)) {
            select = " , c.DISTRICTID ";
            group = " group by c.DISTRICTID ";
        }
        hql.append(select);
        hql.append(" from CX_EAS_CUST_AMOUNT_V e , CX_AWK_PRTNR_ACCOUNTLIST_VIEW c where e.CUSTOMER_NUMBER = c.PartnerId ");
        hql.append(" and e.YEAR_MONTH = ? ");
        hql.append(group);
        hql.append(" order by e.YEAR_MONTH desc ");
        List object = this.baseDao.findBySql(hql.toString(), new Object[]{month});
        return object;
    }

    public Page getListByPage(int pageno, AccountCondition condition, Employee me) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        String regionStr = this.personnelService.getFRegionsByUserId(me.getId());
        hql.append(" from EasCustAmountV e , Customer c  where e.supplierId=c.supplierId and e.applyerId=c.applyerId and e.supplierId=? ");
        args.add(me.getCurrentPartner().getId());
        hql.append(" and c.areaCode in ( ").append(regionStr).append(" )");
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and e.applyerId=? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getYearMounth())) {
            hql.append(" and e.yearMonth= ? ");
            args.add(condition.getYearMounth());
        }
        hql.append(" order by e.yearMonth desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        ArrayList<EasCustAmountV> tempList = new ArrayList<EasCustAmountV>();
        int i = 0;
        while (i < page.getList().size()) {
            Object[] obj = (Object[])page.getList().get(i);
            EasCustAmountV eas = (EasCustAmountV)obj[0];
            Customer customer = (Customer)obj[1];
            eas.setLeftAmt(Arith.sub((double)eas.getCurYearReceiveAmt(), (double)eas.getCurYearPaidInAmt()));
            eas.setCustomer(customer);
            tempList.add(eas);
            ++i;
        }
        page.setList(tempList);
        return page;
    }

    public List<EasCustDocSummaryV> getEasCustDocSummaryVList(AccountCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from EasCustDocSummaryV e where e.supplierId=? and e.applyerId =? and e.docYyyymm=? order by e.docDate ");
        args.add(condition.getSupplierId());
        args.add(condition.getApplyerId());
        args.add(condition.getYearMounth());
        return this.baseDao.findEntity(hql.toString(), args.toArray(), EasCustDocSummaryV.class);
    }

    public List<EasCustDocDetailV> getEasCustDocDetailVList(AccountCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from EasCustDocDetailV e where e.supplierId=? and e.applyerId =? and e.docYyyymm=? ");
        args.add(condition.getSupplierId());
        args.add(condition.getApplyerId());
        args.add(condition.getYearMounth());
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), EasCustDocDetailV.class);
        for (EasCustDocDetailV detail : list) {
            if (!StringUtils.isNotNull(detail.getProductId())) continue;
            Product product = this.productService.get(detail.getProductId());
            detail.setProduct(product);
        }
        return list;
    }

    public void saveHistory(AccountCondition condition, Employee me) {
        AmountRead amountRead = new AmountRead();
        amountRead.fillInitData(me);
        amountRead.setApplyerId(condition.getApplyerId());
        amountRead.setSupplierId(condition.getSupplierId());
        amountRead.setYearMonth(condition.getYearMounth());
        this.baseDao.save((Object)amountRead);
    }

    public Page getAccountList(int pageno, AccountCondition condition, Employee e) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from AmountRead where 1=1  and supplierId=? ");
        args.add(e.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getYearMounth())) {
            hql.append(" and yearMonth =? ");
            args.add(condition.getYearMounth());
        }
        hql.append(" order by createDt desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public EasCustAmountV getEasCustAmountV(AccountCondition condition) {
        String hql = " from EasCustAmountV  where supplierId=? and applyerId =? and yearMonth=? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(condition.getSupplierId());
        args.add(condition.getApplyerId());
        args.add(condition.getYearMounth());
        EasCustAmountV easCustAmountV = (EasCustAmountV)this.baseDao.findFirstEntity(hql, args.toArray(), EasCustAmountV.class);
        if (easCustAmountV == null) {
            easCustAmountV = new EasCustAmountV();
        } else {
            easCustAmountV.setLeftAmt(Arith.sub((double)easCustAmountV.getCurYearReceiveAmt(), (double)easCustAmountV.getCurYearPaidInAmt()));
        }
        return easCustAmountV;
    }
}

