/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.budget;

import com.tcbj.crm.budget.BudgetCondition;
import com.tcbj.crm.budget.BudgetItemCondition;
import com.tcbj.crm.entity.Budget;
import com.tcbj.crm.entity.BudgetItem;
import com.tcbj.crm.shop.ShopEnum;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BudgetService {
    @Autowired
    private BaseDao baseDao;

    public Page findAllBudgets(BudgetCondition con, Employee e, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" from Budget b where 1=1 and b.state <> 9 and b.partnerId=? ");
        args.add(e.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(con.getTarget())) {
            hql.append(" and b.target =? ");
            args.add(con.getTarget());
        }
        if (StringUtils.isNotEmpty(con.getYear())) {
            hql.append(" and b.year = ? ");
            args.add(Long.valueOf(con.getYear()));
        }
        if (StringUtils.isNotEmpty(con.getState())) {
            hql.append(" and b.state = ? ");
            args.add(con.getState());
        }
        hql.append(" order by  b.createDt desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        return page;
    }

    public Budget getBudgetById(String id) {
        return (Budget)this.baseDao.get(Budget.class, (Serializable)((Object)id));
    }

    public void addBudget(Budget budget, Employee me) {
        this.baseDao.save((Object)budget);
    }

    public void updateBudget(Budget budget, Employee me) {
        this.baseDao.update((Object)budget);
    }

    public void del(String id) {
        Budget budget = (Budget)this.baseDao.get(Budget.class, (Serializable)((Object)id));
        if (!budget.getState().equals(ShopEnum.ApproveState.pass.getValue())) {
            this.baseDao.delete((Object)budget);
        } else {
            budget.setState(ShopEnum.ApproveState.del.getValue());
            this.baseDao.update((Object)budget);
        }
    }

    public Page findBudgetAudits(BudgetCondition con, int pageno, Employee me) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" from Budget b where b.partnerId=?  ");
        args.add(me.getCurrentPartner().getId());
        if ("dealing".equals(con.getAuditType())) {
            hql.append(" and b.state = ? ");
            args.add(ShopEnum.ApproveState.audit.getValue());
        } else {
            hql.append(" and b.state in (?,?)");
            args.add(ShopEnum.ApproveState.notpass.getValue());
            args.add(ShopEnum.ApproveState.pass.getValue());
        }
        if (StringUtils.isNotEmpty(con.getTarget())) {
            hql.append(" and b.target =? ");
            args.add(con.getTarget());
        }
        if (StringUtils.isNotEmpty(con.getYear())) {
            hql.append(" and b.year = ? ");
            args.add(Long.valueOf(con.getYear()));
        }
        hql.append(" order by b.createDt desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public void saveAudit(String id, String state, Employee me, String remark) {
        Budget budget = this.getBudgetById(id);
        budget.setState(state);
        budget.setRemark(remark);
        budget.setAuditorId(me.getId());
        budget.setAuditDt(new Date());
        this.baseDao.update((Object)budget);
    }

    public BudgetItem getItem(String id) {
        return (BudgetItem)this.baseDao.get(BudgetItem.class, (Serializable)((Object)id));
    }

    public void updateItem(BudgetItem item) {
        this.baseDao.update((Object)item);
    }

    public Page getOrgPage(BudgetItemCondition con, int pageno) {
        String hql = "from BudgetItem b where b.budgetId = ? and channelId is null and areaId is null and bigareaId is null and sellerId is null ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        if (StringUtils.isNotEmpty(con.getType())) {
            hql = String.valueOf(hql) + "and b.type = ? ";
            args.add(con.getType());
        }
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<BudgetItem> getItems(BudgetItemCondition con) {
        String hql = "from BudgetItem b where b.budgetId = ? and channelId is null and areaId is null and bigareaId is null and sellerId is null ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        return this.baseDao.findEntity(hql, args.toArray(), BudgetItem.class);
    }

    public BudgetItem getBudgetItem(BudgetItemCondition con) {
        String hql = "from BudgetItem b where b.budgetId = ? and b.subType =? and channelId is null and areaId is null and bigareaId is null and sellerId is null ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        args.add(con.getSubType());
        return (BudgetItem)this.baseDao.findFirstEntity(hql, args.toArray(), BudgetItem.class);
    }

    public void addAndupdate(Budget budget, Employee me) {
        List<BudgetItem> list = budget.getList();
        for (BudgetItem bd : list) {
            if (StringUtils.isNotEmpty(bd.getId())) {
                this.baseDao.update((Object)bd);
                continue;
            }
            bd.setPartnerId(me.getCurrentPartner().getId());
            bd.fillInitData(me);
            bd.setBudgetId(budget.getId());
            bd.setState("0");
            bd.setAmountUpt(bd.getAmount());
            bd.setUsedAmount(0.0);
            bd.setTempAmount(0.0);
            bd.setUsingAmount(0.0);
            this.baseDao.save((Object)bd);
        }
    }

    public void delete(String id) {
        this.baseDao.deleteById(BudgetItem.class, (Serializable)((Object)id));
    }

    public boolean isExist(BudgetItemCondition con) {
        List items;
        boolean isExist = false;
        String hql = "from BudgetItem b where b.state = '0'";
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(con.getBudgetId())) {
            hql = String.valueOf(hql) + " and b.budgetId = ?";
            args.add(con.getBudgetId());
        }
        if (StringUtils.isNotEmpty(con.getType())) {
            hql = String.valueOf(hql) + " and b.type = ?";
            args.add(con.getType());
        }
        if (StringUtils.isNotEmpty(con.getSubType())) {
            hql = String.valueOf(hql) + "and b.subType = ? ";
            args.add(con.getSubType());
        }
        if (StringUtils.isNotEmpty(con.getId())) {
            hql = String.valueOf(hql) + " and b.id != ? ";
            args.add(con.getId());
        }
        if (StringUtils.isNotEmpty(con.getChannelId())) {
            hql = String.valueOf(hql) + " and b.channelId = ? ";
            args.add(con.getChannelId());
        }
        if ((items = this.baseDao.findEntity(hql.toString(), args.toArray(), BudgetItem.class)).size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    public boolean validateBudget(Budget budget, Employee me) {
        List list;
        StringBuffer hql = new StringBuffer();
        hql.append(" from Budget where partnerId=? and year=? and state <> 9");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(me.getCurrentPartner().getId());
        args.add(budget.getYear());
        if (StringUtils.isNotEmpty(budget.getId())) {
            hql.append(" and id <> ? ");
            args.add(budget.getId());
        }
        return (list = this.baseDao.findEntity(hql.toString(), args.toArray(), Budget.class)).size() == 0;
    }

    public Page getChannelPage(BudgetItemCondition con, int pageno) {
        String hql = "from BudgetItem b where b.budgetId = ? and b.state = '0' and b.channelId is not null and areaId is null and bigareaId is null and sellerId is null ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        if (StringUtils.isNotEmpty(con.getBudgetId())) {
            hql = String.valueOf(hql) + " and b.budgetId = ?";
            args.add(con.getBudgetId());
        }
        if (StringUtils.isNotEmpty(con.getType())) {
            hql = String.valueOf(hql) + "and b.type = ? ";
            args.add(con.getType());
        }
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<BudgetItem> getChannels(BudgetItemCondition con) {
        String hql = "from BudgetItem b where b.budgetId = ? and state='0' and b.channelId is not null and areaId is null and bigareaId is null and sellerId is null ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        return this.baseDao.findEntity(hql, args.toArray(), BudgetItem.class);
    }

    public Page getBigAreaPage(BudgetItemCondition con, int pageno) {
        String hql = "from BudgetItem b where b.budgetId = ? and b.state = '0' and b.bigareaId is not null and areaId is null and sellerId is null ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        if (StringUtils.isNotEmpty(con.getBudgetId())) {
            hql = String.valueOf(hql) + " and b.budgetId = ?";
            args.add(con.getBudgetId());
        }
        if (StringUtils.isNotEmpty(con.getType())) {
            hql = String.valueOf(hql) + "and b.type = ? ";
            args.add(con.getType());
        }
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<BudgetItem> getBigAreas(BudgetItemCondition con) {
        String hql = "from BudgetItem b where b.budgetId = ? and state='0' and b.bigareaId is not null and areaId is null and sellerId is null ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        return this.baseDao.findEntity(hql, args.toArray(), BudgetItem.class);
    }

    public Page getAreaPage(BudgetItemCondition con, int pageno) {
        String hql = "from BudgetItem b where b.budgetId = ? and b.state = '0' and b.areaId is not null and customerId is null and sellerId is null ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        if (StringUtils.isNotEmpty(con.getBudgetId())) {
            hql = String.valueOf(hql) + " and b.budgetId = ?";
            args.add(con.getBudgetId());
        }
        if (StringUtils.isNotEmpty(con.getType())) {
            hql = String.valueOf(hql) + "and b.type = ? ";
            args.add(con.getType());
        }
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<BudgetItem> getAreas(BudgetItemCondition con) {
        String hql = "from BudgetItem b where b.budgetId = ? and state='0' and b.areaId is not null and customerId is null and sellerId is null ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        return this.baseDao.findEntity(hql, args.toArray(), BudgetItem.class);
    }

    public Page getCustomerPage(BudgetItemCondition con, int pageno) {
        String hql = "from BudgetItem b where b.budgetId = ? and b.state = '0' and b.customerId is not null ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        if (StringUtils.isNotEmpty(con.getBudgetId())) {
            hql = String.valueOf(hql) + " and b.budgetId = ?";
            args.add(con.getBudgetId());
        }
        if (StringUtils.isNotEmpty(con.getType())) {
            hql = String.valueOf(hql) + "and b.type = ? ";
            args.add(con.getType());
        }
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<BudgetItem> getCustomers(BudgetItemCondition con) {
        String hql = "from BudgetItem b where b.budgetId = ? and state='0' and b.customerId is not null ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        return this.baseDao.findEntity(hql, args.toArray(), BudgetItem.class);
    }

    public Page getEmployeePage(BudgetItemCondition con, int pageno) {
        String hql = "from BudgetItem b where b.budgetId = ? and b.state = '0' and b.sellerId is not null";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        if (StringUtils.isNotEmpty(con.getBudgetId())) {
            hql = String.valueOf(hql) + " and b.budgetId = ?";
            args.add(con.getBudgetId());
        }
        if (StringUtils.isNotEmpty(con.getType())) {
            hql = String.valueOf(hql) + "and b.type = ? ";
            args.add(con.getType());
        }
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<BudgetItem> getEmployees(BudgetItemCondition con) {
        String hql = "from BudgetItem b where b.budgetId = ? and state='0' and b.sellerId is not null ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        return this.baseDao.findEntity(hql, args.toArray(), BudgetItem.class);
    }

    public Budget getBudget(Long year, String supplierId) {
        String hql = "from Budget where year = ? and partnerId = ? and state = '2'";
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(year);
        args.add(supplierId);
        return (Budget)this.baseDao.findFirstEntity(hql, args.toArray(), Budget.class);
    }

    public Page getAllPage(BudgetItemCondition con, int pageno) {
        String hql = "from BudgetItem b where b.budgetId = ? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getBudgetId());
        if (StringUtils.isNotEmpty(con.getType())) {
            hql = String.valueOf(hql) + "and b.type = ? ";
            args.add(con.getType());
        }
        hql = String.valueOf(hql) + " order by b.type desc,b.subType desc";
        return this.baseDao.search(hql.toString(), args.toArray(), 500, pageno);
    }
}

