/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.budget;

import com.tcbj.crm.budget.BudgetItemCondition;
import com.tcbj.crm.budget.BudgetService;
import com.tcbj.crm.channelType.ChannelTypeService;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.EmployeeService;
import com.tcbj.crm.entity.BudgetItem;
import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.region.RegionService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetVaildateService")
public class BudgetVaildateService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    ChannelTypeService channelTypeService;
    @Autowired
    RegionService regionService;
    @Autowired
    EmployeeService service;
    @Autowired
    BudgetService budgetService;
    @Autowired
    ClientService clientService;

    public Map<String, String> getChannelTypeMap(String partnerId) {
        List<ChannelType> list = this.channelTypeService.getChannelTypes(partnerId);
        HashMap<String, String> map = new HashMap<String, String>();
        for (ChannelType channelType : list) {
            map.put(channelType.getName(), channelType.getId());
        }
        return map;
    }

    public Map<String, String> getBigAreaMap(String partnerId) {
        List<Region> list = this.regionService.getBigAreas(partnerId);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Region region : list) {
            map.put(region.getRegionName(), region.getId());
        }
        return map;
    }

    public Map<String, String> getAreaMap(String partnerId) {
        List<Region> list = this.regionService.getAreas(partnerId);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Region region : list) {
            map.put(region.getRegionName(), region.getId());
        }
        return map;
    }

    public Map<String, String> getEmployeeMap(String partnerId) {
        List<PartnerContact> list = this.service.find(partnerId);
        HashMap<String, String> map = new HashMap<String, String>();
        for (PartnerContact partnerContact : list) {
            map.put(partnerContact.getContactName(), partnerContact.getId());
        }
        return map;
    }

    public Map<String, String> getCustomerMap(String partnerId) {
        List<Customer> list = this.clientService.findPartnerApplys(partnerId);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Customer customer : list) {
            map.put(customer.getApplyerName(), customer.getApplyerId());
        }
        return map;
    }

    public Map<String, Double> getOrgMapDB(BudgetItemCondition con, int number) {
        List<Object> sqlList = new ArrayList();
        switch (number) {
            case 1: {
                sqlList = this.budgetService.getItems(con);
                break;
            }
            case 2: {
                sqlList = this.budgetService.getChannels(con);
                break;
            }
            case 3: {
                sqlList = this.budgetService.getBigAreas(con);
                break;
            }
            case 4: {
                sqlList = this.budgetService.getAreas(con);
                break;
            }
        }
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (BudgetItem budgetItem : sqlList) {
            String key = "";
            switch (number) {
                case 1: {
                    key = String.valueOf(budgetItem.getTypeName()) + "," + budgetItem.getSubTypeName();
                    break;
                }
                case 2: {
                    key = String.valueOf(budgetItem.getTypeName()) + "," + budgetItem.getSubTypeName() + "," + budgetItem.getChannelName();
                    break;
                }
                case 3: {
                    key = String.valueOf(budgetItem.getTypeName()) + "," + budgetItem.getSubTypeName() + "," + budgetItem.getChannelName() + "," + budgetItem.getBigAreaName();
                    break;
                }
                case 4: {
                    key = String.valueOf(budgetItem.getTypeName()) + "," + budgetItem.getSubTypeName() + "," + budgetItem.getChannelName() + "," + budgetItem.getBigAreaName() + "," + budgetItem.getAreaName();
                    break;
                }
            }
            if (map.get(key) == null) {
                map.put(key, budgetItem.getAmount());
                continue;
            }
            Double count = MathUtils.add((Double)budgetItem.getAmount(), (Double)((Double)map.get(key)));
            map.put(key, count);
        }
        return map;
    }

    public Map<String, Double> getOrgMapDB2(BudgetItemCondition con, int number) {
        List<Object> sqlList = new ArrayList();
        switch (number) {
            case 1: {
                sqlList = this.budgetService.getChannels(con);
                break;
            }
            case 2: {
                sqlList = this.budgetService.getBigAreas(con);
                break;
            }
            case 3: {
                sqlList = this.budgetService.getAreas(con);
                break;
            }
            case 4: {
                sqlList = this.budgetService.getEmployees(con);
                break;
            }
        }
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (BudgetItem budgetItem : sqlList) {
            String key = "";
            switch (number) {
                case 1: {
                    key = String.valueOf(budgetItem.getTypeName()) + "," + budgetItem.getSubTypeName();
                    break;
                }
                case 2: {
                    key = String.valueOf(budgetItem.getTypeName()) + "," + budgetItem.getSubTypeName() + "," + budgetItem.getChannelName();
                    break;
                }
                case 3: {
                    key = String.valueOf(budgetItem.getTypeName()) + "," + budgetItem.getSubTypeName() + "," + budgetItem.getChannelName() + "," + budgetItem.getBigAreaName();
                    break;
                }
                case 4: {
                    key = String.valueOf(budgetItem.getTypeName()) + "," + budgetItem.getSubTypeName() + "," + budgetItem.getChannelName() + "," + budgetItem.getBigAreaName() + "," + budgetItem.getAreaName();
                    break;
                }
            }
            if (map.get(key) == null) {
                map.put(key, budgetItem.getAmount());
                continue;
            }
            Double count = MathUtils.add((Double)budgetItem.getAmount(), (Double)((Double)map.get(key)));
            map.put(key, count);
        }
        return map;
    }

    public Map<String, Double> getChannelCountAmount(List<BudgetItem> list, int number) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (BudgetItem budgetItem : list) {
            String key = "";
            switch (number) {
                case 1: {
                    key = String.valueOf(budgetItem.getTypeName()) + "," + budgetItem.getSubTypeName();
                    break;
                }
                case 2: {
                    key = String.valueOf(budgetItem.getTypeName()) + "," + budgetItem.getSubTypeName() + "," + budgetItem.getChannelName();
                    break;
                }
                case 3: {
                    key = String.valueOf(budgetItem.getTypeName()) + "," + budgetItem.getSubTypeName() + "," + budgetItem.getChannelName() + "," + budgetItem.getBigAreaName();
                    break;
                }
                case 4: {
                    key = String.valueOf(budgetItem.getTypeName()) + "," + budgetItem.getSubTypeName() + "," + budgetItem.getChannelName() + "," + budgetItem.getBigAreaName() + "," + budgetItem.getAreaName();
                    break;
                }
            }
            if (map.get(key) == null) {
                map.put(key, budgetItem.getAmount());
                continue;
            }
            Double count = MathUtils.add((Double)budgetItem.getAmount(), (Double)((Double)map.get(key)));
            map.put(key, count);
        }
        return map;
    }

    public Map<String, Region> getChannelTypeByRegionMap(String partnerId) {
        List<ChannelType> list = this.getChannelTypeChild(partnerId);
        HashMap<String, Region> map = new HashMap<String, Region>();
        for (ChannelType channelType : list) {
            System.out.println("--" + channelType.getName());
            if (channelType.getChildList().size() <= 0) continue;
            for (Region region1 : channelType.getChildList()) {
                System.out.println("----" + region1.getRegionName());
                map.put(String.valueOf(channelType.getName()) + region1.getRegionName(), region1);
            }
        }
        return map;
    }

    public Map<String, Region> getChannelTypeByBigRegionByRegionMap(String partnerId) {
        List<ChannelType> list = this.getChannelTypeChild(partnerId);
        HashMap<String, Region> map = new HashMap<String, Region>();
        for (ChannelType channelType : list) {
            System.out.println("--" + channelType.getName());
            if (channelType.getChildList().size() <= 0) continue;
            for (Region region1 : channelType.getChildList()) {
                System.out.println("----" + region1.getRegionName());
                if (region1.getChildList().size() <= 0) continue;
                for (Region region : region1.getChildList()) {
                    map.put(String.valueOf(channelType.getName()) + region1.getRegionName() + region.getRegionName(), region);
                }
            }
        }
        return map;
    }

    public List<ChannelType> getChannelTypeChild(String partnerId) {
        List<ChannelType> channelTypeList = this.channelTypeService.getChannelTypes(partnerId);
        List<Region> bigRegionList = this.regionService.getBigAreas(partnerId);
        List<Region> regionList = this.regionService.getAreas(partnerId);
        for (ChannelType channelType : channelTypeList) {
            for (Region r : bigRegionList) {
                if (!r.getParentId().equals(channelType.getId())) continue;
                channelType.addChild(r);
                for (Region m : regionList) {
                    if (!m.getParentId().equals(r.getId())) continue;
                    r.addChild(m);
                }
            }
        }
        return channelTypeList;
    }
}

