/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.check;

import com.tcbj.crm.check.CheckVouchCondition;
import com.tcbj.crm.entity.CheckVouch;
import com.tcbj.crm.entity.CheckVouchItem;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkvouchService")
public class CheckVouchService {
    @Autowired
    BaseDao baseDao;

    public void del(String id) throws Exception {
        CheckVouch cv = (CheckVouch)this.baseDao.get(CheckVouch.class, (Serializable)((Object)id));
        if (!cv.getCheckvouchFlag().equals("1")) {
            throw new Exception("\u4e0d\u80fd\u5220\u9664\u8be5\u6570\u636e");
        }
        Object[] args = new Object[]{id};
        String hql = "delete CheckVouchItem where checkVouchId=?";
        this.baseDao.executeHQL(hql, args);
        hql = "delete CheckVouch where id=?";
        this.baseDao.executeHQL(hql, args);
    }

    public Page findCheckVouchs(CheckVouchCondition condition) {
        StringBuffer HQL = new StringBuffer();
        HQL.append("select distinct o from CheckVouch o ,CheckVouchItem c,Product p where c.productId = p.id and o.id = c.checkVouchId ");
        ArrayList<Object> args = new ArrayList<Object>();
        if (StringUtils.isNotEmpty(condition.getCheckvouchFlag())) {
            HQL.append(" and o.checkvouchFlag = ? ");
            args.add(condition.getCheckvouchFlag());
        }
        if (StringUtils.isNotEmpty(condition.getPartnerId())) {
            HQL.append(" and o.orgId = ? ");
            args.add(condition.getPartnerId());
        }
        if (StringUtils.isNotEmpty(condition.getCheckvouchId())) {
            HQL.append(" and o.checkvouchId like ? ");
            args.add("%" + condition.getCheckvouchId() + "%");
        }
        if (condition.startDate != null) {
            HQL.append(" and o.createDt >= ? ");
            args.add(condition.getStartDate());
        }
        if (condition.endDate != null) {
            HQL.append(" and o.createDt <= ? ");
            args.add(condition.getEndDate());
        }
        if (StringUtils.isNotEmpty(condition.getProductNo())) {
            HQL.append(" and p.no = ? ");
            args.add(condition.getProductNo());
        }
        if (condition.getStates().size() > 0) {
            int i = 0;
            HQL.append(" and ( ");
            for (String state : condition.getStates()) {
                HQL.append(" state = ?");
                if (++i < condition.getStates().size()) {
                    HQL.append(" or ");
                }
                args.add(state);
            }
            HQL.append(" ) ");
        }
        HQL.append(" order by o.createDt desc ");
        return this.baseDao.searchForPager2(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, condition.getPageno().intValue());
    }

    public List<CheckVouchItem> getCheckVouchItems(String id) {
        String hql = "from CheckVouchItem where checkVouchId=?";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, CheckVouchItem.class);
    }

    public CheckVouch get(String id) {
        CheckVouch obj = (CheckVouch)this.baseDao.get(CheckVouch.class, (Serializable)((Object)id));
        obj.setCheckVouchItems(this.getCheckVouchItems(id));
        return obj;
    }

    public CheckVouch getSimpleCheckVouch(String id) {
        return (CheckVouch)this.baseDao.get(CheckVouch.class, (Serializable)((Object)id));
    }

    public void saveOrUpdate(CheckVouch checkVouch) {
        if (StringUtils.isEmpty(checkVouch.getId())) {
            this.baseDao.save((Object)checkVouch);
            for (CheckVouchItem checkVouchItem : checkVouch.getCheckVouchItems()) {
                checkVouchItem.setCheckVouchId(checkVouch.getId());
            }
            this.baseDao.save(checkVouch.getCheckVouchItems());
        } else {
            this.baseDao.update((Object)checkVouch);
            List<CheckVouchItem> newItemsCheckVouchItem = checkVouch.getCheckVouchItems();
            List<CheckVouchItem> itemsCheckVouchItem = this.getCheckVouchItems(checkVouch.getId());
            ArrayList<CheckVouchItem> updateItemsCheckVouchItem = new ArrayList<CheckVouchItem>();
            ArrayList<CheckVouchItem> appendItemsCheckVouchItem = new ArrayList<CheckVouchItem>();
            ArrayList<CheckVouchItem> delItemsCheckVouchItem = new ArrayList<CheckVouchItem>();
            for (CheckVouchItem ni : newItemsCheckVouchItem) {
                boolean isnew = true;
                for (CheckVouchItem i : itemsCheckVouchItem) {
                    if (!ni.getId().equals(i.getId())) continue;
                    i.update(ni);
                    isnew = false;
                    updateItemsCheckVouchItem.add(i);
                    break;
                }
                if (!isnew) continue;
                ni.setId(UUIDUtils.getId());
                ni.setCheckVouchId(checkVouch.getId());
                appendItemsCheckVouchItem.add(ni);
            }
            for (CheckVouchItem i : itemsCheckVouchItem) {
                boolean isdel = true;
                for (CheckVouchItem ni : newItemsCheckVouchItem) {
                    if (!ni.getId().equals(i.getId())) continue;
                    isdel = false;
                    break;
                }
                if (!isdel) continue;
                delItemsCheckVouchItem.add(i);
            }
            if (appendItemsCheckVouchItem.size() > 0) {
                this.baseDao.save(appendItemsCheckVouchItem);
            }
            if (updateItemsCheckVouchItem.size() > 0) {
                this.baseDao.update(updateItemsCheckVouchItem);
            }
            if (delItemsCheckVouchItem.size() > 0) {
                this.baseDao.deleteAll(delItemsCheckVouchItem);
            }
        }
    }

    public void updateState(String id, String state) {
        String hql = "update CheckVouch set state=? where id=?";
        Object[] args = new Object[]{state, id};
        this.baseDao.executeHQL(hql, args);
    }
}

