/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.client;

import com.tcbj.crm.client.ClientCondition;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PartnerAddressRecord;
import com.tcbj.crm.entity.PartnerRecord;
import com.tcbj.crm.siebel.service.ClientSiebelService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerAddress;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.PartnerShop;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="clientService")
public class ClientService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;

    public Customer get(String id) {
        return (Customer)this.baseDao.get(Customer.class, (Serializable)((Object)id));
    }

    public List<Partner> findNotOneself(String partenrId, String status) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append("from Partner where parentPartnerId =?");
        args.add(partenrId);
        HQL.append(" and startDt <= ? and nvl(endDt,sysdate) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.now());
        HQL.append(" order by createDt desc ");
        return this.baseDao.findEntity(HQL.toString(), args.toArray(), Partner.class);
    }

    public void getPartners(PartnerShop listPartners, List<PartnerShop> alist) {
        for (PartnerShop partner : listPartners.getChildPartnerShop()) {
            alist.add(partner);
            if (partner.getChildPartnerShop() == null) {
                return;
            }
            this.getPartners(partner, alist);
        }
    }

    public Map<String, PartnerShop> initPartnerShop() {
        HashMap<String, PartnerShop> partnerShopMap = new HashMap<String, PartnerShop>();
        List partnerShop = this.baseDao.findEntity("from PartnerShop", PartnerShop.class);
        for (PartnerShop p : partnerShop) {
            partnerShopMap.put(p.getId(), p);
        }
        for (PartnerShop partner : partnerShopMap.values()) {
            PartnerShop parent = (PartnerShop)partnerShopMap.get(partner.getParentPartnerId());
            if (parent == null) continue;
            parent.getChildPartnerShop().add(partner);
        }
        return partnerShopMap;
    }

    public List<PartnerShop> getPartner(String partenrId) {
        List<Customer> customers = this.findPartnerApplys(partenrId);
        Map<String, PartnerShop> partnerShops = this.initPartnerShop();
        PartnerShop listPartners = partnerShops.get(partenrId);
        ArrayList<PartnerShop> alist = new ArrayList<PartnerShop>();
        this.getPartners(listPartners, alist);
        ArrayList<PartnerShop> list = new ArrayList<PartnerShop>();
        HashMap<String, Customer> map = new HashMap<String, Customer>();
        for (Customer customer : customers) {
            map.put(customer.getApplyerId(), customer);
        }
        for (PartnerShop partner : alist) {
            if (map.get(partner.getId()) != null) continue;
            list.add(partner);
        }
        return list;
    }

    public Page findPartnerApplys(ClientCondition con, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String sb = this.personnelService.getFRegionsByUserId(con.getEmployeeId());
        HQL.append("from Customer c where supplierId=?");
        args.add(con.getPartnerId());
        if (con.isArea()) {
            HQL.append(" and (c.bigAreaCode in ( ");
            HQL.append(sb);
            HQL.append(") or c.areaCode in ( ");
            HQL.append(sb);
            HQL.append(" ))");
        }
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append(" and applyerName like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getAreaId())) {
            HQL.append(" and areaCode = ?");
            args.add(con.getAreaId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            HQL.append(" and bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getApplyerCode())) {
            HQL.append(" and applyerCode like ?");
            args.add("%" + con.getApplyerCode().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            HQL.append(" and createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            HQL.append(" and createDt <= ?");
            args.add(con.getCreateDtE());
        }
        HQL.append(" order by bigAreaCode,areaCode ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page findPartnerApplysValid(ClientCondition con, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String sb = this.personnelService.getFRegionsByUserId(con.getEmployeeId());
        HQL.append("from Customer c where supplierId=?");
        args.add(con.getPartnerId());
        HQL.append(" and (c.bigAreaCode in ( ");
        HQL.append(sb);
        HQL.append(") or c.areaCode in ( ");
        HQL.append(sb);
        HQL.append(" ))");
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append(" and applyerName like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getAreaId())) {
            HQL.append(" and areaCode = ?");
            args.add(con.getAreaId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            HQL.append(" and bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getApplyerCode())) {
            HQL.append(" and applyerCode like ?");
            args.add("%" + con.getApplyerCode().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            HQL.append(" and createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            HQL.append(" and createDt <= ?");
            args.add(con.getCreateDtE());
        }
        HQL.append(" and startdate <= ? and nvl(enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        HQL.append(" order by applyerCode ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page findPartnerApplyers(ClientCondition con, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append("from Customer c where c.supplierId=?");
        args.add(con.getPartnerId());
        HQL.append(" and c.applyerId not in(select s.applyerId from ContactPartner s where s.userId = ? ) ");
        args.add(con.getUserId());
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append(" and (c.applyerName like ? or c.applyerCode like ?) ");
            args.add("%" + con.getName().trim() + "%");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getAreaId())) {
            HQL.append(" and c.areaCode = ?");
            args.add(con.getAreaId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            HQL.append(" and c.bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (con.getCreateDtS() != null) {
            HQL.append(" and c.createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            HQL.append(" and c.createDt <= ?");
            args.add(con.getCreateDtE());
        }
        HQL.append(" and c.startdate <= ? and nvl(c.enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        HQL.append(" order by c.applyerCode ");
        return this.baseDao.search(HQL.toString(), args.toArray(), con.getRowsize().intValue(), pageno);
    }

    public Page findPartnerPost(ClientCondition con, int pageno) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append("from Customer c where c.supplierId=?");
        args.add(con.getPartnerId());
        HQL.append(" and c.applyerId not in(select s.applyerId from PostPartner s where s.postId = ? ) ");
        args.add(con.getUserId());
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append(" and (c.applyerName like ? or c.applyerCode like ?) ");
            args.add("%" + con.getName().trim() + "%");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getAreaId())) {
            HQL.append(" and c.areaCode = ?");
            args.add(con.getAreaId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            HQL.append(" and c.bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (con.getCreateDtS() != null) {
            HQL.append(" and c.createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            HQL.append(" and c.createDt <= ?");
            args.add(con.getCreateDtE());
        }
        HQL.append(" and c.startdate <= ? and nvl(c.enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        HQL.append(" order by c.applyerCode ");
        return this.baseDao.search(HQL.toString(), args.toArray(), con.getRowsize().intValue(), pageno);
    }

    public List<Customer> findPartnerApplys(String supplierId) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append(" from Customer c where c.supplierId=?");
        args.add(supplierId);
        HQL.append(" and startdate <= ? and nvl(enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        List list = this.baseDao.findEntity(HQL.toString(), args.toArray(), Customer.class);
        return list;
    }

    public List<Customer> findPartnerApplys(String supplierId, String applyerName, String areaId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" from Customer c where c.supplierId=?");
        args.add(supplierId);
        if (StringUtils.isNotEmpty(applyerName)) {
            hql.append(" and (c.applyerName like ? or c.applyerCode like ?) ");
            args.add("%" + applyerName + "%");
            args.add("%" + applyerName + "%");
        }
        if (StringUtils.isNotEmpty(areaId)) {
            hql.append(" and c.areaCode = ? ");
            args.add(areaId);
        }
        hql.append(" and startdate <= ? and nvl(enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        hql.append(" order by c.applyerCode ");
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Customer.class);
        return list;
    }

    public List<Customer> findRegionApplys(String supplierId, String userId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String sb = this.personnelService.getFRegionsByUserId(userId);
        hql.append(" from Customer c where c.supplierId=?");
        args.add(supplierId);
        hql.append(" and (c.bigAreaCode in ( ");
        hql.append(sb);
        hql.append(") or c.areaCode in ( ");
        hql.append(sb);
        hql.append(" ))");
        hql.append(" and startdate <= ? and nvl(enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        hql.append(" order by c.applyerCode ");
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Customer.class);
        return list;
    }

    public List<Customer> findRegionApplys(String supplierId, String userId, String applyerName, String areaId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String sb = this.personnelService.getFRegionsByUserId(userId);
        hql.append(" from Customer c where c.supplierId=?");
        args.add(supplierId);
        hql.append(" and (c.bigAreaCode in ( ");
        hql.append(sb);
        hql.append(") or c.areaCode in ( ");
        hql.append(sb);
        hql.append(" ))");
        if (StringUtils.isNotEmpty(applyerName)) {
            hql.append(" and (c.applyerName like ? or c.applyerCode like ?) ");
            args.add("%" + applyerName + "%");
            args.add("%" + applyerName + "%");
        }
        if (StringUtils.isNotEmpty(areaId)) {
            hql.append(" and c.areaCode = ? ");
            args.add(areaId);
        }
        hql.append(" and startdate <= ? and nvl(enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        hql.append(" order by c.applyerCode ");
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Customer.class);
        return list;
    }

    public List<Partner> getSuppliers(String applyerId) {
        ArrayList<String> args = new ArrayList<String>();
        String hql_1 = "from Customer c where c.applyerId=?";
        args.add(applyerId);
        List list = this.baseDao.findEntity(hql_1, args.toArray(), Customer.class);
        ArrayList<Partner> partnerList = new ArrayList<Partner>();
        for (Customer Customer2 : list) {
            partnerList.add((Partner)this.baseDao.get(Partner.class, (Serializable)((Object)Customer2.getSupplierId())));
        }
        return partnerList;
    }

    private List<PartnerAddress> getAddresses(String id) {
        String hql = "from PartnerAddress where partnerId=?";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, PartnerAddress.class);
    }

    private List<PartnerContact> getContacts(String id) {
        String hql = "from PartnerContact where partnerId=? and isContact='Y' ";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, PartnerContact.class);
    }

    public Partner getPartnerRecord(String id) {
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)id));
        partner.setContacts(this.getContacts(id));
        Customer customer = this.getCustomer(partner.getParentPartnerId(), partner.getId());
        partner.setAddresses(this.getAddresses(customer.getId()));
        return partner;
    }

    public Partner getNotAddressesPartnerRecord(String id) {
        Partner apply = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)id));
        if (apply != null) {
            apply.setContacts(this.getContacts(id));
        }
        return apply;
    }

    public String add(PartnerRecord partner, Employee em) {
        for (PartnerAddressRecord address : partner.getAddresses()) {
            address.setId(UUIDUtils.getId());
            address.setPartnerId(partner.getId());
        }
        ClientSiebelService ss = new ClientSiebelService();
        return ss.addOrUpdatePartnerToSiebel(partner, em);
    }

    public void updatePartner(PartnerRecord partner, Employee em) {
        ClientSiebelService ss = new ClientSiebelService();
        ss.addOrUpdatePartnerToSiebel(partner, em);
    }

    public Customer getCustomer(String id) {
        Customer Customer2 = (Customer)this.baseDao.get(Customer.class, (Serializable)((Object)id));
        Customer2.setAddresses(this.getPartnerAddresses(id));
        Customer2.setContacts(this.getContacts(Customer2.getApplyerId()));
        return Customer2;
    }

    public List<PartnerAddress> getPartnerAddresses(String partnerId) {
        String hql_1 = "from PartnerAddress where partnerId=?";
        Object[] args = new Object[]{partnerId};
        return this.baseDao.findEntity(hql_1, args, PartnerAddress.class);
    }

    public Customer getCustomerAddresses(String supplierId, String applyerId) {
        StringBuffer sb = new StringBuffer();
        sb.append("from Customer where supplierId = ? and applyerId = ? ");
        Object[] args = new Object[]{supplierId, applyerId};
        Customer customer = (Customer)this.baseDao.findFirstEntity(sb.toString(), args, Customer.class);
        if (customer == null) {
            return null;
        }
        customer.setAddresses(this.getPartnerAddresses(customer.getId()));
        return customer;
    }

    public Customer getCustomer(String supplierId, String applyerId) {
        StringBuffer sb = new StringBuffer();
        sb.append("from Customer where supplierId = ? and applyerId = ? ");
        Object[] args = new Object[]{supplierId, applyerId};
        Customer prtnr = (Customer)this.baseDao.findFirstEntity(sb.toString(), args, Customer.class);
        if (prtnr == null) {
            return null;
        }
        prtnr.setAddresses(this.getPartnerAddresses(prtnr.getId()));
        prtnr.setContacts(this.getContacts(prtnr.getApplyerId()));
        return prtnr;
    }

    public Customer getCustomerAlone(String supplierId, String applyerId) {
        StringBuffer sb = new StringBuffer();
        sb.append("from Customer where supplierId = ? and applyerId = ? ");
        Object[] args = new Object[]{supplierId, applyerId};
        Customer customer = (Customer)this.baseDao.findFirstEntity(sb.toString(), args, Customer.class);
        return customer;
    }

    public Customer getCodeAndSupplier(String code, String supplierId) {
        StringBuffer sb = new StringBuffer();
        sb.append("from Customer where supplierId = ? and applyerCode = ? ");
        Object[] args = new Object[]{supplierId, code};
        Customer prtnr = (Customer)this.baseDao.findFirstEntity(sb.toString(), args, Customer.class);
        return prtnr;
    }

    public boolean isInto(String supplierId, String applyerId) {
        StringBuffer sb = new StringBuffer();
        sb.append("from Customer where supplierId = ? and applyerId = ? ");
        Object[] args = new Object[]{supplierId, applyerId};
        Customer prtnr = (Customer)this.baseDao.findFirstEntity(sb.toString(), args, Customer.class);
        return StringUtils.isNull(prtnr);
    }

    public Customer getCustomerPartner(String supplierId, String applyerId) {
        StringBuffer sb = new StringBuffer();
        sb.append("from Customer where supplierId = ? and applyerId = ? ");
        Object[] args = new Object[]{supplierId, applyerId};
        Customer prtnr = (Customer)this.baseDao.findFirstEntity(sb.toString(), args, Customer.class);
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)supplierId));
        if (prtnr == null) {
            return null;
        }
        prtnr.setPartner(partner);
        return prtnr;
    }

    public Customer getCustomerByOutNo(String outNo) {
        String hql = " from Customer c where c.extCode =?";
        List list = this.baseDao.findEntity(hql, new Object[]{outNo}, Customer.class);
        if (list.size() > 0) {
            return (Customer)list.get(0);
        }
        return null;
    }
}

