/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.competition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.client.PartnerShopService;
import com.tcbj.crm.competition.CompetitionCondition;
import com.tcbj.crm.competition.CompetitionService;
import com.tcbj.crm.entity.CompetCost;
import com.tcbj.crm.entity.Competition;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.PartnerShop;
import com.tcbj.framework.util.Page;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/competition"})
public class CompetitionController
extends BaseController {
    @Autowired
    CompetitionService service;
    @Autowired
    PartnerShopService partnerShopService;
    @Autowired
    ClientService clientService;

    @RequestMapping(value={"/list.do"})
    public String applys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, CompetitionCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setPartnerId(me.getCurrentPartner().getId());
        Page page = this.service.getPage(con, pageno);
        model.addAttribute("page", (Object)page);
        return "competition/list.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String apply(Model model) {
        Employee me = this.getCurrentEmployee();
        PartnerShop partnerShop = this.partnerShopService.get(me.getCurrentPartner().getId());
        String parPartnerId = me.getCurrentPartner().getParPartnerId();
        parPartnerId = StringUtils.isEmpty((Object)parPartnerId) ? me.getCurrentPartner().getId() : parPartnerId;
        Customer customer = this.clientService.getCustomer(parPartnerId, me.getCurrentPartner().getId());
        Competition competition = new Competition();
        competition.fillInitData(me);
        competition.setProvince(partnerShop.getProvinceName());
        competition.setCity(partnerShop.getCityName());
        competition.setChannelId(partnerShop.getSaleChannelTypeName());
        if (customer != null) {
            competition.setBigArea(customer.getBigAreaName());
        }
        model.addAttribute("competition", (Object)competition);
        return "competition/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    public String applyDo(Competition competition, CompetitionCondition com, HttpServletRequest request, Model model) throws AxisFault {
        Employee me = this.getCurrentEmployee();
        String rtn = null;
        List<IUploadFile> filelist = this.uploadFile(request, "competition");
        List competCosts = JSONArray.parseArray((String)com.getJson(), CompetCost.class);
        competition.setCompetCosts(competCosts);
        competition.setPartnerId(me.getCurrentPartner().getId());
        competition.fillInitData(me);
        this.service.save(competition, filelist, me);
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/del.do"})
    public String del(String id, Model model) {
        this.service.del(id);
        return this.redirect("/competition/list.do");
    }

    @RequestMapping(value={"/del2.do"})
    public String del2(String id, Model model) {
        this.service.update(id);
        return this.redirect("/competition/list.do");
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String id, Model model) {
        Competition competition = this.service.get(id);
        model.addAttribute("competition", (Object)competition);
        model.addAttribute("cost", (Object)JSON.toJSONString(competition.getCompetCosts()));
        return "competition/look.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit(String id, Model model) {
        Competition competition = this.service.get(id);
        model.addAttribute("competition", (Object)competition);
        model.addAttribute("cost", (Object)JSON.toJSONString(competition.getCompetCosts()));
        return "competition/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    public String editPost(Competition competition, CompetitionCondition com, HttpServletRequest request, Model model) {
        Employee me = this.getCurrentEmployee();
        String rtn = null;
        List<IUploadFile> filelist = this.uploadFile(request, "competition");
        List competCosts = JSONArray.parseArray((String)com.getJson(), CompetCost.class);
        competition.setCompetCosts(competCosts);
        competition.setPartnerId(me.getCurrentPartner().getId());
        competition.fillInitData(me);
        this.service.update(competition, filelist, me, com);
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }
}

