/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.dataupload;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.dataupload.DataUploadCondition;
import com.tcbj.crm.dataupload.DataUploadService;
import com.tcbj.crm.dataupload.DataUploadUtils;
import com.tcbj.crm.entity.DataUpload;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/dataupload"})
public class DataUploadController
extends BaseController {
    @Autowired
    private DataUploadService service;

    @RequestMapping(value={"/productList.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String findMyProduct(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") DataUploadCondition condition, Model model) {
        Employee me = this.getCurrentEmployee();
        Page page = this.service.getProducts(condition, me, pageno);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("page", (Object)page);
        return "/dataupload/productList.ftl";
    }

    @RequestMapping(value={"/toUpload.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String toUpload(DataUploadCondition condtion, HttpServletRequest request, Model model) {
        String type = request.getParameter("type");
        String paramsId = request.getParameter("paramsId");
        this.getCurrentEmployee().getCurrentPartner();
        if ("product".equals(type)) {
            Product product = this.service.getProduct(paramsId);
            model.addAttribute("product", (Object)product);
            return "/dataupload/productUpload.ftl";
        }
        if ("license".equals(type)) {
            return "/dataupload/licenseUpload.ftl";
        }
        return "/dataupload/criterionUpload.ftl";
    }

    @RequestMapping(value={"/uploadProduct.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String UploadProduct(DataUpload dataUplad, HttpServletRequest request, Model model) {
        Employee me = this.getCurrentEmployee();
        List<IUploadFile> uploadFilelist = this.uploadFile(request, "product");
        this.service.saveUpload(uploadFilelist, dataUplad, me);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(null)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/viewProduct.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String viewProduct(String type, String canDel, String paramsId, Model model) {
        Employee me = this.getCurrentEmployee();
        Product product = this.service.getProduct(paramsId);
        List<DataUpload> productFileList = this.service.findUploadProducts(type, paramsId);
        model.addAttribute("paramsId", (Object)paramsId);
        model.addAttribute("me", (Object)me);
        model.addAttribute("canDel", (Object)canDel);
        model.addAttribute("productName", (Object)product.getName());
        model.addAttribute("fileList", productFileList);
        return "/dataupload/viewProductFiles.ftl";
    }

    @RequestMapping(value={"/licenseList.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String findLicense(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") DataUploadCondition condition, Model model) {
        Employee me = this.getCurrentEmployee();
        Page page = this.service.findLicense(condition, me, pageno);
        model.addAttribute("partner", (Object)me.getCurrentPartner());
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("page", (Object)page);
        return "/dataupload/licenseList.ftl";
    }

    @RequestMapping(value={"/uploadLicense.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String uploadLicense(DataUpload dataUplad, HttpServletRequest request, Model model) {
        Employee me = this.getCurrentEmployee();
        List<IUploadFile> uploadFilelist = DataUploadUtils.uploadFile(request, String.valueOf(DateUtils.formartDate((Date)new Date(), (String)"yyyy")) + me.getCurrentPartner().getNo(), "license");
        dataUplad.setParamsId(me.getCurrentPartner().getId());
        dataUplad.setEnclosureValue(me.getCurrentPartner().getParPartnerId());
        this.service.saveUpload(uploadFilelist, dataUplad, me);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(null)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/criterionList.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String findCriterion(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") DataUploadCondition condition, Model model) {
        Employee me = this.getCurrentEmployee();
        Page page = this.service.findCriterion(condition, me, pageno);
        model.addAttribute("partner", (Object)me.getCurrentPartner());
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("page", (Object)page);
        return "/dataupload/criterionList.ftl";
    }

    @RequestMapping(value={"/uploadCriterion.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String uploadCriterion(DataUpload dataUplad, HttpServletRequest request, Model model) {
        Employee me = this.getCurrentEmployee();
        List<IUploadFile> uploadFilelist = DataUploadUtils.uploadFile(request, String.valueOf(DateUtils.formartDate((Date)new Date(), (String)"yyyy")) + me.getCurrentPartner().getNo(), "criterion");
        dataUplad.setParamsId(me.getCurrentPartner().getId());
        dataUplad.setEnclosureValue(me.getCurrentPartner().getParPartnerId());
        this.service.saveUpload(uploadFilelist, dataUplad, me);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(null)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/cooperationList.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String findCooperation(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") DataUploadCondition condition, Model model) {
        Employee me = this.getCurrentEmployee();
        Page page = this.service.findCooperation(condition, me, pageno);
        model.addAttribute("partner", (Object)me.getCurrentPartner());
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("page", (Object)page);
        return "/dataupload/cooperationList.ftl";
    }

    @RequestMapping(value={"/del.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String del(HttpServletRequest request, String id, String paramsId, String type, Model model) throws IOException {
        this.service.deleteFile(id);
        if ("product".equals(type)) {
            return this.redirect("/dataupload/viewProduct.do?canDel=1&type=product&paramsId=" + paramsId);
        }
        return this.redirect("/dataupload/" + type + "List.do");
    }

    @RequestMapping(value={"/viewMorList.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String viewMoreList(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") DataUploadCondition condition, Model model) {
        Employee me = this.getCurrentEmployee();
        Page page = this.service.viewMoreByType(condition, me, pageno);
        condition.getType();
        if ("license".equals(condition.getType())) {
            model.addAttribute("nTitle", (Object)"\u8bc1\u7167");
        } else if ("criterion".equals(condition.getType())) {
            model.addAttribute("nTitle", (Object)"\u516c\u53f8\u5236\u5ea6");
        }
        model.addAttribute("partner", (Object)me.getCurrentPartner());
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("page", (Object)page);
        return "/dataupload/viewMoreList.ftl";
    }

    @RequestMapping(value={"/getViewProduct.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String getViewProduct(String type, String canDel, String paramsId, Model model) {
        Employee me = this.getCurrentEmployee();
        Product product = this.service.getProduct(paramsId);
        List<DataUpload> productFileList = this.service.findUploadProducts(type, paramsId);
        model.addAttribute("paramsId", (Object)paramsId);
        model.addAttribute("me", (Object)me);
        model.addAttribute("canDel", (Object)canDel);
        model.addAttribute("productName", (Object)product.getName());
        model.addAttribute("fileList", productFileList);
        return "/dataupload/getViewProductFiles.ftl";
    }
}

