/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.dataupload;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.dataupload.DataUploadService;
import com.tcbj.crm.entity.DataUpload;
import com.tcbj.crm.exception.AppException;
import com.tcbj.framework.dao.BaseDao;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/dataupload"})
public class DownLoadController
extends BaseController {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private DataUploadService service;

    @RequestMapping(value={"/downLoad.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void downloadNet(HttpServletRequest request, HttpServletResponse response, String id) throws IOException {
        DataUpload attachment = this.service.getDataUpload(id);
        String path = String.valueOf(request.getSession().getServletContext().getRealPath("/")) + attachment.getEnclosurePath();
        File file = new File(path);
        if (!file.exists() || file.isDirectory()) {
            throw new AppException("8004");
        }
        FileInputStream fis = new FileInputStream(new File(path));
        ServletOutputStream out = response.getOutputStream();
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + new String(attachment.getEnclosureName().getBytes("GBK"), "ISO8859-1") + "\"");
        byte[] b = new byte[1024];
        try {
            try {
                int len;
                while ((len = ((InputStream)fis).read(b)) > 0) {
                    out.write(b, 0, len);
                }
                out.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            try {
                ((InputStream)fis).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    @RequestMapping(value={"/previewImage.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String previewImage(HttpServletRequest request, String id, Model model) throws IOException {
        DataUpload attachment = this.service.getDataUpload(id);
        model.addAttribute("path", (Object)attachment.getEnclosurePath());
        return "/dataupload/preview.ftl";
    }
}

