/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.dimension;

import com.tcbj.crm.dimension.DimensionCondition;
import com.tcbj.crm.entity.Dimension;
import com.tcbj.crm.entity.ShoppeApplyFile;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dimensionService")
public class DimensionService {
    @Autowired
    BaseDao baseDao;

    public Dimension getById(String id) {
        return (Dimension)this.baseDao.get(Dimension.class, (Serializable)((Object)id));
    }

    public Page getPage(DimensionCondition con, int pageno) {
        String hql = "from Dimension t where t.creatorId = ? and t.state !='9'";
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getApplyerId());
        if (StringUtils.isNotEmpty(con.getState())) {
            hql = String.valueOf(hql) + "and t.state = ? ";
            args.add(con.getState());
        }
        if (StringUtils.isNotEmpty(con.getArea())) {
            hql = String.valueOf(hql) + "and t.area like ? ";
            args.add("%" + con.getArea() + "%");
        }
        if (StringUtils.isNotEmpty(con.getCompany())) {
            hql = String.valueOf(hql) + "and t.company like ? ";
            args.add("%" + con.getCompany() + "%");
        }
        if (StringUtils.isNotEmpty(con.getCodeNo())) {
            hql = String.valueOf(hql) + "and upper(t.codeNo) like upper(?)";
            args.add("%" + con.getCodeNo() + "%");
        }
        hql = String.valueOf(hql) + "order by t.created desc ";
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public void save(Dimension dimension, List<IUploadFile> filelist, Employee me) {
        this.baseDao.save((Object)dimension);
        ArrayList<ShoppeApplyFile> files = new ArrayList<ShoppeApplyFile>();
        for (IUploadFile iUploadFile : filelist) {
            ShoppeApplyFile f = new ShoppeApplyFile();
            f.fillInitData(me);
            f.setApplyId(dimension.getId());
            f.setFileName(iUploadFile.getName());
            f.setPath(iUploadFile.getWebPath());
            f.setSuffix(iUploadFile.getSuffix());
            files.add(f);
        }
        if (files.size() > 0) {
            this.baseDao.save(files);
        }
    }

    public void update(Dimension dimension, List<IUploadFile> filelist, DimensionCondition con, Employee me) {
        String[] fileids;
        this.baseDao.update((Object)dimension);
        String[] stringArray = fileids = con.getFileId().split(",");
        int n = fileids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtils.isEmpty(id)) {
                Object[] args = new Object[]{id};
                this.baseDao.executeHQL("delete ShoppeApplyFile where id= ?", args);
            }
            ++n2;
        }
        ArrayList<ShoppeApplyFile> files = new ArrayList<ShoppeApplyFile>();
        for (IUploadFile iUploadFile : filelist) {
            ShoppeApplyFile f = new ShoppeApplyFile();
            f.fillInitData(me);
            f.setApplyId(dimension.getId());
            f.setFileName(iUploadFile.getName());
            f.setPath(iUploadFile.getWebPath());
            f.setSuffix(iUploadFile.getSuffix());
            files.add(f);
        }
        this.baseDao.save(files);
    }

    public void delete(String id) {
        Object[] args = new Object[]{id};
        this.baseDao.executeHQL("delete ShoppeApplyFile where applyId= ?", args);
        this.baseDao.deleteById(Dimension.class, (Serializable)((Object)id));
        this.baseDao.deleteById(Dimension.class, (Serializable)((Object)id));
    }

    public void updateState(Dimension dimension) {
        this.baseDao.update((Object)dimension);
    }
}

