/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.base.BaseEntity;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.ExchangeDetail;
import com.tcbj.crm.view.PartnerAddress;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OrderApply
extends BaseEntity {
    private String bigAreaId;
    private List<OrderApplyItem> orderApplyItems;
    private String id;
    private String applyerId;
    private Date dt;
    private String no;
    private String orgId;
    private String supplierId;
    private String customerId;
    private String purchaseNo;
    private String areaCode;
    private String currencyCode;
    private String taxCode;
    private Double totalMoney;
    private String isAutoAccounding;
    private Double quantity;
    private String isCreditManaged;
    private String overCreditRemark;
    private Double fineTotalMoney = 0.0;
    private Double freeMoney = 0.0;
    private Double fineMoney = 0.0;
    private Double fineOverMoney = 0.0;
    private Double overTopMoneyRate;
    private Date predictArriveDt;
    private Double discountTotalMoney = 0.0;
    private Double discountCanuseMoney = 0.0;
    private Double discountMoney = 0.0;
    private Double giftDiscountTotalMoney = 0.0;
    private Double giftDiscountCanuseMoney = 0.0;
    private Double giftDiscountMoney = 0.0;
    private Double otherDiscountTotalMoney = 0.0;
    private Double otherDiscountCanuseMoney = 0.0;
    private Double otherDiscountMoney = 0.0;
    private Double freeGiftTotal = 0.0;
    private Double freeGiftOrder = 0.0;
    private Double freeGift = 0.0;
    private Double freeGiftMoney = 0.0;
    private Double remainMoney = 0.0;
    private Double retunsFullyMoney = 0.0;
    private Double retunsOvertopMoney = 0.0;
    private Double returnedMoney = 0.0;
    private String isDeliveryFreezed;
    private String settlementModeCode;
    private String shippingAddress;
    private String contacts;
    private String phone;
    private String salesman;
    private String orderContacts;
    private String orderPhone;
    private String source;
    private String deliveryCode;
    private String state;
    private String remark;
    private String orderTypeCode;
    private String nature;
    private String contractNo;
    private String isReport;
    private String returnsStorage;
    private String deliveryLevelCode;
    private String deliveryWarehouse;
    private String harvestWarehouse;
    private String approverId;
    private Date approveDt;
    private String disApplyerId;
    private String relatedApplyerId;
    private Double productTotalMoney;
    private Double giftTotalMoney;
    private Double giftQuantity;
    private Double actGiftQuantity;
    private String expectDate;
    private String exchangeOrderIds;
    private String oaIfaceCode;
    private Double totalScore;
    private Double totalQuantity;
    private Double totalScoreQuantity;
    private List<ExchangeDetail> scoreDetail;

    public OrderApply() {
        this.setCurrencyCode("CNY");
        this.setSource("\u624b\u5de5");
    }

    public OrderApply(String id, String applyerId, String supplierId, String nature, String state) {
        this.id = id;
        this.applyerId = applyerId;
        this.supplierId = supplierId;
        this.nature = nature;
        this.state = state;
    }

    public OrderApply(String id, String exchangeOrderIds) {
        this.id = id;
        this.exchangeOrderIds = exchangeOrderIds;
    }

    public void bindEditData(Customer customer, Employee me) {
        this.setOrderContacts(me.getName());
        this.setOrderPhone(me.getMobile());
        if (customer.getReceiptAddresses() != null && customer.getReceiptAddresses().size() > 0) {
            PartnerAddress address = customer.getReceiptAddresses().get(0);
            this.setContacts(address.getContactCode());
            this.setPhone(address.getContactPhone());
            this.setShippingAddress(address.getAddress());
            this.setHarvestWarehouse(address.getHarvestWarehouse());
            this.setDisApplyerId(address.getDisDelearId());
        }
    }

    public void bindOrderContacts(Employee me) {
        if (StringUtils.isEmpty(this.getOrderContacts())) {
            this.setOrderContacts(me.getName());
        }
        if (StringUtils.isEmpty(this.getOrderPhone())) {
            this.setOrderPhone(me.getMobile());
        }
    }

    public void bindCannotEditData(Customer customer, Employee me) {
        this.setIsReport("N");
        Long days = customer.getTransportOnlineCode();
        if (days != null) {
            int _days = days.intValue();
            this.setPredictArriveDt(DateUtils.getDateAfter((Date)new Date(), (int)_days));
        }
        this.setDeliveryLevelCode(customer.getDeliveryLevelCode());
        if (this.getNature().equals(TCBJEnum.OrderNature.buy.getValue())) {
            this.setOrderTypeCode(customer.getOrderTypeCode());
        } else {
            this.setOrderTypeCode(customer.getRtnOrderTypeCode());
        }
        this.setIsDeliveryFreezed(customer.getIsDeliveryFreezed());
        this.setTaxCode(customer.getSaleTax());
        if (StringUtils.isNotEmpty(customer.getAreaCode())) {
            this.setAreaCode(customer.getAreaCode());
        } else {
            this.setAreaCode(customer.getBigAreaCode());
        }
        this.setCurrencyCode(customer.getCurrencyCode());
        this.setSettlementModeCode(customer.getSettlementModeCode());
        this.setDeliveryCode(customer.getDeliveryCode());
        this.setIsCreditManaged(customer.getIsCreditManaged());
        this.setSalesman(customer.getCityManagerId());
        this.setRelatedApplyerId(customer.getRelatedDelearId());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getApplyerId() {
        return this.applyerId;
    }

    public String getApplyerName() {
        return Cache.getPartnerName(this.getApplyerId());
    }

    public String getClientAppNo() {
        return Cache.getPartnerCSN(this.getApplyerId());
    }

    public void setApplyerId(String applyerId) {
        this.applyerId = applyerId;
    }

    public Date getDt() {
        return this.dt;
    }

    public void setDt(Date dt) {
        this.dt = dt;
    }

    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getPurchaseNo() {
        return this.purchaseNo;
    }

    public void setPurchaseNo(String purchaseNo) {
        this.purchaseNo = purchaseNo;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public String getAreaName() {
        return Cache.getRegionsName(this.getAreaCode());
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getCurrencyName() {
        return Cache.getCurrencyTypeName(this.getCurrencyCode());
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public Double getTotalMoney() {
        return this.totalMoney;
    }

    public void setTotalMoney(Double totalMoney) {
        this.totalMoney = totalMoney;
    }

    public String getIsAutoAccounding() {
        return this.isAutoAccounding;
    }

    public void setIsAutoAccounding(String isAutoAccounding) {
        this.isAutoAccounding = isAutoAccounding;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public String getIsCreditManaged() {
        return this.isCreditManaged;
    }

    public String getIsCreditManagedName() {
        return Cache.getItemName("YON", this.getIsCreditManaged());
    }

    public void setIsCreditManaged(String isCreditManaged) {
        this.isCreditManaged = isCreditManaged;
    }

    public String getOverCreditRemark() {
        return this.overCreditRemark;
    }

    public void setOverCreditRemark(String overCreditRemark) {
        this.overCreditRemark = overCreditRemark;
    }

    public Double getFineMoney() {
        return this.fineMoney;
    }

    public void setFineMoney(Double fineMoney) {
        this.fineMoney = fineMoney;
    }

    public Double getOverTopMoneyRate() {
        return this.overTopMoneyRate;
    }

    public void setOverTopMoneyRate(Double overTopMoneyRate) {
        this.overTopMoneyRate = overTopMoneyRate;
    }

    public Date getPredictArriveDt() {
        return this.predictArriveDt;
    }

    public void setPredictArriveDt(Date predictArriveDt) {
        this.predictArriveDt = predictArriveDt;
    }

    public Double getRemainMoney() {
        return this.remainMoney;
    }

    public void setRemainMoney(Double remainMoney) {
        this.remainMoney = remainMoney;
    }

    public Double getTotalScoreQuantity() {
        return this.totalScoreQuantity;
    }

    public void setTotalScoreQuantity(Double totalScoreQuantity) {
        this.totalScoreQuantity = totalScoreQuantity;
    }

    public Double getDiscountMoney() {
        if (this.discountMoney == null) {
            this.discountMoney = 0.0;
        }
        return this.discountMoney;
    }

    public String getBigAreaId() {
        return this.bigAreaId;
    }

    public void setBigAreaId(String bigAreaId) {
        this.bigAreaId = bigAreaId;
    }

    public void setDiscountMoney(Double discountMoney) {
        this.discountMoney = discountMoney;
    }

    public Double getRetunsOvertopMoney() {
        return this.retunsOvertopMoney;
    }

    public void setRetunsOvertopMoney(Double retunsOvertopMoney) {
        this.retunsOvertopMoney = retunsOvertopMoney;
    }

    public Double getFullyMoney() {
        if (this.returnedMoney == null) {
            return 0.0;
        }
        if (this.retunsOvertopMoney == null) {
            return this.returnedMoney;
        }
        return this.returnedMoney - this.retunsOvertopMoney;
    }

    public Double getReturnedMoney() {
        return this.returnedMoney;
    }

    public void setReturnedMoney(Double returnedMoney) {
        this.returnedMoney = returnedMoney;
    }

    public String getIsDeliveryFreezed() {
        return this.isDeliveryFreezed;
    }

    public String getIsDeliveryFreezedName() {
        return Cache.getItemName("YON", this.getIsDeliveryFreezed());
    }

    public void setIsDeliveryFreezed(String isDeliveryFreezed) {
        this.isDeliveryFreezed = isDeliveryFreezed;
    }

    public String getSettlementModeCode() {
        return this.settlementModeCode;
    }

    public String getSettlementModeName() {
        return Cache.getItemName("TCBJ_SETTLEMENT_MODE", this.getSettlementModeCode());
    }

    public void setSettlementModeCode(String settlementModeCode) {
        this.settlementModeCode = settlementModeCode;
    }

    public String getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(String shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public String getContacts() {
        return this.contacts;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public String getDeliveryCode() {
        return this.deliveryCode;
    }

    public String getDeliveryName() {
        return Cache.getItemName("TCBJ_SHIPMENT_TYPE", this.getDeliveryCode());
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public Double getOtherDiscountTotalMoney() {
        return this.otherDiscountTotalMoney;
    }

    public void setOtherDiscountTotalMoney(Double otherDiscountTotalMoney) {
        this.otherDiscountTotalMoney = otherDiscountTotalMoney;
    }

    public Double getOtherDiscountCanuseMoney() {
        return this.otherDiscountCanuseMoney;
    }

    public void setOtherDiscountCanuseMoney(Double otherDiscountCanuseMoney) {
        this.otherDiscountCanuseMoney = otherDiscountCanuseMoney;
    }

    public Double getOtherDiscountMoney() {
        if (this.otherDiscountMoney == null) {
            this.otherDiscountMoney = 0.0;
        }
        return this.otherDiscountMoney;
    }

    public void setOtherDiscountMoney(Double otherDiscountMoney) {
        this.otherDiscountMoney = otherDiscountMoney;
    }

    public String getState() {
        if (this.state == null) {
            this.state = TCBJEnum.AuditState.draft.getValue();
        }
        return this.state;
    }

    public String getStateName() {
        String name = "\u672a\u77e5";
        int i = 0;
        while (i < TCBJEnum.AuditState.values().length) {
            TCBJEnum.AuditState s = TCBJEnum.AuditState.values()[i];
            if (s.getValue().equals(this.getState())) {
                name = s.getName();
                break;
            }
            ++i;
        }
        return "<span>" + name + "</span>";
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Double getProductTotalMoney() {
        return this.productTotalMoney;
    }

    public void setProductTotalMoney(Double productTotalMoney) {
        this.productTotalMoney = productTotalMoney;
    }

    public Double getGiftTotalMoney() {
        return this.giftTotalMoney;
    }

    public void setGiftTotalMoney(Double giftTotalMoney) {
        this.giftTotalMoney = giftTotalMoney;
    }

    public String getOrderTypeCode() {
        return this.orderTypeCode;
    }

    public String getOrderTypeName() {
        return Cache.getItemName("TCBJ_ORDER_TYPE", this.getOrderTypeCode());
    }

    public String getRtnOrderTypeName() {
        return Cache.getItemName("TCBJ_RETURN_ORDER_TYPE", this.getOrderTypeCode());
    }

    public void setOrderTypeCode(String type) {
        this.orderTypeCode = type;
    }

    public String getContractNo() {
        return this.contractNo;
    }

    public void setContractNo(String contractNo) {
        this.contractNo = contractNo;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getReturnsStorage() {
        return this.returnsStorage;
    }

    public void setReturnsStorage(String returnsStorage) {
        this.returnsStorage = returnsStorage;
    }

    public String getDeliveryLevelCode() {
        return this.deliveryLevelCode;
    }

    public String getDeliveryLevelName() {
        return Cache.getItemName("TCBJ_SHIPMENT_PRIORITY", this.getDeliveryLevelCode());
    }

    public void setDeliveryLevelCode(String deliveryLevelCode) {
        this.deliveryLevelCode = deliveryLevelCode;
    }

    public String getDeliveryWarehouse() {
        return this.deliveryWarehouse;
    }

    public void setDeliveryWarehouse(String deliveryWarehouse) {
        this.deliveryWarehouse = deliveryWarehouse;
    }

    public String getHarvestWarehouse() {
        return this.harvestWarehouse;
    }

    public void setHarvestWarehouse(String harvestWarehouse) {
        this.harvestWarehouse = harvestWarehouse;
    }

    public List<OrderApplyItem> getOrderApplyItems() {
        if (this.orderApplyItems == null) {
            this.orderApplyItems = new ArrayList<OrderApplyItem>();
        }
        return this.orderApplyItems;
    }

    public void setOrderApplyItems(List<OrderApplyItem> orderApplyItems) {
        this.orderApplyItems = orderApplyItems;
    }

    public String getSupplierId() {
        return this.supplierId;
    }

    public String getSupplierName() {
        return Cache.getPartnerName(this.getSupplierId());
    }

    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getNature() {
        if (this.nature == null) {
            this.nature = TCBJEnum.OrderNature.buy.getValue();
        }
        return this.nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getOrderContacts() {
        return this.orderContacts;
    }

    public void setOrderContacts(String orderContacts) {
        this.orderContacts = orderContacts;
    }

    public String getOrderPhone() {
        return this.orderPhone;
    }

    public void setOrderPhone(String orderPhone) {
        this.orderPhone = orderPhone;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getIsReport() {
        return this.isReport;
    }

    public String getIsReportName() {
        return Cache.getItemName("YON", this.getIsReport());
    }

    public void setIsReport(String isReport) {
        this.isReport = isReport;
    }

    public String getApproverId() {
        return this.approverId;
    }

    public String getApproverName() {
        return Cache.getEmployeeName(this.getApproverId());
    }

    public void setApproverId(String approverId) {
        this.approverId = approverId;
    }

    public Date getApproveDt() {
        return this.approveDt;
    }

    public void setApproveDt(Date approveDt) {
        this.approveDt = approveDt;
    }

    public Double getRetunsFullyMoney() {
        return this.retunsFullyMoney;
    }

    public void setRetunsFullyMoney(Double retunsFullyMoney) {
        this.retunsFullyMoney = retunsFullyMoney;
    }

    public Double getGiftDiscountMoney() {
        if (this.giftDiscountMoney == null) {
            this.giftDiscountMoney = 0.0;
        }
        return this.giftDiscountMoney;
    }

    public void setGiftDiscountMoney(Double giftDiscountMoney) {
        this.giftDiscountMoney = giftDiscountMoney;
    }

    public Double getDiscountTotalMoney() {
        return this.discountTotalMoney;
    }

    public void setDiscountTotalMoney(Double discountTotalMoney) {
        this.discountTotalMoney = discountTotalMoney;
    }

    public Double getDiscountCanuseMoney() {
        return this.discountCanuseMoney;
    }

    public void setDiscountCanuseMoney(Double discountCanuseMoney) {
        this.discountCanuseMoney = discountCanuseMoney;
    }

    public Double getGiftDiscountTotalMoney() {
        return this.giftDiscountTotalMoney;
    }

    public void setGiftDiscountTotalMoney(Double giftDiscountTotalMoney) {
        this.giftDiscountTotalMoney = giftDiscountTotalMoney;
    }

    public Double getGiftDiscountCanuseMoney() {
        return this.giftDiscountCanuseMoney;
    }

    public void setGiftDiscountCanuseMoney(Double giftDiscountCanuseMoney) {
        this.giftDiscountCanuseMoney = giftDiscountCanuseMoney;
    }

    public String getSalesman() {
        return this.salesman;
    }

    public void setSalesman(String salesman) {
        this.salesman = salesman;
    }

    public Double getFineTotalMoney() {
        return this.fineTotalMoney;
    }

    public void setFineTotalMoney(Double fineTotalMoney) {
        this.fineTotalMoney = fineTotalMoney;
    }

    public Double getFreeMoney() {
        if (this.freeMoney == null) {
            this.freeMoney = 0.0;
        }
        return this.freeMoney;
    }

    public void setFreeMoney(Double freeMoney) {
        this.freeMoney = freeMoney;
    }

    public Double getFineOverMoney() {
        return this.fineOverMoney;
    }

    public void setFineOverMoney(Double fineOverMoney) {
        this.fineOverMoney = fineOverMoney;
    }

    public String getDisApplyerId() {
        return this.disApplyerId;
    }

    public void setDisApplyerId(String disApplyerId) {
        this.disApplyerId = disApplyerId;
    }

    public String getRelatedApplyerId() {
        return this.relatedApplyerId;
    }

    public void setRelatedApplyerId(String relatedApplyerId) {
        this.relatedApplyerId = relatedApplyerId;
    }

    @Override
    public void fillInitData(Employee me) {
        this.setCreateDt(DateUtils.now());
        this.setCreatorId(me.getId());
        this.setLastUpdateDt(DateUtils.now());
        this.setLastUpdatorId(me.getId());
        this.setOrgId(me.getCurrentPartner().getOrganizationid());
    }

    public boolean isOrder() {
        return this.getNature().equals(TCBJEnum.OrderNature.buy.getValue());
    }

    public boolean isRtnOrder() {
        return this.getNature().equals(TCBJEnum.OrderNature.rtn.getValue());
    }

    public boolean isDraft() {
        return this.getState().equals(TCBJEnum.AuditState.draft.getValue());
    }

    public boolean isApprovedNotPass() {
        return this.getState().equals(TCBJEnum.AuditState.approveNoPass.getValue());
    }

    public boolean isNew() {
        return StringUtils.isEmpty(this.getId());
    }

    public Double getGiftQuantity() {
        return this.giftQuantity;
    }

    public void setGiftQuantity(Double giftQuantity) {
        this.giftQuantity = giftQuantity;
    }

    public Double getActGiftQuantity() {
        return this.actGiftQuantity;
    }

    public void setActGiftQuantity(Double actGiftQuantity) {
        this.actGiftQuantity = actGiftQuantity;
    }

    public Double getFreeGiftTotal() {
        return this.freeGiftTotal;
    }

    public void setFreeGiftTotal(Double freeGiftTotal) {
        this.freeGiftTotal = freeGiftTotal;
    }

    public Double getFreeGiftOrder() {
        return this.freeGiftOrder;
    }

    public Double getFreeGiftCanuse() {
        return (this.getFreeGiftTotal() == null ? 0.0 : this.getFreeGiftTotal()) + (this.getFreeGiftOrder() == null ? 0.0 : this.getFreeGiftOrder());
    }

    public void setFreeGiftOrder(Double freeGiftOrder) {
        this.freeGiftOrder = freeGiftOrder;
    }

    public Double getFreeGift() {
        return this.freeGift;
    }

    public void setFreeGift(Double freeGift) {
        this.freeGift = freeGift;
    }

    public Double getFreeGiftMoney() {
        if (this.freeGiftMoney == null) {
            this.freeGiftMoney = 0.0;
        }
        return this.freeGiftMoney;
    }

    public void setFreeGiftMoney(Double freeGiftMoney) {
        this.freeGiftMoney = freeGiftMoney;
    }

    public String getExchangeOrderIds() {
        if (StringUtils.isEmpty(this.exchangeOrderIds)) {
            return null;
        }
        if (this.exchangeOrderIds.substring(this.exchangeOrderIds.length() - 1).equals(",")) {
            this.exchangeOrderIds = this.exchangeOrderIds.substring(0, this.exchangeOrderIds.length() - 1);
        }
        return this.exchangeOrderIds;
    }

    public String[] getExchangeOrderIdArray() {
        String _ids = this.getExchangeOrderIds();
        if (StringUtils.isEmpty(_ids)) {
            return null;
        }
        return _ids.split(",");
    }

    public void setExchangeOrderIds(String exchangeOrderIds) {
        this.exchangeOrderIds = exchangeOrderIds;
    }

    public Double getTotalScore() {
        return this.totalScore;
    }

    public void setTotalScore(Double totalScore) {
        this.totalScore = totalScore;
    }

    public Double getTotalQuantity() {
        return this.totalQuantity;
    }

    public void setTotalQuantity(Double totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public List<ExchangeDetail> getScoreDetail() {
        if (this.scoreDetail == null) {
            return new ArrayList<ExchangeDetail>();
        }
        return this.scoreDetail;
    }

    public void setScoreDetail(List<ExchangeDetail> scoreDetail) {
        this.scoreDetail = scoreDetail;
    }

    public String getOaIfaceCode() {
        return this.oaIfaceCode;
    }

    public void setOaIfaceCode(String oaIfaceCode) {
        this.oaIfaceCode = oaIfaceCode;
    }

    public Map<String, Object> toLogiticsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("no", this.getNo());
        map.put("id", this.getId());
        map.put("dt", this.getDt());
        map.put("quantity", this.getQuantity());
        map.put("shippingAddress", this.getShippingAddress());
        map.put("contacts", this.getContacts());
        map.put("phone", this.getPhone());
        map.put("lastUpd", this.getDt());
        map.put("approveDt", this.getApproveDt());
        map.put("approveId", this.getApplyerId());
        map.put("approveName", this.getApproverName());
        map.put("applyerId", this.getApplyerId());
        map.put("applyerName", this.getApplyerName());
        map.put("state", this.getState());
        return map;
    }

    public String getExpectDate() {
        return this.expectDate;
    }

    public void setExpectDate(String expectDate) {
        this.expectDate = expectDate;
    }
}

