/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.expapply;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.entity.BudgetItem;
import com.tcbj.crm.entity.ExpApply;
import com.tcbj.crm.entity.ExpBalance;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.expapply.ExpCondition;
import com.tcbj.crm.expapply.ExpService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.ExpApplyView;
import com.tcbj.crm.view.ExpBalanceView;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/exp"})
public class ExpController
extends BaseController {
    @Autowired
    ExpService service;
    @Autowired
    OrderNoService orderNoService;

    @RequestMapping(value={"/applys.do"})
    public String applys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ExpCondition con, Model model) {
        Page page = this.service.getApplyPage(con, pageno);
        Map<String, String> map = this.service.getApplyByBalance(page.getList());
        model.addAttribute("map", map);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "expapply/applys.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(Model model) {
        Employee me = this.getCurrentEmployee();
        ExpApply expApply = new ExpApply();
        expApply.setOperatorId(me.getId());
        expApply.setSupplierId(me.getCurrentPartner().getId());
        expApply.setOperateDt(DateUtils.now());
        expApply.setYear(Long.valueOf(DateUtils.getYear()));
        model.addAttribute("expApply", (Object)expApply);
        model.addAttribute("orgName", (Object)me.getCurrentPartner().getName());
        return "expapply/apply.ftl";
    }

    private void validateCanApply(String orgId, Long year, String type, String targetId, String targetName, String itemCode) {
        BudgetItem item = this.service.getBudgetItem(orgId, year, type, targetId, itemCode);
        if (item == null) {
            throw new AppException("0010", year + "\u5e74 - " + targetName + " - " + Cache.getItemName("TCBJ_PACT_EXPENSE_TYPE", itemCode) + " , \u5e76\u672a\u7f16\u5236\u9884\u7b97");
        }
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result applyDo(@Valid @RequestBody ExpApply expApply, HttpServletRequest request, Model model) {
        Employee me = this.getCurrentEmployee();
        if (expApply.getAmount() == 0.0) {
            return this.getSuccessResult(null);
        }
        if ("org".equals(expApply.getBudgetTargetType())) {
            expApply.setBudgetTargetId(me.getCurrentPartner().getId());
        }
        if (StringUtils.isEmpty((Object)expApply.getApplyerId())) {
            expApply.setApplyerId(me.getCurrentPartner().getId());
        }
        this.validateCanApply(me.getCurrentPartner().getOrganizationid(), expApply.getYear(), expApply.getBudgetTargetType(), expApply.getBudgetTargetId(), expApply.getBudgetTargetName(), expApply.getExpensesItemCode());
        expApply.setOperateDt(new Date());
        expApply.setState("1");
        expApply.setApp("\u624b\u5de5");
        expApply.setSource("csp");
        expApply.setOperatorId(me.getId());
        expApply.setSupplierId(me.getCurrentPartner().getId());
        expApply.setNo(this.orderNoService.maxNo(me.getCurrentPartner().getNo(), "FYSQ"));
        this.service.saveApply(me.getCurrentPartner().getOrganizationid(), expApply);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/delApply.do"})
    public String delApplyDraft(String id, Model model) {
        this.service.delApply(id);
        return this.redirect("/exp/applys.do");
    }

    @RequestMapping(value={"/viewApply.do"}, method={RequestMethod.GET})
    public String viewApply(String id, Model model) {
        ExpApplyView expApply = this.service.getExpApplyView(id);
        model.addAttribute("expApply", (Object)expApply);
        return "expapply/viewApply.ftl";
    }

    @RequestMapping(value={"/balances.do"})
    public String balances(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ExpCondition con, Model model) {
        Page page = this.service.getBalancePage(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "expapply/balances.ftl";
    }

    @RequestMapping(value={"/balance.do"}, method={RequestMethod.GET})
    public String balance(Model model) {
        Employee me = this.getCurrentEmployee();
        ExpBalance expBalance = new ExpBalance();
        expBalance.setOperatorId(me.getId());
        expBalance.setSupplierId(me.getCurrentPartner().getId());
        expBalance.setOperateDt(DateUtils.now());
        expBalance.setYear(Long.valueOf(DateUtils.getYear()));
        model.addAttribute("expBalance", (Object)expBalance);
        model.addAttribute("orgName", (Object)me.getCurrentPartner().getName());
        return "expapply/balance.ftl";
    }

    @RequestMapping(value={"/balance.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result balanceDo(@Valid @RequestBody ExpBalance expBalance, HttpServletRequest request, Model model) {
        Employee me = this.getCurrentEmployee();
        if (expBalance.getAmount() == 0.0) {
            return this.getSuccessResult(null);
        }
        if ("org".equals(expBalance.getBudgetTargetType())) {
            expBalance.setBudgetTargetId(me.getCurrentPartner().getId());
        }
        if (StringUtils.isEmpty((Object)expBalance.getApplyerId())) {
            expBalance.setApplyerId(me.getCurrentPartner().getId());
        }
        this.validateCanApply(me.getCurrentPartner().getOrganizationid(), expBalance.getYear(), expBalance.getBudgetTargetType(), expBalance.getBudgetTargetId(), expBalance.getBudgetTargetName(), expBalance.getExpensesItemCode());
        expBalance.setOperateDt(new Date());
        expBalance.setState("1");
        expBalance.setApp("\u624b\u5de5");
        expBalance.setSource("csp");
        expBalance.setOperatorId(me.getId());
        expBalance.setSupplierId(me.getCurrentPartner().getId());
        expBalance.setNo(this.orderNoService.maxNo(me.getCurrentPartner().getNo(), "FYHX"));
        this.service.saveBalance(me.getCurrentPartner().getOrganizationid(), expBalance);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/delBalance.do"})
    public String delBalanceDraft(String id, Model model) {
        this.service.delBalance(id);
        return this.redirect("/exp/balances.do");
    }

    @RequestMapping(value={"/viewBalance.do"}, method={RequestMethod.GET})
    public String viewBalance(String id, Model model) {
        ExpBalanceView expBalance = this.service.getExpBalanceView(id);
        model.addAttribute("expBalance", (Object)expBalance);
        return "expapply/viewBalance.ftl";
    }

    @RequestMapping(value={"/selApplys.do"}, method={RequestMethod.GET})
    public String selApplys(Model model) {
        return "expapply/selApplys.ftl";
    }

    @RequestMapping(value={"/selApplyDatas.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page selApplyDatas(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ExpCondition condition, Model model) {
        condition.setIsBalanceSel("Y");
        return this.service.getApplyPage(condition, pageno);
    }
}

