/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.expbalance;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.ExpBalance;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="excelService")
public class ExcelService {
    @Autowired
    BaseDao baseDao;

    public List<String> saveExcel(Long year, Employee emp, List<List<Object>> datas) {
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<ExpBalance> list = new ArrayList<ExpBalance>();
        ExpBalance balance = null;
        Map<String, String> expenseTypeMap = this.getItenMap("TCBJ_PACT_EXPENSE_TYPE");
        int i = 0;
        while (i < datas.size()) {
            balance = new ExpBalance();
            List<Object> row = datas.get(i);
            Partner partner = Cache.getPartnerByNo((String)row.get(0));
            if (partner == null) {
                messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u5ba2\u6237\u52a9\u8bb0\u7801\u4e0d\u6b63\u786e\uff0c\u6ca1\u6709\u627e\u5230\u8be5\u5ba2\u6237");
            } else {
                balance.setApplyerId(partner.getId());
            }
            String type = (String)row.get(2);
            if (StringUtils.isEmpty(type)) {
                messages.add("\u7b2c" + i + "\u884c\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (expenseTypeMap.get(type) == null) {
                messages.add("\u7b2c" + i + "\u884c\u8d39\u7528\u7c7b\u578b\u975e\u6cd5\u7684\u6570\u636e");
            } else {
                balance.setExpensesItemCode(type);
            }
            try {
                Double amount = Double.valueOf((String)row.get(3));
                if (amount == null) {
                    messages.add("\u7b2c" + i + "\u884c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    balance.setAmount(amount);
                }
            }
            catch (Exception exception) {
                messages.add("\u7b2c" + i + "\u884c\u6570\u636e\u91d1\u989d\u6570\u636e\u683c\u5f0f\u6709\u9519\u8bef");
            }
            balance.setYear(year);
            balance.setSupplierId(emp.getCurrentPartner().getOrganizationid());
            balance.setOperatorId(emp.getId());
            balance.setOperatorName(emp.getName());
            balance.setState("0");
            balance.setOperateDt(new Date());
            balance.setBudgetTargetType("org");
            balance.setBudgetTargetId(emp.getCurrentPartner().getOrganizationid());
            balance.setSource("crm");
            balance.setBusinessId("1");
            list.add(balance);
            ++i;
        }
        if (messages.size() == 0) {
            this.baseDao.save(list);
        }
        return messages;
    }

    private Map<String, String> getItenMap(String type) {
        List<DictionaryItem> items = Cache.getItems(type);
        HashMap<String, String> map = new HashMap<String, String>();
        for (DictionaryItem dictionaryItem : items) {
            map.put(dictionaryItem.getName(), dictionaryItem.getVal());
        }
        return map;
    }
}

