/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.expbalance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.ExpApply;
import com.tcbj.crm.entity.ExpBalance;
import com.tcbj.crm.expapply.ExpService;
import com.tcbj.crm.expbalance.ExpBalanceCondition;
import com.tcbj.crm.expbalance.ExpBalanceService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/expbalance"})
public class ExpBalanceController
extends BaseController {
    @Autowired
    ExpBalanceService service;
    @Autowired
    ExpService expapplyService;

    @RequestMapping(value={"/list.do"})
    public String applys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ExpBalanceCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setOperatorId(me.getId());
        Page page = this.service.getPage(con, pageno);
        List<ExpApply> expApplys = this.service.getList(this.getCurrentEmployee().getId());
        model.addAttribute("expApplys", expApplys);
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)con);
        return "expbalance/list.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String apply(Model model) {
        Employee me = this.getCurrentEmployee();
        ExpBalance expApply = new ExpBalance();
        expApply.setOperatorId(me.getId());
        expApply.setSupplierId(me.getCurrentPartner().getId());
        model.addAttribute("expApply", (Object)expApply);
        return "expbalance/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result applyDo(@Valid @RequestBody ExpBalance expApply, HttpServletRequest request, Model model) {
        String budgetItemID = null;
        if (StringUtils.isEmpty(expApply.getActivityId())) {
            this.service.getAmount(expApply.getYear(), expApply.getSupplierId(), expApply.getExpensesItemCode(), expApply.getAmount());
        }
        expApply.setOperateDt(new Date());
        expApply.setState("0");
        expApply.setBudgetTargetType("org");
        expApply.setBudgetTargetId(expApply.getSupplierId());
        expApply.setSource("crm");
        expApply.setBusinessId("1");
        if (expApply.getActivityId() == null) {
            expApply.setApplyId(budgetItemID);
        }
        this.service.save(expApply);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/del.do"})
    public String del(String id, Model model) {
        this.service.del(id);
        return this.redirect("/expbalance/list.do");
    }

    @RequestMapping(value={"/del2.do"})
    public String del2(String id, Model model) {
        this.service.update(id);
        return this.redirect("/expbalance/list.do");
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String id, Model model) {
        ExpBalance expApply = this.service.get(id);
        List<ExpApply> expApplys = this.service.getList(this.getCurrentEmployee().getCurrentPartner().getId());
        model.addAttribute("expApplys", expApplys);
        model.addAttribute("expApply", (Object)expApply);
        return "expbalance/look.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit(String id, Model model) {
        ExpBalance expApply = this.service.get(id);
        model.addAttribute("expApply", (Object)expApply);
        return "expbalance/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPost(@Valid @RequestBody ExpBalance expApply, HttpServletRequest request, Model model) {
        ExpBalance balance = this.service.getExpBalance(expApply.getId());
        if (StringUtils.isEmpty(expApply.getActivityId())) {
            this.service.getAmount(expApply.getYear(), expApply.getSupplierId(), expApply.getExpensesItemCode(), MathUtils.sub((Double)expApply.getAmount(), (Double)balance.getAmount()));
        }
        this.service.update(expApply);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/AJAXApply.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result ajaxPartner(String id, HttpServletResponse response) {
        ExpApply expApply = this.expapplyService.get(id);
        String json = JSON.toJSONStringWithDateFormat((Object)expApply, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]);
        return this.getSuccessResult(json);
    }
}

