/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.fgift;

import com.tcbj.crm.aplfine.AplfineCondition;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.FreeBalance;
import com.tcbj.crm.entity.Gift;
import com.tcbj.crm.entity.GiftHis;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.fgift.FGiftCondition;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="fGiftService")
public class FGiftService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;

    public Page getgiftremainder(FGiftCondition con, int pageno) {
        String regionids = this.personnelService.getFRegionsByUserId(con.getEm().getId());
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(con.getEm().getCurrentPartner().getId());
        hql.append("from FreeBalance a,Customer b where( b.areaCode in (" + regionids + ") or b.bigAreaCode in (" + regionids + ") ) and a.applyerId=b.applyerId and a.supplierId=? and a.supplierId = b.supplierId");
        if (StringUtils.isNotEmpty(con.getClientId())) {
            hql.append(" and a.applyerId = ? ");
            args.add(con.getClientId());
        }
        if (StringUtils.isNotEmpty(con.getInspectType())) {
            hql.append(" and a.giftType = ? ");
            args.add(con.getInspectType());
        }
        if (con.getStartDate() != null) {
            hql.append(" and a.createDt >= ? ");
            args.add(con.getStartDate());
        }
        if (con.getEndDateHQL() != null) {
            hql.append(" and a.createDt <= ? ");
            args.add(con.getEndDateHQL());
        }
        hql.append(" order by a.createDt desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public String saveGiftRemainder(FreeBalance giftBalance) {
        List list = this.baseDao.findEntity("from FreeBalance a where a.applyerId=? ", new Object[]{giftBalance.getApplyerId()});
        if (list.size() > 0) {
            return "repeat";
        }
        this.baseDao.save((Object)giftBalance);
        return "true";
    }

    public FreeBalance getGiftRemainder(String id) {
        return (FreeBalance)this.baseDao.get(FreeBalance.class, (Serializable)((Object)id));
    }

    public void updateGiftRemainder(FreeBalance giftBalance) {
        FreeBalance entity = (FreeBalance)this.baseDao.get(FreeBalance.class, (Serializable)((Object)giftBalance.getId()));
        entity.setGiftType(giftBalance.getGiftType());
        this.baseDao.update((Object)entity);
    }

    public List<Object[]> getserialList(AplfineCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("from GiftHis a,FreeBalance b where a.giftBalanceId=b.id and b.id=? ");
        args.add(condition.getId());
        if (condition.getStartDate() != null) {
            hql.append(" and a.useDate >= ? ");
            args.add(condition.getStartDate());
        }
        if (condition.getEndDateHQL() != null) {
            hql.append(" and a.useDate <= ? ");
            args.add(condition.getEndDateHQL());
        }
        hql.append(" order by a.useDate desc ");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
    }

    public void addGiftHis(GiftHis giftHis) {
        FreeBalance balance = this.getGiftRemainder(giftHis.getGiftBalanceId());
        if (balance == null) {
            return;
        }
        String giftType = balance.getGiftType();
        if ("QUANTITY".equals(giftType)) {
            balance.setUseCount(MathUtils.add((Double)balance.getUseCount(), (Double)giftHis.getUseCount()));
            balance.setExtendCount(MathUtils.add((Double)balance.getExtendCount(), (Double)giftHis.getOrderGetCount()));
            balance.setUseAmount(MathUtils.add((Double)balance.getUseAmount(), (Double)MathUtils.mul((Double)giftHis.getUseCount(), (Double)4.0)));
            balance.setExtendAmount(MathUtils.add((Double)balance.getExtendAmount(), (Double)MathUtils.mul((Double)giftHis.getOrderGetCount(), (Double)4.0)));
        } else if ("AMOUNT".equals(giftType)) {
            balance.setUseAmount(MathUtils.add((Double)balance.getUseAmount(), (Double)giftHis.getUseAmount()));
            balance.setExtendAmount(MathUtils.add((Double)balance.getExtendAmount(), (Double)giftHis.getOrderGetAmount()));
        } else {
            return;
        }
        this.baseDao.update((Object)balance);
        this.baseDao.save((Object)giftHis);
    }

    private List<Gift> getGiftRuleList(String applyerId, String supplierId, Date orderDate) {
        List giftRuleList = this.baseDao.findEntity(" from Gift g where g.clientId = ? and g.organizationId = ? and g.startDate <= ? and nvl(g.endDate,?) >= ? ", new Object[]{applyerId, supplierId, orderDate, DateUtils.getEndTime(), orderDate}, Gift.class);
        return giftRuleList;
    }

    private List<GiftWarp> getGiftRuleList(String applyerId, String supplierId, Date orderDate, Map<String, List<OrderApplyItem>> list) {
        List<Gift> giftRuleList = this.getGiftRuleList(applyerId, supplierId, orderDate);
        ArrayList<GiftWarp> giftWarpList = new ArrayList<GiftWarp>();
        HashMap histroyQuantityMap = new HashMap();
        HashMap histroyAmountMap = new HashMap();
        HashMap<String, Gift> giftMap = new HashMap<String, Gift>();
        for (Gift gift : giftRuleList) {
            giftMap.put(gift.getId(), gift);
        }
        Set<String> giftIds = list.keySet();
        for (String giftId : giftIds) {
            List<OrderApplyItem> itemList = list.get(giftId);
            for (OrderApplyItem item : itemList) {
                Double historyAmount;
                Double historyQuantity;
                HashMap<String, Double> hqm = (HashMap<String, Double>)histroyQuantityMap.get(giftId);
                if (hqm == null) {
                    hqm = new HashMap<String, Double>();
                    histroyQuantityMap.put(giftId, hqm);
                }
                if ((historyQuantity = (Double)hqm.get(item.getProductId())) == null) {
                    historyQuantity = 0.0;
                    hqm.put(item.getProductId(), historyQuantity);
                }
                historyQuantity = MathUtils.add((Double)historyQuantity, (Double)(item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity()));
                hqm.put(item.getProductId(), historyQuantity);
                HashMap<String, Double> ham = (HashMap<String, Double>)histroyAmountMap.get(giftId);
                if (ham == null) {
                    ham = new HashMap<String, Double>();
                    histroyAmountMap.put(giftId, ham);
                }
                if ((historyAmount = (Double)ham.get(item.getProductId())) == null) {
                    historyAmount = 0.0;
                    ham.put(item.getProductId(), historyAmount);
                }
                double quantity = item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity();
                double price = item.getActPrice() == null || item.getActPrice() == 0.0 ? item.getPrice() : item.getActPrice();
                historyAmount = MathUtils.add((Double)historyAmount, (Double)MathUtils.mul((Double)quantity, (Double)price));
                ham.put(item.getProductId(), historyAmount);
            }
        }
        for (Gift giftRule : giftRuleList) {
            Double giftQuantity;
            HashMap amountMap;
            HashMap quantityMap = (HashMap)histroyQuantityMap.get(giftRule.getId());
            if (quantityMap == null) {
                quantityMap = new HashMap();
                histroyQuantityMap.put(giftRule.getId(), quantityMap);
            }
            if ((amountMap = (HashMap)histroyAmountMap.get(giftRule.getId())) == null) {
                amountMap = new HashMap();
                histroyAmountMap.put(giftRule.getId(), amountMap);
            }
            giftQuantity = (giftQuantity = (Double)quantityMap.get(giftRule.getGiftId())) == null ? 0.0 : giftQuantity;
            Double checkNum = Double.parseDouble(giftRule.getCheckNm());
            Double giftNum = Double.parseDouble(giftRule.getGiftNm());
            Double productQuantity = null;
            productQuantity = "AMOUNT".equals(giftRule.getInspectType()) ? (Double)amountMap.get(giftRule.getInspectProduct()) : (Double)quantityMap.get(giftRule.getInspectProduct());
            productQuantity = productQuantity == null ? 0.0 : productQuantity;
            Double times = MathUtils.getInt((Double)(productQuantity / checkNum));
            Double allGiftNum = MathUtils.mul((Double)times, (Double)giftNum);
            Double available = MathUtils.sub((Double)allGiftNum, (Double)giftQuantity);
            GiftWarp giftWarp = new GiftWarp(giftRule, available);
            giftWarpList.add(giftWarp);
        }
        return giftWarpList;
    }

    private Map<String, List<OrderApplyItem>> getHistoryOrderItemList(String applyerId, String supplierId, Date orderDate) {
        List<Gift> giftRuleList = this.getGiftRuleList(applyerId, supplierId, orderDate);
        if (giftRuleList.size() == 0) {
            return new HashMap<String, List<OrderApplyItem>>();
        }
        Date ruleStartDate = null;
        Date ruleEndDate = null;
        HashMap<String, List<OrderApplyItem>> resultMap = new HashMap<String, List<OrderApplyItem>>();
        for (Gift giftRule : giftRuleList) {
            HashMap<String, OrderApplyItem> historyMap = new HashMap<String, OrderApplyItem>();
            ArrayList historyOrderItemList = new ArrayList();
            ruleStartDate = giftRule.getStartDate();
            ruleEndDate = giftRule.getEndDate();
            if (ruleEndDate == null) {
                ruleEndDate = DateUtils.getEndTime();
            }
            List items = this.baseDao.findEntity("select o from OrderApplyItem o,OrderApply a where o.orderApplyId = a.id and a.applyerId = ? and a.supplierId = ? and a.dt > ? and a.dt < ? and a.state in ('2','3','4','5','6') ", new Object[]{applyerId, supplierId, ruleStartDate, ruleEndDate}, OrderApplyItem.class);
            for (OrderApplyItem item : items) {
                historyMap.put(item.getId(), item);
            }
            historyOrderItemList.addAll(historyMap.values());
            resultMap.put(giftRule.getId(), historyOrderItemList);
        }
        return resultMap;
    }

    public List<GiftWarp> getGiftRuleAvailableList(String applyerId, String supplierId, Date orderDate, List<OrderApplyItem> currentList, String orderId) {
        Map<String, List<OrderApplyItem>> historyList = this.getHistoryOrderItemList(applyerId, supplierId, orderDate);
        List<Gift> giftRuleList = this.getGiftRuleList(applyerId, supplierId, orderDate);
        for (Gift gift : giftRuleList) {
            List<OrderApplyItem> list = historyList.get(gift.getId());
            if (list == null) {
                list = new ArrayList<OrderApplyItem>();
                historyList.put(gift.getId(), list);
            }
            list.addAll(currentList);
        }
        if (orderId != null) {
            for (String key : historyList.keySet()) {
                List<OrderApplyItem> items = historyList.get(key);
                Iterator<OrderApplyItem> it = items.iterator();
                while (it.hasNext()) {
                    OrderApplyItem item = it.next();
                    if (item.getOrderApplyId() == null || !item.getOrderApplyId().equals(orderId)) continue;
                    it.remove();
                }
            }
        }
        return this.getGiftRuleList(applyerId, supplierId, orderDate, historyList);
    }

    public Page getFastSelect(String supplierId, ProductCondition con, int pageno) {
        ArrayList<Object> args = new ArrayList<Object>();
        String regions = this.personnelService.getFRegionsByUserId(con.getEm().getId());
        args.add(supplierId);
        StringBuffer sf = new StringBuffer();
        sf.append("from Customer a where ( a.areaCode in (" + regions + ") or a.bigAreaCode in (" + regions + ") ) and a.supplierId=? ");
        if (StringUtils.isNotEmpty(con.getProdname())) {
            sf.append(" and a.applyerName like ? ");
            args.add("%" + con.getProdname() + "%");
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            sf.append(" and a.applyerCode like ? ");
            args.add("%" + con.getNo() + "%");
        }
        if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            sf.append(" and a.partnerChnlType = ? ");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            sf.append(" and a.areaCode = ? ");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            sf.append(" and a.bigAreaCode = ? ");
            args.add(con.getBigAreaCode());
        }
        sf.append(" and a.startdate <= ? and nvl(a.enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        sf.append(" order by a.bigAreaCode,a.areaCode ");
        Page page = this.baseDao.search(sf.toString(), args.toArray(), 500, pageno);
        return page;
    }

    public static class GiftWarp {
        Gift gift = null;
        double available = 0.0;

        public GiftWarp(Gift gift, double available) {
            this.gift = gift;
            this.available = available;
        }

        public Gift getGift() {
            return this.gift;
        }

        public void setGift(Gift gift) {
            this.gift = gift;
        }

        public double getAvailable() {
            return this.available;
        }

        public void setAvailable(double available) {
            this.available = available;
        }
    }
}

