/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.freegift;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.GiftIntRebate;
import com.tcbj.crm.entity.RebateArea;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.freegift.FreeGiftCondition;
import com.tcbj.crm.freegift.FreeGiftService;
import com.tcbj.crm.freegift.GiftIntRebatemgWrap;
import com.tcbj.crm.gift.GiftCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/gift"})
public class FreeGiftController
extends BaseController {
    @Autowired
    FreeGiftService freeGiftService;

    @RequestMapping(value={"/rebateareaList.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(GiftCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) {
        Employee me = this.getCurrentEmployee();
        condition.setEm(me);
        Page page = this.freeGiftService.getRebateAreaList(pageno, condition);
        model.addAttribute("page", (Object)page);
        return "freegift/rebateareaList.ftl";
    }

    @RequestMapping(value={"/rebateareaList2.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list2(GiftCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) {
        Employee me = this.getCurrentEmployee();
        condition.setEm(me);
        Page page = this.freeGiftService.getRebateAreaList(pageno, condition);
        model.addAttribute("page", (Object)page);
        return "freegift/rebateareaList2.ftl";
    }

    @RequestMapping(value={"/addRebatearea.do"}, method={RequestMethod.GET})
    public String add_get() {
        return "freegift/add.ftl";
    }

    @RequestMapping(value={"/editRebatearea.do"}, method={RequestMethod.GET})
    public String edit_get(String id, Model model) {
        model.addAttribute("rebatearea", (Object)this.freeGiftService.getRebateArea(id));
        return "freegift/edit.ftl";
    }

    @RequestMapping(value={"/editRebatearea.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post(@Valid @RequestBody RebateArea rebateArea, BindingResult result, Model model) {
        Employee emp = this.getCurrentEmployee();
        if (StringUtils.isEmpty(rebateArea.getAreaId()) && StringUtils.isEmpty(rebateArea.getBigareaId())) {
            throw new AppException("");
        }
        if (StringUtils.isEmpty(rebateArea.getAreaId())) {
            rebateArea.setAreaId(rebateArea.getBigareaId());
        }
        rebateArea.setPartnerId(emp.getCurrentPartner().getId());
        rebateArea.setSource("\u624b\u5de5");
        rebateArea.fillInitData(emp);
        this.freeGiftService.updateRebateArea(rebateArea);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/allotRebatearea.do"}, method={RequestMethod.GET})
    public String allot_get(String id, Model model) {
        RebateArea rebateArea = this.freeGiftService.getRebateArea(id);
        List<GiftIntRebatemgWrap> list = this.freeGiftService.getGiftIntRebatemg(id);
        model.addAttribute("rebateArea", (Object)rebateArea);
        model.addAttribute("list", (Object)JSON.toJSONStringWithDateFormat(list, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("giftRegionIntrebatemgId", (Object)id);
        return "freegift/allotGiftIntRebatemg.ftl";
    }

    @RequestMapping(value={"/allotRebatearea.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result allot_post(@Valid @RequestBody FreeGiftCondition freeGiftCondition, Model model) {
        Employee emp = this.getCurrentEmployee();
        this.freeGiftService.saveAllot(emp, freeGiftCondition);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/addRebatearea.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result add_post(@Valid @RequestBody RebateArea rebateArea, BindingResult result) {
        Employee emp = this.getCurrentEmployee();
        if (StringUtils.isEmpty(rebateArea.getAreaId()) && StringUtils.isEmpty(rebateArea.getBigareaId())) {
            throw new AppException("");
        }
        if (StringUtils.isEmpty(rebateArea.getAreaId())) {
            rebateArea.setAreaId(rebateArea.getBigareaId());
        }
        rebateArea.setPartnerId(emp.getCurrentPartner().getId());
        rebateArea.setSource("\u624b\u5de5");
        rebateArea.fillInitData(emp);
        this.freeGiftService.saveRebateArea(rebateArea);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/giftInterbatemgList.do"}, method={RequestMethod.GET})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, FreeGiftCondition condition, Model model, HttpServletRequest request) {
        Employee em = this.getCurrentEmployee();
        condition.setSupplierId(em.getCurrentPartner().getId());
        condition.setUserId(em.getId());
        model.addAttribute("page", (Object)this.freeGiftService.getGiftInterbatemgList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        return "freegift/list.ftl";
    }

    @RequestMapping(value={"/viewHistory.do"}, method={RequestMethod.GET})
    public String viewIntRebate(String id, Model model) {
        List<GiftIntRebate> list = this.freeGiftService.getIntRebateHistoryById(id);
        model.addAttribute("list", list);
        model.addAttribute("id", (Object)id);
        return "freegift/viewHistory.ftl";
    }
}

