/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.intrebatemg;

import com.tcbj.crm.entity.IntRebate;
import com.tcbj.crm.entity.IntRebatemg;
import com.tcbj.crm.intrebatemg.IntRebatemgService;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.MathUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="intrebatemgFacadeService")
public class IntRebatemgFacadeService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    IntRebatemgService intRebatemgService;

    public Double[] getDiscount(String supplierId, String applyerId, Date date, Double[] _productMoney, Double[] _giftMoney, Integer precision) {
        List<IntRebatemg> list = this.intRebatemgService.getlist(supplierId, applyerId, date);
        double productCanuse = 0.0;
        double giftCanuse = 0.0;
        double productTotal = 0.0;
        double giftTotal = 0.0;
        double productMoney = _productMoney[0] == null ? 0.0 : _productMoney[0];
        double freezeProductMoney = _productMoney[1] == null ? 0.0 : _productMoney[1];
        double giftMoney = _giftMoney[0] == null ? 0.0 : _giftMoney[0];
        double freezeGiftMoney = _giftMoney[1] == null ? 0.0 : _giftMoney[1];
        for (IntRebatemg r : list) {
            double canuse;
            if ("PRODUCT".equals(r.getProducttype())) {
                canuse = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney());
                productTotal = MathUtils.add((Double)productTotal, (Double)canuse);
                continue;
            }
            if (!"GIFT".equals(r.getProducttype())) continue;
            canuse = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney());
            giftTotal = MathUtils.add((Double)giftTotal, (Double)canuse);
        }
        productTotal = MathUtils.sub((Double)productTotal, (Double)freezeProductMoney);
        giftTotal = MathUtils.sub((Double)giftTotal, (Double)freezeGiftMoney);
        productTotal = productTotal > 0.0 ? productTotal : 0.0;
        giftTotal = giftTotal > 0.0 ? giftTotal : 0.0;
        productCanuse = productTotal < MathUtils.mul((Double)productMoney, (Double)0.4) ? productTotal : MathUtils.mul((Double)productMoney, (Double)0.4);
        giftCanuse = giftTotal < MathUtils.mul((Double)giftMoney, (Double)1.0) ? giftTotal : MathUtils.mul((Double)giftMoney, (Double)1.0);
        precision = precision != null ? precision : 1;
        productTotal = MathUtils.getPrecision((Double)productTotal, (Integer)precision);
        productCanuse = MathUtils.getPrecision((Double)productCanuse, (Integer)precision);
        giftTotal = MathUtils.getPrecision((Double)giftTotal, (Integer)precision);
        giftCanuse = MathUtils.getPrecision((Double)giftCanuse, (Integer)precision);
        Double[] result = new Double[]{productTotal, productCanuse, giftTotal, giftCanuse};
        return result;
    }

    public void unuse(String orderId) {
        List list = this.baseDao.findEntity(" from IntRebate r where r.indentApplyId = ? and r.state = '1' ", new Object[]{orderId}, IntRebate.class);
        for (IntRebate r : list) {
            String rebateId = r.getRebateId();
            IntRebatemg intRebatemg = (IntRebatemg)this.baseDao.get(IntRebatemg.class, (Serializable)((Object)rebateId));
            if (intRebatemg != null) {
                intRebatemg.setWithheldMoney(MathUtils.sub((Double)intRebatemg.getWithheldMoney(), (Double)Double.valueOf(r.getWithheldMoney())));
                this.baseDao.update((Object)intRebatemg);
            }
            this.baseDao.executeHQL(" update IntRebate set state = ? where id = ?", new Object[]{0, r.getId()});
        }
    }

    public void use(String orderId, String orderNo, String applyerId, String supplierId, String operaterId, double orderSum, double useSum, Date orderDate, String type) {
        double used = 0.0;
        List<IntRebatemg> list = this.intRebatemgService.getlist(supplierId, applyerId, orderDate);
        for (IntRebatemg r : list) {
            if (!type.equals(r.getProducttype())) continue;
            if (used >= useSum) break;
            double canuse = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney());
            if (MathUtils.add((Double)used, (Double)canuse) > useSum) {
                canuse = MathUtils.sub((Double)useSum, (Double)used);
            }
            r.setWithheldMoney(MathUtils.add((Double)r.getWithheldMoney(), (Double)canuse));
            used = MathUtils.add((Double)used, (Double)canuse);
            this.baseDao.update((Object)r);
            if (!(canuse > 0.0)) continue;
            IntRebate intRebate = new IntRebate();
            operaterId = operaterId == null ? "0-1" : operaterId;
            intRebate.setCreatorId(operaterId);
            intRebate.setLastUpdatorId(operaterId);
            intRebate.setIndentApplyId(orderId);
            intRebate.setOrderNo(orderNo);
            intRebate.setRebateId(r.getId());
            intRebate.setWithheldMoney(String.valueOf(canuse));
            intRebate.setState(1);
            this.baseDao.save((Object)intRebate);
        }
    }
}

