/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.login;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.User;
import com.tcbj.crm.login.LoginService;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.right.RightService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ResourceUtils;
import com.tcbj.util.SessionUtils;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class LoginController
extends BaseController {
    @Autowired
    private LoginService service;
    @Autowired
    private PartnerService partnerService;
    @Autowired
    private RightService rightService;
    private static String wxn_url;
    private static String jld_orgId;
    private static String wxn_orgId;

    static {
        Properties p = ResourceUtils.getProperties((String)"classpath*:extenal_sys_conf.properties");
        if (Beans.isEmpty((Object)p)) {
            throw new RuntimeException("extenal_sys_conf.properties not find");
        }
        String env = p.getProperty("env", "dev");
        wxn_url = p.getProperty(String.valueOf(env) + "_wxn_url");
        jld_orgId = p.getProperty(String.valueOf(env) + "_jld_orgId");
        wxn_orgId = p.getProperty(String.valueOf(env) + "_wxn_orgId");
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
    }

    private void loadConfig(Model model) {
        model.addAttribute("wxn_url", (Object)wxn_url);
        model.addAttribute("jld_orgId", (Object)jld_orgId);
        model.addAttribute("wxn_orgId", (Object)wxn_orgId);
    }

    @RequestMapping(value={"/login.do"}, method={RequestMethod.GET})
    public String login(Model model) {
        User user = new User();
        model.addAttribute("user", (Object)user);
        this.loadConfig(model);
        return "login/newlogin.ftl";
    }

    @RequestMapping(value={"/relogin.do"}, method={RequestMethod.GET})
    public String relogin(Model model) {
        User user = new User();
        model.addAttribute("user", (Object)user);
        return "login/relogin.ftl";
    }

    @RequestMapping(value={"/login2.do"}, method={RequestMethod.GET})
    public String login2(Model model) {
        User user = new User();
        model.addAttribute("user", (Object)user);
        return "login/login2.ftl";
    }

    @RequestMapping(value={"/logout.do"}, method={RequestMethod.GET})
    public String logout(HttpServletRequest request) {
        SessionUtils.clearEmployee(request);
        return "redirect:login.do";
    }

    @RequestMapping(value={"/nologin.do"}, method={RequestMethod.GET})
    public String nologin(String account, Model model, HttpServletRequest request) {
        Employee e = this.service.noauth(account);
        List<EmployeePartner> partners = this.partnerService.findEmployeePartners(e.getId());
        e.setPartners(partners);
        if (partners.size() > 0) {
            e.setCurrentPartner(partners.get(0));
        }
        SessionUtils.setEmployee(request, e);
        this.rightService.cacheRights(request, e);
        return "redirect:index.do";
    }

    @RequestMapping(value={"/login.do"}, method={RequestMethod.POST})
    public String login_do(@Valid @ModelAttribute(value="user") User user, BindingResult br, Model model, HttpServletRequest request) {
        this.validatCode(user.getValidateCode(), br, request);
        this.loadConfig(model);
        if (br.hasErrors()) {
            return "login/newlogin.ftl";
        }
        Employee e = this.service.auth(user);
        if (e == null) {
            br.rejectValue("account", "user.account.error");
        }
        if (br.hasErrors()) {
            return "login/newlogin.ftl";
        }
        if (e.getEndDt() != null && e.getEndDt().getTime() <= DateUtils.now().getTime()) {
            br.rejectValue("account", "user.account.invalid");
        }
        if (br.hasErrors()) {
            return "login/newlogin.ftl";
        }
        List<EmployeePartner> partners = this.partnerService.findEmployeePartners(e.getId());
        e.setPartners(partners);
        if (partners.size() > 0) {
            e.setCurrentPartner(partners.get(0));
        } else {
            br.rejectValue("account", "user.account.logout");
        }
        if (br.hasErrors()) {
            return "login/newlogin.ftl";
        }
        SessionUtils.setEmployee(request, e);
        this.rightService.cacheRights(request, e);
        return "redirect:index.do";
    }

    private void validatCode(String vc, BindingResult br, HttpServletRequest request) {
        String code = (String)request.getSession().getAttribute("KAPTCHA_SESSION_KEY");
        if (vc == null || code == null || !vc.toLowerCase().equals(code.toLowerCase())) {
            br.rejectValue("account", "user.validateCodeError");
        }
    }
}

