/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.newdesktop;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.desktop.DesktopService;
import com.tcbj.crm.entity.DataUpload;
import com.tcbj.crm.entity.Notice;
import com.tcbj.crm.entity.PactMbo;
import com.tcbj.crm.entity.Position;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.entity.Target;
import com.tcbj.crm.entity.TargetData;
import com.tcbj.crm.notice.NoticeService;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.post.PostService;
import com.tcbj.crm.product.HintNumber;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.region.RegionService;
import com.tcbj.crm.reply.ReplyService;
import com.tcbj.crm.report.Pandect;
import com.tcbj.crm.report.PandectReportService;
import com.tcbj.crm.right.RightService;
import com.tcbj.crm.score.ScoreService;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.target.TargetCondition;
import com.tcbj.crm.target.TargetService;
import com.tcbj.crm.target.TargetWrap;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.Partner;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller(value="newdesktop")
public class DesktopController
extends BaseController {
    @Autowired
    private DesktopService service;
    @Autowired
    private OrderApplyService orderService;
    @Autowired
    private ProductService productService;
    @Autowired
    private PartnerService partnerService;
    @Autowired
    private ShopService shopService;
    @Autowired
    private ReplyService replyService;
    @Autowired
    private RightService rightService;
    @Autowired
    private RegionService regionService;
    @Autowired
    private TargetService targetService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private ScoreService scoreService;
    @Autowired
    private PandectReportService pandectReportService;
    @Autowired
    private PostService postService;

    @RequestMapping(value={"/index.do"}, method={RequestMethod.GET})
    public String index(Model model) {
        model.addAttribute("currentEmployee", (Object)this.getCurrentEmployee());
        return "newdesktop/index.ftl";
    }

    @RequestMapping(value={"/top.do"}, method={RequestMethod.GET})
    public String top(Model model) {
        model.addAttribute("currentEmployee", (Object)this.getCurrentEmployee());
        return "newdesktop/top.ftl";
    }

    @RequestMapping(value={"/menu.do"}, method={RequestMethod.GET})
    public String menu(Model model) {
        model.addAttribute("currentEmployee", (Object)this.getCurrentEmployee());
        String type = this.loginInfo();
        model.addAttribute("type", (Object)type);
        return "newdesktop/menu.ftl";
    }

    @RequestMapping(value={"/work.do"}, method={RequestMethod.GET})
    public String work(Model model, HttpServletRequest request, HttpServletResponse response) {
        Employee me = this.getCurrentEmployee();
        int[] stats = this.orderService.getOrderStats(me.getId(), me.getCurrentPartner().getId());
        model.addAttribute("stats", (Object)stats);
        List<Notice> newsNList = this.service.getNoticeByType(me, "NEWS", "2", null);
        List<Notice> sysNList = this.service.getNoticeByType(me, "NOTICE", "2", null);
        List<Notice> proNList = this.service.getNoticeByType(me, "PRODUCT_INF", "2", null);
        List<Notice> proDataNList = this.service.getNoticeByType(me, "PRODUCT_DATA", "2", null);
        List<Notice> dynList = this.service.getNoticeByType(me, "PRODUCT_DYNAMIC", "2", null);
        List<Notice> advertList = this.service.getNoticeByType(me, "AD", "2", null);
        model.addAttribute("newsNList", newsNList);
        model.addAttribute("sysNList", sysNList);
        model.addAttribute("proNList", proNList);
        model.addAttribute("proDataNList", proDataNList);
        model.addAttribute("dynList", dynList);
        model.addAttribute("advertList", advertList);
        List<DataUpload> licenseList = this.service.getDataUploadByType(me, "license");
        List<DataUpload> criterionList = this.service.getDataUploadByType(me, "criterion");
        model.addAttribute("licenseList", licenseList);
        model.addAttribute("criterionList", criterionList);
        HintNumber hit = this.productService.getStatProduct(me.getCurrentPartner().getId());
        model.addAttribute("hit", (Object)hit);
        int score = this.scoreService.getExchangeOrdersNumber(me.getCurrentPartner().getId(), "Submitted");
        model.addAttribute("score", (Object)score);
        Long draftCount = this.shopService.getDraftShopList(me);
        model.addAttribute("drafCount", (Object)draftCount);
        Long auditCount = this.shopService.getAuditShopCount(me);
        model.addAttribute("auditCount", (Object)auditCount);
        int[] counts = this.partnerService.getSketchCount(me.getId(), me.getCurrentPartner().getId());
        model.addAttribute("counts", (Object)counts);
        Long[] replayCount = this.replyService.replayCount(me.getCurrentPartner().getId());
        model.addAttribute("replayCount", (Object)replayCount);
        if (me.getCurrentPartner().isOrg()) {
            if (this.rightService.hasRightByUser(me.getId(), "/orderapply/approves.do")) {
                OrderApplyCondition con = new OrderApplyCondition();
                con.setSupplierId(me.getCurrentPartner().getId());
                con.getOrderStates().add(TCBJEnum.AuditState.approve.getValue());
                con.setEmployeeId(me.getId());
                con.setRegionFilter(true);
                List orderApplys = this.orderService.findOrderApplys(con, "order by o.createDt desc").getList();
                model.addAttribute("approveOrders", (Object)orderApplys);
            }
        } else if (this.rightService.hasRightByUser(me.getId(), "/orderapply/applys.do")) {
            OrderApplyCondition con = new OrderApplyCondition();
            con.setApplyerId(me.getCurrentPartner().getId());
            con.setEmployeeId(me.getId());
            List orderApplys = this.orderService.findOrderApplys(con, "order by o.createDt desc").getList();
            model.addAttribute("applyOrders", (Object)orderApplys);
        }
        this.chart4Partner(model, me);
        this.chart4BigArea(model, me);
        this.chart4Employee(model, me);
        this.chart4Pandect(model, me);
        model.addAttribute("userName", (Object)me.getName());
        model.addAttribute("userId", (Object)me.getId());
        model.addAttribute("partnerName", (Object)me.getCurrentPartner().getName());
        return "newdesktop/work.ftl";
    }

    private void chart4Partner(Model model, Employee me) {
        TargetCondition condition = new TargetCondition();
        condition.setYear(String.valueOf(DateUtils.getYear()));
        condition.setTargetType("SAL_TARGET");
        condition.setObjectId(me.getId());
        List<TargetWrap> list = this.targetService.queryBySalesman(condition, me, 0, 1000);
        if (list != null && list.size() > 0) {
            TargetWrap tw = list.get(0);
            model.addAttribute("condition", (Object)condition);
            model.addAttribute("salesmanX", (Object)"\"\u4e00\u6708\",\"\u4e8c\u6708\",\"\u4e09\u6708\",\"\u56db\u6708\",\"\u4e94\u6708\",\"\u516d\u6708\",\"\u4e03\u6708\",\"\u516b\u6708\",\"\u4e5d\u6708\",\"\u5341\u6708\",\"\u5341\u4e00\u6708\",\"\u5341\u4e8c\u6708\"");
            String target = "\"" + tw.getTarget().getM1() + "\",\"" + tw.getTarget().getM2() + "\",\"" + tw.getTarget().getM3() + "\",\"" + tw.getTarget().getM4() + "\",\"" + tw.getTarget().getM5() + "\",\"" + tw.getTarget().getM6() + "\",\"" + tw.getTarget().getM7() + "\",\"" + tw.getTarget().getM8() + "\",\"" + tw.getTarget().getM9() + "\",\"" + tw.getTarget().getM10() + "\",\"" + tw.getTarget().getM11() + "\",\"" + tw.getTarget().getM12() + "\"";
            String data = "\"" + tw.getM1Data() + "\",\"" + tw.getM2Data() + "\",\"" + tw.getM3Data() + "\",\"" + tw.getM4Data() + "\",\"" + tw.getM5Data() + "\",\"" + tw.getM6Data() + "\",\"" + tw.getM7Data() + "\",\"" + tw.getM8Data() + "\",\"" + tw.getM9Data() + "\",\"" + tw.getM10Data() + "\",\"" + tw.getM11Data() + "\",\"" + tw.getM12Data() + "\"";
            String p = "\"" + tw.getM1ProgressNum() + "\",\"" + tw.getM2ProgressNum() + "\",\"" + tw.getM3ProgressNum() + "\",\"" + tw.getM4ProgressNum() + "\",\"" + tw.getM5ProgressNum() + "\",\"" + tw.getM6ProgressNum() + "\",\"" + tw.getM7ProgressNum() + "\",\"" + tw.getM8ProgressNum() + "\",\"" + tw.getM9ProgressNum() + "\",\"" + tw.getM10ProgressNum() + "\",\"" + tw.getM11ProgressNum() + "\",\"" + tw.getM12ProgressNum() + "\"";
            model.addAttribute("salesmanCount1", (Object)target);
            model.addAttribute("salesmanCount2", (Object)data);
            model.addAttribute("salesmanCount3", (Object)p);
        } else {
            model.addAttribute("condition", (Object)condition);
            model.addAttribute("salesmanX", (Object)"\"\u4e00\u6708\",\"\u4e8c\u6708\",\"\u4e09\u6708\",\"\u56db\u6708\",\"\u4e94\u6708\",\"\u516d\u6708\",\"\u4e03\u6708\",\"\u516b\u6708\",\"\u4e5d\u6708\",\"\u5341\u6708\",\"\u5341\u4e00\u6708\",\"\u5341\u4e8c\u6708\"");
            String target = "\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"";
            String data = "\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"";
            String p = "\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"";
            model.addAttribute("salesmanCount1", (Object)target);
            model.addAttribute("salesmanCount2", (Object)data);
            model.addAttribute("salesmanCount3", (Object)p);
        }
    }

    private void chart4Employee(Model model, Employee me) {
        TargetCondition condition = new TargetCondition();
        condition.setYear(String.valueOf(DateUtils.getYear()));
        condition.setTargetType("SAL_TARGET");
        condition.setObjectId(me.getId());
        List<TargetWrap> list = this.targetService.queryBySalesman(condition, me, 0, 1000);
        if (list != null && list.size() > 0) {
            TargetWrap tw = list.get(0);
            model.addAttribute("condition", (Object)condition);
            model.addAttribute("salesmanX", (Object)"\"\u4e00\u6708\",\"\u4e8c\u6708\",\"\u4e09\u6708\",\"\u56db\u6708\",\"\u4e94\u6708\",\"\u516d\u6708\",\"\u4e03\u6708\",\"\u516b\u6708\",\"\u4e5d\u6708\",\"\u5341\u6708\",\"\u5341\u4e00\u6708\",\"\u5341\u4e8c\u6708\"");
            String target = "\"" + tw.getTarget().getM1() + "\",\"" + tw.getTarget().getM2() + "\",\"" + tw.getTarget().getM3() + "\",\"" + tw.getTarget().getM4() + "\",\"" + tw.getTarget().getM5() + "\",\"" + tw.getTarget().getM6() + "\",\"" + tw.getTarget().getM7() + "\",\"" + tw.getTarget().getM8() + "\",\"" + tw.getTarget().getM9() + "\",\"" + tw.getTarget().getM10() + "\",\"" + tw.getTarget().getM11() + "\",\"" + tw.getTarget().getM12() + "\"";
            String data = "\"" + tw.getM1Data() + "\",\"" + tw.getM2Data() + "\",\"" + tw.getM3Data() + "\",\"" + tw.getM4Data() + "\",\"" + tw.getM5Data() + "\",\"" + tw.getM6Data() + "\",\"" + tw.getM7Data() + "\",\"" + tw.getM8Data() + "\",\"" + tw.getM9Data() + "\",\"" + tw.getM10Data() + "\",\"" + tw.getM11Data() + "\",\"" + tw.getM12Data() + "\"";
            String p = "\"" + tw.getM1ProgressNum() + "\",\"" + tw.getM2ProgressNum() + "\",\"" + tw.getM3ProgressNum() + "\",\"" + tw.getM4ProgressNum() + "\",\"" + tw.getM5ProgressNum() + "\",\"" + tw.getM6ProgressNum() + "\",\"" + tw.getM7ProgressNum() + "\",\"" + tw.getM8ProgressNum() + "\",\"" + tw.getM9ProgressNum() + "\",\"" + tw.getM10ProgressNum() + "\",\"" + tw.getM11ProgressNum() + "\",\"" + tw.getM12ProgressNum() + "\"";
            model.addAttribute("salesmanCount1", (Object)target);
            model.addAttribute("salesmanCount2", (Object)data);
            model.addAttribute("salesmanCount3", (Object)p);
        } else {
            model.addAttribute("condition", (Object)condition);
            model.addAttribute("salesmanX", (Object)"\"\u4e00\u6708\",\"\u4e8c\u6708\",\"\u4e09\u6708\",\"\u56db\u6708\",\"\u4e94\u6708\",\"\u516d\u6708\",\"\u4e03\u6708\",\"\u516b\u6708\",\"\u4e5d\u6708\",\"\u5341\u6708\",\"\u5341\u4e00\u6708\",\"\u5341\u4e8c\u6708\"");
            String target = "\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"";
            String data = "\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"";
            String p = "\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"";
            model.addAttribute("salesmanCount1", (Object)target);
            model.addAttribute("salesmanCount2", (Object)data);
            model.addAttribute("salesmanCount3", (Object)p);
        }
    }

    private void chart4BigArea(Model model, Employee me) {
        List<Region> bagAreasList = this.regionService.getBigAreas(me.getCurrentPartner().getOrganizationid());
        TargetCondition condition = new TargetCondition();
        condition.setYear(String.valueOf(DateUtils.getYear()));
        condition.setTargetType("SAL_TARGET");
        List<TargetWrap> list = this.targetService.queryByBigarea(condition, me, 0, 1000);
        HashMap<String, TargetWrap> map = new HashMap<String, TargetWrap>();
        String bigAreaName = "";
        String count1 = "";
        String count2 = "";
        String count5 = "";
        String count6 = "";
        String count7 = "";
        int j = 0;
        while (j < list.size()) {
            map.put(list.get(j).getTarget().getBigareaId(), list.get(j));
            ++j;
        }
        int i = 0;
        while (i < bagAreasList.size()) {
            bigAreaName = String.valueOf(bigAreaName) + "\"" + bagAreasList.get(i).getRegionName() + "\",";
            if (map.get(bagAreasList.get(i).getId()) == null) {
                count1 = String.valueOf(count1) + "\"0\",";
                count2 = String.valueOf(count2) + "\"0\",";
                count5 = String.valueOf(count5) + "{value:0, name:'" + bagAreasList.get(i).getRegionName() + "'},";
                count6 = String.valueOf(count6) + "{value:0, name:'" + bagAreasList.get(i).getRegionName() + "'},";
                count7 = String.valueOf(count7) + "\"0.0\",";
            } else {
                count1 = String.valueOf(count1) + "\"" + ((TargetWrap)map.get(bagAreasList.get(i).getId())).getTarget().getY() + "\",";
                count2 = String.valueOf(count2) + "\"" + ((TargetWrap)map.get(bagAreasList.get(i).getId())).getYearData() + "\",";
                count5 = String.valueOf(count5) + "{value:" + ((TargetWrap)map.get(bagAreasList.get(i).getId())).getTarget().getY() + ", name:'" + bagAreasList.get(i).getRegionName() + "'},";
                count6 = String.valueOf(count6) + "{value:" + ((TargetWrap)map.get(bagAreasList.get(i).getId())).getYearData() + ", name:'" + bagAreasList.get(i).getRegionName() + "'},";
                count7 = String.valueOf(count7) + "\"" + ((TargetWrap)map.get(bagAreasList.get(i).getId())).getYearProgressNum() + "\",";
            }
            ++i;
        }
        if (bigAreaName.length() > 1) {
            bigAreaName = bigAreaName.substring(0, bigAreaName.length() - 1);
            count1 = count1.substring(0, count1.length() - 1);
            count2 = count2.substring(0, count2.length() - 1);
            count5 = count5.substring(0, count5.length() - 1);
            count6 = count6.substring(0, count6.length() - 1);
            count7 = count7.substring(0, count7.length() - 1);
        }
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("bigAreaName", (Object)bigAreaName);
        model.addAttribute("count1", (Object)count1);
        model.addAttribute("count2", (Object)count2);
        model.addAttribute("count5", (Object)count5);
        model.addAttribute("count6", (Object)count6);
        model.addAttribute("count7", (Object)count7);
    }

    private void chart4Pandect(Model model, Employee me) {
        String oId;
        List<DictionaryItem> targetTypes = this.pandectReportService.tragetList("TCBJ_PACT_TARGET_TYPE", "Y");
        String sale = null;
        ArrayList<Pandect> pandectList = new ArrayList<Pandect>();
        int i = 0;
        while (i < targetTypes.size()) {
            DictionaryItem targetType = targetTypes.get(i);
            sale = i == 0 ? "\"" + targetType.getVal() + "\"" : String.valueOf(sale) + ",\"" + targetType.getVal() + "\"";
            if (i == targetTypes.size() - 1 && i < 5) {
                while (i < 4) {
                    sale = String.valueOf(sale) + ",\"\"";
                    ++i;
                }
            }
            Pandect target = new Pandect();
            target.setName(targetType.getVal());
            target.setType(targetType.getName());
            target.setYear(String.valueOf(DateUtils.getYear()));
            target.setTarget_all(0.0);
            target.setTarget_now(0.0);
            target.setUnit(targetType.getDescText());
            pandectList.add(target);
            ++i;
        }
        TargetCondition condition = new TargetCondition();
        condition.setYear(String.valueOf(DateUtils.getYear()));
        List<Position> poList = this.postService.getRoletype(me.getId());
        String roletype = null;
        if (poList.size() > 0) {
            roletype = poList.get(0).getRoletype();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String sName = this.setsName(roletype, "", me.getName());
        String tId = this.getCurrentEmployee().getCurrentPartner().getId();
        if (tId.equals(oId = this.getCurrentEmployee().getCurrentPartner().getOrganizationid())) {
            if (Pandect.city.equals(roletype)) {
                condition.setpType("\u4eba\u5458");
            } else {
                condition.setpType("\u5ba2\u6237");
            }
        } else {
            condition.setpType("\u7ecf\u9500\u5546");
        }
        Pandect pandect = this.pandectReportService.queryByPartner(condition, me);
        List<Target> targetList = pandect.getTargetList();
        int i2 = 0;
        while (i2 < targetList.size()) {
            Target target = targetList.get(i2);
            this.setInfo(map, roletype, target.getYear() + target.getType());
            Double count = 0.0;
            count = count + (this.setM(target.getM1()) + this.setM(target.getM2()) + this.setM(target.getM3()) + this.setM(target.getM4()));
            count = count + (this.setM(target.getM5()) + this.setM(target.getM6()) + this.setM(target.getM7()) + this.setM(target.getM8()));
            count = count + (this.setM(target.getM9()) + this.setM(target.getM10()) + this.setM(target.getM11()) + this.setM(target.getM12()));
            for (Pandect pandects : pandectList) {
                if (!pandects.getType().equals(target.getType())) continue;
                Double target_all = pandects.getTarget_all() + count;
                pandects.setTarget_all(target_all);
            }
            ++i2;
        }
        List<PactMbo> pactMboList = pandect.getPactMboList();
        int i3 = 0;
        while (i3 < pactMboList.size()) {
            PactMbo pactMbo = pactMboList.get(i3);
            this.setInfo(map, roletype, pactMbo.getYear() + pactMbo.getTargetType());
            Double count = 0.0;
            count = count + (this.setM(pactMbo.getMonth1()) + this.setM(pactMbo.getMonth2()) + this.setM(pactMbo.getMonth3()) + this.setM(pactMbo.getMonth4()));
            count = count + (this.setM(pactMbo.getMonth5()) + this.setM(pactMbo.getMonth6()) + this.setM(pactMbo.getMonth7()) + this.setM(pactMbo.getMonth8()));
            count = count + (this.setM(pactMbo.getMonth9()) + this.setM(pactMbo.getMonth10()) + this.setM(pactMbo.getMonth11()) + this.setM(pactMbo.getMonth12()));
            for (Pandect pandects : pandectList) {
                if (!pandects.getType().equals(pactMbo.getTargetType())) continue;
                Double target_all = pandects.getTarget_all() + count;
                pandects.setTarget_all(target_all);
            }
            ++i3;
        }
        List<TargetData> targetDataList = pandect.getTargetDataList();
        int i4 = 0;
        while (i4 < targetDataList.size()) {
            TargetData targetData = targetDataList.get(i4);
            if (this.boolInfo(map, roletype, targetData)) {
                Double count = 0.0;
                count = count + (targetData.getM1() + targetData.getM2() + targetData.getM3() + targetData.getM4());
                count = count + (targetData.getM5() + targetData.getM6() + targetData.getM7() + targetData.getM8());
                count = count + (targetData.getM9() + targetData.getM10() + targetData.getM11() + targetData.getM12());
                for (Pandect pandects : pandectList) {
                    if (!pandects.getType().equals(targetData.getType())) continue;
                    Double target_now = pandects.getTarget_now() + count;
                    pandects.setTarget_now(target_now);
                }
            }
            ++i4;
        }
        for (Pandect pandects : pandectList) {
            if (pandects.getType() == null || "".equals(pandects.getType())) continue;
            Double target_all = pandects.getTarget_all();
            Double target_now = pandects.getTarget_now();
            if (target_all == 0.0) {
                pandects.setPercent("" + target_all);
            } else if (target_now == 0.0) {
                pandects.setPercent("0");
            } else {
                pandects.setPercent(String.valueOf(this.Percent(target_now, target_all)));
            }
            if (!"\u4e07\u5143".equals(pandects.getUnit())) continue;
            BigDecimal all = BigDecimal.valueOf(target_all).setScale(4, 4);
            pandects.setTarget_all(all.doubleValue());
            BigDecimal now = BigDecimal.valueOf(target_now).setScale(4, 4);
            pandects.setTarget_now(now.doubleValue());
        }
        String items = JSON.toJSONString(pandectList);
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("sName", (Object)sName);
        model.addAttribute("sale", (Object)sale);
        model.addAttribute("targetList", (Object)items);
    }

    public String toString(Double m) {
        if (StringUtils.isNull(m)) {
            return "\"0\",";
        }
        return "\"" + String.valueOf(m) + "\",";
    }

    @RequestMapping(value={"/changePartner.do"}, method={RequestMethod.GET})
    public String change(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        for (EmployeePartner p : me.getPartners()) {
            if (!p.getId().equals(p.getId())) continue;
            me.setCurrentPartner(p);
        }
        return this.index(model);
    }

    public String loginInfo() {
        Employee e = this.getCurrentEmployee();
        String logId = e.getCurrentPartner().getId();
        Partner partner = this.partnerService.getSimplePartner(logId);
        String type = partner.getPartnerShipFlag();
        return type;
    }

    private double Percent(double tdm, double tm) {
        int k = 100;
        double p = tdm / tm * (double)k;
        int i = (int)(p * (double)k);
        return (double)i / (double)k;
    }

    private double Percent2(double tdm, int t) {
        int i = (int)(tdm * (double)t);
        return (double)i / (double)t;
    }

    public String setsName(String roletype, String sName, String roleName) {
        String year = String.valueOf(DateUtils.getYear());
        if (Pandect.ceo.equals(roletype)) {
            sName = "\u6c64\u81e3\u500d\u5065" + year + "\u5e74\u5ea6\u76ee\u6807\u5b8c\u6210\u60c5\u51b5";
        } else if (Pandect.sale.equals(roletype)) {
            sName = "\u6c64\u81e3\u500d\u5065" + year + "\u5e74\u5ea6\u60a8\u6240\u7ba1\u8f96\u7684\u6e20\u9053\u76ee\u6807\u5b8c\u6210\u60c5\u51b5";
        } else if (Pandect.distict.equals(roletype)) {
            sName = "\u6c64\u81e3\u500d\u5065" + year + "\u5e74\u5ea6\u60a8\u6240\u7ba1\u8f96\u7684\u5927\u533a\u76ee\u6807\u5b8c\u6210\u60c5\u51b5";
        } else if (Pandect.region.equals(roletype)) {
            sName = "\u6c64\u81e3\u500d\u5065" + year + "\u5e74\u5ea6\u60a8\u6240\u7ba1\u8f96\u7684\u533a\u57df\u76ee\u6807\u5b8c\u6210\u60c5\u51b5";
        } else if (Pandect.city.equals(roletype)) {
            sName = String.valueOf(roleName) + " " + year + "\u5e74\u5ea6\u76ee\u6807\u5b8c\u6210\u60c5\u51b5";
        }
        return sName;
    }

    public void setInfo(Map<String, String> map, String roletype, String customerId) {
        String tw = map.get(customerId);
        if (tw == null || "".equals(tw)) {
            map.put(customerId, "1");
        }
    }

    public boolean boolInfo(Map<String, String> map, String roletype, TargetData targetData) {
        boolean bool = false;
        String customerId = targetData.getYear() + targetData.getType();
        String tw = map.get(customerId);
        if (tw != null && !"".equals(tw)) {
            bool = true;
        }
        return bool;
    }

    public Double setM(Double M) {
        if (M == null) {
            M = 0.0;
        }
        return M;
    }
}

