/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.notice;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Notice;
import com.tcbj.crm.entity.NoticeE;
import com.tcbj.crm.entity.NoticeS;
import com.tcbj.crm.entity.NoticeU;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.notice.NoticeCondition;
import com.tcbj.crm.notice.NoticeEService;
import com.tcbj.crm.notice.NoticeService;
import com.tcbj.crm.right.RightService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/notice"})
public class NoticeContoller
extends BaseController {
    @Autowired
    NoticeService noticeService;
    @Autowired
    NoticeEService noticeEService;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    RightService rightService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String name, Model model, NoticeCondition condition) throws Exception {
        Employee e = this.getCurrentEmployee();
        Contact contact = this.personnelService.get(e.getId());
        List<DictionaryItem> dicList = Cache.getItems("TCBJ_NOTICE_SYS");
        Page page = this.noticeService.getList(e.getCurrentPartner().getId(), condition, pageno, contact);
        model.addAttribute("page", (Object)page);
        HashMap<String, String> m = new HashMap<String, String>();
        for (DictionaryItem dictionaryItem : dicList) {
            m.put(dictionaryItem.getName(), dictionaryItem.getVal());
        }
        String noticeType = condition.getNoticeType();
        this.settingTitle(model, noticeType);
        model.addAttribute("sysFlag", m);
        model.addAttribute("dicList", dicList);
        model.addAttribute("condition", (Object)condition);
        return "notice/list.ftl";
    }

    private void settingTitle(Model model, String noticeType) {
        String title = "";
        if ("NEWS".equals(noticeType)) {
            title = "\u65b0\u95fb";
        }
        if ("PRODUCT_INF".equals(noticeType)) {
            title = "\u4ea7\u54c1";
        }
        if ("NOTICE".equals(noticeType)) {
            title = "\u516c\u544a";
        }
        if ("PRODUCT_DATA".equals(noticeType)) {
            title = "\u4ea7\u54c1\u8d44\u6599";
        }
        if ("PRODUCT_DYNAMIC".equals(noticeType)) {
            title = "\u4ea7\u54c1\u52a8\u6001";
        }
        if ("unreadNotice".equals(noticeType)) {
            title = "\u672a\u8bfb\u516c\u544a";
        }
        if ("AD".equals(noticeType)) {
            title = "\u5e7f\u544a\u8bbe\u8ba1";
        }
        model.addAttribute("ntitle", (Object)title);
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public void add(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("base", (Object)request.getContextPath());
        request.setAttribute("startDate", (Object)DateUtils.formartDate((Date)new Date(), (String)"YYYY-MM-dd"));
        request.getRequestDispatcher("/resource/notice/add.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    public String add(Notice notice, HttpServletRequest request, Model model) {
        Employee e = this.getCurrentEmployee();
        notice.setCreated(DateUtils.now());
        notice.setCreatedBy(e.getId());
        notice.setDbLastUpd(DateUtils.now());
        notice.setLastUpdBy(e.getId());
        notice.setLastUpd(DateUtils.now());
        notice.setModificationNum(922337203L);
        notice.setConflictId("11");
        notice.setLastupdateDt(DateUtils.now());
        notice.setLastupdatorId(e.getId());
        notice.setCreateDt(DateUtils.now());
        notice.setCreatorId(e.getId());
        notice.setOrganizationId(e.getCurrentPartner().getId());
        notice.setPublishDate(DateUtils.now());
        List<IUploadFile> fileMap = this.uploadFile(request, "notice");
        this.noticeService.save(notice, fileMap, e);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(notice.getNoticeType())));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/push.do"}, method={RequestMethod.GET})
    public String push(String noticeType, String id, Model model) {
        List<DictionaryItem> dicList = Cache.getItems("TCBJ_NOTICE_SYS");
        model.addAttribute("notice", (Object)this.noticeService.findById(id));
        Map<String, NoticeS> map = this.noticeService.findNoticeSById(id);
        model.addAttribute("noticeS", map);
        model.addAttribute("sysFlag", dicList);
        model.addAttribute("noticeType", (Object)noticeType);
        return "notice/push.ftl";
    }

    @RequestMapping(value={"/addpush.do"}, method={RequestMethod.POST})
    public String push(String noticeType, NoticeS noticeS, String[] systemFlag, Model model) {
        Employee e = this.getCurrentEmployee();
        this.noticeService.save(e, noticeS.getNoticeId(), systemFlag);
        return this.redirect("/notice/list.do?noticeType=" + noticeType);
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String noticeType, String id, Model model) {
        Notice notice = this.noticeService.findById(id);
        if (notice != null && "NOTICE".equals(noticeType)) {
            this.noticeService.saveReadEmp(id, this.getCurrentEmployee().getId());
        }
        model.addAttribute("notice", (Object)notice);
        List<NoticeE> fileList = this.noticeService.getNoticeFile(id);
        this.settingTitle(model, noticeType);
        model.addAttribute("fileList", fileList);
        model.addAttribute("noticeType", (Object)noticeType);
        return "notice/look.ftl";
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String delete(String noticeType, String id) {
        this.noticeService.delete(id);
        List<NoticeE> fileList = this.noticeService.getNoticeFile(id);
        for (NoticeE noticeE : fileList) {
            this.noticeEService.delete(noticeE.getId());
        }
        return this.redirect("/notice/list.do?noticeType=" + noticeType);
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public void edit(HttpServletRequest request, HttpServletResponse response, String noticeType, String id) throws ServletException, IOException {
        Notice notice = this.noticeService.findById(id);
        request.setAttribute("notice", (Object)notice);
        List<NoticeE> fileList = this.noticeService.getNoticeFile(id);
        request.setAttribute("fileList", fileList);
        request.setAttribute("noticeType", (Object)noticeType);
        request.setAttribute("base", (Object)request.getContextPath());
        request.getRequestDispatcher("/resource/notice/edit.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    public String edit(Notice notice, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        notice.setDbLastUpd(DateUtils.now());
        notice.setLastUpdBy(e.getId());
        notice.setLastUpd(DateUtils.now());
        notice.setLastupdateDt(DateUtils.now());
        notice.setLastupdatorId(e.getId());
        notice.setPublishDate(DateUtils.now());
        List<IUploadFile> fileMap = this.uploadFile(request, "notice");
        this.noticeService.update(notice, fileMap, e);
        return this.redirect("/notice/list.do?noticeType=" + notice.getNoticeType());
    }

    @RequestMapping(value={"/deletefile.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void deletefile(String id, HttpServletResponse response) {
        try {
            this.noticeService.deleteFile(id);
            response.getWriter().write("true");
        }
        catch (Exception e) {
            throw new AppException("\u4fe1\u606f\u7ba1\u7406-\u5355\u72ec\u5220\u9664\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }

    @RequestMapping(value={"/check.do"}, method={RequestMethod.GET})
    public String check(String noticeType, String id, Model model) {
        Notice notice = this.noticeService.findById(id);
        model.addAttribute("notice", (Object)notice);
        List<NoticeE> fileList = this.noticeService.getNoticeFile(id);
        model.addAttribute("fileList", fileList);
        return "notice/check.ftl";
    }

    @RequestMapping(value={"/check.do"}, method={RequestMethod.POST})
    public String check(String noticeType, String id, String noticeFlag) {
        String publishOrgId = this.getCurrentEmployee().getCurrentPartner().getOrganizationid();
        this.noticeService.updateCheck(id, noticeFlag, publishOrgId);
        return this.redirect("/notice/list.do?dis=1&state=1");
    }

    @RequestMapping(value={"/toSelectOuter.do"}, method={RequestMethod.GET})
    public String toSelectOuter(NoticeCondition noticeCondition, String noticeType, String flag, String id, String noticeFlag, Model model, HttpServletRequest request) {
        Notice notice = this.noticeService.findById(id);
        model.addAttribute("select", (Object)"select");
        model.addAttribute("noticeType", (Object)noticeType);
        model.addAttribute("notice", (Object)notice);
        model.addAttribute("condition", (Object)noticeCondition);
        model.addAttribute("flag", (Object)flag);
        return "notice/selectOuter.ftl";
    }

    @RequestMapping(value={"/select.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String select(NoticeCondition noticeCondition, String noticeType, String flag, String id, String noticeFlag, Model model, HttpServletRequest request) {
        Notice notice = this.noticeService.findById(id);
        Employee me = this.getCurrentEmployee();
        if (request.getMethod().toUpperCase().equals("GET")) {
            model.addAttribute("select", (Object)"select");
            model.addAttribute("flag", (Object)flag);
            model.addAttribute("notice", (Object)notice);
            model.addAttribute("condition", (Object)noticeCondition);
            return "notice/select.ftl";
        }
        try {
            List<Contact> contactList = null;
            if ("inner".equals(flag)) {
                contactList = this.noticeService.getInnerPerson(me, noticeCondition);
                model.addAttribute("flag", (Object)"inner");
            } else {
                contactList = this.noticeService.getOuterPerson(me, noticeCondition);
                model.addAttribute("flag", (Object)"outer");
            }
            List<NoticeU> listY = this.noticeService.getSelectedList(id);
            HashMap<String, String> map = new HashMap<String, String>();
            for (NoticeU u : listY) {
                map.put(u.getUserId(), u.getUserId());
            }
            Iterator<Contact> iterator = contactList.iterator();
            while (iterator.hasNext()) {
                Contact emp = iterator.next();
                if (map.get(emp.getId()) == null) continue;
                iterator.remove();
            }
            model.addAttribute("notice", (Object)notice);
            model.addAttribute("condition", (Object)noticeCondition);
            model.addAttribute("list", contactList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ("inner".equals(flag)) {
            model.addAttribute("condition", (Object)noticeCondition);
            model.addAttribute("notice", (Object)notice);
            return "notice/select.ftl";
        }
        model.addAttribute("condition", (Object)noticeCondition);
        model.addAttribute("notice", (Object)notice);
        return "notice/selectOuter.ftl";
    }

    @RequestMapping(value={"/selectY.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String selectY(NoticeCondition noticeCondition, String noticeType, String id, String noticeFlag, Model model) {
        try {
            this.getCurrentEmployee();
            Notice notice = this.noticeService.findById(id);
            List<Contact> list = this.noticeService.getSelectedNoticeUser(id, noticeCondition);
            model.addAttribute("list", list);
            model.addAttribute("notice", (Object)notice);
            model.addAttribute("condition", (Object)noticeCondition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "notice/selectY.ftl";
    }

    @RequestMapping(value={"/selectsave.do"}, method={RequestMethod.POST})
    public String select(String noticeType, String[] userId, String id) {
        try {
            Employee e = this.getCurrentEmployee();
            String[] stringArray = userId;
            int n = userId.length;
            int n2 = 0;
            while (n2 < n) {
                String uid = stringArray[n2];
                NoticeU niticeU = new NoticeU();
                niticeU.setCreated(DateUtils.now());
                niticeU.setCreatedBy(e.getId());
                niticeU.setDbLastUpd(DateUtils.now());
                niticeU.setLastUpdBy(e.getId());
                niticeU.setLastUpd(DateUtils.now());
                niticeU.setModificationNum(922337203L);
                niticeU.setConflictId("11");
                niticeU.setLastupdateDt(DateUtils.now());
                niticeU.setLastupdatorId(e.getId());
                niticeU.setCreateDt(DateUtils.now());
                niticeU.setCreatorId(e.getId());
                niticeU.setNoticeId(id);
                niticeU.setUserId(uid);
                this.noticeService.save(niticeU);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.redirect("/notice/list.do?noticeType=" + noticeType);
    }

    @RequestMapping(value={"/deleteuser.do"}, method={RequestMethod.GET})
    public String deleteUser(String userId, String noticeId, String noticeType, Model model, NoticeCondition condition) {
        try {
            this.noticeService.deleteNotice(userId, noticeId);
            condition.setId(noticeId);
            condition.setNoticeType(noticeType);
            model.addAttribute("condition", (Object)condition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.redirect("/notice/selectY.do?id=" + noticeId + "&noticeType=" + noticeType);
    }

    @RequestMapping(value={"/viewNotice.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String viewNotice(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model, NoticeCondition condition) {
        Employee me = this.getCurrentEmployee();
        Page page = null;
        if ("unreadNotice".equals(condition.getNoticeType())) {
            condition.setNoticeType("NOTICE");
            page = this.noticeService.getUnreadSysNoticesByPage(me, condition, pageno);
            condition.setNoticeType("unreadNotice");
        } else {
            page = this.noticeService.getNoticeByPage(me, condition, pageno);
        }
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        this.settingTitle(model, condition.getNoticeType());
        return "notice/viewList.ftl";
    }

    @RequestMapping(value={"/unread.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result hasUnreadNotice(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, NoticeCondition condition) {
        Page page = this.noticeService.getUnreadSysNoticesByPage(this.getCurrentEmployee(), condition, pageno);
        if (page.getList().size() > 0) {
            return this.getSuccessResult(true);
        }
        return this.getSuccessResult(false);
    }

    @RequestMapping(value={"/unreadList.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String getUnreadNotice(Model model, NoticeCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageNo) {
        Page page = this.noticeService.getUnreadSysNoticesByPage(this.getCurrentEmployee(), condition, pageNo);
        model.addAttribute("page", (Object)page);
        model.addAttribute("ntitle", (Object)"\u672a\u8bfb\u516c\u544a");
        model.addAttribute("condition", (Object)condition);
        return "notice/unread.ftl";
    }
}

