/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.allot.QyAllotService;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.AuditInfo;
import com.tcbj.crm.entity.IntRebatemg;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.entity.PrAdjdetail;
import com.tcbj.crm.entity.QyAllotRow;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.gift.GiftService;
import com.tcbj.crm.intrebatemg.IntRebatemgService;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.crm.order.PartnerCreditService;
import com.tcbj.crm.order.base.BaseApplyController;
import com.tcbj.crm.score.ScoreService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.ExchangeOrder;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerCredit;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/orderapply"})
public class OrderApplyController
extends BaseApplyController {
    @Autowired
    protected QyAllotService qyAllService;
    @Autowired
    protected PartnerCreditService creditServcie;
    @Autowired
    protected GiftService giftService;
    @Autowired
    IntRebatemgService intrebatemgservice;
    @Autowired
    ScoreService scoreService;
    @Autowired
    BaseDao baseDao;

    @ModelAttribute
    public void initNames(Model model) {
        model.addAttribute("_title", (Object)"\u8ba2\u5355");
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model) {
        OrderApply orderApply = this.loadOrderApply(id, model);
        List<OrderProduct> products = this.getProducts(orderApply);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        String[] exchangeOrdersByIds = orderApply.getExchangeOrderIdArray();
        if (exchangeOrdersByIds != null) {
            List<ExchangeOrder> exchangeOrders = null;
            exchangeOrders = this.scoreService.getExchangeOrdersByIds(exchangeOrdersByIds);
            model.addAttribute("exchangeOrders", exchangeOrders);
        }
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("auditInfos", this.auditService.find(id));
        model.addAttribute("view", (Object)"true");
        if (Constant.SCALETYPE_QUANTITY.equals(contract.getFreeScaleType())) {
            Double freeGiftTotal = orderApply.getFreeGiftTotal() == null ? 0.0 : orderApply.getFreeGiftTotal();
            Double freeGiftOrder = orderApply.getFreeGiftOrder() == null ? 0.0 : orderApply.getFreeGiftOrder();
            Double freeGiftCanuse = orderApply.getFreeGiftCanuse() == null ? 0.0 : orderApply.getFreeGiftCanuse();
            Double[] _rtns = new Double[]{MathUtils.div((Double)freeGiftTotal, (Double)Constant.FREE_RATE), MathUtils.div((Double)freeGiftOrder, (Double)Constant.FREE_RATE), MathUtils.div((Double)freeGiftCanuse, (Double)Constant.FREE_RATE)};
            model.addAttribute("freeGiftQuantitys", (Object)_rtns);
        }
        return "order/view.ftl";
    }

    @RequestMapping(value={"/viewAll.do"}, method={RequestMethod.GET})
    public String viewAll(@RequestParam(value="id", required=false) String id, Model model) {
        OrderApply orderApply = this.loadOrderApply(id, model);
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId());
        this.fillInfoToProducts(orderApply, products);
        ArrayList<OrderProduct> selectedProducts = new ArrayList<OrderProduct>();
        ArrayList<OrderProduct> noselectedProducts = new ArrayList<OrderProduct>();
        for (OrderProduct product : products) {
            if (product.getQuantity() != null && product.getQuantity() > 0.0) {
                selectedProducts.add(product);
                continue;
            }
            noselectedProducts.add(product);
        }
        for (OrderProduct product : noselectedProducts) {
            selectedProducts.add(product);
        }
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        String[] exchangeOrdersByIds = orderApply.getExchangeOrderIdArray();
        if (exchangeOrdersByIds != null) {
            List<ExchangeOrder> exchangeOrders = null;
            exchangeOrders = this.scoreService.getExchangeOrdersByIds(exchangeOrdersByIds);
            model.addAttribute("exchangeOrders", exchangeOrders);
        }
        model.addAttribute("products", (Object)JSON.toJSONString(selectedProducts));
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("auditInfos", this.auditService.find(id));
        if (Constant.SCALETYPE_QUANTITY.equals(contract.getFreeScaleType())) {
            Double freeGiftTotal = orderApply.getFreeGiftTotal() == null ? 0.0 : orderApply.getFreeGiftTotal();
            Double freeGiftOrder = orderApply.getFreeGiftOrder() == null ? 0.0 : orderApply.getFreeGiftOrder();
            Double freeGiftCanuse = orderApply.getFreeGiftCanuse() == null ? 0.0 : orderApply.getFreeGiftCanuse();
            Double[] _rtns = new Double[]{MathUtils.div((Double)freeGiftTotal, (Double)Constant.FREE_RATE), MathUtils.div((Double)freeGiftOrder, (Double)Constant.FREE_RATE), MathUtils.div((Double)freeGiftCanuse, (Double)Constant.FREE_RATE)};
            model.addAttribute("freeGiftQuantitys", (Object)_rtns);
        }
        return "order/view.ftl";
    }

    @RequestMapping(value={"/applys.do"})
    public String applys(@ModelAttribute(value="condition") OrderApplyCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setApplyerId(me.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(con.getState())) {
            con.getOrderStates().add(con.getState());
        }
        this.findApplys(con, "order by o.createDt desc", model);
        return "order/applys.ftl";
    }

    @RequestMapping(value={"/approves.do"})
    public String approves(@ModelAttribute(value="condition") OrderApplyCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setSupplierId(me.getCurrentPartner().getId());
        if (con.getState() == null || con.getState().equals("dealing")) {
            con.getOrderStates().add(TCBJEnum.AuditState.approve.getValue());
        } else if (con.getState().equals("dealed")) {
            con.getOrderStates().add(TCBJEnum.AuditState.approvePass.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.approveNoPass.getValue());
        } else {
            con.getOrderStates().add(TCBJEnum.AuditState.approve.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.approvePass.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.approveNoPass.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.balancePass.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.sended.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.received.getValue());
        }
        con.setEmployeeId(me.getId());
        con.setRegionFilter(true);
        this.findApplys(con, "order by o.lastUpdateDt desc", model);
        return "order/approves.ftl";
    }

    @RequestMapping(value={"/getDiscount.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getDiscount(@Valid @RequestBody OrderApply orderApply, BindingResult errors, Model model) {
        OrderApply old;
        if (StringUtils.isNotEmpty(orderApply.getId()) && (old = this.service.getSimpleOrderApply(orderApply.getId())) != null) {
            orderApply.setDt(old.getDt());
        }
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        List<Double[]> rtns = this.getDiscounts(orderApply, regularDt, customer.getPrecision());
        return this.getSuccessResult(rtns);
    }

    @RequestMapping(value={"/getOtherDiscount.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getOtherDiscount(@Valid @RequestBody OrderApply orderApply, BindingResult errors, Model model) {
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        Double[] rtns = this.getOtherDiscounts(orderApply, regularDt, customer.getPrecision());
        return this.getSuccessResult(rtns);
    }

    @RequestMapping(value={"/getGiftRule.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getGiftRuel(@Valid @RequestBody OrderApply orderApply, BindingResult errors, Model model) {
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        List<OrderApplyItem> items = orderApply.getOrderApplyItems();
        ArrayList<OrderApplyItem> newItems = new ArrayList<OrderApplyItem>();
        for (OrderApplyItem item : items) {
            if (!"PRODUCT".equals(item.getProductType())) continue;
            newItems.add(item);
        }
        List<GiftService.GiftWarp> giftWarps = this.giftService.getGiftRuleAvailableList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt, newItems, null);
        Double totalGiftBalance = this.giftService.getGiftBalance(orderApply.getApplyerId(), orderApply.getSupplierId());
        Double orderGiftBalance = this.giftService.getCurrentGiftBalance(orderApply);
        Double canuseGiftBalance = MathUtils.add((Double)totalGiftBalance, (Double)orderGiftBalance);
        Object[] rtns = new Object[]{giftWarps, totalGiftBalance, orderGiftBalance, canuseGiftBalance};
        return this.getSuccessResult(rtns);
    }

    @RequestMapping(value={"/getFreeGift.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getFreeGift(@Valid @RequestBody OrderApply orderApply, BindingResult errors, Model model) {
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        Double[] rtns = this.getFreeGiftMoneys(orderApply, contract.getFreeScaleType(), customer.getPrecision());
        return this.getSuccessResult(rtns);
    }

    @RequestMapping(value={"/getGiftRuleOnApprove.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getGiftRuelOnApprove(@Valid @RequestBody OrderApply orderApply, BindingResult errors, Model model) {
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        List<OrderApplyItem> items = orderApply.getOrderApplyItems();
        ArrayList<OrderApplyItem> newItems = new ArrayList<OrderApplyItem>();
        for (OrderApplyItem item : items) {
            if (!"PRODUCT".equals(item.getProductType())) continue;
            item.setQuantity(item.getActQuantity());
            item.setPrice(item.getActPrice());
            item.setMoney(MathUtils.sub((Double)item.getActQuantity(), (Double)item.getActPrice()));
            newItems.add(item);
        }
        List<GiftService.GiftWarp> giftWarps = this.giftService.getGiftRuleAvailableList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt, newItems, orderApply.getId());
        Double totalGiftBalance = this.giftService.getGiftBalance(orderApply.getApplyerId(), orderApply.getSupplierId());
        Double orderGiftBalance = this.giftService.getCurrentGiftBalance(orderApply);
        Double canuseGiftBalance = MathUtils.add((Double)totalGiftBalance, (Double)orderGiftBalance);
        Object[] rtns = new Object[]{giftWarps, totalGiftBalance, orderGiftBalance, canuseGiftBalance};
        return this.getSuccessResult(rtns);
    }

    @RequestMapping(value={"/getCredit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getCredit(@RequestParam(value="applyerId", required=false) String applyerId, Model model) {
        Partner applyer = this.partnerService.getSimplePartner(applyerId);
        PartnerCredit credit = this.creditServcie.getCredit(applyer);
        return this.getSuccessResult(credit);
    }

    @RequestMapping(value={"/getSuppliers.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public List<Partner> getSuppliers(String applyerId, Model model) {
        return this.clientService.getSuppliers(applyerId);
    }

    @RequestMapping(value={"/canUnApprove.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result canUnApprove(@RequestParam(value="id", required=false) String id, Model model) {
        boolean tof = false;
        try {
            tof = true;
        }
        catch (Exception exception) {}
        return this.getSuccessResult(tof);
    }

    @RequestMapping(value={"/test.do"}, method={RequestMethod.GET})
    public String test(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        List<OrderProduct> products = this.getProducts(me.getCurrentPartner().getId(), me.getCurrentPartner().getParPartnerId());
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        return "order/test.ftl";
    }

    @RequestMapping(value={"/test1.do"})
    public String test(HttpServletResponse response, Model model) throws IOException {
        List pm = this.baseDao.findEntity(" from PactMain p ", PactMain.class);
        StringBuffer sb = new StringBuffer();
        sb.append("<table>");
        for (PactMain p : pm) {
            List<OrderProduct> products = null;
            try {
                products = this.getProducts(p.getApplyerId(), p.getSupplierId());
            }
            catch (Exception exception) {}
            if (products == null) continue;
            List<PrAdjdetail> details = this.priceAdjustService.getList(p.getApplyerId(), p.getSupplierId(), new Date());
            Customer customer = this._getCustomer(p.getApplyerId(), p.getSupplierId());
            this.calculateProductPrices(p, products, details, customer.getPrecision());
            for (OrderProduct product : products) {
                sb.append("<tr>");
                sb.append("<td>").append(p.getApplyerName()).append("</td>");
                sb.append("<td>").append(product.getNo()).append("</td>");
                sb.append("<td>").append(product.getName()).append("</td>");
                sb.append("<td>").append(product.getPrice()).append("</td>");
                sb.append("</tr>");
            }
        }
        sb.append("</table>");
        model.addAttribute("rtn", (Object)sb.toString());
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.loadOrderApply(id, model);
        orderApply.setApplyerId(me.getCurrentPartner().getId());
        this.assertOrderBelongMyPartner(orderApply, me);
        this.fillSupplierInOrderApply(orderApply, request);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        if (orderApply.isDraft() && contract != null) {
            orderApply.setContractNo(contract.getPactNo());
        }
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        this.assertHasPushOrder(orderApply, customer);
        model.addAttribute("addresses", (Object)JSON.toJSONString(customer.getReceiptAddresses()));
        if (orderApply.isNew()) {
            orderApply.bindEditData(customer, me);
        } else {
            orderApply.bindOrderContacts(me);
        }
        orderApply.bindCannotEditData(customer, me);
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId());
        this.fillQuantityToProducts(orderApply, products);
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.calculateProductPrices(contract, products, details, customer.getPrecision());
        this.calculateProductStocks(products, orderApply.getSupplierId(), null, customer.getIsStockShow());
        List<QyAllotRow> qys = this.qyAllService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        Map<String, Double> productUsedQuantitys = null;
        if (qys != null && qys.size() > 0) {
            Date startDt = qys.get(0).getStartDate();
            productUsedQuantitys = this.service.findProductApplyQuantitys(orderApply.getApplyerId(), orderApply.getSupplierId(), startDt, regularDt, orderApply.getId());
        }
        this.calculateProductLimitQuantitys(products, qys, productUsedQuantitys);
        this.calculateOrderMoney(orderApply, products, customer.getPrecision());
        Double fineTotalMoney = this.getFineMoney(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt, orderApply.getId());
        orderApply.setFineTotalMoney(fineTotalMoney);
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        if (!orderApply.isNew() && (orderApply.getDiscountMoney() > 0.0 || orderApply.getGiftDiscountMoney() > 0.0)) {
            List<Double[]> discounts = this.getDiscounts(orderApply, regularDt, customer.getPrecision());
            model.addAttribute("discounts", discounts);
        }
        if (!orderApply.isNew() && orderApply.getOtherDiscountMoney() > 0.0) {
            Double[] otherDiscount = this.getOtherDiscounts(orderApply, regularDt, customer.getPrecision());
            model.addAttribute("otherDiscounts", (Object)otherDiscount);
        }
        if (!orderApply.isNew() && orderApply.getFreeGiftMoney() > 0.0) {
            Double[] rtns = this.getFreeGiftMoneys(orderApply, contract.getFreeScaleType(), customer.getPrecision());
            model.addAttribute("freeGiftMoneys", (Object)rtns);
            if (Constant.SCALETYPE_QUANTITY.equals(contract.getFreeScaleType())) {
                Double[] _rtns = new Double[]{MathUtils.div((Double)rtns[0], (Double)Constant.FREE_RATE), MathUtils.div((Double)rtns[1], (Double)Constant.FREE_RATE), MathUtils.div((Double)rtns[2], (Double)Constant.FREE_RATE)};
                model.addAttribute("freeGiftQuantitys", (Object)_rtns);
            }
        }
        List<ExchangeOrder> exchangeOrders = null;
        if (StringUtils.isEmpty(orderApply.getId()) && StringUtils.isEmpty(orderApply.getExchangeOrderIds())) {
            exchangeOrders = this.scoreService.getMyExchangeOrders(me.getCurrentPartner().getId());
            exchangeOrders = this.service.filterHasBind(orderApply.getApplyerId(), exchangeOrders, null);
        } else {
            exchangeOrders = this.scoreService.getExchangeOrdersByIds(orderApply.getExchangeOrderIdArray());
        }
        model.addAttribute("exchangeOrders", exchangeOrders);
        List<AuditInfo> auditInfos = this.auditService.find(orderApply.getId());
        model.addAttribute("auditInfos", auditInfos);
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("contract", (Object)contract);
        return "order/apply.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody OrderApply orderApply, BindingResult errors, HttpServletRequest request) {
        this.assertOrderApplyData(orderApply);
        Employee me = this.getCurrentEmployee();
        try {
            this.validateService.validateOrder(me, orderApply);
            this.giftService.validate(orderApply, orderApply.getActGiftQuantity());
        }
        catch (Exception e) {
            throw new AppException("3017", e.getMessage());
        }
        orderApply.fillInitData(me);
        this.assertOrderBelongMyPartner(orderApply, me);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.assertContractIsExsit(contract);
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        orderApply.bindCannotEditData(customer, me);
        if (StringUtils.isEmpty(orderApply.getSalesman()) || orderApply.getSalesman().trim().toLowerCase().equals("null")) {
            orderApply.setSalesman(customer.getCityManagerId());
        }
        OrderApply oldOrderApply = null;
        if (StringUtils.isNotEmpty(orderApply.getId())) {
            oldOrderApply = this.service.getSimpleOrderApply(orderApply.getId());
            this.assertOrderExist(oldOrderApply);
            this.assertOrderBelongMyPartner(oldOrderApply, me);
            this.assertOrderCanApply(oldOrderApply);
            if (!oldOrderApply.isDraft()) {
                orderApply.setState(oldOrderApply.getState());
                orderApply.setNo(oldOrderApply.getNo());
                orderApply.setDt(oldOrderApply.getDt());
                orderApply.setContractNo(oldOrderApply.getContractNo());
                orderApply.setNature(oldOrderApply.getNature());
            }
        }
        Partner applyer = this.assertOrderApplyerIsEffective(orderApply.getApplyerId());
        this.assertOrderSupplierIsEffective(orderApply.getSupplierId());
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId());
        if (oldOrderApply == null || !oldOrderApply.isApprovedNotPass()) {
            this.assertOrderProduct(orderApply, products);
        }
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.assertProductPrices(orderApply, contract, products, details, customer.getPrecision());
        List<QyAllotRow> qys = this.qyAllService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        Map<String, Double> productUsedQuantitys = null;
        if (qys != null && qys.size() > 0) {
            Date startDt = qys.get(0).getStartDate();
            productUsedQuantitys = this.service.findProductApplyQuantitys(orderApply.getApplyerId(), orderApply.getSupplierId(), startDt, regularDt, orderApply.getId());
        }
        this.assertProductLimitQuantitys(orderApply, products, qys, productUsedQuantitys);
        if ("N".equals(customer.getNothingCanOrderFlg())) {
            this.assertProductAvailableStock(orderApply.getOrderApplyItems(), products, orderApply.getSupplierId(), customer.getIsStockShow());
        }
        if ("Y".equals(customer.getIsStockReceived())) {
            this.assertProductIsOverRepository(orderApply);
        }
        this.calculateOrderMoney(orderApply, customer.getPrecision());
        this.assertFineMoney(orderApply, products, regularDt, customer.getPrecision());
        this.assertOrderOtherDiacount(orderApply, regularDt, customer.getPrecision());
        this.assertOrderDiacount(orderApply, regularDt, customer.getPrecision());
        this.assertOrderFreeGiftMoney(orderApply, contract.getFreeScaleType(), customer.getPrecision());
        if (orderApply.isToApprove()) {
            if (StringUtils.isEmpty(orderApply.getNo())) {
                String type = orderApply.getNature().equals(TCBJEnum.OrderNature.buy.getValue()) ? "01" : "02";
                orderApply.setNo(this.orderNoService.maxNo(applyer.getNo(), type));
                orderApply.setDt(DateUtils.now());
                orderApply.setContractNo(contract.getPactNo());
            }
            orderApply.setState(TCBJEnum.AuditState.approve.getValue());
        }
        double totalQuantity = 0.0;
        PactMain pactMain = this.pactMainService.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        for (OrderApplyItem item : orderApply.getOrderApplyItems()) {
            item.fillInitData(me);
            double quantity = item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity();
            double price = item.getActPrice() == null || item.getActPrice() == 0.0 ? item.getPrice() : item.getActPrice();
            if (!"GIFT".equals(item.getProductType())) continue;
            if ("QUANTITY".equals(pactMain.getScaleType())) {
                totalQuantity += quantity;
                continue;
            }
            totalQuantity += MathUtils.mul((Double)quantity, (Double)price).doubleValue();
        }
        orderApply.setActGiftQuantity(totalQuantity);
        orderApply.setGiftQuantity(totalQuantity);
        if (orderApply.getExchangeOrderIdArray() != null && this.service.hasBind(orderApply.getApplyerId(), orderApply.getExchangeOrderIdArray(), orderApply.getId())) {
            throw new AppException("3063");
        }
        this.service.saveOrUpdateOrderApply(orderApply, false);
        if (orderApply.isToAudit() || orderApply.isToApprove()) {
            AuditInfo auditInfo = new AuditInfo(orderApply.getId(), "OrderApply", orderApply.getState(), orderApply.getRemark(), me.getId(), DateUtils.now());
            this.auditService.add(auditInfo);
        }
        return this.getSuccessResult(null);
    }

    private void assertProductAvailableStock(List<OrderApplyItem> orderApplyItems, List<OrderProduct> products, String supplierId, String isShow) {
        this.calculateProductStocks(products, supplierId, null, isShow);
        for (OrderApplyItem orderItem : orderApplyItems) {
            for (OrderProduct allProdcut : products) {
                if (!orderItem.getProductId().equals(allProdcut.getId()) || !orderItem.getProductId().equals(allProdcut.getId()) || !(orderItem.getQuantity() > allProdcut.getRemainQuantity())) continue;
                throw new AppException("3008", allProdcut.getName());
            }
        }
    }

    @RequestMapping(value={"/approve.do"}, method={RequestMethod.GET})
    public String approve(@RequestParam(value="id", required=true) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.loadOrderApply(id, model);
        this.assertOrderBelongMySupplier(orderApply, me);
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        orderApply.setBigAreaId(customer.getBigAreaCode());
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        int days = customer.getTransportOnlineCode() == null ? 3 : customer.getTransportOnlineCode().intValue();
        orderApply.setPredictArriveDt(DateUtils.getDateAfter((Date)orderApply.getDt(), (int)days));
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId());
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        model.addAttribute("contract", (Object)contract);
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.calculateProductPrices(contract, products, details, customer.getPrecision());
        this.calculateProductStocks(products, orderApply.getSupplierId(), orderApply.getId(), "Y");
        List<QyAllotRow> qys = this.qyAllService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        Map<String, Double> productUsedQuantitys = null;
        if (qys != null && qys.size() > 0) {
            Date startDt = qys.get(0).getStartDate();
            productUsedQuantitys = this.service.findProductApplyQuantitys(orderApply.getApplyerId(), orderApply.getSupplierId(), startDt, regularDt, orderApply.getId());
        }
        this.calculateProductLimitQuantitys(products, qys, productUsedQuantitys);
        this.fillQuantityToProducts(orderApply, products);
        this.calculateOrderMoney(orderApply, products, customer.getPrecision());
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        Double fineTotalMoney = this.getFineMoney(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt, orderApply.getId());
        orderApply.setFineTotalMoney(fineTotalMoney);
        if (orderApply.getDiscountMoney() > 0.0 || orderApply.getGiftDiscountMoney() > 0.0) {
            List<Double[]> discounts = this.getDiscounts(orderApply, regularDt, customer.getPrecision());
            model.addAttribute("discounts", discounts);
        }
        if (!orderApply.isNew() && (orderApply.getOtherDiscountMoney() > 0.0 || orderApply.getGiftDiscountMoney() > 0.0)) {
            Double[] otherDiscount = this.getOtherDiscounts(orderApply, regularDt, customer.getPrecision());
            model.addAttribute("otherDiscounts", (Object)otherDiscount);
        }
        if (!orderApply.isNew() && orderApply.getFreeGiftMoney() > 0.0) {
            Double[] rtns = this.getFreeGiftMoneys(orderApply, contract.getFreeScaleType(), customer.getPrecision());
            model.addAttribute("freeGiftMoneys", (Object)rtns);
            if (Constant.SCALETYPE_QUANTITY.equals(contract.getFreeScaleType())) {
                Double[] _rtns = new Double[]{MathUtils.div((Double)rtns[0], (Double)Constant.FREE_RATE), MathUtils.div((Double)rtns[1], (Double)Constant.FREE_RATE), MathUtils.div((Double)rtns[2], (Double)Constant.FREE_RATE)};
                model.addAttribute("freeGiftQuantitys", (Object)_rtns);
            }
        }
        List<ExchangeOrder> exchangeOrders = this.scoreService.getExchangeOrdersByIds(orderApply.getExchangeOrderIdArray());
        model.addAttribute("exchangeOrders", exchangeOrders);
        model.addAttribute("customer", (Object)customer);
        return "order/approve.ftl";
    }

    @RequestMapping(value={"/unApprove.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result unApprove_do(@RequestParam(value="id", required=false) String id, HttpServletRequest request) {
        OrderApply order = this.service.getSimpleOrderApply(id);
        if (order == null) {
            throw new AppException("3061");
        }
        this.service.unApprove(id);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/approve.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result approve_do(@Valid @RequestBody OrderApply orderApply, BindingResult errors, HttpServletRequest request) {
        Partner supplier;
        Employee me = this.getCurrentEmployee();
        OrderApply oldOrderApply = this.service.getSimpleOrderApply(orderApply.getId());
        this.assertOrderExist(oldOrderApply);
        this.assertOrderCanApprove(oldOrderApply);
        if (!orderApply.isPass()) {
            this.service.updateOrderApplyState(orderApply.getId(), TCBJEnum.AuditState.approveNoPass.getValue(), me);
            AuditInfo auditInfo = new AuditInfo();
            auditInfo.setCreateDt(DateUtils.now());
            auditInfo.setCreatorId(me.getId());
            auditInfo.setBusinessId(orderApply.getId());
            auditInfo.setBusinessType("OrderApply");
            auditInfo.setOpinion(TCBJEnum.AuditState.approveNoPass.getValue());
            auditInfo.setRemark(orderApply.getRemark());
            this.auditService.add(auditInfo);
            return this.getSuccessResult(null);
        }
        this.assertApplyerIsValid(orderApply.getApplyerId());
        orderApply.setApproverId(me.getId());
        orderApply.setApproveDt(DateUtils.now());
        orderApply.setState(TCBJEnum.AuditState.approvePass.getValue());
        this.stockService.getStorageQuantityByPartner(orderApply.getSupplierId());
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        if (StringUtils.isEmpty(orderApply.getSalesman()) || orderApply.getSalesman().trim().toLowerCase().equals("null")) {
            orderApply.setSalesman(customer.getCityManagerId());
        }
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.assertContractIsExsit(contract);
        this.assertOrderSupplierIsEffective(orderApply.getSupplierId());
        this.calculateOrderMoney(orderApply, customer.getPrecision());
        if (orderApply.getNature().equals(TCBJEnum.OrderNature.buy.getValue())) {
            this.assertOrderOtherDiacount(orderApply, regularDt, customer.getPrecision());
            this.assertOrderDiacount(orderApply, regularDt, customer.getPrecision());
            this.assertOrderFreeGiftMoney(orderApply, contract.getFreeScaleType(), customer.getPrecision());
            List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId());
            List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
            this.calculateProductPrices(contract, products, details, customer.getPrecision());
            this.assertFineMoney(orderApply, products, regularDt, customer.getPrecision());
        } else {
            Double contractTotalMoney = this.calculateContractOrdersMoney(orderApply.getApplyerId(), orderApply.getContractNo());
            Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(orderApply.getApplyerId(), orderApply.getContractNo(), orderApply.getId());
            this.calculateRtnOrderMoney(orderApply, contract, contractTotalMoney, contractFullyMoney, customer.getPrecision());
        }
        for (OrderApplyItem item : orderApply.getOrderApplyItems()) {
            item.fillInitData(me);
        }
        try {
            this.giftService.validate(orderApply, orderApply.getActGiftQuantity());
        }
        catch (Exception e) {
            throw new AppException("3017", e.getMessage());
        }
        boolean triggerEAS = false;
        if (oldOrderApply.isOrder()) {
            triggerEAS = true;
        } else {
            supplier = this.partnerService.getSimplePartner(orderApply.getSupplierId());
            if (!supplier.isOrg()) {
                triggerEAS = true;
            }
        }
        this.service.approveOrderApply(orderApply, triggerEAS, customer.getPrecision());
        if (triggerEAS) {
            this.service.triggerEAS(orderApply.getId());
        }
        if (!(supplier = this.partnerService.getPartner(orderApply.getSupplierId())).isOrg()) {
            this.service.addOrderInOut(orderApply.getId(), me);
        }
        AuditInfo auditInfo = new AuditInfo();
        auditInfo.setCreateDt(DateUtils.now());
        auditInfo.setCreatorId(me.getId());
        auditInfo.setBusinessId(orderApply.getId());
        auditInfo.setBusinessType("OrderApply");
        auditInfo.setOpinion(TCBJEnum.AuditState.approvePass.getValue());
        auditInfo.setRemark(orderApply.getRemark());
        this.auditService.add(auditInfo);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/del.do"})
    public String del(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.service.getSimpleOrderApply(id);
        this.assertOrderBelongMyPartner(orderApply, me);
        this.assertOrderIsDraft(orderApply);
        this.service.delOrderApply(id);
        return "redirect:applys.do?conscope=session";
    }

    @RequestMapping(value={"/cancel.do"})
    public String cancel(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.service.getSimpleOrderApply(id);
        this.assertOrderBelongMyPartner(orderApply, me);
        this.assertOrderIsApproveNotPass(orderApply);
        this.service.cancelOrderApply(id, orderApply.getExchangeOrderIdArray());
        return "redirect:applys.do?conscope=session";
    }

    @RequestMapping(value={"/viewPrices.do"}, method={RequestMethod.GET})
    public String viewPrices(@RequestParam(value="applyerId", required=false) String applyerId, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        String supplierId = me.getCurrentPartner().getId();
        if (StringUtils.isEmpty(applyerId)) {
            supplierId = me.getCurrentPartner().getParPartnerId();
            applyerId = me.getCurrentPartner().getId();
        }
        model.addAttribute("applyerId", (Object)applyerId);
        Date regularDt = DateUtils.now();
        PactMain contract = this.getPactMain(applyerId, supplierId, regularDt);
        if (contract == null) {
            return "order/viewPrices.ftl";
        }
        List<OrderProduct> products = this.getProducts(applyerId, supplierId);
        Customer customer = this._getCustomer(applyerId, supplierId);
        List<PrAdjdetail> details = this.priceAdjustService.getList(applyerId, supplierId, regularDt);
        this.calculateProductPrices(contract, products, details, customer.getPrecision());
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        return "order/viewPrices.ftl";
    }

    @RequestMapping(value={"findIntRebatemg.do"})
    public String get_details(String supplierId, Model model) {
        List<IntRebatemg> its = this.intrebatemgservice.getlist(supplierId, this.getCurrentEmployee().getCurrentPartner().getId(), DateUtils.now());
        model.addAttribute("its", its);
        return "order/findIntRebatemg.ftl";
    }
}

