/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order.base;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.aplfine.AplfineService;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.common.AuditService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.IntRebatemg;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.entity.PartnerProductREL;
import com.tcbj.crm.entity.PrAdjdetail;
import com.tcbj.crm.entity.QyAllotRow;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.fgift.FGiftFacadeService;
import com.tcbj.crm.intrebatemg.GiftIntRebatemgService;
import com.tcbj.crm.intrebatemg.IntRebatemgFacadeService;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.crm.order.PriceFormula;
import com.tcbj.crm.order.validate.ValidateService;
import com.tcbj.crm.pactMain.PactMainService;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.priceAdjust.PriceAdjustService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.score.ScoreService;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;

public class BaseApplyController
extends BaseController {
    @Autowired
    protected OrderApplyService service;
    @Autowired
    protected AuditService auditService;
    @Autowired
    protected ValidateService validateService;
    @Autowired
    protected ClientService clientService;
    @Autowired
    protected ProductService productService;
    @Autowired
    protected IntRebatemgFacadeService discountService;
    @Autowired
    protected GiftIntRebatemgService otherDiscountService;
    @Autowired
    protected OrderNoService orderNoService;
    @Autowired
    protected PartnerService partnerService;
    @Autowired
    protected PactMainService pactMainService;
    @Autowired
    protected StockService stockService;
    @Autowired
    protected PriceAdjustService priceAdjustService;
    @Autowired
    protected AplfineService aplfineService;
    @Autowired
    protected FGiftFacadeService fGiftService;
    @Autowired
    ScoreService scoreService;

    protected void findApplys(OrderApplyCondition con, String orderby, Model model) {
        con = (OrderApplyCondition)this.wrapCondition(con, "applys");
        Employee me = this.getCurrentEmployee();
        Page orderApplys = this.service.findOrderApplys(con, orderby);
        model.addAttribute("me", (Object)me);
        model.addAttribute("orderApplys", (Object)orderApplys);
        model.addAttribute("condition", (Object)con);
    }

    protected OrderApply loadOrderApply(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = null;
        if (StringUtils.isEmpty(id)) {
            orderApply = new OrderApply();
            orderApply.fillInitData(me);
        } else {
            orderApply = this.service.getOrderApply(id);
            this.assertOrderExist(orderApply);
        }
        model.addAttribute("me", (Object)me);
        model.addAttribute("orderApply", (Object)orderApply);
        model.addAttribute("orderApplyItems", (Object)JSON.toJSONString(orderApply.getOrderApplyItems()));
        return orderApply;
    }

    protected Partner getSupplier(String applyerId) {
        Partner applyer = this.partnerService.getSimplePartner(applyerId);
        List<Partner> suppliers = this.clientService.getSuppliers(applyerId);
        for (Partner s : suppliers) {
            if (!s.getId().equals(applyer.getParentPartnerId())) continue;
            return s;
        }
        if (suppliers == null || suppliers.size() == 0) {
            return null;
        }
        return suppliers.get(0);
    }

    protected void calculateOrderMoney(OrderApply orderApply, List<OrderProduct> products, Integer precision) {
        Double totalQuantity = 0.0;
        Double totalMoney = 0.0;
        Double productTotalMoney = 0.0;
        Double giftTotalMoney = 0.0;
        for (OrderProduct product : products) {
            product.setMoney(MathUtils.m2((Double)(product.getActPrice() * product.getActQuantity()), (int)precision));
            totalQuantity = totalQuantity + product.getActQuantity();
            totalMoney = totalMoney + product.getMoney();
            if ("PRODUCT".equals(product.getProductType())) {
                if (!"N".equals(product.getValuation())) continue;
                productTotalMoney = productTotalMoney + product.getMoney();
                continue;
            }
            if (!"GIFT".equals(product.getProductType()) && !"MATERIAL".equals(product.getProductType()) || !"N".equals(product.getValuation())) continue;
            giftTotalMoney = giftTotalMoney + product.getMoney();
        }
        orderApply.setQuantity(totalQuantity);
        orderApply.setTotalMoney(MathUtils.m2((Double)totalMoney, (int)precision));
        orderApply.setProductTotalMoney(MathUtils.m2((Double)productTotalMoney, (int)precision));
        orderApply.setGiftTotalMoney(MathUtils.m2((Double)giftTotalMoney, (int)precision));
        orderApply.setRemainMoney(MathUtils.m2((Double)(totalMoney - orderApply.getDiscountMoney() - orderApply.getGiftDiscountMoney() - orderApply.getOtherDiscountMoney() - orderApply.getFreeMoney() - orderApply.getFreeGiftMoney()), (int)precision));
    }

    protected void calculateOrderMoney(OrderApply orderApply, Integer precision) {
        Double totalQuantity = 0.0;
        Double totalMoney = 0.0;
        Double productMoney = 0.0;
        Double giftMoney = 0.0;
        for (OrderApplyItem item : orderApply.getOrderApplyItems()) {
            item.setMoney(MathUtils.m2((Double)(item.getActPrice() * item.getActQuantity()), (int)precision));
            totalQuantity = MathUtils.add((Double)totalQuantity, (Double)item.getActQuantity());
            totalMoney = MathUtils.add((Double)totalMoney, (Double)item.getMoney());
            Product p = Cache.getProduct(item.getProductId());
            if (p == null) continue;
            if (p.getOrderProdType().equals("PRODUCT")) {
                productMoney = MathUtils.add((Double)productMoney, (Double)item.getMoney());
                continue;
            }
            if (!p.getOrderProdType().equals("GIFT") && !p.getOrderProdType().equals("MATERIAL")) continue;
            giftMoney = MathUtils.add((Double)giftMoney, (Double)item.getMoney());
        }
        orderApply.setProductTotalMoney(productMoney);
        orderApply.setGiftTotalMoney(giftMoney);
        orderApply.setQuantity(totalQuantity);
        orderApply.setTotalMoney(MathUtils.m2((Double)totalMoney, (int)precision));
        orderApply.setRemainMoney(MathUtils.m2((Double)(totalMoney - orderApply.getDiscountMoney() - orderApply.getGiftDiscountMoney() - orderApply.getOtherDiscountMoney() - orderApply.getFreeMoney() - orderApply.getFreeGiftMoney()), (int)precision));
    }

    protected void fillInfoToProducts(OrderApply orderApply, List<OrderProduct> products) {
        if (StringUtils.isEmpty(orderApply.getId())) {
            return;
        }
        List<OrderApplyItem> items = orderApply.getOrderApplyItems();
        HashMap<String, OrderProduct> productMap = new HashMap<String, OrderProduct>();
        for (OrderProduct product : products) {
            productMap.put(product.getId(), product);
        }
        for (OrderApplyItem item : items) {
            OrderProduct product;
            String productId = item.getProductId();
            if (StringUtils.isEmpty(productId) || (product = (OrderProduct)productMap.get(productId)) == null) continue;
            product.setBasePrice(item.getBasePrice());
            product.setPrice(item.getPrice());
            product.setQuantity(item.getQuantity());
            product.setActPrice(item.getActPrice());
            product.setActQuantity(item.getActQuantity());
            product.setMoney(item.getMoney());
            product.setPriceFormula(item.getPriceFormula());
            product.setIsFree(item.getIsFree());
        }
    }

    protected void fillQuantityToProducts(OrderApply orderApply, List<OrderProduct> products) {
        if (StringUtils.isEmpty(orderApply.getId())) {
            return;
        }
        List<OrderApplyItem> items = orderApply.getOrderApplyItems();
        HashMap<String, OrderProduct> productMap = new HashMap<String, OrderProduct>();
        for (OrderProduct product : products) {
            productMap.put(product.getId(), product);
        }
        HashMap<String, OrderApplyItem> repeatMap = new HashMap<String, OrderApplyItem>();
        for (OrderApplyItem item : items) {
            OrderProduct product;
            String productId = item.getProductId();
            if (StringUtils.isEmpty(productId) || (product = (OrderProduct)productMap.get(productId)) == null) continue;
            if (repeatMap.containsKey(productId)) {
                OrderProduct _product = product;
                product = product.clone();
                products.add(products.indexOf(_product), product);
            } else {
                repeatMap.put(productId, item);
            }
            product.setQuantity(item.getQuantity());
            product.setActQuantity(item.getActQuantity());
            product.setIsFree(item.getIsFree());
            product.setBatchNum(item.getBatchNum());
        }
    }

    protected void fillPriceToProducts(OrderApply orderApply, List<OrderProduct> products) {
        if (StringUtils.isEmpty(orderApply.getId())) {
            return;
        }
        List<OrderApplyItem> items = orderApply.getOrderApplyItems();
        HashMap<String, OrderProduct> productMap = new HashMap<String, OrderProduct>();
        for (OrderProduct product : products) {
            productMap.put(product.getId(), product);
        }
        for (OrderApplyItem item : items) {
            OrderProduct product;
            String productId = item.getProductId();
            if (StringUtils.isEmpty(productId) || (product = (OrderProduct)productMap.get(productId)) == null) continue;
            product.setPrice(item.getPrice());
            product.setActPrice(item.getActPrice());
        }
    }

    protected void fillSupplierInOrderApply(OrderApply orderApply, HttpServletRequest request) {
        if (request.getParameter("supplierId") != null) {
            orderApply.setSupplierId(request.getParameter("supplierId"));
        }
        if (StringUtils.isNotEmpty(orderApply.getId())) {
            return;
        }
        Partner supplier = this.getSupplier(orderApply.getApplyerId());
        if (supplier == null) {
            throw new AppException("3012");
        }
        orderApply.setSupplierId(supplier.getId());
    }

    protected void assertContractIsExsit(PactMain PactMain2) {
        if (PactMain2 == null) {
            throw new AppException("3015");
        }
    }

    protected PactMain getPactMain(String applyerId, String supplierId, Date dt) {
        if (dt == null) {
            dt = DateUtils.now();
        }
        return this.pactMainService.getPactMain(applyerId, supplierId, dt);
    }

    protected PactMain getPactMain(String supplierId, String contractNo) {
        return this.pactMainService.getPactMain(supplierId, contractNo);
    }

    protected List<PactMain> getPactMains(String applyerId, String supplierId) {
        return this.pactMainService.getPactMainList(applyerId, supplierId);
    }

    protected void dealOrderApplyBaseDate(OrderApply order) {
    }

    protected Partner assertOrderApplyerIsEffective(String applyerId) {
        Partner applyer = this.partnerService.getSimplePartner(applyerId);
        if (applyer == null) {
            throw new AppException("3013");
        }
        return applyer;
    }

    protected Partner assertOrderSupplierIsEffective(String supplierId) {
        Partner supplier = this.partnerService.getSimplePartner(supplierId);
        if (supplier == null) {
            throw new AppException("3014");
        }
        return supplier;
    }

    protected void assertOrderProduct(OrderApply order, List<OrderProduct> products) {
        List<OrderApplyItem> items = order.getOrderApplyItems();
        HashMap<String, OrderProduct> productMap = new HashMap<String, OrderProduct>();
        for (OrderProduct product : products) {
            productMap.put(product.getId(), product);
        }
        for (OrderApplyItem item : items) {
            String productId = item.getProductId();
            if (StringUtils.isEmpty(productId)) {
                throw new AppException("3006", item.getProductName());
            }
            OrderProduct product = (OrderProduct)productMap.get(productId);
            if (product != null) continue;
            throw new AppException("3006", item.getProductName());
        }
    }

    protected void assertFineMoney(OrderApply orderApply, List<OrderProduct> products, Date orderDt, Integer precision) {
        Double fineMoney = orderApply.getFineMoney();
        if (fineMoney == null) {
            return;
        }
        Double penaltyMoney = this.getFineMoney(orderApply.getApplyerId(), orderApply.getSupplierId(), orderDt, orderApply.getId());
        Double useMoney = 0.0;
        for (OrderApplyItem item : orderApply.getOrderApplyItems()) {
            for (OrderProduct product : products) {
                if (!product.getId().equals(item.getProductId())) continue;
                Double penaltyRate = product.getPenaltyRate();
                Double basePrice = product.getBasePrice();
                useMoney = useMoney + basePrice * penaltyRate * item.getActQuantity() / 100.0;
            }
        }
        orderApply.setFineTotalMoney(penaltyMoney);
        if (fineMoney > MathUtils.m2((Double)useMoney, (int)precision) || fineMoney > penaltyMoney) {
            throw new AppException("3021");
        }
    }

    protected void assertHasPushOrder(OrderApply orderApply, Customer customer) {
        if (StringUtils.isNotEmpty(orderApply.getId())) {
            return;
        }
        if ("N".equals(customer.getZdbhFlg())) {
            return;
        }
        if (this.service.hasPushOrder(customer.getSupplierId(), customer.getApplyerId())) {
            throw new AppException("3064");
        }
    }

    protected void assertOrderDiacount(OrderApply order, Date orderDt, Integer precision) {
        List<Double[]> discounts = this.getDiscounts(order, orderDt, precision);
        Double[] productDiscounts = discounts.get(0);
        Double[] giftDiscounts = discounts.get(1);
        if (order.getDiscountMoney() != null && order.getDiscountMoney() > 0.0) {
            if (order.getDiscountMoney() > productDiscounts[0]) {
                throw new AppException("3009");
            }
            if (order.getDiscountMoney() > productDiscounts[1]) {
                throw new AppException("3010");
            }
        }
        order.setDiscountTotalMoney(productDiscounts[0]);
        order.setDiscountCanuseMoney(productDiscounts[1]);
        if (order.getGiftDiscountMoney() != null && order.getGiftDiscountMoney() > 0.0) {
            if (order.getGiftDiscountMoney() > giftDiscounts[0]) {
                throw new AppException("3009");
            }
            if (order.getGiftDiscountMoney() > giftDiscounts[1]) {
                throw new AppException("3010");
            }
        }
        order.setGiftDiscountTotalMoney(giftDiscounts[0]);
        order.setGiftDiscountCanuseMoney(giftDiscounts[1]);
    }

    protected void assertOrderOtherDiacount(OrderApply order, Date orderDt, Integer precision) {
        Double[] otherDiscounts = this.getOtherDiscounts(order, orderDt, precision);
        if (order.getOtherDiscountMoney() != null && order.getOtherDiscountMoney() > 0.0) {
            if (order.getDiscountMoney() > 0.0 || order.getGiftDiscountMoney() > 0.0) {
                throw new AppException("3024");
            }
            if (order.getFreeGiftMoney() > 0.0) {
                throw new AppException("3025");
            }
            if (order.getOtherDiscountMoney() > otherDiscounts[0]) {
                throw new AppException("3026");
            }
            if (order.getOtherDiscountMoney() > otherDiscounts[1]) {
                throw new AppException("3027");
            }
        }
        order.setOtherDiscountTotalMoney(otherDiscounts[0]);
        order.setOtherDiscountCanuseMoney(otherDiscounts[1]);
    }

    protected Double[] getFreeGiftMoneys(OrderApply orderApply, String freeScaleType, Integer precision) {
        Double usingFreeGiftBalance = this.service.getUsingFreeGiftMoney(orderApply.getApplyerId(), orderApply.getSupplierId(), freeScaleType, orderApply.getId(), precision);
        Double totalFreeGiftBalance = this.fGiftService.getGiftBalance(orderApply.getApplyerId(), orderApply.getSupplierId(), precision);
        Double orderFreeGiftBalance = this.fGiftService.getCurrentGiftBalance(orderApply, precision);
        totalFreeGiftBalance = (totalFreeGiftBalance = MathUtils.sub((Double)totalFreeGiftBalance, (Double)usingFreeGiftBalance)) < 0.0 ? 0.0 : totalFreeGiftBalance;
        orderFreeGiftBalance = orderFreeGiftBalance < 0.0 ? 0.0 : orderFreeGiftBalance;
        Double canuseFreeGiftBalance = MathUtils.add((Double)totalFreeGiftBalance, (Double)orderFreeGiftBalance);
        Double[] rtns = new Double[]{totalFreeGiftBalance, orderFreeGiftBalance, canuseFreeGiftBalance};
        return rtns;
    }

    protected void assertOrderFreeGiftMoney(OrderApply orderApply, String freeScaleType, Integer precision) {
        Double[] rtns = this.getFreeGiftMoneys(orderApply, freeScaleType, precision);
        Double totalFreeGiftBalance = rtns[0];
        Double orderFreeGiftBalance = rtns[1];
        Double canuseFreeGiftBalance = rtns[2];
        Double tmp = orderApply.getFreeGiftMoney();
        if (tmp > canuseFreeGiftBalance) {
            throw new AppException("3022");
        }
        Double freeGiftMoney = orderApply.getFreeGiftMoney();
        Double giftDiscountMoney = orderApply.getGiftDiscountMoney();
        Double giftTotalMoney = orderApply.getGiftTotalMoney();
        if (freeGiftMoney + giftDiscountMoney > giftTotalMoney) {
            throw new AppException("3023");
        }
        orderApply.setFreeGiftTotal(totalFreeGiftBalance);
        orderApply.setFreeGiftOrder(orderFreeGiftBalance);
    }

    protected Double getFineMoney(String applyerId, String supplierId, Date dt, String excludeId) {
        Double tmp = this.aplfineService.getAplfineValue(supplierId, applyerId, dt);
        Double usingPenalty = this.service.getUsingPenalty(applyerId, supplierId, excludeId);
        tmp = tmp == null ? 0.0 : tmp - usingPenalty;
        tmp = tmp < 0.0 ? 0.0 : tmp;
        return tmp;
    }

    protected List<Double[]> getDiscounts(OrderApply orderApply, Date dt, Integer precision) {
        String applyerId = orderApply.getApplyerId();
        String supplierId = orderApply.getSupplierId();
        String excludeId = orderApply.getId();
        Double productTotalMoney = orderApply.getProductTotalMoney();
        Double giftTotalMoney = orderApply.getGiftTotalMoney();
        Double[] usingDiscounts = this.service.getUsingDiacount(applyerId, supplierId, excludeId);
        Double[] productMoney = new Double[]{productTotalMoney, usingDiscounts[0]};
        Double[] giftMoney = new Double[]{giftTotalMoney, usingDiscounts[1]};
        Double[] discounts = this.discountService.getDiscount(supplierId, applyerId, dt, productMoney, giftMoney, precision);
        Double[] productDiscounts = new Double[]{discounts[0], discounts[1]};
        Double[] giftDiscounts = new Double[]{discounts[2], discounts[3]};
        ArrayList<Double[]> rtns = new ArrayList<Double[]>();
        rtns.add(productDiscounts);
        rtns.add(giftDiscounts);
        return rtns;
    }

    protected Double[] getOtherDiscounts(OrderApply orderApply, Date dt, Integer precision) {
        String applyerId = orderApply.getApplyerId();
        String supplierId = orderApply.getSupplierId();
        String excludeId = orderApply.getId();
        Double giftTotalMoney = orderApply.getGiftTotalMoney() == null ? 0.0 : orderApply.getGiftTotalMoney();
        Double usingOtherDiscount = this.service.getUsingOtherDiacount(applyerId, supplierId, excludeId);
        Double[] discounts = this.otherDiscountService.getDiscount(supplierId, applyerId, dt, giftTotalMoney, usingOtherDiscount, precision);
        return discounts;
    }

    private Double[] getDiscounts2(List<IntRebatemg> discounts, Double usingDiscount, Double totalMoney, Integer precision) {
        if (discounts == null || discounts.size() == 0) {
            Double[] rtns = new Double[]{0.0, 0.0};
            return rtns;
        }
        Double discountTotal = 0.0;
        Double discountLimit = 0.0;
        for (IntRebatemg discount : discounts) {
            Double total = discount.getRebateMoney() != null ? discount.getRebateMoney() : 0.0;
            Double used = discount.getWithheldMoney() != null ? discount.getWithheldMoney() : 0.0;
            Double remain = total - used;
            Double rate = discount.getIndentMoneyPercent();
            totalMoney = totalMoney == null ? 0.0 : totalMoney;
            if (rate != null && totalMoney > 0.0) {
                discountLimit = discountLimit + totalMoney * rate / 100.0;
                totalMoney = totalMoney - discountLimit;
            }
            discountTotal = discountTotal + remain;
        }
        discountTotal = discountTotal - usingDiscount;
        discountLimit = discountLimit > discountTotal ? discountTotal : discountLimit;
        Double[] discountMoneys = new Double[]{MathUtils.m2((Double)discountTotal, (int)precision), MathUtils.m2((Double)discountLimit, (int)precision)};
        return discountMoneys;
    }

    private Map<String, Double> getStocks(String supplierId) {
        if (supplierId == null) {
            return null;
        }
        return this.stockService.getQuantityByPartner(supplierId);
    }

    private Double getProductSubTypeRate(OrderProduct product) {
        String subType = product.getSubType();
        DictionaryItem item = Cache.getItem("TCBJ_PRODUCT_SUB_TYPE", subType);
        if (item == null || StringUtils.isEmpty(item.getLow())) {
            return null;
        }
        try {
            return Double.valueOf(item.getLow().trim());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Integer getPrecision(String partnerName) {
        String[] names;
        Integer precision = 2;
        String[] stringArray = names = new String[]{"\u8302\u540d\u5927\u53c2\u6797\u8fde\u9501\u836f\u5e97\u6709\u9650\u516c\u53f8", "\u5927\u53c2\u6797\u533b\u836f\u96c6\u56e2\u80a1\u4efd\u6709\u9650\u516c\u53f8", "\u4e2d\u8054", "\u76ca\u4e30", "\u4e91\u5357\u9e3f\u7fd4\u4e00\u5fc3\u5802\u836f\u4e1a\uff08\u96c6\u56e2\uff09\u80a1\u4efd\u6709\u9650\u516c\u53f8", "\u4e30\u6c83\u8fbe\u533b\u836f\u7269\u6d41(\u6e56\u5357)\u6709\u9650\u516c\u53f8", "\u5927\u53c2\u6797\u533b\u836f\u96c6\u56e2\u80a1\u4efd\u6709\u9650\u516c\u53f81", "\u56fd\u836f\u63a7\u80a1\u56fd\u5927\u836f\u623f\u6709\u9650\u516c\u53f8", "\u4e30\u6c83\u8fbe\u533b\u836f\u7269\u6d41\uff08\u6e56\u5357\uff09\u6709\u9650\u516c\u53f8", "\u90d1\u5dde\u5927\u53c2\u6797\u8fde\u9501\u836f\u5e97\u6709\u9650\u516c\u53f8", "\u4f5b\u5c71\u5e02\u987a\u5fb7\u533a\u5927\u53c2\u6797\u836f\u4e1a\u6709\u9650\u516c\u53f8", "\u6c5f\u95e8\u5927\u53c2\u6797\u836f\u5e97\u6709\u9650\u516c\u53f8", "\u6f4d\u574a\u767e\u8d27\u96c6\u56e2\u80a1\u4efd\u6709\u9650\u516c\u53f8", "\u82cf\u679c\u8d85\u5e02\u6709\u9650\u516c\u53f8"};
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(partnerName)) {
                precision = 2;
                break;
            }
            ++n2;
        }
        if ("\u798f\u5efa\u65b0\u7d2b\u91d1\u533b\u836f\u6709\u9650\u516c\u53f8".equals(partnerName)) {
            precision = 0;
        }
        return precision;
    }

    private void calculateProductPrice(PactMain contract, OrderProduct product, PrAdjdetail adjdetail, Integer precision) {
        Double rate;
        if (contract == null) {
            return;
        }
        Double basePrice = product.getPrice() == null ? 0.0 : product.getPrice();
        Double settleRate = contract.getSettleRate() == null ? 100.0 : contract.getSettleRate();
        Double productSubTypeRate = this.getProductSubTypeRate(product);
        Double d = rate = productSubTypeRate != null ? productSubTypeRate : settleRate;
        if (adjdetail == null) {
            product.setPrice(MathUtils.m2((Double)(basePrice * rate / 100.0), (int)precision));
            product.setActPrice(product.getPrice());
            product.setPriceFormula(new PriceFormula(basePrice, contract.getPactNo(), settleRate, productSubTypeRate).toString());
            return;
        }
        Double price = adjdetail.getPrice();
        Double discount = adjdetail.getDisCount() == null ? 0.0 : adjdetail.getDisCount();
        Double markup = adjdetail.getMarkUp() == null ? 0.0 : adjdetail.getMarkUp();
        adjdetail.getNumberFrom();
        adjdetail.getNumberTo();
        product.setPenaltyRate(discount);
        if (price != null) {
            product.setPrice(price);
            product.setActPrice(product.getPrice());
            product.setPriceFormula(new PriceFormula(basePrice, contract.getPactNo(), adjdetail.getId(), price).toString());
            return;
        }
        Double rtnPrice = MathUtils.m2((Double)(basePrice * (rate + discount) / 100.0 + markup), (int)precision);
        product.setPrice(rtnPrice);
        product.setActPrice(product.getPrice());
        product.setPriceFormula(new PriceFormula(basePrice, contract.getPactNo(), settleRate, productSubTypeRate, adjdetail.getId(), discount, markup).toString());
    }

    protected void calculateProductPrices(PactMain contract, List<OrderProduct> products, List<PrAdjdetail> adjdetails, Integer precision) {
        if (contract == null || products == null) {
            return;
        }
        adjdetails = adjdetails == null ? new ArrayList() : adjdetails;
        for (OrderProduct product : products) {
            boolean hasPrAdjdetail = false;
            for (PrAdjdetail detail : adjdetails) {
                if (!product.getPartnerId().equals(detail.getApplyerId()) || !product.getId().equals(detail.getProductId())) continue;
                hasPrAdjdetail = true;
                this.calculateProductPrice(contract, product, detail, precision);
                break;
            }
            if (hasPrAdjdetail) continue;
            this.calculateProductPrice(contract, product, null, precision);
        }
    }

    protected void assertProductPrices(OrderApply order, PactMain contract, List<OrderProduct> products, List<PrAdjdetail> adjdetails, Integer precision) {
        this.calculateProductPrices(contract, products, adjdetails, precision);
        for (OrderApplyItem item : order.getOrderApplyItems()) {
            for (OrderProduct product : products) {
                if (!product.getId().equals(item.getProductId()) || product.getPrice().doubleValue() == item.getPrice().doubleValue()) continue;
                throw new AppException("3007", product.getName());
            }
        }
    }

    protected void calculateProductLimitQuantitys(List<OrderProduct> products, List<QyAllotRow> qys, Map<String, Double> productApplyQuantitys) {
        if (products == null || qys == null || qys.size() == 0) {
            return;
        }
        block0: for (OrderProduct product : products) {
            for (QyAllotRow qy : qys) {
                if (!product.getPartnerId().equals(qy.getApplyerId()) || !product.getId().equals(qy.getProductId())) continue;
                Double usedQuantity = 0.0;
                if (productApplyQuantitys != null) {
                    usedQuantity = productApplyQuantitys.get(product.getId());
                }
                usedQuantity = usedQuantity == null ? 0.0 : usedQuantity;
                Double lq = qy.getQuotaNumber() - usedQuantity;
                lq = lq > 0.0 ? lq : 0.0;
                product.setLimitQuantity(lq);
                product.setQuantity(product.getLimitQuantity());
                product.setActQuantity(product.getLimitQuantity());
                continue block0;
            }
        }
    }

    protected void assertProductLimitQuantitys(OrderApply order, List<OrderProduct> products, List<QyAllotRow> qys, Map<String, Double> productApplyQuantitys) {
        this.calculateProductLimitQuantitys(products, qys, productApplyQuantitys);
        for (OrderApplyItem item : order.getOrderApplyItems()) {
            for (OrderProduct product : products) {
                if (!product.getId().equals(item.getProductId()) || !(product.getLimitQuantity() < item.getQuantity())) continue;
                throw new AppException("3008", product.getName());
            }
        }
    }

    protected void assertRtnOrderQuantitys(OrderApply order, List<OrderProduct> products) {
        for (OrderApplyItem item : order.getOrderApplyItems()) {
            for (OrderProduct product : products) {
                if (!product.getId().equals(item.getProductId()) || !(product.getRemainQuantity() < item.getQuantity())) continue;
                throw new AppException("3016", product.getName());
            }
        }
    }

    private Map<String, Double> getOrderProductQuantity(OrderApply order) {
        HashMap<String, Double> orderProductQuantitys = new HashMap<String, Double>();
        if (order == null || order.getOrderApplyItems() == null) {
            return orderProductQuantitys;
        }
        for (OrderApplyItem item : order.getOrderApplyItems()) {
            String productId = item.getProductId();
            Double quantity = item.getActPrice();
            if (quantity == null || !(quantity > 0.0)) continue;
            orderProductQuantitys.put(productId, quantity);
        }
        return orderProductQuantitys;
    }

    protected void assertProductIsOverRepository(OrderApply order) {
        Map<String, Double> stockProductQuantitys = this.stockService.getQuantityByPartner(order.getApplyerId());
        Map<String, Double> stockProductMaxLimits = this.productService.getParnterProductMaxLimits(order.getApplyerId());
        if (order == null || order.getOrderApplyItems() == null) {
            return;
        }
        for (OrderApplyItem item : order.getOrderApplyItems()) {
            String productId = item.getProductId();
            Double quantity = item.getActQuantity();
            if (quantity == null || quantity <= 0.0) continue;
            Double stockProductQuantity = stockProductQuantitys.get(productId);
            Double stockProductMaxLimit = stockProductMaxLimits.get(productId);
            stockProductQuantity = stockProductQuantity == null ? 0.0 : stockProductQuantity;
            if (stockProductMaxLimit == null || !(MathUtils.add((Double)quantity, (Double)stockProductQuantity) > stockProductMaxLimit)) continue;
            String error = String.valueOf(item.getProductName()) + "\u91c7\u8d2d\u6570\u91cf\uff1a" + quantity + ",\u5e93\u5b58\u73b0\u6709\u6570\u91cf\uff1a" + stockProductQuantity + ",\u5e93\u5b58\u4e0a\u9650\u6570\u91cf\uff1a" + stockProductMaxLimit + ",\u91c7\u8d2d\u6570\u91cf+\u5e93\u5b58\u73b0\u6709\u91cf \u5fc5\u987b<=\u5e93\u5b58\u4e0a\u7ebf\u6570\u91cf";
            throw new AppException("0010", error);
        }
    }

    protected void calculateRtnOrderMoney(OrderApply order, PactMain contract, Double contractTotalMoney, Double contractFreeMoney, Integer precision) {
        Double fullyRate = contract.getReturnsFreeQuota() == null ? 0.0 : contract.getReturnsFreeQuota();
        Double remainRate = contract.getOvertopMoneyQuota() == null ? 100.0 : contract.getOvertopMoneyQuota();
        Double totalMoney = order.getTotalMoney();
        Double fullyMoney = contractTotalMoney * fullyRate / 100.0 - contractFreeMoney;
        fullyMoney = fullyMoney > totalMoney ? totalMoney : fullyMoney;
        fullyMoney = fullyMoney < 0.0 ? 0.0 : fullyMoney;
        Double retunsOvertopMoney = MathUtils.m2((Double)((totalMoney - fullyMoney) * remainRate / 100.0), (int)precision);
        Double retunsMoney = MathUtils.m2((Double)(fullyMoney + retunsOvertopMoney), (int)precision);
        order.setRetunsFullyMoney(fullyMoney);
        order.setRetunsOvertopMoney(retunsOvertopMoney);
        order.setReturnedMoney(retunsMoney);
    }

    protected void calculateProductStocks(List<OrderProduct> orderProducts, String supplierId, String extendId, String isShow) {
        Partner supplier = this.partnerService.getSimplePartner(supplierId);
        Map<String, Double> applyedQuantitys = null;
        applyedQuantitys = supplier.isOrg() ? this.service.findProductApplyedQuantitysForOrg(supplierId, extendId) : this.service.findProductApplyedQuantitys(supplierId, extendId);
        Map<String, Double> scoreMap = this.scoreService.findProductGiftQuantity(supplierId);
        Map<String, Double> easMap = this.getStocks(supplierId);
        for (OrderProduct orderProduct : orderProducts) {
            String productId = orderProduct.getId();
            Double applyedQuantity = applyedQuantitys.get(productId) == null ? 0.0 : applyedQuantitys.get(productId);
            Double scoreQuantity = scoreMap.get(productId) == null ? 0.0 : scoreMap.get(productId);
            Double quantity = easMap.get(productId) == null ? 0.0 : easMap.get(productId);
            quantity = quantity - applyedQuantity - scoreQuantity;
            orderProduct.setRemainQuantity(quantity);
            if ("Y".equals(isShow)) {
                orderProduct.setRemainQuantityView("N".equals(orderProduct.getDisplayStock()) ? "0" : quantity.toString());
                continue;
            }
            if (quantity <= 0.0 || "N".equals(orderProduct.getDisplayStock())) {
                orderProduct.setRemainQuantityView("\u65e0");
                continue;
            }
            orderProduct.setRemainQuantityView("\u6709");
        }
    }

    protected void calculateRtnProductStocks(List<OrderProduct> orderProducts, String applyerId, String extendId) {
        Map<String, Double> applyedQuantitys = this.service.findRtnProductApplyedQuantitys(applyerId, extendId);
        Map<String, Double> stocks = this.getStocks(applyerId);
        for (OrderProduct orderProduct : orderProducts) {
            String productId = orderProduct.getId();
            Double applyedQuantity = applyedQuantitys.get(productId);
            Double quantity = stocks.get(productId);
            if (quantity == null) {
                quantity = 0.0;
            }
            if (applyedQuantity != null) {
                quantity = quantity - applyedQuantity;
            }
            orderProduct.setRemainQuantity(quantity);
        }
    }

    protected Double calculateContractOrdersMoney(String applyerId, String contractNo) {
        return this.service.getContractOrdersMoney(applyerId, contractNo);
    }

    protected Double calculateContractRtnOrdersFullyMoney(String applyerId, String contractNo, String extendId) {
        return this.service.getContractRtnOrdersFullyMoney(applyerId, contractNo, extendId);
    }

    protected List<OrderProduct> getProducts(String applyerId, String supplierId) {
        return this.getProducts(applyerId, supplierId, true);
    }

    protected List<OrderProduct> getProducts(String applyerId, String supplierId, boolean effective) {
        ArrayList<OrderProduct> orderProducts = new ArrayList<OrderProduct>();
        List<Object> products = this.productService.getPartnerProducts(applyerId, supplierId, effective);
        for (Object ps : products) {
            Product p = (Product)((Object[])ps)[0];
            PartnerProductREL pd = (PartnerProductREL)((Object[])ps)[1];
            OrderProduct orderProduct = new OrderProduct(p, pd);
            orderProducts.add(orderProduct);
        }
        return orderProducts;
    }

    protected List<OrderProduct> getProducts(OrderApply orderApply) {
        List<OrderApplyItem> items = orderApply.getOrderApplyItems();
        ArrayList<OrderProduct> orderProducts = new ArrayList<OrderProduct>();
        for (OrderApplyItem item : items) {
            OrderProduct product = new OrderProduct(orderApply.getApplyerId(), item);
            orderProducts.add(product);
        }
        return orderProducts;
    }

    protected Customer _getCustomer(String applyerId, String supplierId) {
        return this.clientService.getCustomer(supplierId, applyerId);
    }

    protected List<Customer> getCustomers(String supplierId) {
        return this.clientService.findPartnerApplys(supplierId);
    }

    protected void assertOrderApplyData(OrderApply order) {
        if (order.getQuantity() <= 0.0) {
            throw new AppException("3065");
        }
    }

    protected void assertOrderExist(OrderApply order) {
        if (order == null) {
            throw new AppException("3001");
        }
    }

    protected void assertOrderCanApply(OrderApply order) {
        if (!order.getState().equals(TCBJEnum.AuditState.draft.getValue()) && !order.getState().equals(TCBJEnum.AuditState.approveNoPass.getValue())) {
            throw new AppException("3029");
        }
    }

    protected void assertOrderCanApprove(OrderApply order) {
        if (!order.getState().equals(TCBJEnum.AuditState.approve.getValue())) {
            throw new AppException("3028");
        }
    }

    protected void assertOrderIsDraft(OrderApply order) {
        if (!order.getState().equals(TCBJEnum.AuditState.draft.getValue())) {
            throw new AppException("3002");
        }
    }

    protected void assertOrderIsApproveNotPass(OrderApply order) {
        if (!order.getState().equals(TCBJEnum.AuditState.approveNoPass.getValue())) {
            throw new AppException("3002");
        }
    }

    protected void assertOrderCreatedByMe(OrderApply order, Employee me) {
        if (!order.getCreatorId().equals(me.getId())) {
            throw new AppException("3003");
        }
    }

    protected void assertOrderBelongMyPartner(OrderApply order, Employee me) {
        if (!order.getApplyerId().equals(me.getCurrentPartner().getId())) {
            throw new AppException("3004");
        }
    }

    protected void assertOrderBelongMySupplier(OrderApply order, Employee me) {
        if (!order.getSupplierId().equals(me.getCurrentPartner().getId())) {
            throw new AppException("3005");
        }
    }

    protected void assertApplyerIsValid(String applyerId) {
        Partner applyer = this.partnerService.getSimplePartner(applyerId);
        if (applyer == null) {
            throw new AppException("3030");
        }
        if (StringUtils.isEmpty(applyer.getClientAppNo())) {
            throw new AppException("3031");
        }
    }
}

