/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order.validate;

import com.tcbj.crm.entity.IntRule;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.order.validate.Validator;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SingleRule5Validator
extends Validator {
    @Override
    protected void validate(Employee emp, OrderApply order, List<IntRule> ruleList, BaseDao baseDao) throws Exception {
        if (ruleList == null || ruleList.size() == 0) {
            return;
        }
        Iterator<IntRule> it = ruleList.iterator();
        while (it.hasNext()) {
            IntRule rule = it.next();
            if (!rule.getLocusOfControl().equals("ITEM") || !rule.getControlContent().equals("ITEM_HIGH_AMT")) continue;
            it.remove();
            List<OrderApplyItem> items = order.getOrderApplyItems();
            for (OrderApplyItem item : items) {
                if (!item.getProductId().equals(rule.getProductId())) continue;
                try {
                    if (!(item.getQuantity() * item.getPrice() > Double.parseDouble(rule.getControllingValue()))) continue;
                    throw new Exception(String.valueOf(item.getProductName()) + "\u4ea7\u54c1\u8ba2\u8d27\u91d1\u989d\u4e0d\u80fd\u9ad8\u4e8e" + rule.getControllingValue());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }
}

