/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.orderinout;

import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderInOut;
import com.tcbj.crm.entity.OrderInOutItem;
import com.tcbj.crm.orderinout.Opt;
import com.tcbj.crm.orderinout.OrderInOutCondition;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.stock.UpdateStockItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.OrderInOutView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderinoutService")
public class OrderInOutService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    StockService stockService;

    public Page findOrderOuts(String partnerId, OrderInOutCondition condition, String orderby) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" select v from OrderInOutView v,Partner p where 1=1 ");
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append(" and (");
        HQL.append(" (v.supplierId=? and v.nature=? and p.id=v.applyerId )");
        args.add(partnerId);
        args.add(TCBJEnum.OrderNature.buy.getValue());
        HQL.append(" or ");
        HQL.append(" (v.applyerId=? and v.nature=? and p.id=v.supplierId )");
        args.add(partnerId);
        args.add(TCBJEnum.OrderNature.rtn.getValue());
        HQL.append(" ) ");
        if (StringUtils.isNotEmpty(condition.getReceivePartnerName())) {
            HQL.append(" and p.name like ? ");
            args.add("%" + condition.getReceivePartnerName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getNo())) {
            HQL.append(" and v.no like ? ");
            args.add("%" + condition.getNo().trim() + "%");
        }
        if (condition.getOrderDtS() != null) {
            HQL.append(" and v.dt >= ?");
            args.add(condition.getOrderDtS());
        }
        if (condition.getOrderDtE() != null) {
            HQL.append(" and v.dt <= ?");
            args.add(condition.getOrderDtE());
        }
        if (condition.getStates().size() > 0) {
            int i = 0;
            HQL.append(" and ( ");
            for (String state : condition.getStates()) {
                HQL.append(" v.state = ?");
                if (++i < condition.getStates().size()) {
                    HQL.append(" or ");
                }
                args.add(state);
            }
            HQL.append(" ) ");
        }
        if (StringUtils.isNotEmpty(orderby)) {
            HQL.append(" " + orderby);
        }
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, condition.getPageno().intValue());
    }

    public Page findOrderIns(String partnerId, OrderInOutCondition condition, String orderby) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" select v from OrderInOutView v,Partner p where 1=1 ");
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append(" and (");
        HQL.append(" (v.applyerId=? and v.nature=? and p.id=v.supplierId )");
        args.add(partnerId);
        args.add(TCBJEnum.OrderNature.buy.getValue());
        HQL.append(" or ");
        HQL.append(" (v.supplierId=? and v.nature=? and p.id=v.applyerId )");
        args.add(partnerId);
        args.add(TCBJEnum.OrderNature.rtn.getValue());
        HQL.append(" ) ");
        if (StringUtils.isNotEmpty(condition.getSendPartnerName())) {
            HQL.append(" and p.name like ? ");
            args.add("%" + condition.getSendPartnerName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getNo())) {
            HQL.append(" and v.no like ? ");
            args.add("%" + condition.getNo().trim() + "%");
        }
        if (condition.getOrderDtS() != null) {
            HQL.append(" and v.dt >= ?");
            args.add(condition.getOrderDtS());
        }
        if (condition.getOrderDtE() != null) {
            HQL.append(" and v.dt <= ?");
            args.add(condition.getOrderDtE());
        }
        if (condition.getStates().size() > 0) {
            int i = 0;
            HQL.append(" and ( ");
            for (String state : condition.getStates()) {
                HQL.append(" v.state = ?");
                if (++i < condition.getStates().size()) {
                    HQL.append(" or ");
                }
                args.add(state);
            }
            HQL.append(" ) ");
        }
        if (StringUtils.isNotEmpty(orderby)) {
            HQL.append(" " + orderby);
        }
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, condition.getPageno().intValue());
    }

    public List<OrderInOutItem> getOrderInOutItems(String id) {
        String hql = "select o from OrderInOutItem o , Product p where o.productId = p.id and o.orderInOutId=? order by p.no ";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, OrderInOutItem.class);
    }

    public OrderInOutView get(String id) {
        OrderInOutView obj = (OrderInOutView)this.baseDao.get(OrderInOutView.class, (Serializable)((Object)id));
        return obj;
    }

    public void createOrderInOut(OrderInOut io) {
        this.baseDao.save((Object)io);
        for (OrderInOutItem item : io.getOrderInOutItems()) {
            item.setOrderInOutId(io.getId());
        }
        this.baseDao.save(io.getOrderInOutItems());
    }

    public void send(Employee me, Opt opt) {
        String hql = " update OrderInOut set outerId=?,outOperateDt=?,outDt=?,outRepositoryId=?, state=? where id=? ";
        Object[] args = new Object[]{opt.getOperatorId(), opt.getOperateDt(), opt.getDt(), opt.getRepositoryId(), TCBJEnum.SendOrReceiveState.sended.getValue(), opt.getId()};
        this.baseDao.executeHQL(hql, args);
        OrderInOut orderInout = (OrderInOut)this.baseDao.get(OrderInOut.class, (Serializable)((Object)opt.getId()));
        OrderApply order = (OrderApply)this.baseDao.get(OrderApply.class, (Serializable)((Object)orderInout.getOrderId()));
        List list = this.baseDao.findEntity(" from OrderInOutItem where orderInOutId = ?", (Object)opt.getId(), OrderInOutItem.class);
        ArrayList<UpdateStockItem> slist = new ArrayList<UpdateStockItem>();
        for (OrderInOutItem item : list) {
            UpdateStockItem sitem = new UpdateStockItem(item.getId(), item.getProductId(), 0.0 - item.getQuantity());
            sitem.setSupplierId(order.getSupplierId());
            sitem.setApplyerId(order.getApplyerId());
            slist.add(sitem);
        }
        this.stockService.updateQuantity(me, order.getSupplierId(), opt.getRepositoryId(), opt.getId(), "\u53d1\u8d27", slist);
    }

    public void receive(Employee me, Opt opt) {
        String hql = " update OrderInOut set inerId=?,inOperateDt=?,inDt=?,inRepositoryId=?, state=? where id=? ";
        Object[] args = new Object[]{opt.getOperatorId(), opt.getOperateDt(), opt.getDt(), opt.getRepositoryId(), TCBJEnum.SendOrReceiveState.received.getValue(), opt.getId()};
        this.baseDao.executeHQL(hql, args);
        OrderInOut orderInout = (OrderInOut)this.baseDao.get(OrderInOut.class, (Serializable)((Object)opt.getId()));
        OrderApply order = (OrderApply)this.baseDao.get(OrderApply.class, (Serializable)((Object)orderInout.getOrderId()));
        List list = this.baseDao.findEntity(" from OrderInOutItem where orderInOutId = ?", (Object)opt.getId(), OrderInOutItem.class);
        ArrayList<UpdateStockItem> slist = new ArrayList<UpdateStockItem>();
        for (OrderInOutItem item : list) {
            UpdateStockItem sitem = new UpdateStockItem(item.getId(), item.getProductId(), item.getQuantity());
            sitem.setSupplierId(order.getSupplierId());
            sitem.setApplyerId(order.getApplyerId());
            slist.add(sitem);
        }
        this.stockService.updateQuantity(me, order.getSupplierId(), opt.getRepositoryId(), opt.getId(), "\u6536\u8d27", slist);
    }
}

