/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.org;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.dao.BaseDao;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orgService")
public class OrgService {
    @Autowired
    BaseDao baseDao;

    public String getChildNodeTree(String id, String orgId) throws JSONException {
        String str = "";
        JSONArray nodes = new JSONArray();
        List pns = this.baseDao.findEntity("from Region p where p.parentId = ? and p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by startDate ", new Object[]{id, orgId, new Date(), new Date()}, Region.class);
        for (Region pn : pns) {
            JSONObject node = new JSONObject();
            node.put("id", (Object)pn.getId());
            node.put("pId", (Object)pn.getParentId());
            node.put("name", (Object)pn.getRegionName());
            node.put("iconSkin", (Object)"start");
            node.put("url", (Object)"/org/list");
            node.put("level", (Object)"level");
            node.put("isParent", (Object)"true");
            nodes.put((Object)node);
        }
        List cts = this.baseDao.findEntity("from Customer c where c.areaCode = ? and c.supplierId = ?", new Object[]{id, orgId}, Customer.class);
        for (Customer ct : cts) {
            JSONObject node1 = new JSONObject();
            node1.put("id", (Object)ct.getApplyerId());
            node1.put("pId", (Object)ct.getSupplierId());
            node1.put("name", (Object)ct.getApplyerName());
            node1.put("iconSkin", (Object)"root");
            node1.put("partnerId", (Object)"partnerId");
            node1.put("isParent", (Object)"true");
            node1.put("url", (Object)"/org/list");
            node1.put("partner", (Object)"true");
            node1.put("level", (Object)"level");
            nodes.put((Object)node1);
        }
        List cms = this.baseDao.findEntity("from Customer c where c.supplierId = ?", new Object[]{id}, Customer.class);
        for (Customer cm : cms) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)cm.getApplyerId());
            node2.put("pId", (Object)cm.getSupplierId());
            node2.put("name", (Object)cm.getApplyerName());
            node2.put("iconSkin", (Object)"root");
            node2.put("isParent", (Object)"true");
            node2.put("url", (Object)"/org/list");
            node2.put("partner", (Object)"true");
            node2.put("level", (Object)"level");
            nodes.put((Object)node2);
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public String getOrgTree(Partner pt) throws Exception {
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject rootNode = new JSONObject();
        rootNode.put("id", (Object)pt.getId());
        rootNode.put("pId", (Object)pt.getParentPartnerId());
        rootNode.put("name", (Object)pt.getName());
        rootNode.put("open", (Object)"true");
        rootNode.put("iconSkin", (Object)"root");
        rootNode.put("level", (Object)"level");
        rootNode.put("partner", (Object)"true");
        rootNode.put("url", (Object)"/org/list");
        rootNode.put("isParent", (Object)"true");
        nodes.put((Object)rootNode);
        List dts = this.baseDao.findEntity("from ChannelType c where c.partnerId = ? and c.startDt < ? and (c.endDt > ? or c.endDt is null)", new Object[]{pt.getId(), new Date(), new Date()}, ChannelType.class);
        for (ChannelType dt : dts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)dt.getId());
            node2.put("pId", (Object)pt.getId());
            node2.put("name", (Object)dt.getName());
            node2.put("isParent", (Object)"true");
            node2.put("iconSkin", (Object)"start");
            node2.put("level", (Object)"level");
            nodes.put((Object)node2);
        }
        List<DictionaryItem> des = Cache.getItems("TCBJ_STORE_TYPE");
        for (DictionaryItem de : des) {
            JSONObject node = new JSONObject();
            node.put("id", (Object)de.getName());
            node.put("pId", (Object)pt.getId());
            node.put("name", (Object)de.getVal());
            node.put("url", (Object)"/org/list");
            node.put("level", (Object)"level");
            node.put("iconSkin", (Object)"MD");
            node.put("isParent", (Object)"true");
            nodes.put((Object)node);
            List sps = this.baseDao.findEntity("from ShopView s where s.parentDealerId = ? and s.shopType = ?", new Object[]{pt.getId(), de.getName()}, ShopView.class);
            for (ShopView sp : sps) {
                JSONObject node1 = new JSONObject();
                node1.put("id", (Object)sp.getId());
                node1.put("pId", (Object)de.getName());
                node1.put("name", (Object)sp.getShopName());
                node1.put("isParent", (Object)"true");
                node1.put("nocheck", (Object)"true");
                node1.put("MD", (Object)"MD");
                node1.put("partner", (Object)"true");
                node1.put("level", (Object)"level");
                nodes.put((Object)node1);
            }
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }
}

