/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.pactMain;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.client.PartnerShopService;
import com.tcbj.crm.entity.PactActivit;
import com.tcbj.crm.entity.PactChannel;
import com.tcbj.crm.entity.PactExpense;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.entity.PactMbo;
import com.tcbj.crm.entity.PactResourc;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.pactMain.PactMainCondition;
import com.tcbj.crm.pactMain.PactMainService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.PartnerShop;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pactMain"})
public class PactMainController
extends BaseController {
    @Autowired
    PactMainService pactmainservice;
    @Autowired
    ClientService clientService;
    @Autowired
    PartnerShopService partnerShopService;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String addGet(Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        model.addAttribute("pname", (Object)e);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String date = sdf.format(new Date());
        model.addAttribute("sDate", (Object)(String.valueOf(date) + "-01-01"));
        model.addAttribute("eDate", (Object)(String.valueOf(date) + "-12-31"));
        return "pactMain/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result addPost(@Valid @RequestBody PactMain pactmain, String so, BindingResult errors, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        this.pactmainservice.validataPactNo(pactmain.getPactNo(), e.getCurrentPartner().getId(), null);
        this.pactmainservice.validataDate(pactmain.getStartDate(), pactmain.getEndDate(), pactmain.getApplyerId(), e.getCurrentPartner().getId(), null);
        boolean flag = pactmain.getStartDate().before(pactmain.getEndDate());
        if (!flag) {
            throw new AppException("1103");
        }
        pactmain.fillInitData(e);
        if ("save".equals(so)) {
            pactmain.setPactState("1");
        } else {
            pactmain.setPactState("0");
        }
        this.pactmainservice.save(pactmain);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPost(@Valid @RequestBody PactMain pactmain, String so, BindingResult errors, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        this.pactmainservice.validataPactNo(pactmain.getPactNo(), e.getCurrentPartner().getId(), pactmain.getId());
        this.pactmainservice.validataDate(pactmain.getStartDate(), pactmain.getEndDate(), pactmain.getApplyerId(), e.getCurrentPartner().getId(), pactmain.getId());
        boolean flag = pactmain.getStartDate().before(pactmain.getEndDate());
        if (!flag) {
            throw new AppException("1103");
        }
        if ("save".equals(so)) {
            pactmain.setPactState("1");
        } else {
            pactmain.setPactState("0");
        }
        pactmain.fillInitData(e);
        this.pactmainservice.update(pactmain);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editBo.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editBo(@Valid @RequestBody PactMain pactmain, Model model, HttpServletRequest request) {
        this.pactmainservice.updatePactMbo(pactmain);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editPactResourc.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPactResourc(@Valid @RequestBody PactMain pactmain, Model model, HttpServletRequest request) {
        this.pactmainservice.updatePactResourc(pactmain);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editPactChannel.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPactChannel(@Valid @RequestBody PactMain pactmain, Model model, HttpServletRequest request) {
        this.pactmainservice.updatePactChannel(pactmain);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editPactActivit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPactActivit(@Valid @RequestBody PactMain pactmain, Model model, HttpServletRequest request) {
        this.pactmainservice.updatePactActivit(pactmain);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editPactExpense.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPactExpense(@Valid @RequestBody PactMain pactmain, Model model, HttpServletRequest request) {
        this.pactmainservice.updatePactExpense(pactmain);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, PactMainCondition condition, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        condition.setFirstParty(e.getCurrentPartner().getId());
        condition.setUserId(e.getId());
        model.addAttribute("page", (Object)this.pactmainservice.getList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        return "pactMain/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String editGet(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        Employee e = this.getCurrentEmployee();
        model.addAttribute("pname", (Object)e);
        PactMain pactmain = this.pactmainservice.get(id);
        List<PactResourc> pactResourcs = this.pactmainservice.getPactResourc(id);
        List<PactChannel> pactChannel = this.pactmainservice.getPactChannel(id);
        List<PactMbo> pactMbo = this.pactmainservice.getPactMbo(id);
        List<PactActivit> pactActivit = this.pactmainservice.getPactActivit(id);
        List<PactExpense> pactExpense = this.pactmainservice.getPactExpense(id);
        PartnerShop partnerShop = this.partnerShopService.get(pactmain.getApplyerId());
        model.addAttribute("RowGridData1", (Object)JSON.toJSONString(pactMbo));
        model.addAttribute("RowGridData2", (Object)JSON.toJSONString(pactResourcs));
        model.addAttribute("RowGridData3", (Object)JSON.toJSONString(pactChannel));
        model.addAttribute("RowGridData4", (Object)JSON.toJSONString(pactActivit));
        model.addAttribute("RowGridData5", (Object)JSON.toJSONStringWithDateFormat(pactExpense, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("customer", (Object)this.clientService.getCustomerAlone(e.getCurrentPartner().getId(), pactmain.getApplyerId()));
        model.addAttribute("master", (Object)pactmain);
        model.addAttribute("partner", (Object)partnerShop);
        return "pactMain/edit.ftl";
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String deleteGet(String id, Model model, HttpServletRequest request) {
        this.pactmainservice.delete(id);
        return "redirect:/pactMain/list.do";
    }

    @RequestMapping(value={"/getPartner.do"}, method={RequestMethod.POST})
    public void getPartner(String id, HttpServletResponse response) throws Exception {
        Employee me = this.getCurrentEmployee();
        PartnerShop partnerShop = this.partnerShopService.get(id);
        Customer customer = this.clientService.getCustomerAlone(me.getCurrentPartner().getId(), id);
        JSONObject rootNode = new JSONObject();
        rootNode.put("countyCode", (Object)partnerShop.getCountyName());
        rootNode.put("cityCode", (Object)partnerShop.getCityName());
        rootNode.put("provinceCode", (Object)partnerShop.getProvinceName());
        rootNode.put("saleChannelTypeCode", (Object)partnerShop.getSaleChannelTypeName());
        rootNode.put("bigAreaName", (Object)customer.getBigAreaName());
        rootNode.put("areaName", (Object)customer.getAreaName());
        rootNode.put("bigAreaManagerName", (Object)customer.getBigAreaManagerName());
        rootNode.put("areaManagerName", (Object)customer.getAreaManagerName());
        rootNode.put("applyerCode", (Object)customer.getApplyerCode());
        rootNode.put("saleChannelTypeCode", (Object)customer.getPartnerChnlTypeName());
        rootNode.put("cityManagerName", (Object)customer.getCityManagerName());
        response.getWriter().write(rootNode.toString());
    }

    @RequestMapping(value={"/submit.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result submit(String id, String status) {
        Employee e = this.getCurrentEmployee();
        PactMain pactmain = this.pactmainservice.get(id);
        this.pactmainservice.validataDate(pactmain.getStartDate(), pactmain.getEndDate(), pactmain.getApplyerId(), e.getCurrentPartner().getId(), pactmain.getId());
        boolean flag = pactmain.getStartDate().before(pactmain.getEndDate());
        if (!flag) {
            throw new AppException("1103");
        }
        this.pactmainservice.updateStatus(id, "1", e.getId());
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/del.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String del(String id, String status) {
        Employee e = this.getCurrentEmployee();
        this.pactmainservice.updateStatus(id, status, e.getId());
        return "redirect:/pactMain/list.do";
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String id, Model model) {
        Employee e = this.getCurrentEmployee();
        PactMain pactmain = this.pactmainservice.get(id);
        PartnerShop partnerShop = this.partnerShopService.get(pactmain.getApplyerId());
        model.addAttribute("customer", (Object)this.clientService.getCustomerAlone(e.getCurrentPartner().getId(), pactmain.getApplyerId()));
        model.addAttribute("master", (Object)pactmain);
        model.addAttribute("partner", (Object)partnerShop);
        List<PactResourc> pactResourcs = this.pactmainservice.getPactResourc(id);
        List<PactChannel> pactChannel = this.pactmainservice.getPactChannel(id);
        List<PactMbo> pactMbo = this.pactmainservice.getPactMbo(id);
        List<PactActivit> pactActivit = this.pactmainservice.getPactActivit(id);
        List<PactExpense> pactExpense = this.pactmainservice.getPactExpense(id);
        model.addAttribute("RowGridData1", (Object)JSON.toJSONString(pactMbo));
        model.addAttribute("RowGridData2", (Object)JSON.toJSONString(pactResourcs));
        model.addAttribute("RowGridData3", (Object)JSON.toJSONString(pactChannel));
        model.addAttribute("RowGridData4", (Object)JSON.toJSONString(pactActivit));
        model.addAttribute("RowGridData5", (Object)JSON.toJSONStringWithDateFormat(pactExpense, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "pactMain/look.ftl";
    }
}

