/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.pactMain;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.client.PartnerShopService;
import com.tcbj.crm.entity.NoticeE;
import com.tcbj.crm.entity.PactActivit;
import com.tcbj.crm.entity.PactChannel;
import com.tcbj.crm.entity.PactExpense;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.entity.PactMbo;
import com.tcbj.crm.entity.PactResourc;
import com.tcbj.crm.notice.NoticeService;
import com.tcbj.crm.pactMain.ExcelHandleService;
import com.tcbj.crm.pactMain.PactMainCondition;
import com.tcbj.crm.pactMain.PactMainExcel;
import com.tcbj.crm.pactMain.PactMainService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/pactMain"})
public class PactMainExcelController
extends BaseController {
    @Autowired
    PactMainService pactmainservice;
    @Autowired
    ClientService clientService;
    @Autowired
    PartnerShopService partnerShopService;
    @Autowired
    ExcelHandleService excelHandleService;
    @Autowired
    NoticeService noticeService;

    @RequestMapping(value={"/intoExcel.do"}, method={RequestMethod.GET})
    public String addGet(Model model, HttpServletRequest request) throws Exception {
        return "pactMain/excel.ftl";
    }

    @RequestMapping(value={"/intoExcel.do"}, method={RequestMethod.POST})
    public String addPost(Model model, HttpServletRequest request) throws Exception {
        Employee me = this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "pactmain");
        String url = "";
        String rtn = null;
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        ArrayList<PactMain> pactMains = new ArrayList<PactMain>();
        List<AdjustStockUtil> msglist = this.getFileReadyExcel(pactMains, url);
        if (StringUtils.isNull(pactMains)) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        for (PactMain pactmain : pactMains) {
            boolean isDate;
            boolean isNo = this.pactmainservice.getPactNo(pactmain.getPactNo(), me.getCurrentPartner().getId(), null);
            if (!isNo) {
                msglist.add(new AdjustStockUtil("\u7f16\u53f7\uff1a" + pactmain.getPactNo() + "\u7684\u5408\u540c\uff0c\u5408\u540c\u7f16\u53f7\u91cd\u590d\u91cd\u590d\u3002"));
            }
            if (isDate = this.pactmainservice.validataDateS(pactmain.getStartDate(), pactmain.getEndDate(), pactmain.getApplyerId(), me.getCurrentPartner().getId(), null)) continue;
            msglist.add(new AdjustStockUtil("\u7f16\u53f7\uff1a" + pactmain.getPactNo() + "\u7684\u5408\u540c\uff0c\u5408\u540c\u6709\u6548\u671f\u4e0d\u80fd\u4ea4\u53c9\u3002"));
        }
        this.excelHandleService.save(pactMains);
        if (pactMains.size() > 0) {
            NoticeE n = new NoticeE();
            n.fillInitData(me);
            n.setNoticeId(((PactMain)pactMains.get(0)).getId());
            n.setEnclosureType(filelist.get(0).getSuffix());
            n.setEnclosurePath(filelist.get(0).getWebPath());
            n.setEnclosureName(filelist.get(0).getName());
            this.noticeService.save(n);
        }
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    public List<AdjustStockUtil> getFileReadyExcel(List<PactMain> pactMains, String url) {
        Employee em = this.getCurrentEmployee();
        PactMainExcel pactMainExcel = new PactMainExcel();
        List<AdjustStockUtil> msglist = this.excelHandleService.readSheetByExcel(url, em, pactMainExcel);
        pactMains.addAll(pactMainExcel.getPactMain());
        for (PactMain pactMain : pactMains) {
            for (PactActivit pactActivit : pactMainExcel.getPactActivit()) {
                if (!pactMain.getPactNo().equals(pactActivit.getPactNo())) continue;
                pactMain.addChild(pactActivit);
            }
            for (PactChannel pactChannel : pactMainExcel.getPactChannel()) {
                if (!pactMain.getPactNo().equals(pactChannel.getPactNo())) continue;
                pactMain.addChild(pactChannel);
            }
            for (PactExpense actExpense : pactMainExcel.getPactExpense()) {
                if (!pactMain.getPactNo().equals(actExpense.getPactNo())) continue;
                pactMain.addChild(actExpense);
            }
            for (PactMbo pactMbo : pactMainExcel.getPactMbo()) {
                if (!pactMain.getPactNo().equals(pactMbo.getPactNo())) continue;
                pactMain.addChild(pactMbo);
            }
            for (PactResourc pactResourc : pactMainExcel.getPactResourc()) {
                if (!pactMain.getPactNo().equals(pactResourc.getPactNo())) continue;
                pactMain.addChild(pactResourc);
            }
        }
        return msglist;
    }

    @RequestMapping(value={"/contractListExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void excel(PactMainCondition condition, Model model, HttpServletRequest request, HttpServletResponse response) {
        this.setYears(model);
        Employee emp = this.getCurrentEmployee();
        condition.setFirstParty(emp.getCurrentPartner().getId());
        condition.setUserId(emp.getId());
        List<PactMain> list = this.pactmainservice.getPactMainListBySerch(condition, emp);
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "pactMain");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.pactmainservice.excels(list, dir.getPath(), emp, response);
    }

    private void setYears(Model model) {
        int currentYear = Calendar.getInstance().get(1);
        ArrayList<Integer> years = new ArrayList<Integer>();
        int i = 0;
        while (i < 5) {
            years.add(++currentYear);
            ++i;
        }
        model.addAttribute("years", years);
    }
}

