/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.partner;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.channelType.ChannelTypeService;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.PartnerAddressRecord;
import com.tcbj.crm.entity.PartnerContactRecord;
import com.tcbj.crm.entity.PartnerRecord;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.partner.PartnerCondition;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.framework.util.Page;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.beanutils.BeanUtils;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/partner"})
public class PartnerController
extends BaseController {
    @Autowired
    PartnerService service;
    @Autowired
    ClientService clientService;
    @Autowired
    StorageService storageService;
    @Autowired
    Cache cache;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    ChannelTypeService channelTypeService;

    @RequestMapping(value={"/applys.do"})
    public String applys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") PartnerCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        if (con == null) {
            con = new PartnerCondition();
        }
        Page Partners = null;
        con.setPartnerId(me.getCurrentPartner().getId());
        if ("person".equals(con.getType())) {
            con.setEmployeeId(me.getId());
            Partners = this.service.findPartnerApplys(con, pageno);
        } else {
            con.setEmployeeId(me.getId());
            Partners = this.service.findPartnerApplyCompanys(con, pageno);
        }
        model.addAttribute("partners", (Object)Partners);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "partner/applys.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Partner partnerMy = this.service.getSimplePartner(me.getCurrentPartner().getId());
        PartnerRecord partner = null;
        if (StringUtils.isEmpty((Object)id)) {
            partner = new PartnerRecord();
            partner.setParentPartnerId(me.getCurrentPartner().getId());
            partner.initialize();
        } else {
            partner = this.service.getPartnerRecord(id);
        }
        boolean isOrg = partnerMy.isOrg();
        if (isOrg) {
            model.addAttribute("isOrg", (Object)"true");
        } else {
            model.addAttribute("isOrg", (Object)"false");
            partner.setNo(this.orderNoService.updateNo("100001", false));
        }
        partner.fillInitData(me);
        model.addAttribute("me", (Object)me);
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(partner.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "partner/apply.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody PartnerRecord partner, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        partner.setNo(partner.getNo().trim());
        String partnerId = me.getCurrentPartner().getOrganizationid();
        if (StringUtils.isEmpty((Object)partner.getId())) {
            this.validateName(partnerId, partner.getName(), null);
            this.validateNo(partnerId, partner.getNo(), null);
            this.validateClientAppNo(partnerId, partner.getClientAppNo(), null);
        } else {
            this.validateName(partnerId, partner.getName(), partner.getId());
            this.validateNo(partnerId, partner.getNo(), partner.getId());
            this.validateClientAppNo(partnerId, partner.getClientAppNo(), partner.getId());
        }
        Partner partnerMy = this.service.getSimplePartner(me.getCurrentPartner().getId());
        boolean isOrg = partnerMy.isOrg();
        if (!isOrg) {
            partner.setNo(this.orderNoService.updateNo("100001", true));
        }
        partner.fillInitData(me);
        partner.setApplyType(TCBJEnum.ApplyType.add.getValue());
        if (!TCBJEnum.ApplyState.audit.getValue().equals(partner.getApplyState())) {
            partner.setApplyState(TCBJEnum.ApplyState.draft.getValue());
        }
        for (PartnerAddressRecord address : partner.getAddresses()) {
            address.fillInitData(me);
        }
        for (PartnerContactRecord contact : partner.getContacts()) {
            contact.fillInitData(me);
        }
        if (StringUtils.isEmpty((Object)partner.getId())) {
            this.service.add(partner);
        } else {
            this.service.update(partner);
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/del"})
    public String del(String id, Model model) {
        this.service.del(id);
        return this.redirect("/partner/applys.do?type=person");
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=true) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        PartnerRecord partner = this.service.getPartnerRecord(id);
        model.addAttribute("me", (Object)me);
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(partner.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "partner/look.ftl";
    }

    @RequestMapping(value={"/audits.do"})
    public String audits(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") PartnerCondition con, Model model) {
        if (!"dealing".equals(con.getAuditType()) && !"dealed".equals(con.getAuditType())) {
            throw new AppException("2003");
        }
        Employee me = this.getCurrentEmployee();
        con.setPartnerId(me.getCurrentPartner().getId());
        con.setEmployeeId(me.getId());
        Page audits = this.service.findPartnerAudits(con, pageno);
        model.addAttribute("audits", (Object)audits);
        return "partner/audits.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.GET})
    public String audit(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        PartnerRecord partner = this.service.getPartnerRecord(id);
        model.addAttribute("me", (Object)me);
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(partner.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "partner/audit.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result audit_do(@Valid @RequestBody Partner partner, Model model) {
        if (!partner.getApplyState().equals(TCBJEnum.ApplyState.pass.getValue()) && !partner.getApplyState().equals(TCBJEnum.ApplyState.notpass.getValue())) {
            partner.setApplyState(TCBJEnum.ApplyState.notpass.getValue());
        }
        Employee me = this.getCurrentEmployee();
        this.service.audit(partner.getId(), partner.getApplyState(), me, partner.getOpinion());
        if (partner.getApplyState().equals("2")) {
            this.cache.initPartners();
            this.cache.initCustomers();
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editPartner.do"}, method={RequestMethod.GET})
    public String edit(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Partner partnerMy = this.service.getSimplePartner(me.getCurrentPartner().getId());
        boolean isOrg = partnerMy.isOrg();
        if (isOrg) {
            model.addAttribute("isOrg", (Object)"true");
        } else {
            model.addAttribute("isOrg", (Object)"false");
        }
        Customer customer = this.clientService.getCustomer(me.getCurrentPartner().getId(), id);
        model.addAttribute("customer", (Object)customer);
        Partner partner = this.service.getPartner(id);
        if (customer == null) {
            customer = new Customer();
        }
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(customer.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("partner", (Object)partner);
        return "partner/edit.ftl";
    }

    @RequestMapping(value={"/editPartner.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_do(@Valid @RequestBody PartnerRecord partner, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        partner.setNo(partner.getNo().trim());
        String partnerId = me.getCurrentPartner().getOrganizationid();
        this.validateName(partnerId, partner.getName(), partner.getId());
        this.validateNo(partnerId, partner.getNo(), partner.getId());
        this.validateClientAppNo(partnerId, partner.getClientAppNo(), partner.getId());
        partner.fillInitData(me);
        partner.setApplyType(TCBJEnum.ApplyType.edit.getValue());
        partner.setApplyState(TCBJEnum.ApplyState.pass.getValue());
        for (PartnerAddressRecord address : partner.getAddresses()) {
            address.setSiebelId(address.getId());
            address.fillInitData(me);
        }
        for (PartnerContactRecord contact : partner.getContacts()) {
            contact.setSiebelId(contact.getId());
            contact.fillInitData(me);
        }
        List<PartnerContactRecord> partnerContactRecords = partner.getContacts();
        String[] stringArray = partner.getDelIds().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contactId = stringArray[n2];
            if (!com.tcbj.util.StringUtils.isEmpty(contactId)) {
                PartnerContactRecord partnerContactRecord = new PartnerContactRecord();
                PartnerContact partnerContact = this.service.getPartnerContact(contactId);
                try {
                    BeanUtils.copyProperties((Object)partnerContactRecord, (Object)partnerContact);
                }
                catch (Exception exception) {
                    throw new AppException("2002");
                }
                partnerContactRecord.setIsContact("N");
                partnerContactRecord.fillInitData(me);
                partnerContactRecords.add(partnerContactRecord);
            }
            ++n2;
        }
        this.service.updatePartner(partner);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/viewself.do"}, method={RequestMethod.GET})
    public String viewself(Model model) {
        Employee me = this.getCurrentEmployee();
        String parPartnerId = me.getCurrentPartner().getParPartnerId();
        parPartnerId = StringUtils.isEmpty((Object)parPartnerId) ? me.getCurrentPartner().getId() : parPartnerId;
        Customer customer = this.clientService.getCustomer(parPartnerId, me.getCurrentPartner().getId());
        model.addAttribute("customer", (Object)customer);
        Partner partner = this.service.getPartner(me.getCurrentPartner().getId());
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(partner.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "partner/viewself.ftl";
    }

    @RequestMapping(value={"/editself.do"}, method={RequestMethod.GET})
    public String editSelf(Model model) {
        String partnerId = this.getCurrentEmployee().getCurrentPartner().getId();
        Partner partner = this.service.getPartner(partnerId);
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("partner", (Object)partner);
        return "partner/editself.ftl";
    }

    @RequestMapping(value={"/editself.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editSelf_do(@Valid @RequestBody PartnerRecord partner, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        String partnerId = me.getCurrentPartner().getId();
        Partner old = this.service.getPartner(partnerId);
        PartnerRecord newPartner = new PartnerRecord();
        try {
            BeanUtils.copyProperties((Object)newPartner, (Object)old);
        }
        catch (Exception exception) {
            throw new AppException("2002");
        }
        newPartner.setSiebelId(newPartner.getId());
        newPartner.setId(null);
        newPartner.fillInitData(me);
        newPartner.setParentPartnerId(old.getParentPartnerId());
        newPartner.setFax(partner.getFax());
        newPartner.setPhone(partner.getPhone());
        newPartner.setAddress(partner.getAddress());
        newPartner.setIsReport(partner.getIsReport());
        newPartner.setContacts(partner.getContacts());
        newPartner.setApplyType(TCBJEnum.ApplyType.edit.getValue());
        newPartner.setApplyState(TCBJEnum.ApplyState.pass.getValue());
        for (PartnerContactRecord contact : newPartner.getContacts()) {
            contact.fillInitData(me);
        }
        List<PartnerContactRecord> partnerContactRecords = partner.getContacts();
        String[] stringArray = partner.getDelIds().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contactId = stringArray[n2];
            if (!com.tcbj.util.StringUtils.isEmpty(contactId)) {
                PartnerContactRecord partnerContactRecord = new PartnerContactRecord();
                PartnerContact partnerContact = this.service.getPartnerContact(contactId);
                if (partnerContact != null) {
                    try {
                        BeanUtils.copyProperties((Object)partnerContactRecord, (Object)partnerContact);
                    }
                    catch (Exception exception) {
                        throw new AppException("2002");
                    }
                    partnerContactRecord.setIsContact("N");
                    partnerContactRecord.fillInitData(me);
                    partnerContactRecords.add(partnerContactRecord);
                }
            }
            ++n2;
        }
        this.service.updateMyPartner(newPartner);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/findPartners.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findPartners(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") PartnerCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setPartnerId(me.getCurrentPartner().getId());
        con.setEmployeeId(me.getId());
        Page partners = this.service.findPartners(con, pageno);
        model.addAttribute("partners", (Object)partners);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "partner/finds.ftl";
    }

    @RequestMapping(value={"/viewPartner.do"}, method={RequestMethod.GET})
    public String viewPartner(@RequestParam(value="id", required=true) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Customer customer = this.clientService.getCustomer(me.getCurrentPartner().getId(), id);
        model.addAttribute("customer", (Object)customer);
        Partner partner = this.service.getPartner(id);
        model.addAttribute("partner", (Object)partner);
        if (customer == null) {
            customer = new Customer();
        }
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(customer.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("hideaudit", (Object)"true");
        return "partner/view.ftl";
    }

    @RequestMapping(value={"/findRecords.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findRecords(String id, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) {
        Page partners = this.service.findPartnerRecords(id, pageno);
        model.addAttribute("partners", (Object)partners);
        return "partner/records.ftl";
    }

    @RequestMapping(value={"partnerTree.do"})
    public String tree(Model model) throws JSONException {
        Employee e = this.getCurrentEmployee();
        Partner p = this.service.getPartner(e.getCurrentPartner().getId());
        String tree = this.service.partnerTree(p);
        model.addAttribute("isMultipleChoice", (Object)"false");
        model.addAttribute("tree", (Object)tree);
        return "partner/partnerTree.ftl";
    }

    @RequestMapping(value={"/ajaxGetChild.do"})
    public void ajaxGetChildNode1(String id, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        try {
            Employee e = this.getCurrentEmployee();
            String result = this.service.getChildTree(id, e.getCurrentPartner().getId());
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }

    private void validateNo(String partnerId, String no, String id) {
        boolean isPartnerRecord = this.service.isPartnerRecord(partnerId, no, id);
        boolean isPartner = this.service.isPartnerNo(partnerId, no, id);
        if (isPartnerRecord && isPartner) {
            throw new AppException("2003");
        }
    }

    private void validateName(String partnerId, String name, String id) {
        boolean isPartnerRecordName = this.service.isPartnerRecordName(partnerId, name, id);
        boolean isPartnerName = this.service.isPartnerName(partnerId, name, id);
        if (isPartnerRecordName && isPartnerName) {
            throw new AppException("2006");
        }
    }

    private void validateClientAppNo(String partnerId, String clientAppNo, String id) {
        boolean isPartnerRecordClientAppNo = this.service.isPartnerRecordClientAppNo(partnerId, clientAppNo, id);
        boolean isPartnerClientAppNo = this.service.isPartnerClientAppNo(partnerId, clientAppNo, id);
        if (isPartnerRecordClientAppNo && isPartnerClientAppNo) {
            throw new AppException("2007");
        }
    }

    @RequestMapping(value={"/selectSubPartners.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String selectSubPartners(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") PartnerCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        Page partners = this.service.findSubPartners(con, me, pageno);
        model.addAttribute("partners", (Object)partners);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "partner/subPartners.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String addGet(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        PartnerRecord partner = null;
        if (StringUtils.isEmpty((Object)id)) {
            partner = new PartnerRecord();
            partner.initialize();
        } else {
            partner = this.service.getPartnerRecord(id);
        }
        partner.fillInitData(me);
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(partner.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "partner/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result addPost(@Valid @RequestBody PartnerRecord partnerRecord, Model model) {
        Employee me = this.getCurrentEmployee();
        partnerRecord.setNo(partnerRecord.getNo().trim());
        String partnerId = me.getCurrentPartner().getOrganizationid();
        this.validateName(partnerId, partnerRecord.getName(), null);
        this.validateNo(partnerId, partnerRecord.getNo(), null);
        this.validateClientAppNo(partnerId, partnerRecord.getClientAppNo(), null);
        Partner partnerMy = this.service.getSimplePartner(partnerRecord.getParentPartnerId());
        partnerRecord.setMasterOuId(partnerMy.getMasterOuId());
        for (PartnerAddressRecord address : partnerRecord.getAddresses()) {
            address.fillInitData(me);
        }
        for (PartnerContactRecord contact : partnerRecord.getContacts()) {
            contact.fillInitData(me);
        }
        this.service.addSiebel(partnerRecord);
        Thread t = new Thread(){

            @Override
            public void run() {
                PartnerController.this.cache.initPartners();
                PartnerController.this.cache.initCustomers();
            }
        };
        t.start();
        return this.getSuccessResult(null);
    }
}

