/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.partner;

import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PartnerAddressRecord;
import com.tcbj.crm.entity.PartnerContactRecord;
import com.tcbj.crm.entity.PartnerRecord;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.partner.PartnerCondition;
import com.tcbj.crm.siebel.service.PartnerSiebelService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerAddress;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="partnerService")
public class PartnerService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;

    @PostConstruct
    public void init() {
    }

    public List<EmployeePartner> findEmployeePartners(String employeeId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from EmployeePartner where personId=? and type='Partner'");
        args.add(employeeId);
        return this.baseDao.findEntity(hql.toString(), args.toArray(), EmployeePartner.class);
    }

    public Page findPartners(PartnerCondition con, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String sb = this.personnelService.getFRegionsByUserId(con.getEmployeeId());
        hql.append("from Partner p,Customer c where ");
        hql.append(" (c.bigAreaCode in ( ");
        hql.append(sb);
        hql.append(") or c.areaCode in ( ");
        hql.append(sb);
        hql.append(" ))");
        hql.append(" and p.id = c.applyerId and c.supplierId  = ? ");
        args.add(con.getPartnerId());
        if (StringUtils.isNotEmpty(con.getName())) {
            hql.append(" and p.name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            hql.append(" and p.createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            hql.append(" and p.createDt <= ?");
            args.add(con.getCreateDtE());
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql.append(" and p.no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            hql.append(" and p.saleChannelTypeCode = ?");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            hql.append(" and c.areaCode = ?");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getProvinceCode())) {
            hql.append(" and p.provinceCode = ?");
            args.add(con.getProvinceCode());
        }
        if (StringUtils.isNotEmpty(con.getCityCode())) {
            hql.append(" and p.cityCode = ?");
            args.add(con.getCityCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaManagerId())) {
            hql.append(" and c.areaManagerId = ?");
            args.add(con.getAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaManagerId())) {
            hql.append(" and c.bigAreaManagerId = ?");
            args.add(con.getBigAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getCityManagerId())) {
            hql.append(" and c.cityManagerId = ?");
            args.add(con.getCityManagerId());
        }
        if (StringUtils.isNotEmpty(con.getMarketManagerId())) {
            hql.append(" and c.marketManagerId = ?");
            args.add(con.getMarketManagerId());
        }
        hql.append(" order by p.createDt desc");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        ArrayList<Partner> list = new ArrayList<Partner>();
        List obgs = page.getList();
        for (Object[] objects : obgs) {
            list.add((Partner)objects[0]);
        }
        page.setList(list);
        return page;
    }

    public Page findPartnerRecords(String siebelId, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from PartnerRecord where siebelId=?");
        args.add(siebelId);
        hql.append(" order by createDt desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page findPartnerApplys(PartnerCondition con, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("from PartnerRecord where applyType <> '2' and parentPartnerId=?");
        args.add(con.getPartnerId());
        if (StringUtils.isNotEmpty(con.getEmployeeId())) {
            hql.append(" and creatorId = ?");
            args.add(con.getEmployeeId());
        }
        if (StringUtils.isNotEmpty(con.getName())) {
            hql.append(" and name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql.append(" and no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            hql.append(" and createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            hql.append(" and createDt <= ?");
            args.add(con.getCreateDtE());
        }
        if (StringUtils.isNotEmpty(con.getApplyState())) {
            hql.append(" and applyState = ?");
            args.add(con.getApplyState());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            hql.append(" and areaCode = ?");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            hql.append(" and bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            hql.append(" and saleChannelTypeCode = ?");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(con.getProvinceCode())) {
            hql.append(" and provinceCode = ?");
            args.add(con.getProvinceCode());
        }
        if (StringUtils.isNotEmpty(con.getCityCode())) {
            hql.append(" and cityCode = ?");
            args.add(con.getCityCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaManagerId())) {
            hql.append(" and areaManagerId = ?");
            args.add(con.getAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaManagerId())) {
            hql.append(" and bigAreaManagerId = ?");
            args.add(con.getBigAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getCityManagerId())) {
            hql.append(" and cityManagerId = ?");
            args.add(con.getCityManagerId());
        }
        if (StringUtils.isNotEmpty(con.getMarketManagerId())) {
            hql.append(" and marketManagerId = ?");
            args.add(con.getMarketManagerId());
        }
        hql.append(" order by lastUpdateDt desc,applyState ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page findPartnerApplyCompanys(PartnerCondition con, int pageno) {
        StringBuffer hql2 = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql2.append("select p.id from PartnerRecord p ,ContactRegion c ,Region r where ((p.bigAreaCode = c.regionId and c.userId = ?) or (p.areaCode = c.regionId and c.userId = ?)) and p.applyType <> '2' ");
        args.add(con.getEmployeeId());
        args.add(con.getEmployeeId());
        hql2.append(" and c.regionId = r.id ");
        hql2.append(" and c.startDate <= ? and nvl(c.endDate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        if (StringUtils.isNotEmpty(con.getName())) {
            hql2.append(" and p.name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql2.append(" and p.no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            hql2.append(" and p.createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            hql2.append(" and p.createDt <= ?");
            args.add(con.getCreateDtE());
        }
        if (StringUtils.isNotEmpty(con.getApplyState())) {
            hql2.append(" and p.applyState = ?");
            args.add(con.getApplyState());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            hql2.append(" and p.areaCode = ?");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            hql2.append(" and p.bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            hql2.append(" and p.saleChannelTypeCode = ?");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(con.getProvinceCode())) {
            hql2.append(" and p.provinceCode = ?");
            args.add(con.getProvinceCode());
        }
        if (StringUtils.isNotEmpty(con.getCityCode())) {
            hql2.append(" and p.cityCode = ?");
            args.add(con.getCityCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaManagerId())) {
            hql2.append(" and p.areaManagerId = ?");
            args.add(con.getAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaManagerId())) {
            hql2.append(" and p.bigAreaManagerId = ?");
            args.add(con.getBigAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getCityManagerId())) {
            hql2.append(" and p.cityManagerId = ?");
            args.add(con.getCityManagerId());
        }
        if (StringUtils.isNotEmpty(con.getMarketManagerId())) {
            hql2.append(" and p.marketManagerId = ?");
            args.add(con.getMarketManagerId());
        }
        hql2.append(" order by p.lastUpdateDt desc,p.applyState ");
        List idlist = this.baseDao.findEntity(hql2.toString(), args.toArray(), Object.class);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object element : idlist) {
            set.add((String)element);
        }
        if (set.size() > 0) {
            Object element;
            String pf = " ";
            element = set.iterator();
            while (element.hasNext()) {
                String cfr_ignored_0 = (String)element.next();
                pf = String.valueOf(pf) + "?,";
            }
            pf = pf.substring(0, pf.length() - 1);
            String hql = " from PartnerRecord p where p.id in ( " + pf + ")";
            Page page = this.baseDao.search(hql, set.toArray(), Constant.DEFAULT_ROWS, pageno);
            return page;
        }
        return new Page(new ArrayList(), 1, Constant.DEFAULT_ROWS, 0);
    }

    public Page findPartnerAudits(PartnerCondition con, int pageno) {
        StringBuffer hql2 = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql2.append("select p.id from PartnerRecord p ,ContactRegion c ,Region r where ((p.bigAreaCode = c.regionId and c.userId = ?) or (p.areaCode = c.regionId and c.userId = ?)) and p.applyType <> '2' ");
        args.add(con.getEmployeeId());
        args.add(con.getEmployeeId());
        hql2.append(" and c.regionId = r.id ");
        hql2.append(" and c.startDate <= ? and nvl(c.endDate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        if (StringUtils.isNotEmpty(con.getName())) {
            hql2.append(" and p.name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql2.append(" and p.no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            hql2.append(" and p.createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            hql2.append(" and p.createDt <= ?");
            args.add(con.getCreateDtE());
        }
        if (StringUtils.isNotEmpty(con.getApplyState())) {
            hql2.append(" and p.applyState = ?");
            args.add(con.getApplyState());
        }
        if ("dealing".equals(con.getAuditType())) {
            hql2.append(" and p.applyState = ?");
            args.add(TCBJEnum.ApplyState.audit.getValue());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            hql2.append(" and p.areaCode = ?");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            hql2.append(" and p.bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            hql2.append(" and p.saleChannelTypeCode = ?");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(con.getProvinceCode())) {
            hql2.append(" and p.provinceCode = ?");
            args.add(con.getProvinceCode());
        }
        if (StringUtils.isNotEmpty(con.getCityCode())) {
            hql2.append(" and p.cityCode = ?");
            args.add(con.getCityCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaManagerId())) {
            hql2.append(" and p.areaManagerId = ?");
            args.add(con.getAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaManagerId())) {
            hql2.append(" and p.bigAreaManagerId = ?");
            args.add(con.getBigAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getCityManagerId())) {
            hql2.append(" and p.cityManagerId = ?");
            args.add(con.getCityManagerId());
        }
        if (StringUtils.isNotEmpty(con.getMarketManagerId())) {
            hql2.append(" and p.marketManagerId = ?");
            args.add(con.getMarketManagerId());
        }
        if ("dealed".equals(con.getAuditType())) {
            hql2.append(" and (p.applyState = ? or p.applyState=?)");
            args.add(TCBJEnum.ApplyState.pass.getValue());
            args.add(TCBJEnum.ApplyState.notpass.getValue());
        }
        hql2.append(" order by p.lastUpdateDt desc,p.applyState ");
        List idlist = this.baseDao.findEntity(hql2.toString(), args.toArray(), Object.class);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object element : idlist) {
            set.add((String)element);
        }
        if (set.size() > 0) {
            Object element;
            String pf = " ";
            element = set.iterator();
            while (element.hasNext()) {
                String cfr_ignored_0 = (String)element.next();
                pf = String.valueOf(pf) + "?,";
            }
            pf = pf.substring(0, pf.length() - 1);
            String hql = " from PartnerRecord p where p.id in ( " + pf + ")";
            Page page = this.baseDao.search(hql, set.toArray(), Constant.DEFAULT_ROWS, pageno);
            return page;
        }
        return new Page(new ArrayList(), 1, Constant.DEFAULT_ROWS, 0);
    }

    private List<PartnerAddressRecord> getAddresses(String id) {
        String hql = "from PartnerAddressRecord where partnerId=?";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, PartnerAddressRecord.class);
    }

    private List<PartnerContactRecord> getContacts(String id) {
        String hql = "from PartnerContactRecord where partnerId=?";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, PartnerContactRecord.class);
    }

    public PartnerRecord getPartnerRecord(String id) {
        PartnerRecord apply = (PartnerRecord)this.baseDao.get(PartnerRecord.class, (Serializable)((Object)id));
        apply.setAddresses(this.getAddresses(id));
        apply.setContacts(this.getContacts(id));
        return apply;
    }

    public void add(PartnerRecord partner) {
        partner.setId(UUIDUtils.getId());
        this.baseDao.save((Object)partner);
        for (PartnerAddressRecord address : partner.getAddresses()) {
            address.setId(UUIDUtils.getId());
            address.setPartnerId(partner.getId());
        }
        for (PartnerContactRecord contact : partner.getContacts()) {
            contact.setId(UUIDUtils.getId());
            contact.setPartnerId(partner.getId());
        }
        this.baseDao.save(partner.getAddresses());
        this.baseDao.save(partner.getContacts());
    }

    public void update(PartnerRecord partner) {
        Object[] args = new Object[]{partner.getId()};
        this.baseDao.update((Object)partner);
        this.baseDao.executeHQL("delete PartnerAddressRecord where partnerId=?", args);
        this.baseDao.executeHQL("delete PartnerContactRecord where partnerId=?", args);
        for (PartnerAddressRecord address : partner.getAddresses()) {
            address.setId(UUIDUtils.getId());
            address.setPartnerId(partner.getId());
        }
        for (PartnerContactRecord contact : partner.getContacts()) {
            contact.setId(UUIDUtils.getId());
            contact.setPartnerId(partner.getId());
        }
        this.baseDao.save(partner.getAddresses());
        this.baseDao.save(partner.getContacts());
    }

    public String audit(String id, String applyState, Employee me, String opinion) {
        String siebelId = null;
        if (applyState.equals("2")) {
            PartnerSiebelService ss = new PartnerSiebelService();
            PartnerRecord partnerRecord = this.getPartnerRecord(id);
            partnerRecord.setMasterOuId(me.getCurrentPartner().getOrganizationid());
            siebelId = ss.addOrUpdatePartnerToSiebel(partnerRecord, 0);
            String hql = "update PartnerRecord set applyState=?,opinion=?,auditorId=?,auditDt=?,siebelId=? where id=?";
            Object[] args = new Object[]{applyState, opinion, me.getId(), DateUtils.now(), siebelId, id};
            this.baseDao.executeHQL(hql, args);
        } else {
            String hql = "update PartnerRecord set applyState=?,opinion=?,auditorId=?,auditDt=? where id=?";
            Object[] args = new Object[]{applyState, opinion, me.getId(), DateUtils.now(), id};
            this.baseDao.executeHQL(hql, args);
        }
        return siebelId;
    }

    public String addSiebel(PartnerRecord partnerRecord) {
        PartnerSiebelService ss = new PartnerSiebelService();
        return ss.addOrUpdatePartnerToSiebel(partnerRecord, 0);
    }

    public void updateMyPartner(PartnerRecord partner) {
        PartnerSiebelService ss = new PartnerSiebelService();
        ss.updatePartPartnerToSiebel(partner);
    }

    public void updatePartner(PartnerRecord partner) {
        partner.setSiebelId(partner.getId());
        this.add(partner);
        PartnerSiebelService ss = new PartnerSiebelService();
        ss.addOrUpdatePartnerToSiebel(partner, 1);
    }

    public int[] getSketchCount(String userId, String suplierId) {
        String sb = this.personnelService.getFRegionsByUserId(userId);
        String hql1 = "from PartnerRecord where parentPartnerId=? and applyState='0'";
        Object[] args1 = new Object[]{suplierId};
        hql1 = String.valueOf(hql1) + " and (areaCode in(" + sb + ") or bigAreaCode in (" + sb + "))";
        List list1 = this.baseDao.findEntity(hql1, args1, PartnerRecord.class);
        String hql2 = "from PartnerRecord where parentPartnerId=? and applyState='1'";
        Object[] args2 = new Object[]{suplierId};
        hql2 = String.valueOf(hql2) + " and (areaCode in(" + sb + ") or bigAreaCode in (" + sb + "))";
        List list2 = this.baseDao.findEntity(hql2, args2, PartnerRecord.class);
        int[] counts = new int[]{list1.size(), list2.size()};
        return counts;
    }

    public PartnerContact getPartnerContact(String id) {
        return (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where id = ?", new Object[]{id}, PartnerContact.class);
    }

    public List<PartnerContact> getPartnerContacts(String partnerId) {
        return this.baseDao.findEntity(" from PartnerContact where partnerId=? and isContact='Y' ", new Object[]{partnerId}, PartnerContact.class);
    }

    public Partner getPartner(String id) {
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)id));
        String hql = "from PartnerContact where partnerId=? and isContact='Y'";
        String hql1 = "from PartnerAddress where partnerId=?";
        Object[] args = new Object[]{id};
        partner.setContacts(this.baseDao.findEntity(hql, args, PartnerContact.class));
        partner.setAddresses(this.baseDao.findEntity(hql1, args, PartnerAddress.class));
        return partner;
    }

    public Partner getSimplePartner(String id) {
        return (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)id));
    }

    public void del(String id) {
        PartnerRecord partner = (PartnerRecord)this.baseDao.get(PartnerRecord.class, (Serializable)((Object)id));
        if (!partner.getApplyState().equals(TCBJEnum.ApplyState.draft.getValue())) {
            throw new AppException("2001");
        }
        Object[] args = new Object[]{partner.getId()};
        this.baseDao.executeHQL("delete PartnerAddressRecord where partnerId=?", args);
        this.baseDao.executeHQL("delete PartnerContactRecord where partnerId=?", args);
        this.baseDao.executeHQL("delete PartnerRecord where id=?", args);
    }

    public String partnerTree(Partner p) throws JSONException {
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject node = new JSONObject();
        node.put("id", (Object)p.getId());
        node.put("pId", (Object)p.getParentPartnerId());
        node.put("name", (Object)p.getName());
        node.put("open", (Object)"true");
        node.put("nocheck", (Object)"true");
        node.put("iconSkin", (Object)"root");
        node.put("isParent", (Object)"true");
        nodes.put((Object)node);
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public String getChildTree(String id, String orgId) throws JSONException {
        JSONArray nodes = new JSONArray();
        List pts = this.baseDao.findEntity("from Partner p where p.parentPartnerId = ? ", new Object[]{id}, Partner.class);
        for (Partner pn : pts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)pn.getId());
            node2.put("pId", (Object)pn.getParentPartnerId());
            node2.put("name", (Object)pn.getName());
            node2.put("isParent", (Object)"true");
            nodes.put((Object)node2);
        }
        return nodes.toString();
    }

    public Partner getCodeByPartner(String code, String supplierId) {
        Object[] args = new Object[]{code, supplierId};
        return (Partner)this.baseDao.findFirstEntity("from Partner where parentPartnerId = ? and no =? ", args, Partner.class);
    }

    public List<Partner> getOrgByPartner(String orgId) {
        Object[] args = new Object[]{orgId};
        return this.baseDao.findEntity(" select distinct(p) from Partner p where p.masterOuId = ? ", args, Partner.class);
    }

    public boolean isPartner(String code, String supplierId) {
        return !StringUtils.isNotNull(this.getCodeByPartner(code, supplierId));
    }

    public boolean isPartnerRecord(String partnerId, String no, String id) {
        PartnerRecord partnerRecord;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from PartnerRecord where no = ? and parentPartnerId = ? ";
        args.add(no);
        args.add(partnerId);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partnerRecord = (PartnerRecord)this.baseDao.findFirstEntity(hql, args.toArray(), PartnerRecord.class));
    }

    public boolean isPartnerNo(String partnerId, String no, String id) {
        Partner partner;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from Partner where no = ? and masterOuId = ? ";
        args.add(no);
        args.add(partnerId);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partner = (Partner)this.baseDao.findFirstEntity(hql, args.toArray(), Partner.class));
    }

    public boolean isPartnerRecordClientAppNo(String partnerId, String clientAppNo, String id) {
        PartnerRecord partnerRecord;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from PartnerRecord where clientAppNo = ? and parentPartnerId = ? ";
        args.add(clientAppNo);
        args.add(partnerId);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partnerRecord = (PartnerRecord)this.baseDao.findFirstEntity(hql, args.toArray(), PartnerRecord.class));
    }

    public boolean isPartnerClientAppNo(String partnerId, String clientAppNo, String id) {
        Partner partner;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from Partner where clientAppNo = ? and masterOuId = ? ";
        args.add(clientAppNo);
        args.add(partnerId);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partner = (Partner)this.baseDao.findFirstEntity(hql, args.toArray(), Partner.class));
    }

    public boolean isPartnerRecordName(String partnerId, String name, String id) {
        PartnerRecord partnerRecord;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from PartnerRecord where parentPartnerId = ? and name = ? ";
        args.add(partnerId);
        args.add(name);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partnerRecord = (PartnerRecord)this.baseDao.findFirstEntity(hql, args.toArray(), PartnerRecord.class));
    }

    public boolean isPartnerName(String partnerId, String name, String id) {
        Partner partner;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from Partner where masterOuId = ? and name = ? ";
        args.add(partnerId);
        args.add(name);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partner = (Partner)this.baseDao.findFirstEntity(hql, args.toArray(), Partner.class));
    }

    public Page findSubPartners(PartnerCondition con, Employee me, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from Partner p where p.masterOuId = ?  ");
        args.add(me.getCurrentPartner().getOrganizationid());
        if (StringUtils.isNotEmpty(con.getName())) {
            hql.append(" and p.name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql.append(" and p.no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getProvinceCode())) {
            hql.append(" and p.provinceCode = ?");
            args.add(con.getProvinceCode());
        }
        if (StringUtils.isNotEmpty(con.getCityCode())) {
            hql.append(" and p.cityCode = ?");
            args.add(con.getCityCode());
        }
        hql.append(" order by p.no");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        return page;
    }

    public Map<String, String> findSubPartnersMap(Employee me) {
        String hql = "select new Partner(p.id,p.name,p.no) from Partner p where p.masterOuId = ? ";
        List list = this.baseDao.findEntity(hql, new Object[]{me.getCurrentPartner().getOrganizationid()}, Partner.class);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Partner p : list) {
            map.put(p.getNo(), p.getId());
        }
        return map;
    }
}

