/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.post;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientCondition;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Position;
import com.tcbj.crm.entity.PostPartner;
import com.tcbj.crm.entity.PostShop;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.post.PostCondition;
import com.tcbj.crm.post.PostService;
import com.tcbj.crm.shop.ShopCondition;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/post"})
public class PostController
extends BaseController {
    @Autowired
    PostService service;
    @Autowired
    PersonnelService personnelservice;
    @Autowired
    Cache cache;
    @Autowired
    ClientService clientService;
    @Autowired
    ShopService shopService;

    @RequestMapping(value={"/list.do"})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, PostCondition con, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        con.setOrgId(e.getCurrentPartner().getId());
        model.addAttribute("page", (Object)this.service.getList(pageno, con));
        model.addAttribute("condition", (Object)con);
        return "post/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit_get(String id, Model model) {
        Position position = this.service.get(id);
        model.addAttribute("partnerId", (Object)this.getCurrentEmployee().getCurrentPartner().getId());
        model.addAttribute("master", (Object)position);
        return "post/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post(@Valid @RequestBody Position position, BindingResult errors, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        this.validateName(position.getPostName(), e.getCurrentPartner().getId(), position.getId());
        this.service.update(position, e);
        return this.getSuccessResult(position.getParentId());
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add_get(@RequestParam(value="parentId", required=false) String parentId, Model model) {
        model.addAttribute("partnerId", (Object)this.getCurrentEmployee().getCurrentPartner().getId());
        model.addAttribute("parentId", (Object)parentId);
        model.addAttribute("date", (Object)DateUtils.now());
        return "post/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result add_post(@Valid @RequestBody Position position, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        this.validateName(position.getPostName(), e.getCurrentPartner().getId(), null);
        this.service.save(position, e);
        this.cache.initPositions();
        return this.getSuccessResult(position.getParentId());
    }

    private void validateName(String name, String orgId, String id) throws Exception {
        boolean isExist = this.service.isName(name, orgId, id);
        if (isExist) {
            throw new AppException("3101");
        }
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String delete_get(String id, Model model) throws Exception {
        Position cm = this.service.get(id);
        cm.setEndDate(DateUtils.now());
        this.service.update(cm);
        return "redirect:/post/list.do?refresh=1&parentId=" + cm.getParentId();
    }

    @RequestMapping(value={"/view.do"})
    public String view(String id, @RequestParam(value="parentId", required=false) String parentId, Model model) throws Exception {
        Position cm = this.service.get(id);
        model.addAttribute("cm", (Object)cm);
        return "/post/view.ftl";
    }

    @RequestMapping(value={"/orgTree.do"})
    public String tree(String orgId, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        Partner p = this.personnelservice.getById(e.getCurrentPartner().getId());
        String tree = this.service.getOrgTree(orgId, p);
        model.addAttribute("tree", (Object)tree);
        model.addAttribute("orgId", (Object)orgId);
        return "post/orgTree.ftl";
    }

    @RequestMapping(value={"/ajaxGetChildNode.do"})
    public void ajaxGetChildNode(String parentId, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        try {
            Employee e = this.getCurrentEmployee();
            String result = this.service.getChildNodeTree(parentId, e.getCurrentPartner().getId());
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }

    @RequestMapping(value={"/ajaxGetChild.do"})
    public void ajaxGetChildNode1(String id, String orgId, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        try {
            String result = this.service.getChildTree(id, orgId);
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }

    @RequestMapping(value={"posTree.do"})
    public String artree(Model model, String orgId, String partnerId) throws Exception {
        Partner p = null;
        Employee e = this.getCurrentEmployee();
        p = partnerId.equals("") ? this.personnelservice.getById(e.getCurrentPartner().getId()) : this.personnelservice.getById(orgId);
        String tree = this.service.posTree(p);
        model.addAttribute("tree", (Object)tree);
        model.addAttribute("orgId", (Object)orgId);
        return "/post/posTree.ftl";
    }

    @RequestMapping(value={"/selectPartner.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page get_page(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ClientCondition con) {
        try {
            if (StringUtils.isNotEmpty(con.getName())) {
                con.setName(new String(con.getName().getBytes("iso8859-1"), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Page page = this.clientService.findPartnerPost(con, pageno);
        return page;
    }

    @RequestMapping(value={"/getPartners.do"})
    public String get_partner(String partnerId, String userId, Model model) {
        model.addAttribute("partnerId", (Object)partnerId);
        model.addAttribute("userId", (Object)userId);
        return "employee/selectPartner.ftl";
    }

    @RequestMapping(value={"/editPartner.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page editPartner(PostCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno) {
        Page page = this.service.getPagePartner(condition, pageno);
        return page;
    }

    @RequestMapping(value={"/intoselectshop.do"}, method={RequestMethod.GET})
    public String selectProductView(String userId, Model model) {
        model.addAttribute("userId", (Object)userId);
        return "employee/shopList.ftl";
    }

    @RequestMapping(value={"/selectshop.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page getSelectShop(ShopCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno) throws Exception {
        if (StringUtils.isNotEmpty(condition.getName())) {
            condition.setName(new String(condition.getName().getBytes("iso8859-1"), "UTF-8"));
        }
        return this.shopService.getPostShop(condition, pageno);
    }

    @RequestMapping(value={"/editShop.do"}, method={RequestMethod.GET, RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page editShop(PostCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno) {
        try {
            if (StringUtils.isNotEmpty(condition.getShopName())) {
                condition.setShopName(new String(condition.getShopName().getBytes("iso8859-1"), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Page page = this.service.getShop(condition, pageno);
        return page;
    }

    @RequestMapping(value={"/excelshop.do"}, method={RequestMethod.GET})
    public String excelshop() {
        return "post/excelshop.ftl";
    }

    @RequestMapping(value={"/excelshop.do"}, method={RequestMethod.POST})
    public String excelshop(Model model, HttpServletRequest request) throws Exception {
        Employee me = this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "post");
        String url = "";
        String rtn = null;
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        ArrayList<PostShop> postShops = new ArrayList<PostShop>();
        List<AdjustStockUtil> msglist = this.service.readyExcelPostShop(postShops, url, me);
        if (StringUtils.isNull(postShops)) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        this.service.savePostShop(postShops);
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/excelpartner.do"}, method={RequestMethod.GET})
    public String excelpartner() {
        return "post/excelpartner.ftl";
    }

    @RequestMapping(value={"/excelpartner.do"}, method={RequestMethod.POST})
    public String excelpartner(Model model, HttpServletRequest request) throws Exception {
        Employee me = this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "post");
        String url = "";
        String rtn = null;
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        ArrayList<PostPartner> postPartners = new ArrayList<PostPartner>();
        List<AdjustStockUtil> msglist = this.service.readyExcelPostPartner(postPartners, url, me);
        if (StringUtils.isNull(postPartners)) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        this.service.savePostPartner(postPartners);
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }
}

