/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.post;

import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.entity.Position;
import com.tcbj.crm.entity.PostPartner;
import com.tcbj.crm.entity.PostShop;
import com.tcbj.crm.post.PostCondition;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jxl.Sheet;
import jxl.Workbook;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="postService")
public class PostService {
    @Autowired
    BaseDao baseDao;
    private static final String FORMDATE = "yy/MM/dd";

    public Position get(String id) {
        return (Position)this.baseDao.get(Position.class, (Serializable)((Object)id));
    }

    public List<PostShop> getPostShops(String id) {
        return this.baseDao.findEntity("from PostShop where postId = ? ", new Object[]{id}, PostShop.class);
    }

    public List<PostPartner> getPostPartners(String id) {
        return this.baseDao.findEntity("from PostPartner where postId = ? ", new Object[]{id}, PostPartner.class);
    }

    private String getNo(String parentId) {
        Object obj = this.baseDao.findFirstEntity("select max(no) from Position where parentId = ? ", new Object[]{parentId}, Object.class);
        return (String)obj;
    }

    @Transactional
    public void savePostShop(List<PostShop> shops) {
        for (PostShop postShop : shops) {
            if (StringUtils.isNotEmpty(postShop.getId())) {
                this.baseDao.update((Object)postShop);
                continue;
            }
            this.baseDao.save((Object)postShop);
        }
    }

    @Transactional
    public void savePostPartner(List<PostPartner> partners) {
        for (PostPartner postPartner : partners) {
            if (StringUtils.isNotEmpty(postPartner.getId())) {
                this.baseDao.update((Object)postPartner);
                continue;
            }
            this.baseDao.save((Object)postPartner);
        }
    }

    @Transactional
    public void save(Position obj, Employee e) {
        obj.setOrgId(e.getCurrentPartner().getId());
        obj.fillInitData(e);
        String no = this.getNo(obj.getParentId());
        if (obj.getParentId().equals("0")) {
            if (no == null) {
                obj.setNo("01");
            } else {
                obj.setNo(String.format("%02d", Integer.valueOf(no) + 1));
            }
        } else if (no == null) {
            Position po = (Position)this.baseDao.get(Position.class, (Serializable)((Object)obj.getParentId()));
            obj.setNo(String.valueOf(po.getNo()) + "01");
        } else {
            String a = no.substring(no.length() - 2, no.length());
            obj.setNo(String.valueOf(no.substring(0, no.length() - 2)) + String.format("%02d", Integer.valueOf(a) + 1));
        }
        this.baseDao.save((Object)obj);
        int i = 0;
        while (i < obj.getShop().size()) {
            obj.getShop().get(i).fillInitData(e);
            obj.getShop().get(i).setPostId(obj.getId());
            ++i;
        }
        this.baseDao.save(obj.getShop());
        i = 0;
        while (i < obj.getPartner().size()) {
            obj.getPartner().get(i).fillInitData(e);
            obj.getPartner().get(i).setPostId(obj.getId());
            ++i;
        }
        this.baseDao.save(obj.getPartner());
    }

    public Page getList(int pageno, PostCondition con) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from Position o where 1=1");
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(con.getPostName())) {
            HQL.append(" and o.postName like ? ");
            args.add("%" + con.getPostName() + "%");
        }
        if (StringUtils.isNotEmpty(con.getOrgId())) {
            HQL.append(" and o.orgId = ? ");
            args.add(con.getOrgId());
        }
        if (StringUtils.isNotEmpty(con.getParentId())) {
            HQL.append(" and o.parentId = ? ");
            args.add(con.getParentId());
        }
        HQL.append("order by o.createDt desc ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    @Transactional
    public void update(Position obj) {
        this.baseDao.update((Object)obj);
    }

    @Transactional
    public void update(Position obj, Employee e) {
        int n;
        int n2;
        String[] stringArray;
        obj.fillInitData(e);
        this.baseDao.update((Object)obj);
        if (StringUtils.isNotEmpty(obj.getPartnerIds())) {
            stringArray = obj.getPartnerIds().split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String id = stringArray[n];
                this.baseDao.deleteById(PostPartner.class, (Serializable)((Object)id));
                ++n;
            }
        }
        int i = 0;
        while (i < obj.getPartner().size()) {
            obj.getPartner().get(i).fillInitData(e);
            obj.getPartner().get(i).setPostId(obj.getId());
            if (StringUtils.isNotEmpty(obj.getPartner().get(i).getId())) {
                this.baseDao.update((Object)obj.getPartner().get(i));
            } else {
                this.baseDao.save((Object)obj.getPartner().get(i));
            }
            ++i;
        }
        if (StringUtils.isNotEmpty(obj.getShopIds())) {
            stringArray = obj.getShopIds().split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String id = stringArray[n];
                this.baseDao.deleteById(PostShop.class, (Serializable)((Object)id));
                ++n;
            }
        }
        i = 0;
        while (i < obj.getShop().size()) {
            obj.getShop().get(i).fillInitData(e);
            obj.getShop().get(i).setPostId(obj.getId());
            if (StringUtils.isNotEmpty(obj.getShop().get(i).getId())) {
                this.baseDao.update((Object)obj.getShop().get(i));
            } else {
                this.baseDao.save((Object)obj.getShop().get(i));
            }
            ++i;
        }
    }

    @Transactional
    public void delete(String id) {
        this.baseDao.deleteById(Position.class, (Serializable)((Object)id));
    }

    public String getChildNodeTree(String parentId, String orgId) throws JSONException {
        JSONArray nodes = new JSONArray();
        List pts = this.baseDao.findEntity("from Position p where p.parentId = ? and p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by createDt desc ", new Object[]{parentId, orgId, new Date(), new Date()}, Position.class);
        for (Position pn : pts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)pn.getId());
            node2.put("pId", (Object)pn.getParentId());
            node2.put("name", (Object)pn.getPostName());
            node2.put("url", (Object)"/post/list");
            node2.put("isParent", (Object)"true");
            nodes.put((Object)node2);
        }
        return nodes.toString();
    }

    public String getOrgTree(String orgId, Partner p) throws Exception {
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject rootNode = new JSONObject();
        rootNode.put("id", (Object)"0");
        rootNode.put("pId", (Object)p.getParentPartnerId());
        rootNode.put("name", (Object)(String.valueOf(p.getName()) + "\u5c97\u4f4d\u6811"));
        rootNode.put("open", true);
        rootNode.put("iconSkin", (Object)"root");
        rootNode.put("isParent", (Object)"true");
        rootNode.put("url", (Object)"/post/list");
        nodes.put((Object)rootNode);
        List dts = this.baseDao.findEntity("from Position c where c.orgId = ? and c.parentId = '0' and c.startDate < ? and (c.endDate > ? or c.endDate is null) order by showId ", new Object[]{p.getId(), new Date(), new Date()}, Position.class);
        for (Position dt : dts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)dt.getId());
            node2.put("pId", (Object)dt.getParentId());
            node2.put("name", (Object)dt.getPostName());
            node2.put("isParent", (Object)"true");
            node2.put("url", (Object)"/post/list");
            nodes.put((Object)node2);
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public boolean isName(String name, String orgId, String id) throws Exception {
        List list;
        boolean isexist = false;
        String hql = "from Position a where 1=1";
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(name)) {
            hql = String.valueOf(hql) + "and a.postName = ?";
            args.add(name);
        }
        if (StringUtils.isNotEmpty(orgId)) {
            hql = String.valueOf(hql) + "and a.orgId = ?";
            args.add(orgId);
        }
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + "and a.id != ?";
            args.add(id);
        }
        if ((list = this.baseDao.findEntity(hql, args.toArray(), Position.class)).size() > 0) {
            isexist = true;
        }
        return isexist;
    }

    public String getChildTree(String id, String orgId) throws JSONException {
        JSONArray nodes = new JSONArray();
        List pts = this.baseDao.findEntity("from Position p where p.parentId = ? and p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by createDt ", new Object[]{id, orgId, new Date(), new Date()}, Position.class);
        for (Position pn : pts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)pn.getId());
            node2.put("pId", (Object)pn.getParentId());
            node2.put("name", (Object)pn.getPostName());
            node2.put("isParent", (Object)"true");
            nodes.put((Object)node2);
        }
        return nodes.toString();
    }

    public String posTree(Partner p) throws Exception {
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject rootNode = new JSONObject();
        rootNode.put("id", (Object)p.getId());
        rootNode.put("pId", (Object)"1");
        rootNode.put("name", (Object)(String.valueOf(p.getName()) + "\u804c\u4f4d\u6811"));
        rootNode.put("open", (Object)"true");
        rootNode.put("nocheck", (Object)"true");
        rootNode.put("iconSkin", (Object)"root");
        rootNode.put("isParent", (Object)"true");
        nodes.put((Object)rootNode);
        List dts = this.baseDao.findEntity("from Position c where c.orgId = ? and c.parentId = '0' and c.startDate < ? and (c.endDate > ? or c.endDate is null) order by showId ", new Object[]{p.getId(), new Date(), new Date()}, Position.class);
        for (Position dt : dts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)dt.getId());
            node2.put("pId", (Object)dt.getParentId());
            node2.put("name", (Object)dt.getPostName());
            node2.put("isParent", (Object)"true");
            node2.put("url", (Object)"/post/list");
            nodes.put((Object)node2);
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public List<Position> getPositions(String partnerId) {
        String hql = "from Position p where p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by created ";
        return this.baseDao.findEntity(hql, new Object[]{partnerId, new Date(), new Date()}, Position.class);
    }

    public List<Position> getPositionByOrg(String orgId) {
        String hql = "from Position p where p.orgId = ? ";
        return this.baseDao.findEntity(hql, new Object[]{orgId}, Position.class);
    }

    public Page getPagePartner(PostCondition condition, int pageno) {
        String hql = "from PostPartner s where s.postId = ?";
        return this.baseDao.search(hql.toString(), new Object[]{condition.getPostId()}, condition.getRowsize().intValue(), pageno);
    }

    public Page getShop(PostCondition condition, int pageno) {
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from PostShop c,ShopView s where c.shopId = s.id and c.postId = ?";
        args.add(condition.getPostId());
        if (StringUtils.isNotEmpty(condition.getShopName())) {
            hql = String.valueOf(hql) + " and s.shopName like ? ";
            args.add("%" + condition.getShopName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getShopNo())) {
            condition.setShopNo(condition.getShopNo().replaceAll("\uff0c", ","));
            if (condition.getShopNo().indexOf(",") != -1 && condition.getShopNo().split(",").length > 1) {
                String[] nos = condition.getShopNo().split(",");
                int i = 0;
                while (i < nos.length) {
                    String no = nos[i];
                    no = no.trim().replaceAll("\n", "");
                    hql = i == 0 ? String.valueOf(hql) + " and (upper(s.shopNumber) like upper('%" + no + "%')" : (i == nos.length - 1 ? String.valueOf(hql) + " or upper(s.shopNumber) like upper('%" + no + "%'))" : String.valueOf(hql) + " or upper(s.shopNumber) like upper('%" + no + "%'))");
                    ++i;
                }
            } else {
                hql = String.valueOf(hql) + "and s.shopNumber like ? ";
                args.add("%" + condition.getShopNo().trim() + "%");
            }
        }
        hql = String.valueOf(hql) + " order by s.shopNumber ";
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize().intValue(), pageno);
        ArrayList<PostShop> list = new ArrayList<PostShop>();
        int i = 0;
        while (i < page.getList().size()) {
            Object[] obj = (Object[])page.getList().get(i);
            PostShop postShop = (PostShop)obj[0];
            ShopView shopView = (ShopView)obj[1];
            postShop.setShopName(shopView.getShopName());
            postShop.setShopNo(shopView.getShopNumber());
            list.add(postShop);
            ++i;
        }
        page.setList(list);
        return page;
    }

    public List<AdjustStockUtil> readyExcelPostShop(List<PostShop> postShops, String url, Employee me) {
        int myR;
        Sheet st;
        Workbook rwb;
        ArrayList<AdjustStockUtil> megs;
        block28: {
            megs = new ArrayList<AdjustStockUtil>();
            FileInputStream is = new FileInputStream(url);
            rwb = Workbook.getWorkbook((InputStream)is);
            st = rwb.getSheet(0);
            myR = st.getRows();
            if (myR >= 2) break block28;
            return null;
        }
        try {
            List shopList = this.baseDao.findEntity("from ShopView ", ShopView.class);
            HashMap<String, String> shopMap = new HashMap<String, String>();
            for (ShopView shop : shopList) {
                shopMap.put(shop.getShopNumber(), shop.getId());
            }
            List positionList = this.baseDao.findEntity("from Position p where p.orgId = ? ", new Object[]{me.getCurrentPartner().getId()}, Position.class);
            HashMap<String, String> postpMap = new HashMap<String, String>();
            for (Position post : positionList) {
                postpMap.put(post.getNo(), post.getId());
            }
            boolean sys = true;
            if (System.getProperty("os.name").indexOf("Windows") >= 0) {
                sys = false;
            }
            PostShop postShop = null;
            int j = 1;
            while (j < myR) {
                String edate;
                SimpleDateFormat sdf;
                postShop = new PostShop();
                String no = st.getCell(0, j).getContents();
                if (no == null || "".equals(String.valueOf(no).trim())) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u5c97\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                if (postpMap.get(no) == null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u975e\u6cd5\u7684\u6570\u636e(" + no + ")\u3002"));
                } else {
                    postShop.setPostId((String)postpMap.get(no.trim()));
                }
                String code = st.getCell(1, j).getContents();
                if (code == null || "".equals(String.valueOf(code).trim())) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u95e8\u5e97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                if (shopMap.get(code) == null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u975e\u6cd5\u7684\u6570\u636e(" + code + ")\u3002"));
                } else {
                    postShop.setShopId((String)shopMap.get(code.trim()));
                }
                String sdate = st.getCell(3, j).getContents();
                if (sdate == null || "".equals(String.valueOf(sdate).trim())) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                if (sys) {
                    sdf = new SimpleDateFormat(FORMDATE);
                    try {
                        sdf.parse(String.valueOf(sdate).trim());
                    }
                    catch (Exception exception) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u5f00\u59cb\u65f6\u95f4\u4e0d\u6b63\u786e\uff01"));
                    }
                    postShop.setStartDate(sdf.parse(String.valueOf(sdate).trim()));
                    edate = st.getCell(4, j).getContents();
                    if (edate != null && !"".equals(String.valueOf(edate).trim())) {
                        try {
                            sdf.parse(String.valueOf(edate).trim());
                        }
                        catch (Exception exception) {
                            megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u7ed3\u675f\u65f6\u95f4\u4e0d\u6b63\u786e\uff01"));
                        }
                        postShop.setEndDate(sdf.parse(String.valueOf(edate).trim()));
                    }
                } else {
                    sdf = new SimpleDateFormat(FORMDATE);
                    try {
                        sdf.parse(String.valueOf(sdate).trim());
                    }
                    catch (Exception exception) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u5f00\u59cb\u65f6\u95f4\u4e0d\u6b63\u786e\uff01"));
                    }
                    postShop.setStartDate(sdf.parse(String.valueOf(sdate).trim()));
                    edate = st.getCell(4, j).getContents();
                    if (edate != null && !"".equals(String.valueOf(edate).trim())) {
                        try {
                            sdf.parse(String.valueOf(edate).trim());
                        }
                        catch (Exception exception) {
                            megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u7ed3\u675f\u65f6\u95f4\u4e0d\u6b63\u786e\uff01"));
                        }
                        postShop.setEndDate(sdf.parse(String.valueOf(edate).trim()));
                    }
                }
                postShop.fillInitData(me);
                PostShop ps = (PostShop)this.baseDao.findFirstEntity("from PostShop where postId = ? and shopId = ? ", new Object[]{postShop.getPostId(), postShop.getShopId()}, PostShop.class);
                if (ps == null) {
                    postShops.add(postShop);
                } else {
                    ps.setStartDate(postShop.getStartDate());
                    ps.setEndDate(postShop.getEndDate());
                    postShops.add(ps);
                }
                ++j;
            }
            rwb.close();
        }
        catch (Exception exception) {}
        return megs;
    }

    public List<AdjustStockUtil> readyExcelPostPartner(List<PostPartner> postPartners, String url, Employee me) {
        int myR;
        Sheet st;
        Workbook rwb;
        ArrayList<AdjustStockUtil> megs;
        block28: {
            megs = new ArrayList<AdjustStockUtil>();
            FileInputStream is = new FileInputStream(url);
            rwb = Workbook.getWorkbook((InputStream)is);
            st = rwb.getSheet(0);
            myR = st.getRows();
            if (myR >= 2) break block28;
            return null;
        }
        try {
            List customers = this.baseDao.findEntity("from Customer where supplierId = ? ", new Object[]{me.getCurrentPartner().getId()}, Customer.class);
            HashMap<String, String> cusMap = new HashMap<String, String>();
            for (Customer customer : customers) {
                cusMap.put(customer.getApplyerCode(), customer.getApplyerId());
            }
            List positionList = this.baseDao.findEntity("from Position p where p.orgId = ? ", new Object[]{me.getCurrentPartner().getId()}, Position.class);
            HashMap<String, String> postpMap = new HashMap<String, String>();
            for (Position post : positionList) {
                postpMap.put(post.getNo(), post.getId());
            }
            boolean sys = true;
            if (System.getProperty("os.name").indexOf("Windows") >= 0) {
                sys = false;
            }
            PostPartner postPartner = null;
            int j = 1;
            while (j < myR) {
                String edate;
                SimpleDateFormat sdf;
                postPartner = new PostPartner();
                String no = st.getCell(0, j).getContents();
                if (no == null || "".equals(String.valueOf(no).trim())) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u5c97\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                if (postpMap.get(no) == null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u975e\u6cd5\u7684\u6570\u636e(" + no + ")\u3002"));
                } else {
                    postPartner.setPostId((String)postpMap.get(no.trim()));
                }
                String code = st.getCell(1, j).getContents();
                if (code == null || "".equals(String.valueOf(code).trim())) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u95e8\u5e97\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                if (cusMap.get(code) == null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u975e\u6cd5\u7684\u6570\u636e(" + code + ")\u3002"));
                } else {
                    postPartner.setApplyerId((String)cusMap.get(code.trim()));
                }
                String sdate = st.getCell(3, j).getContents();
                if (sdate == null || "".equals(String.valueOf(sdate).trim())) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                if (sys) {
                    sdf = new SimpleDateFormat(FORMDATE);
                    try {
                        sdf.parse(String.valueOf(sdate).trim());
                    }
                    catch (Exception exception) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u5f00\u59cb\u65f6\u95f4\u4e0d\u6b63\u786e\uff01"));
                    }
                    postPartner.setStartdate(sdf.parse(String.valueOf(sdate).trim()));
                    edate = st.getCell(4, j).getContents();
                    if (edate != null && !"".equals(String.valueOf(edate).trim())) {
                        try {
                            sdf.parse(String.valueOf(edate).trim());
                        }
                        catch (Exception exception) {
                            megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u7ed3\u675f\u65f6\u95f4\u4e0d\u6b63\u786e\uff01"));
                        }
                        postPartner.setEnddate(sdf.parse(String.valueOf(edate).trim()));
                    }
                } else {
                    sdf = new SimpleDateFormat(FORMDATE);
                    try {
                        sdf.parse(String.valueOf(sdate).trim());
                    }
                    catch (Exception exception) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u5f00\u59cb\u65f6\u95f4\u4e0d\u6b63\u786e\uff01"));
                    }
                    postPartner.setStartdate(sdf.parse(String.valueOf(sdate).trim()));
                    edate = st.getCell(4, j).getContents();
                    if (edate != null && !"".equals(String.valueOf(edate).trim())) {
                        try {
                            sdf.parse(String.valueOf(edate).trim());
                        }
                        catch (Exception exception) {
                            megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:\u7ed3\u675f\u65f6\u95f4\u4e0d\u6b63\u786e\uff01"));
                        }
                        postPartner.setEnddate(sdf.parse(String.valueOf(edate).trim()));
                    }
                }
                postPartner.fillInitData(me);
                PostPartner ps = (PostPartner)this.baseDao.findFirstEntity("from PostPartner where postId = ? and applyerId = ? ", new Object[]{postPartner.getPostId(), postPartner.getApplyerId()}, PostPartner.class);
                if (ps == null) {
                    postPartners.add(postPartner);
                } else {
                    ps.setStartdate(postPartner.getStartdate());
                    ps.setEnddate(postPartner.getEnddate());
                    postPartners.add(ps);
                }
                ++j;
            }
            rwb.close();
        }
        catch (Exception exception) {}
        return megs;
    }

    public List<Position> getRoletype(String userId) {
        String sql = "select p from Position p,ContactPosition cp where p.id = cp.postId and p.roletype is not null and cp.userId = ? and cp.startDate < ? and (cp.endDate > ? or cp.endDate is null)";
        return this.baseDao.findEntity(sql, new Object[]{userId, new Date(), new Date()}, Position.class);
    }
}

