/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.reply;

import com.tcbj.crm.base.BaseService;
import com.tcbj.crm.entity.ContactRegion;
import com.tcbj.crm.entity.Reply;
import com.tcbj.crm.entity.ReplyDetails;
import com.tcbj.crm.reply.ReplyCondition;
import com.tcbj.crm.view.Contact;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="replyService")
public class ReplyService
extends BaseService {
    @Autowired
    BaseDao baseDao;

    public Reply get(String id) {
        return (Reply)this.baseDao.get(Reply.class, (Serializable)((Object)id));
    }

    public void save(Reply obj) {
        this.baseDao.save((Object)obj);
    }

    public Page getList(int pageno, ReplyCondition condition) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from Reply o where 1=1 and o.applyerId=? ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getCurrentEmployee().getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTitle())) {
            HQL.append(" and o.title like ? ");
            args.add("%" + condition.getTitle() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            HQL.append(" and o.supplierId = ? ");
            args.add(condition.getSupplierId());
        }
        HQL.append(" and o.flag!='3' order by o.flag asc,o.lastUpdateDt desc ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page getMyList(int pageno, ReplyCondition condition) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from Reply o where 1=1 and o.supplierId = ? ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getCurrentEmployee().getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTitle())) {
            HQL.append(" and o.title like ? ");
            args.add("%" + condition.getTitle() + "%");
        }
        HQL.append(" and o.flag!='3' order by o.flag asc,o.lastUpdateDt desc ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public void update(Reply obj) {
        this.baseDao.update((Object)obj);
    }

    public void delete(String id) {
        Reply reply = (Reply)this.baseDao.get(Reply.class, (Serializable)((Object)id));
        reply.setFlag("3");
        this.baseDao.update((Object)reply);
    }

    public void deleteReplyDetails(String id) {
        this.baseDao.deleteById(ReplyDetails.class, (Serializable)((Object)id));
    }

    public void saveReplyDetails(ReplyDetails rd) {
        this.baseDao.save((Object)rd);
    }

    public List<ReplyDetails> getReplyDetails(String id) {
        return this.baseDao.findEntity("from ReplyDetails a where a.replyId=? order by a.lastUpdateDt", new Object[]{id}, ReplyDetails.class);
    }

    public List<Contact> getStaffRegion(String id) {
        List list = this.baseDao.findEntity("from ContactRegion a where a.regionId=?", new Object[]{id}, ContactRegion.class);
        ArrayList<Contact> listname = new ArrayList<Contact>();
        for (ContactRegion sr : list) {
            listname.add((Contact)this.baseDao.get(Contact.class, (Serializable)((Object)sr.getUserId())));
        }
        return listname;
    }

    public Long[] replayCount(String id) {
        Long applyer = (Long)this.baseDao.findEntity("select count(*) from Reply o where  o.applyerId=? and o.flag<'2' ", new Object[]{id}).get(0);
        Long supplier = (Long)this.baseDao.findEntity("select count(*) from Reply o where  o.supplierId = ? and o.flag<'2' ", new Object[]{id}).get(0);
        return new Long[]{applyer, supplier};
    }
}

