/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.report;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.report.EmployeeReportCondition;
import com.tcbj.crm.report.EmployeeReportService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/report"})
public class EmployeeReportController
extends BaseController {
    @Autowired
    EmployeeReportService employeeReportService;

    @RequestMapping(value={"/employeelist.do"})
    public String getList(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, EmployeeReportCondition condition, Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        Page page = this.employeeReportService.getReportEmployeePage(condition, pageno, e);
        if (page.getList().size() > 0) {
            Map<String, String> positionMap = this.employeeReportService.getContactPositionMap(e.getCurrentPartner().getId());
            Map<String, String> regionMap = this.employeeReportService.getContactRegionMap(e.getCurrentPartner().getId());
            Map<String, String> partnerMap = this.employeeReportService.getContactPartnerMap(e.getCurrentPartner().getId());
            Map<String, String> shopMap = this.employeeReportService.getContactShopMap(e.getCurrentPartner().getId());
            List list = page.getList();
            for (PartnerContact contact : list) {
                contact.setPositions(positionMap.get(contact.getId()));
                contact.setRegions(regionMap.get(contact.getId()));
                contact.setPartners(partnerMap.get(contact.getId()));
                contact.setShops(shopMap.get(contact.getId()));
            }
        }
        model.addAttribute("page", (Object)page);
        model.addAttribute("map", Cache.getEmployees());
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        model.addAttribute("condition", (Object)condition);
        return "report/employeelist.ftl";
    }

    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(EmployeeReportCondition condition, HttpServletRequest request, HttpServletResponse response) {
        File dir;
        Employee e = this.getCurrentEmployee();
        List<PartnerContact> list = this.employeeReportService.getReportEmployeeList(condition);
        if (list.size() > 0) {
            Map<String, String> positionMap = this.employeeReportService.getContactPositionMap(e.getCurrentPartner().getId());
            Map<String, String> regionMap = this.employeeReportService.getContactRegionMap(e.getCurrentPartner().getId());
            Map<String, String> partnerMap = this.employeeReportService.getContactPartnerMap(e.getCurrentPartner().getId());
            Map<String, String> shopMap = this.employeeReportService.getContactShopMap(e.getCurrentPartner().getId());
            for (PartnerContact contact : list) {
                contact.setPositions(positionMap.get(contact.getId()));
                contact.setRegions(regionMap.get(contact.getId()));
                contact.setPartners(partnerMap.get(contact.getId()));
                contact.setShops(shopMap.get(contact.getId()));
            }
        }
        if (!(dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "employeeexcel")).exists()) {
            dir.mkdirs();
        }
        EmployeeReportController.excels(list, dir.getPath(), String.valueOf(e.getCurrentPartner().getNo()) + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
    }

    public static boolean excels(List<PartnerContact> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u7ecf\u9500\u5546\u540d\u79f0", "\u59d3\u540d", "\u804c\u52a1", "\u7c7b\u578b", "\u6027\u522b", "\u8eab\u4efd\u8bc1\u53f7\u7801", "\u5165\u804c\u65f6\u95f4", "\u5458\u5de5\u53f7", "\u5b66\u5386", "\u79fb\u52a8\u7535\u8bdd", "\u5bb6\u5ead\u7535\u8bdd", "\u7535\u5b50\u90ae\u4ef6", "QQ", "\u8054\u7cfb\u5730\u5740", "\u7ba1\u7406\u5927\u533a/\u533a\u57df", "\u7ba1\u7406\u804c\u4f4d", "\u7ba1\u7406\u7ecf\u9500\u5546", "\u7ba1\u7406\u95e8\u5e97"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            PartnerContact stu = list.get(i);
            String[] vals = new String[]{stu.getPartnerName(), stu.getContactName(), stu.getDutyTypeName(), stu.getPersontypeName(), stu.getSexName(), stu.getIdnumber(), DateUtils.formartDate((Date)stu.getHireDate(), (String)"yyyy-MM-dd"), stu.getNo(), stu.getEducation(), stu.getMobile(), stu.getFamilyphone(), stu.getEmail(), stu.getQq(), stu.getAddress(), stu.getRegions(), stu.getPositions(), stu.getPartners(), stu.getShops()};
            int j = 0;
            while (j < vals.length) {
                row.createCell(j).setCellValue(vals[j]);
                ++j;
            }
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean exportExcel(HttpServletResponse response, List<PartnerContact> list, String name) {
        try {
            ServletOutputStream os = response.getOutputStream();
            response.reset();
            response.setHeader("Content-disposition", "attachment; filename=" + name);
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            WritableWorkbook wbook = Workbook.createWorkbook((OutputStream)os);
            String tmptitle = "\u4eba\u5458";
            WritableSheet wsheet = wbook.createSheet(tmptitle, 0);
            wsheet.addCell((WritableCell)new Label(0, 0, "\u59d3\u540d"));
            wsheet.addCell((WritableCell)new Label(1, 0, "\u804c\u52a1"));
            wsheet.addCell((WritableCell)new Label(2, 0, "\u7c7b\u578b "));
            wsheet.addCell((WritableCell)new Label(3, 0, "\u6027\u522b"));
            wsheet.addCell((WritableCell)new Label(4, 0, "\u8eab\u4efd\u8bc1\u53f7\u7801"));
            wsheet.addCell((WritableCell)new Label(5, 0, "\u5165\u804c\u65f6\u95f4"));
            wsheet.addCell((WritableCell)new Label(6, 0, "\u5458\u5de5\u53f7"));
            wsheet.addCell((WritableCell)new Label(7, 0, "\u5b66\u5386"));
            wsheet.addCell((WritableCell)new Label(8, 0, "\u79fb\u52a8\u7535\u8bdd"));
            wsheet.addCell((WritableCell)new Label(9, 0, "\u5bb6\u5ead\u7535\u8bdd"));
            wsheet.addCell((WritableCell)new Label(10, 0, "\u7535\u5b50\u90ae\u4ef6"));
            wsheet.addCell((WritableCell)new Label(11, 0, "QQ"));
            wsheet.addCell((WritableCell)new Label(12, 0, "\u8054\u7cfb\u5730\u5740"));
            wsheet.addCell((WritableCell)new Label(13, 0, "\u7ba1\u7406\u5927\u533a/\u533a\u57df"));
            wsheet.addCell((WritableCell)new Label(14, 0, "\u7ba1\u7406\u804c\u4f4d"));
            wsheet.addCell((WritableCell)new Label(15, 0, "\u7ba1\u7406\u7ecf\u9500\u5546"));
            wsheet.addCell((WritableCell)new Label(16, 0, "\u7ba1\u7406\u95e8\u5e97"));
            int i = 0;
            while (i < list.size()) {
                wsheet.addCell((WritableCell)new Label(0, i + 1, list.get(i).getContactName()));
                wsheet.addCell((WritableCell)new Label(1, i + 1, list.get(i).getDutyTypeName()));
                wsheet.addCell((WritableCell)new Label(2, i + 1, list.get(i).getPersontypeName()));
                wsheet.addCell((WritableCell)new Label(3, i + 1, list.get(i).getSexName()));
                wsheet.addCell((WritableCell)new Label(4, i + 1, list.get(i).getIdnumber()));
                wsheet.addCell((WritableCell)new Label(5, i + 1, DateUtils.formartDate((Date)list.get(i).getHireDate(), (String)"yyyy-MM-dd")));
                wsheet.addCell((WritableCell)new Label(6, i + 1, list.get(i).getNo()));
                wsheet.addCell((WritableCell)new Label(7, i + 1, list.get(i).getEducation()));
                wsheet.addCell((WritableCell)new Label(8, i + 1, list.get(i).getMobile()));
                wsheet.addCell((WritableCell)new Label(9, i + 1, list.get(i).getFamilyphone()));
                wsheet.addCell((WritableCell)new Label(10, i + 1, list.get(i).getEmail()));
                wsheet.addCell((WritableCell)new Label(11, i + 1, list.get(i).getQq()));
                wsheet.addCell((WritableCell)new Label(12, i + 1, list.get(i).getAddress()));
                wsheet.addCell((WritableCell)new Label(13, i + 1, list.get(i).getRegions()));
                wsheet.addCell((WritableCell)new Label(14, i + 1, list.get(i).getPositions()));
                wsheet.addCell((WritableCell)new Label(15, i + 1, list.get(i).getPartners()));
                wsheet.addCell((WritableCell)new Label(16, i + 1, list.get(i).getShops()));
                ++i;
            }
            wbook.write();
            wbook.close();
            os.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

