/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.report;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.report.ProductReportService;
import com.tcbj.crm.report.ProductVo;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/report"})
public class ProductReportController
extends BaseController {
    @Autowired
    PersonnelService personnelservice;
    @Autowired
    ProductReportService service;

    @RequestMapping(value={"/productList.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, String dis, Model model, String id, ProductCondition condition, String partnerno) {
        Employee em = this.getCurrentEmployee();
        Page product = this.service.getProductsByPage(em, condition, pageno);
        model.addAttribute("products", (Object)product);
        model.addAttribute("partner", (Object)em.getCurrentPartner());
        model.addAttribute("condition", (Object)condition);
        return "report/productList.ftl";
    }

    @RequestMapping(value={"/exportProdExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(ProductCondition condition, Model model, HttpServletRequest request, HttpServletResponse response) {
        Employee em = this.getCurrentEmployee();
        List<ProductVo> list = this.service.getReportProductList(em, condition);
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "exportProdExcel");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ProductReportController.excels(list, dir.getPath(), String.valueOf(em.getCurrentPartner().getNo()) + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
    }

    public static boolean excels(List<ProductVo> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        int sheetSize = list.size() / 50000 + 1;
        int j = 0;
        while (j < sheetSize) {
            HSSFSheet sheet = wb.createSheet(String.valueOf(j));
            HSSFRow row = sheet.createRow(0);
            row.createCell(0).setCellValue("\u7ecf\u9500\u5546\u540d\u79f0");
            row.createCell(1).setCellValue("\u52a9\u8bb0\u7801");
            row.createCell(2).setCellValue("\u4ea7\u54c1\u7f16\u53f7");
            row.createCell(3).setCellValue("\u4ea7\u54c1\u540d\u79f0");
            row.createCell(4).setCellValue("\u4ea7\u54c1\u7c7b\u522b");
            row.createCell(5).setCellValue("\u4ea7\u54c1\u5b50\u5206\u7c7b");
            row.createCell(6).setCellValue("EAS\u7f16\u7801");
            row.createCell(7).setCellValue("\u5355\u4f4d");
            row.createCell(8).setCellValue("\u662f\u5426\u5206\u914d");
            row.createCell(9).setCellValue("\u5931\u6548\u65e5\u671f");
            row.createCell(10).setCellValue("\u5e93\u5b58\u53ef\u89c1\u72b6\u6001");
            int size = 50000 * (j + 1);
            if (size > list.size()) {
                size = list.size();
            }
            int k = 0;
            int i = 50000 * j;
            while (i < size) {
                row = sheet.createRow(k + 1);
                ProductVo prVo = list.get(i);
                row.createCell(0).setCellValue(prVo.getPartnerName());
                row.createCell(1).setCellValue(prVo.getPartnerCode());
                row.createCell(2).setCellValue(prVo.getProdNo());
                row.createCell(3).setCellValue(prVo.getProductName());
                row.createCell(4).setCellValue(prVo.getProdTypeName());
                row.createCell(5).setCellValue(prVo.getSubTypeName());
                row.createCell(6).setCellValue(prVo.getEasNo());
                row.createCell(7).setCellValue(prVo.getUnitTypeName());
                row.createCell(8).setCellValue(prVo.getIsDis());
                row.createCell(9).setCellValue(DateUtils.formartDate((Date)prVo.getInvalidDate(), (String)"yyyy-MM-dd hh:mm:ss"));
                row.createCell(10).setCellValue(prVo.getDisplay());
                ++k;
                ++i;
            }
            ++j;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean exportExcel(HttpServletResponse response, List<ProductVo> list, String name) {
        try {
            ServletOutputStream os = response.getOutputStream();
            response.reset();
            response.setHeader("Content-disposition", "attachment; filename=" + name);
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            WritableWorkbook wbook = Workbook.createWorkbook((OutputStream)os);
            String tmptitle = "\u8ba2\u8d2d\u4ea7\u54c1\u660e\u7ec6";
            WritableSheet wsheet = wbook.createSheet(tmptitle, 0);
            wsheet.addCell((WritableCell)new Label(0, 0, "\u7ecf\u9500\u5546\u540d\u79f0"));
            wsheet.addCell((WritableCell)new Label(1, 0, "\u52a9\u8bb0\u7801"));
            wsheet.addCell((WritableCell)new Label(2, 0, "\u4ea7\u54c1\u7f16\u53f7"));
            wsheet.addCell((WritableCell)new Label(3, 0, "\u4ea7\u54c1\u540d\u79f0"));
            wsheet.addCell((WritableCell)new Label(4, 0, "\u4ea7\u54c1\u7c7b\u522b"));
            wsheet.addCell((WritableCell)new Label(5, 0, "\u4ea7\u54c1\u5b50\u5206\u7c7b"));
            wsheet.addCell((WritableCell)new Label(6, 0, "EAS\u7f16\u7801"));
            wsheet.addCell((WritableCell)new Label(7, 0, "\u5355\u4f4d"));
            wsheet.addCell((WritableCell)new Label(8, 0, "\u662f\u5426\u5206\u914d"));
            wsheet.addCell((WritableCell)new Label(9, 0, "\u5931\u6548\u65e5\u671f"));
            wsheet.addCell((WritableCell)new Label(10, 0, "\u5e93\u5b58\u53ef\u89c1\u72b6\u6001"));
            int i = 0;
            while (i < list.size()) {
                wsheet.addCell((WritableCell)new Label(0, i + 1, list.get(i).getPartnerName()));
                wsheet.addCell((WritableCell)new Label(1, i + 1, list.get(i).getPartnerCode()));
                wsheet.addCell((WritableCell)new Label(2, i + 1, list.get(i).getProdNo()));
                wsheet.addCell((WritableCell)new Label(3, i + 1, list.get(i).getProductName()));
                wsheet.addCell((WritableCell)new Label(4, i + 1, list.get(i).getProdTypeName()));
                wsheet.addCell((WritableCell)new Label(5, i + 1, list.get(i).getSubTypeName()));
                wsheet.addCell((WritableCell)new Label(6, i + 1, list.get(i).getEasNo()));
                wsheet.addCell((WritableCell)new Label(7, i + 1, list.get(i).getUnitTypeName()));
                wsheet.addCell((WritableCell)new Label(8, i + 1, list.get(i).getIsDis()));
                wsheet.addCell((WritableCell)new Label(9, i + 1, DateUtils.formartDate((Date)list.get(i).getInvalidDate(), (String)"yyyy-MM-dd hh:mm:ss")));
                wsheet.addCell((WritableCell)new Label(10, i + 1, list.get(i).getDisplay()));
                ++i;
            }
            wbook.write();
            wbook.close();
            os.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

