/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.right;

import com.tcbj.crm.right.RangeRight;
import com.tcbj.crm.right.RightService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="rightService")
public class RightServiceimpl
implements RightService {
    @Autowired
    private BaseDao baseDao;

    @Override
    public boolean hasRightByUser(String userId, String funCode) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        Date date = new Date();
        HQL.append(" select count(*) from cx_awk_function f left join cx_awk_role_f rf ");
        HQL.append(" on rf.function_id = f.row_id left join cx_awk_role_c rc ");
        HQL.append(" on rf.role_id = rc.role_id where rc.user_id = ? ");
        HQL.append(" and rc.start_date <?  and f.function_code = ?");
        args.add(userId);
        args.add(date);
        args.add(funCode);
        List object = this.baseDao.findBySql(HQL.toString(), args.toArray());
        BigDecimal bd = (BigDecimal)object.get(0);
        return bd.intValue() > 0;
    }

    @Override
    public boolean hasRightByUser(String funCode) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Map codes = (Map)request.getSession().getAttribute("functions");
        return codes.get(funCode) != null && ((Set)codes.get(funCode)).size() != 0;
    }

    @Override
    public RangeRight getRightByUser(String userId, String funCode) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        Date date = new Date();
        HQL.append(" select rf.range from cx_awk_function f left join cx_awk_role_f rf ");
        HQL.append(" on rf.function_id = f.row_id left join cx_awk_role_c rc ");
        HQL.append(" on rf.role_id = rc.role_id where rc.user_id = ? ");
        HQL.append(" and rc.start_date >?  and f.function_code = ?");
        args.add(userId);
        args.add(date);
        args.add(funCode);
        List object = this.baseDao.findBySql(HQL.toString(), args.toArray());
        if (object.size() > 0) {
            RangeRight rr = RangeRight.getRangeRight(((Object[])object.get(0)).toString());
            return rr;
        }
        return null;
    }

    @Override
    public void cacheRights(HttpServletRequest request, Employee emp) {
        HashMap codes = new HashMap();
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append(" select f.function_code,f.FUTURE_PARAMETER from cx_awk_function f left join cx_awk_role_f rf ");
        HQL.append(" on rf.function_id = f.row_id left join cx_awk_role_c rc ");
        HQL.append(" on rf.role_id = rc.role_id where rc.user_id = ? ");
        args.add(emp.getId());
        List objects = this.baseDao.findBySql(HQL.toString(), args.toArray());
        for (Object[] obj : objects) {
            HashSet<String> set = new HashSet<String>();
            String code = (String)obj[0];
            set.add((String)obj[1]);
            codes.put(code, set);
        }
        request.getSession().setAttribute("functions", codes);
    }
}

