/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.role;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.employee.EmployeeService;
import com.tcbj.crm.entity.RoleUse;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.role.RoleService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.io.IOException;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/role"})
public class RoleController
extends BaseController {
    @Autowired
    EmployeeService service;
    @Autowired
    RoleService roleService;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(String name, Model model, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno) {
        Page list = this.roleService.getList(this.getCurrentEmployee().getCurrentPartner().getId(), name, pageno);
        model.addAttribute("role", (Object)list);
        model.addAttribute("name", (Object)name);
        return "role/list.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add() {
        return "role/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result save(@Valid @RequestBody RoleUse role) {
        Employee e = this.getCurrentEmployee();
        role.setOrganizationId(e.getCurrentPartner().getId());
        role.fillInitData(e);
        this.roleService.save(role);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit(String id, Model model) {
        RoleUse cxAwkRoleUse = this.roleService.findById(id);
        model.addAttribute("cxAwkRoleUse", (Object)cxAwkRoleUse);
        return "role/update.ftl";
    }

    @RequestMapping(value={"/update.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result update(@Valid @RequestBody RoleUse form) throws IOException {
        Employee e = this.getCurrentEmployee();
        form.setLastUpdBy(e.getId());
        form.setLastUpd(DateUtils.now());
        this.roleService.update(form);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result delete(@Valid @RequestBody RoleUse form) throws IOException {
        boolean isExist = this.roleService.isExist(form.getId());
        if (isExist) {
            throw new AppException("1501");
        }
        this.roleService.delete(form);
        return this.getSuccessResult(null);
    }
}

