/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.score;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.score.ScoreCondition;
import com.tcbj.crm.score.ScoreService;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.stock.UpdateStockItem;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.ExchangeDetail;
import com.tcbj.crm.view.ExchangeOrder;
import com.tcbj.crm.view.MemberPoints;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/score"})
public class ScoreController
extends BaseController {
    @Autowired
    private ScoreService service;
    @Autowired
    private StorageService storageService;
    @Autowired
    private StockService stockService;

    @RequestMapping(value={"/myscore.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String myscore(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ScoreCondition condition, Model model) {
        Employee emp = this.getCurrentEmployee();
        condition.setSupplierId(emp.getCurrentPartner().getId());
        condition.setApplyerId(emp.getCurrentPartner().getId());
        condition.setDetail(true);
        MemberPoints memberPoints = this.service.getMemberPoints(condition.getSupplierId());
        if (StringUtils.isNotNull(memberPoints)) {
            memberPoints.setTotalPoint(MathUtils.add((Double)(memberPoints.getProdPoint() == null ? 0.0 : memberPoints.getProdPoint()), (Double)(memberPoints.getGiftPoint() == null ? 0.0 : memberPoints.getGiftPoint())));
        }
        Page page = this.service.getExchangeOrders(condition, pageno);
        this.calculationScore(page.getList());
        model.addAttribute("memberPoints", (Object)memberPoints);
        model.addAttribute("page", (Object)page);
        model.addAttribute("name", (Object)emp.getCurrentPartner().getName());
        model.addAttribute("condition", (Object)condition);
        return "score/myscore.ftl";
    }

    private void calculationScore(List<ExchangeOrder> list) {
        for (ExchangeOrder exchangeOrder : list) {
            List<ExchangeDetail> detailslist = this.service.getExchangeDetails(exchangeOrder.getId(), null);
            exchangeOrder.setProductScore(this.getProductScore(detailslist, "GPRODUCT"));
            exchangeOrder.setGiftScore(this.getProductScore(detailslist, "GPACKAGE"));
            exchangeOrder.setProductQuantity(this.getProductQuantity(detailslist, "GPRODUCT"));
            exchangeOrder.setGiftQuantity(this.getProductQuantity(detailslist, "GPACKAGE"));
        }
    }

    private Double getProductScore(List<ExchangeDetail> detailslist, String type) {
        Double productScore = 0.0;
        for (ExchangeDetail exchangeDetail : detailslist) {
            if (!type.equals(exchangeDetail.getTransactionSubTypeCode()) || exchangeDetail.getQuantity() == null || exchangeDetail.getPoints() == null) continue;
            productScore = MathUtils.add((Double)productScore, (Double)(exchangeDetail.getQuantity() * exchangeDetail.getPoints()));
        }
        return productScore;
    }

    private Double getProductQuantity(List<ExchangeDetail> detailslist, String type) {
        Double giftQuantity = 0.0;
        for (ExchangeDetail exchangeDetail : detailslist) {
            if (!type.equals(exchangeDetail.getTransactionSubTypeCode()) || exchangeDetail.getQuantity() == null) continue;
            giftQuantity = MathUtils.add((Double)giftQuantity, (Double)exchangeDetail.getQuantity());
        }
        return giftQuantity;
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model) {
        ExchangeOrder exchangeOrder = this.service.getExchangeOrder(id);
        List<ExchangeDetail> list = this.service.getExchangeDetails(id, null);
        model.addAttribute("exchangeOrder", (Object)exchangeOrder);
        model.addAttribute("details", (Object)JSON.toJSONStringWithDateFormat(list, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "score/view.ftl";
    }

    @RequestMapping(value={"/shopApply.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String shopApply(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ScoreCondition condition, Model model) {
        Employee emp = this.getCurrentEmployee();
        condition.setSupplierId(emp.getCurrentPartner().getId());
        condition.setRedeemType("SendByPartner");
        Page page = this.service.getExchangeOrders(condition, pageno);
        this.calculationScore(page.getList());
        model.addAttribute("page", (Object)page);
        model.addAttribute("name", (Object)emp.getCurrentPartner().getName());
        model.addAttribute("condition", (Object)condition);
        return "score/shopApply.ftl";
    }

    @RequestMapping(value={"/approveByScore.do"}, method={RequestMethod.GET})
    public String getApproveByScore(String id, Model model) {
        ExchangeOrder exchangeOrder = this.service.getExchangeOrder(id);
        List<ExchangeDetail> list = this.service.getExchangeDetails(id, null);
        model.addAttribute("exchangeOrder", (Object)exchangeOrder);
        model.addAttribute("details", (Object)JSON.toJSONStringWithDateFormat(list, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "score/approveByScore.ftl";
    }

    @RequestMapping(value={"/approveByScore.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result approveByScore(@Valid @RequestBody ExchangeOrder exchangeOrder, String sos, Model model) {
        Employee emp = this.getCurrentEmployee();
        exchangeOrder = this.service.getExchangeOrder(exchangeOrder.getId());
        List<ExchangeDetail> list = this.service.getExchangeDetails(exchangeOrder.getId(), null);
        exchangeOrder.setDetails(list);
        if ("1".equals(sos)) {
            exchangeOrder.setState("Approved");
        } else {
            exchangeOrder.setState("Declined");
        }
        this.service.updateExchangeOrder(exchangeOrder, emp);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/shipByScore.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result shipByScore(@Valid @RequestBody ExchangeOrder exchangeOrder, Model model) {
        Employee emp = this.getCurrentEmployee();
        exchangeOrder = this.service.getExchangeOrder(exchangeOrder.getId());
        List<ExchangeDetail> list = this.service.getExchangeDetails(exchangeOrder.getId(), null);
        exchangeOrder.setDetails(list);
        exchangeOrder.setState("Sended");
        exchangeOrder.setDlvDate(DateUtils.now());
        this.service.updateExchangeOrder(exchangeOrder, emp);
        Storage storage = this.storageService.getStorage(emp.getCurrentPartner().getId());
        ArrayList<UpdateStockItem> list2 = new ArrayList<UpdateStockItem>();
        for (ExchangeDetail item : exchangeOrder.getDetails()) {
            UpdateStockItem sitem = new UpdateStockItem(item.getId(), item.getProductId(), item.getQuantity());
            sitem.setSupplierId(emp.getCurrentPartner().getId());
            sitem.setApplyerId(emp.getCurrentPartner().getId());
            list2.add(sitem);
        }
        this.stockService.updateQuantity(emp, emp.getCurrentPartner().getId(), storage.getId(), exchangeOrder.getId(), "\u95e8\u5e97\u79ef\u5206\u5151\u6362", list2);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/detailed.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String detailed(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ScoreCondition condition, Model model) {
        Employee emp = this.getCurrentEmployee();
        condition.setSupplierId(emp.getCurrentPartner().getId());
        condition.setRedeemType("SendByPartner");
        Page page = this.service.getDetailed(condition, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("name", (Object)emp.getCurrentPartner().getName());
        model.addAttribute("condition", (Object)condition);
        return "score/detailed.ftl";
    }

    @RequestMapping(value={"/detailedExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void excel(ScoreCondition condition, HttpServletRequest request, HttpServletResponse response) {
        Employee emp = this.getCurrentEmployee();
        condition.setSupplierId(emp.getCurrentPartner().getId());
        condition.setRedeemType("SendByPartner");
        List<ExchangeDetail> list = this.service.getDetailedOrList(condition);
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "score");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.service.excels(list, dir.getPath(), String.valueOf(emp.getCurrentPartner().getNo()) + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
    }
}

