/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.shop;

import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.entity.Shop;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.region.RegionService;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ValidataUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="shopExcelVaildateService")
public class ShopExcelVaildateService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    ClientService clientService;
    @Autowired
    Cache cache;
    @Autowired
    PartnerService partnerService;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    ShopService shopService;
    @Autowired
    RegionService regionService;
    private static final String FORMDATE = "MM/dd/yy";
    private final Logger LOG = LoggerFactory.getLogger(ShopExcelVaildateService.class);

    public List<AdjustStockUtil> readShopByExcel(String filePath, Employee me, List<Shop> list) {
        int myR;
        Sheet st;
        Workbook rwb;
        ArrayList<AdjustStockUtil> megs;
        block67: {
            megs = new ArrayList<AdjustStockUtil>();
            FileInputStream is = new FileInputStream(filePath);
            rwb = Workbook.getWorkbook((InputStream)is);
            st = rwb.getSheet(0);
            int myCol = st.getColumns();
            myR = st.getRows();
            this.LOG.debug("//\u5217\u6570" + myCol + "//\u884c\u6570:" + myR);
            if (myR >= 2) break block67;
            return null;
        }
        try {
            Map<String, String> partnerMap = this.partnerService.findSubPartnersMap(me);
            Map<String, String> saleManMap = this.personnelService.getByOrgMap(me.getCurrentPartner().getOrganizationid());
            Map<String, String> regionMap = this.getRegionMap(me);
            Map<String, String> areaMap = this.getAreaMap(me);
            Map<String, String> provinceTypeMap = this.getItenMap("STATE_ABBREV");
            Map<String, String> cityTypeMap = this.getItenMap("TCBJ_CITY");
            Map<String, String> countyTypeMap = this.getItenMap("COUNTY");
            Map<String, String> stroreTypeMap = this.getItenMap("TCBJ_STORE_TYPE");
            Map<String, String> subTypeMap = this.getItenMap("TCBJ_STORE_SUBTYPE");
            Map<String, String> levelTypeMap = this.getItenMap("TCBJ_TERMIMAL_LEVEL");
            Map<String, String> modeTypeMap = this.getItenMap("TCBJ_PROMOTION_MODE");
            HashMap<String, String> selectTypeMap = new HashMap<String, String>();
            selectTypeMap.put("\u662f", "Y");
            selectTypeMap.put("\u5426", "N");
            String message = null;
            String result = null;
            Shop shop = null;
            int j = 1;
            while (j < myR) {
                shop = new Shop();
                result = null;
                message = ValidataUtils.validataMap((Object)st.getCell(0, j).getContents().trim(), partnerMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u4e0a\u7ea7\u7ecf\u9500\u5546\u52a9\u8bb0\u7801 \uff1a" + message;
                } else {
                    shop.setParentDealerId(partnerMap.get(st.getCell(0, j).getContents().trim()));
                }
                message = ValidataUtils.validataMap((Object)(String.valueOf(st.getCell(2, j).getContents().trim()) + "_" + st.getCell(3, j).getContents().trim()), saleManMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u4e1a\u52a1\u5458 \uff1a" + message;
                } else {
                    shop.setSalseManId(saleManMap.get(String.valueOf(st.getCell(2, j).getContents().trim()) + "_" + st.getCell(3, j).getContents().trim()));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(4, j).getContents().trim(), regionMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5927\u533a \uff1a" + message;
                } else {
                    shop.setBigAreaId(regionMap.get(st.getCell(4, j).getContents()).trim());
                }
                message = ValidataUtils.validataMap((Object)st.getCell(5, j).getContents().trim(), areaMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u533a\u57df \uff1a" + message;
                } else {
                    shop.setAreaId(areaMap.get(st.getCell(5, j).getContents().trim()));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(6, j).getContents().trim(), provinceTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u7701\u4efd \uff1a" + message;
                } else {
                    shop.setProvinceId(provinceTypeMap.get(st.getCell(6, j).getContents()));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(7, j).getContents().trim(), cityTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u57ce\u5e02 \uff1a" + message;
                } else {
                    shop.setCityId(cityTypeMap.get(st.getCell(7, j).getContents().trim()));
                }
                message = ValidataUtils.validateMapOrNull((Object)st.getCell(8, j).getContents().trim(), countyTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u53bf\u57ce \uff1a" + message;
                } else if (com.tcbj.util.StringUtils.isNotEmpty(st.getCell(8, j).getContents().trim())) {
                    shop.setCountyId(countyTypeMap.get(st.getCell(8, j).getContents().trim()));
                }
                message = this.validaShopName(me, st.getCell(9, j).getContents().trim(), st.getCell(14, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97\u540d\u79f0 \uff1a" + message;
                } else {
                    shop.setShopName(st.getCell(9, j).getContents().trim());
                }
                message = ValidataUtils.validataMap((Object)st.getCell(10, j).getContents().trim(), stroreTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97\u7c7b\u578b \uff1a" + message;
                } else {
                    shop.setShopType(stroreTypeMap.get(st.getCell(10, j).getContents().trim()));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(11, j).getContents().trim(), subTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97\u5206\u7c7b \uff1a" + message;
                } else {
                    shop.setShopClassify(subTypeMap.get(st.getCell(11, j).getContents().trim()));
                }
                shop.setShopTel(st.getCell(12, j).getContents().trim());
                shop.setAddressDetails(st.getCell(13, j).getContents().trim());
                message = ValidataUtils.validataMap((Object)st.getCell(14, j).getContents().trim(), selectTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u662f\u5426\u4f1a\u5458\u5e97 \uff1a" + message;
                } else {
                    shop.setIsMenberShop((String)selectTypeMap.get(st.getCell(14, j).getContents().trim()));
                }
                message = ValidataUtils.validataMap((Object)st.getCell(15, j).getContents().trim(), modeTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u4fc3\u9500\u6a21\u5f0f \uff1a" + message;
                } else {
                    shop.setPromotionMode(modeTypeMap.get(st.getCell(15, j).getContents().trim()));
                }
                message = ValidataUtils.validataDoubleOrNull((Object)st.getCell(16, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u95e8\u5e97\u603b\u9762\u79ef \uff1a" + message;
                } else if (com.tcbj.util.StringUtils.isNotEmpty(st.getCell(16, j).getContents().trim())) {
                    shop.setShopTotalArea(Double.valueOf(st.getCell(16, j).getContents().trim()));
                }
                message = ValidataUtils.validataDoubleOrNull((Object)st.getCell(17, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u95e8\u5e97\u54c1\u724c\u9762\u79ef \uff1a" + message;
                } else if (com.tcbj.util.StringUtils.isNotEmpty(st.getCell(17, j).getContents().trim())) {
                    shop.setShopBrandArea(Double.valueOf(st.getCell(17, j).getContents().trim()));
                }
                message = this.validateLongIsNull(st.getCell(18, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u7ecf\u5ea6 \uff1a" + message;
                } else if (com.tcbj.util.StringUtils.isNotEmpty(st.getCell(18, j).getContents().trim())) {
                    shop.setLatitude(Long.valueOf(st.getCell(18, j).getContents().trim()));
                }
                message = this.validateLongIsNull(st.getCell(19, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u7eac\u5ea6 \uff1a" + message;
                } else if (com.tcbj.util.StringUtils.isNotEmpty(st.getCell(19, j).getContents().trim())) {
                    shop.setLongitude(Long.valueOf(st.getCell(19, j).getContents().trim()));
                }
                message = this.validateOutCilentNo(st.getCell(20, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u5916\u56f4\u5ba2\u6237\u7aef\u7f16\u53f7 \uff1a" + message;
                } else {
                    shop.setOuterClientNo(st.getCell(20, j).getContents().trim());
                }
                message = ValidataUtils.validateMapOrNull((Object)st.getCell(21, j).getContents().trim(), levelTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u7ec8\u7aef\u7b49\u7ea7 \uff1a" + message;
                } else {
                    shop.setTerminalLevel(com.tcbj.util.StringUtils.isEmpty(st.getCell(21, j).getContents().trim()) ? "" : levelTypeMap.get(st.getCell(21, j).getContents().trim()));
                }
                message = this.validateLongIsNull(st.getCell(22, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u4fc3\u9500\u4eba\u6570\uff1a" + message;
                } else if (com.tcbj.util.StringUtils.isNotEmpty(st.getCell(22, j).getContents().trim())) {
                    shop.setPromotionNumber(Long.valueOf(st.getCell(22, j).getContents().trim()));
                }
                message = this.validateLongIsNull(st.getCell(23, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + "\u4e13\u67dc\u4e2a\u6570\uff1a" + message;
                } else if (com.tcbj.util.StringUtils.isNotEmpty(st.getCell(23, j).getContents().trim())) {
                    shop.setShoppeNumber(Long.valueOf(st.getCell(23, j).getContents().trim()));
                }
                message = ValidataUtils.validateMapOrNull((Object)st.getCell(24, j).getContents(), selectTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u662f\u5426\u9ed8\u8ba4\u63a5\u53d7\u5e93\u5b58 \uff1a" + message;
                } else {
                    shop.setIsReceiveAllot(com.tcbj.util.StringUtils.isEmpty(st.getCell(24, j).getContents().trim()) ? "N" : (String)selectTypeMap.get(st.getCell(24, j).getContents()));
                }
                message = this.validateDate(st.getCell(25, j).getContents());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5f00\u59cb\u65f6\u95f4 \uff1a" + message;
                } else {
                    shop.setStartDate(DateUtils.formDate((String)st.getCell(25, j).getContents().trim(), (String)FORMDATE));
                }
                message = this.validateDateIsNull(st.getCell(26, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u7ed3\u675f\u65f6\u95f4 \uff1a" + message;
                } else if (com.tcbj.util.StringUtils.isNotEmpty(st.getCell(26, j).getContents().trim())) {
                    shop.setEndDate(DateUtils.formDate((String)st.getCell(26, j).getContents().trim(), (String)"yy-MM-dd"));
                }
                message = this.shopService.validateShopUnique(st.getCell(0, j).getContents().trim(), st.getCell(9, j).getContents().trim(), st.getCell(13, j).getContents().trim());
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u95e8\u5e97\u6d88\u606f \uff1a" + message;
                }
                if (result != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:" + result));
                }
                list.add(shop);
                ++j;
            }
            if (megs.size() > 0) {
                return megs;
            }
            Shop t1 = null;
            Shop t2 = null;
            String s1 = null;
            String s2 = null;
            String clientNo1 = null;
            String clientNo2 = null;
            int k = 0;
            while (k < list.size()) {
                t1 = list.get(k);
                s1 = String.valueOf(t1.getParentDealerId()) + t1.getShopName() + t1.getAddressDetails() + t1.getOuterClientNo();
                clientNo1 = t1.getOuterClientNo();
                int k2 = k + 1;
                while (k2 < list.size()) {
                    t2 = list.get(k2);
                    s2 = String.valueOf(t2.getParentDealerId()) + t2.getShopName() + t2.getAddressDetails() + t2.getOuterClientNo();
                    clientNo2 = t2.getOuterClientNo();
                    if (StringUtils.isNotEmpty((String)clientNo1) && StringUtils.isNotEmpty((String)clientNo2) && clientNo1 == clientNo2) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u5916\u56f4\u5ba2\u6237\u7aef\u7f16\u53f7\u91cd\u590d\uff1a" + clientNo1));
                    }
                    if (s1.equals(s2)) {
                        megs.add(new AdjustStockUtil("\u7b2c" + (k + 2) + "\u548c" + (k2 + 2) + "\u884c\u6570\u636e\u91cd\u590d"));
                    }
                    ++k2;
                }
                ++k;
            }
            if (megs.size() > 0) {
                return megs;
            }
            if (megs.size() > 0) {
                return megs;
            }
            rwb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return megs;
    }

    private Map<String, String> getRegionMap(Employee me) {
        List<Region> list = this.regionService.getBigAreas(me.getCurrentPartner().getOrganizationid());
        HashMap<String, String> map = new HashMap<String, String>();
        for (Region r : list) {
            map.put(r.getRegionName(), r.getId());
        }
        return map;
    }

    private Map<String, String> getAreaMap(Employee me) {
        List<Region> list = this.regionService.getAreas(me.getCurrentPartner().getId());
        HashMap<String, String> map = new HashMap<String, String>();
        for (Region r : list) {
            map.put(r.getRegionName(), r.getId());
        }
        return map;
    }

    public String validateDateIsNull(Object object) {
        String s = (String)object;
        if (com.tcbj.util.StringUtils.isEmpty(s)) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.parse(s);
        }
        catch (Exception exception) {
            return "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef";
        }
        return null;
    }

    public String validateDate(Object object) {
        String dateStr = (String)object;
        if (StringUtils.isEmpty((String)dateStr)) {
            return "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002";
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(FORMDATE);
            sdf.parse(dateStr.trim());
        }
        catch (Exception exception) {
            return "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef";
        }
        return null;
    }

    public String validateOutCilentNo(String outClientNo) {
        boolean flag = this.shopService.validateCilentNo(null, outClientNo);
        if (!flag) {
            return String.valueOf(outClientNo) + " \u5df2\u7ecf\u88ab\u5360\u7528";
        }
        return null;
    }

    private String validaShopName(Employee me, Object obj1, Object obj2) {
        String shopName = (String)obj1;
        String address = (String)obj2;
        if (StringUtils.isEmpty((String)shopName)) {
            return "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002";
        }
        boolean flag = this.shopService.validateShopViewName(me, shopName, address);
        if (!flag) {
            return String.valueOf(shopName) + " \u5df2\u7ecf\u5b58\u5728";
        }
        return null;
    }

    private Map<String, String> getItenMap(String type) {
        List<DictionaryItem> items = Cache.getItems(type);
        HashMap<String, String> map = new HashMap<String, String>();
        for (DictionaryItem dictionaryItem : items) {
            map.put(dictionaryItem.getVal(), dictionaryItem.getName());
        }
        return map;
    }

    public String validateLongIsNull(Object object) {
        String s = String.valueOf(object).trim();
        if (com.tcbj.util.StringUtils.isEmpty(s)) {
            return null;
        }
        try {
            Long.parseLong(String.valueOf(object).trim());
        }
        catch (Exception exception) {
            return "\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002";
        }
        return null;
    }

    public static String str(String str) {
        if (str == null || "".equals(str.trim()) || "NULL".equals(str.toUpperCase())) {
            str = "";
        }
        return str.trim();
    }

    public void initMap(Map<String, String> cusMap, String partnerId, String userId) {
        List<Customer> list = this.clientService.findRegionApplys(partnerId, userId);
        for (Customer customer : list) {
            cusMap.put(customer.getApplyerCode(), customer.getApplyerId());
        }
    }
}

