/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.shoppeapply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.competition.CompetitionService;
import com.tcbj.crm.entity.ShoppeApply;
import com.tcbj.crm.entity.ShoppeApplyItem;
import com.tcbj.crm.shop.ShopCondition;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.shoppeapply.ShoppeApplyCondition;
import com.tcbj.crm.shoppeapply.ShoppeApplyService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/shoppeapply"})
public class ShoppeApplyController
extends BaseController {
    @Autowired
    private ShoppeApplyService service;
    @Autowired
    ClientService clientService;
    @Autowired
    ShopService shopService;
    @Autowired
    CompetitionService competitionService;

    @RequestMapping(value={"/list.do"})
    public String shoppedList(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") ShoppeApplyCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        model.addAttribute("condition", (Object)con);
        Page shoppeApplys = this.service.findShoppeApplys(con, me, pageno);
        model.addAttribute("startDate", (Object)DateUtils.now());
        model.addAttribute("shoppeApplys", (Object)shoppeApplys);
        return "shoppeapply/list.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model) {
        ShoppeApply shoppeApply = null;
        shoppeApply = StringUtils.isEmpty(id) ? new ShoppeApply() : this.service.getShoppeById(id);
        model.addAttribute("shoppeApply", (Object)shoppeApply);
        model.addAttribute("shoppApplyItems", (Object)JSON.toJSONString(this.service.getShoppApplyItems(id)));
        return "shoppeapply/apply.ftl";
    }

    @RequestMapping(value={"/AjaxSupplier.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result ajaxSupplier(String id, HttpServletResponse response) {
        Employee me = this.getCurrentEmployee();
        Customer customer = this.clientService.getCustomerPartner(id, me.getCurrentPartner().getId());
        return this.getSuccessResult(JSON.toJSONString((Object)customer));
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    public String addShoppeApply(ShoppeApply shoppeApply, Model model, HttpServletRequest request) throws Exception {
        Employee me = this.getCurrentEmployee();
        shoppeApply.getState();
        List itmes = JSONArray.parseArray((String)shoppeApply.getGridItmes(), ShoppeApplyItem.class);
        shoppeApply.setShoppeApplyItmes(itmes);
        List<IUploadFile> fileMap = this.uploadFile(request, "shoppeApply");
        this.service.saveShoppeApply(shoppeApply, me, fileMap);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(null)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit_do(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        ShoppeApply shoppeApply = this.service.getShoppeById(id);
        model.addAttribute("me", (Object)me);
        model.addAttribute("shoppeApply", (Object)shoppeApply);
        model.addAttribute("shoppApplyItems", (Object)JSON.toJSONString(this.service.getShoppApplyItems(id)));
        return "shoppeapply/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    public String editShoppeApply(ShoppeApply shoppeApply, Model model, HttpServletRequest request) throws Exception {
        Employee me = this.getCurrentEmployee();
        shoppeApply.setState("1");
        List itmes = JSONArray.parseArray((String)shoppeApply.getGridItmes(), ShoppeApplyItem.class);
        shoppeApply.setShoppeApplyItmes(itmes);
        List<IUploadFile> fileMap = this.uploadFile(request, "shoppeApply");
        this.service.updateShoppeApply(shoppeApply, me, fileMap);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(null)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/del.do"})
    @ResponseBody
    public Result delete(String id, Model model) throws Exception {
        this.service.delShoppeApply(id);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/deletefile.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void deletefile(String id, HttpServletResponse response) {
        try {
            this.service.deleteFile(id);
            response.getWriter().write("true");
        }
        catch (Exception exception) {}
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=true) String id, Model model) {
        ShoppeApply ShoppeApply2 = this.service.getShoppeById(id);
        model.addAttribute("shoppeApply", (Object)ShoppeApply2);
        model.addAttribute("shoppApplyItems", (Object)JSON.toJSONString(ShoppeApply2.getShoppeApplyItmes()));
        return "shoppeapply/view.ftl";
    }

    @RequestMapping(value={"/intoselectshop.do"}, method={RequestMethod.GET})
    public String selectProductView(Model model) {
        return "shoppeapply/shopList.ftl";
    }

    @RequestMapping(value={"/selectshop.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page getSelectShop(ShopCondition condition, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) {
        Employee me = this.getCurrentEmployee();
        Page page = this.shopService.findShopViews(condition, me, pageno);
        return page;
    }
}

