/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.statistics;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.org.OrgService;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.statistics.InoutCondition;
import com.tcbj.crm.statistics.StatisticsService;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/statistics"})
public class StatisticsController
extends BaseController {
    @Autowired
    StockService stockService;
    @Autowired
    StorageService storageService;
    @Autowired
    ProductService productService;
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelservice;
    @Autowired
    OrgService orgService;
    @Autowired
    Cache cache;
    @Autowired
    StatisticsService statisticsService;
    @Autowired
    PartnerService partnerService;
    @Autowired
    PersonnelService service;

    @RequestMapping(value={"/queryStorage.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String queryStorage(String name, boolean md, String partnerId, String no, String type, Model model) throws Exception {
        Partner p;
        String _partnerId = partnerId;
        Employee employee = this.getCurrentEmployee();
        Contact contact = this.service.get(employee.getId());
        EmployeePartner partner = employee.getCurrentPartner();
        if (partner == null) {
            throw new AppException("9210");
        }
        if (_partnerId == null) {
            _partnerId = partner.getId();
        }
        if (!md && (p = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)_partnerId))) == null) {
            throw new AppException("9214");
        }
        List<Product> productList = this.productService.getProducts(name, _partnerId, no, type, contact);
        Map<String, Map<String, Double>> map = this.stockService.getStorageQuantityByPartner(_partnerId);
        HashMap<String, Double> allMap = new HashMap<String, Double>();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            Map<String, Double> pmap = map.get(key);
            Set<String> pkeys = pmap.keySet();
            for (String productId : pkeys) {
                Double quantity = pmap.get(productId);
                Double oldQuantity = (Double)allMap.get(productId);
                double newQuantity = 0.0;
                newQuantity = oldQuantity == null ? quantity : oldQuantity + quantity;
                allMap.put(productId, newQuantity);
            }
        }
        map.put("all", allMap);
        model.addAttribute("map", map);
        Set<String> storageSet = map.keySet();
        model.addAttribute("partnerId", (Object)_partnerId);
        model.addAttribute("type", (Object)type);
        model.addAttribute("no", (Object)no);
        model.addAttribute("name", (Object)name);
        model.addAttribute("storageList", storageSet);
        model.addAttribute("storageMap", Cache.getStorages());
        model.addAttribute("productList", productList);
        return "statistics/queryStorage2.ftl";
    }

    private void fillProduct(List<Product> productList, String no, String type) {
        Iterator<Product> pit = productList.iterator();
        while (pit.hasNext()) {
            Product product = pit.next();
            if (StringUtils.isNotEmpty(no) && product.getNo() == null) {
                pit.remove();
                continue;
            }
            if (StringUtils.isNotEmpty(no) && !no.contains(product.getNo())) {
                pit.remove();
                continue;
            }
            if (!StringUtils.isNotEmpty(type) || type.equals(product.getOrderProdType())) continue;
            pit.remove();
        }
    }

    @RequestMapping(value={"/orgTree.do"}, method={RequestMethod.GET})
    public String tree(Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        Partner pt = this.personnelservice.getById(e.getCurrentPartner().getId());
        String tree = this.orgService.getOrgTree(pt);
        String orgId = e.getCurrentPartner().getId();
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("tree", (Object)tree);
        return "statistics/orgTree.ftl";
    }

    @RequestMapping(value={"/queryLogistics.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String queryLogistics(String batch, String code, Model model, @RequestParam(value="pageno", required=false, defaultValue="0") int pageno) throws Exception {
        String partnerId = this.getCurrentEmployee().getCurrentPartner().getId();
        Partner partner = this.partnerService.getSimplePartner(partnerId);
        String clientAppNo = partner.getClientAppNo();
        if (clientAppNo != null && clientAppNo.indexOf(".") > 0) {
            clientAppNo = clientAppNo.substring(clientAppNo.indexOf(".") + 1);
        }
        Page page = this.statisticsService.queryLog(batch, code, clientAppNo, pageno);
        model.addAttribute("query", (Object)"query");
        model.addAttribute("code", (Object)code);
        model.addAttribute("batch", (Object)batch);
        model.addAttribute("page", (Object)page);
        return "statistics/queryLogistics.ftl";
    }

    @RequestMapping(value={"/queryInout.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String queryInout(InoutCondition condition, Model model) {
        Employee emp = this.getCurrentEmployee();
        if (StringUtils.isEmpty(condition.getPartnerId())) {
            condition.setPartnerId(emp.getCurrentPartner().getId());
        }
        Page page = this.statisticsService.queryInout(condition);
        model.addAttribute("query", (Object)"query");
        model.addAttribute("page", (Object)page);
        model.addAttribute("condition", (Object)condition);
        return "statistics/queryInout.ftl";
    }
}

