/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.stock;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.AdjustStockDetails;
import com.tcbj.crm.entity.IndentBusinessControl;
import com.tcbj.crm.entity.Stock;
import com.tcbj.crm.stock.UpdateStockItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.OrgStock;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StockService {
    @Autowired
    BaseDao baseDao;

    public Double getQuantityByPartner(String partnerId, String productId) {
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)partnerId));
        if (partner.isOrg()) {
            return 0.0;
        }
        List list = this.baseDao.findEntity(" from Stock where partnerId = ? and productId = ?", new Object[]{partnerId, productId}, Stock.class);
        Double result = 0.0;
        for (Stock stock : list) {
            result = result + stock.getQuantity();
        }
        return result;
    }

    public Map<String, Double> getQuantityByPartner(String partnerId) {
        if (partnerId == null) {
            return new LinkedHashMap<String, Double>();
        }
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)partnerId));
        if (partner.isOrg()) {
            return this.getQuantityByOrg(partnerId);
        }
        return this.getQuantityOnStock(partnerId);
    }

    private Map<String, Double> getQuantityOnStock(String partnerId) {
        List list = this.baseDao.findEntity(" from Stock where partnerId = ? ", new Object[]{partnerId}, Stock.class);
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        for (Stock stock : list) {
            Double quantity = map.get(stock.getProductId()) == null ? 0.0 : (Double)map.get(stock.getProductId());
            quantity = quantity + stock.getQuantity();
            map.put(stock.getProductId(), quantity);
        }
        return map;
    }

    private Map<String, Double> getQuantityByOrg(String partnerId) {
        List list = this.baseDao.findEntity(" from OrgStock where orgId = ? ", new Object[]{partnerId}, OrgStock.class);
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        for (OrgStock stock : list) {
            Double quantity = map.get(stock.getProductId()) == null ? 0.0 : (Double)map.get(stock.getProductId());
            quantity = quantity + stock.getAvailableQty();
            map.put(stock.getProductId(), quantity);
        }
        return map;
    }

    public Map<String, Map<String, Double>> getStorageQuantityByPartner(String partnerId) {
        if (partnerId == null) {
            return new LinkedHashMap<String, Map<String, Double>>();
        }
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)partnerId));
        if (partner != null && partner.isOrg()) {
            return this.getStorageQuantityByOrg(partnerId);
        }
        List list = this.baseDao.findEntity(" from Stock where partnerId = ? ", new Object[]{partnerId}, Stock.class);
        LinkedHashMap<String, Map<String, Double>> map = new LinkedHashMap<String, Map<String, Double>>();
        for (Stock stock : list) {
            LinkedHashMap<String, Double> pMap = (LinkedHashMap<String, Double>)map.get(stock.getStorageId());
            if (pMap == null) {
                pMap = new LinkedHashMap<String, Double>();
                map.put(stock.getStorageId(), pMap);
            }
            pMap.put(stock.getProductId(), stock.getQuantity());
        }
        return map;
    }

    private Map<String, Map<String, Double>> getStorageQuantityByOrg(String partnerId) {
        List list = this.baseDao.findEntity(" from OrgStock where orgId = ? ", new Object[]{partnerId}, OrgStock.class);
        LinkedHashMap<String, Map<String, Double>> map = new LinkedHashMap<String, Map<String, Double>>();
        for (OrgStock stock : list) {
            LinkedHashMap<String, Double> pMap = (LinkedHashMap<String, Double>)map.get(stock.getSubinvName());
            if (pMap == null) {
                pMap = new LinkedHashMap<String, Double>();
                map.put(stock.getSubinvName(), pMap);
            }
            pMap.put(stock.getProductId(), stock.getAvailableQty());
        }
        return map;
    }

    public Map<String, Double> getQuantityByStorage(String storageId) {
        if (storageId == null) {
            return new HashMap<String, Double>();
        }
        List list = this.baseDao.findEntity(" from Stock where storageId = ? ", new Object[]{storageId}, Stock.class);
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (Stock stock : list) {
            double quantity = map.get(stock.getProductId()) == null ? 0.0 : (Double)map.get(stock.getProductId());
            map.put(stock.getProductId(), quantity += stock.getQuantity().doubleValue());
        }
        return map;
    }

    public Stock getStockY(String partnerId, String productId, String storageId) {
        return (Stock)this.baseDao.findFirstEntity(" from Stock t where t.partnerId = ? and t.productId = ? and t.storageId = ? ", new Object[]{partnerId, productId, storageId}, Stock.class);
    }

    public void updateQuantity(Employee emp, String parnterId, String storageId, String receiptsId, String businessType, List<UpdateStockItem> list) {
        if (emp == null || storageId == null || list == null) {
            return;
        }
        for (UpdateStockItem item : list) {
            if (item.getQuantity() == null || item.getQuantity() == 0.0) continue;
            this.updateQuantity(emp.getCurrentPartner().getId(), storageId, item.getProductId(), item.getQuantity());
            this.addStockRecord(emp.getId(), emp.getCurrentPartner().getId(), receiptsId, businessType, item);
        }
    }

    private void addStockRecord(String userId, String partnerId, String receiptsId, String businessType, UpdateStockItem item) {
        IndentBusinessControl ibc = new IndentBusinessControl();
        ibc.setBusinessDate(new Date());
        ibc.setBusinessQuantity(item.getQuantity());
        ibc.setOrganizationId(item.getApplyerId());
        ibc.setBusinessType(businessType);
        ibc.setProductId(item.getProductId());
        ibc.setReceiptsId(receiptsId);
        ibc.setReceiptsRowId(item.getReceiptsRowid());
        ibc.setSupplierId(item.getSupplierId());
        ibc.setApplyerId(item.getApplyerId());
        ibc.setBusinessPerson(userId);
        ibc.setBusinessUnit(Cache.getProductUnit(item.getProductId()));
        ibc.setProductBatchId(item.getProductBatchId());
        this.baseDao.save((Object)ibc);
    }

    private void updateQuantity(String partnerId, String storageId, String productId, double quantity) {
        if (productId == null) {
            return;
        }
        List list = this.baseDao.findEntity(" from Stock where storageId = ? and productId = ? ", new Object[]{storageId, productId}, Stock.class);
        if (list != null && list.size() > 0) {
            Stock stock = (Stock)list.get(0);
            stock.setQuantity(stock.getQuantity() + quantity);
            this.baseDao.update((Object)stock);
        } else {
            Stock stock = new Stock();
            stock.setStorageId(storageId);
            stock.setProductId(productId);
            stock.setQuantity(quantity);
            stock.setPartnerId(partnerId);
            this.baseDao.save((Object)stock);
        }
    }

    public void updateQuantity(String userId, String receiptsId, String businessType, AdjustStockDetails adjustStockDetails) {
        if (StringUtils.isEmpty(adjustStockDetails.getShopId()) || StringUtils.isEmpty(adjustStockDetails.getStorageId())) {
            return;
        }
        if (adjustStockDetails.getAdjustQuantity() != null) {
            this.updateQuantity(adjustStockDetails.getShopId(), adjustStockDetails.getStorageId(), adjustStockDetails.getProductId(), adjustStockDetails.getAdjustQuantity());
            this.addStockRecord(userId, adjustStockDetails.getShopId(), receiptsId, businessType, adjustStockDetails);
        }
    }

    private void addStockRecord(String userId, String partnerId, String receiptsId, String businessType, AdjustStockDetails item) {
        if (item.getProductId() == null) {
            return;
        }
        IndentBusinessControl ibc = new IndentBusinessControl();
        ibc.setBusinessDate(new Date());
        ibc.setBusinessQuantity(item.getAdjustQuantity());
        ibc.setOrganizationId(item.getShopId());
        ibc.setBusinessType(businessType);
        ibc.setProductId(item.getProductId());
        ibc.setReceiptsId(receiptsId);
        ibc.setReceiptsRowId(item.getId());
        ibc.setSupplierId(partnerId);
        ibc.setApplyerId(item.getShopId());
        ibc.setBusinessPerson(userId);
        ibc.setBusinessUnit(Cache.getProductUnit(item.getProductId()));
        ibc.setProductBatchId(item.getProductBatch());
        this.baseDao.save((Object)ibc);
    }
}

