/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.storage;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.right.RightService;
import com.tcbj.crm.storage.StorageCondition;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.view.Employee;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/storage"})
public class StorageController
extends BaseController {
    @Autowired
    StorageService storageservice;
    @Autowired
    RightService rightService;
    @Autowired
    Cache cache;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String addGet(Model model, HttpServletRequest request) {
        Storage storage = new Storage();
        model.addAttribute("master", (Object)storage);
        return "storage/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result addPost(@Valid @RequestBody Storage storage, Model model, HttpServletRequest request) {
        boolean isAcquiesce;
        Employee e = this.getCurrentEmployee();
        storage.setStorageName(storage.getStorageName().trim());
        storage.setStorageCode(storage.getStorageCode().trim());
        boolean onlyCode = this.storageservice.findCode(e.getCurrentPartner().getId(), storage.getStorageCode(), "");
        if (onlyCode) {
            throw new AppException("1201");
        }
        if ("Y".equals(storage.getIsAcquiesce()) && (isAcquiesce = this.storageservice.findIsAcquiesce(e.getCurrentPartner().getId(), null))) {
            throw new AppException("1202");
        }
        storage.fillInitData(e);
        storage.setSupplierId(e.getCurrentPartner().getId());
        this.storageservice.save(storage);
        this.cache.initStorages();
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, StorageCondition condition, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        condition.setSupplierId(e.getCurrentPartner().getId());
        model.addAttribute("page", (Object)this.storageservice.getList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        return "storage/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String editGet(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        Storage storage = this.storageservice.get(id);
        model.addAttribute("master", (Object)storage);
        return "storage/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPost(@Valid @RequestBody Storage storage, Model model, HttpServletRequest request) {
        boolean isAcquiesce;
        Employee e = this.getCurrentEmployee();
        storage.setStorageName(storage.getStorageName().trim());
        storage.setStorageCode(storage.getStorageCode().trim());
        boolean onlyCode = this.storageservice.findCode(e.getCurrentPartner().getId(), storage.getStorageCode(), storage.getId());
        if (onlyCode) {
            throw new AppException("1201");
        }
        if ("Y".equals(storage.getIsAcquiesce()) && (isAcquiesce = this.storageservice.findIsAcquiesce(e.getCurrentPartner().getId(), storage.getId()))) {
            throw new AppException("1202");
        }
        storage.fillInitData(e);
        this.storageservice.update(storage);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String deleteGet(String id, Model model, HttpServletRequest request) {
        this.storageservice.updateDate(id);
        return this.redirect("/storage/list.do");
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        Storage storage = this.storageservice.get(id);
        model.addAttribute("master", (Object)storage);
        return "storage/look.ftl";
    }
}

