/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.storage;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.storage.StorageCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="storageService")
public class StorageService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    Cache cache;

    public Storage get(String id) {
        Storage storage = null;
        if (id != null) {
            storage = (Storage)this.baseDao.get(Storage.class, (Serializable)((Object)id));
        }
        if (storage == null) {
            storage = new Storage();
        }
        return storage;
    }

    public void save(Storage obj) {
        this.baseDao.save((Object)obj);
    }

    public Page getList(int pageno, StorageCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from Storage o where supplierId =? ");
        args.add(condition.getSupplierId());
        if (StringUtils.isNotEmpty(condition.getStorageBelongs())) {
            hql.append(" and o.storageBelongs = ? ");
            args.add(condition.getStorageBelongs());
        }
        if (StringUtils.isNotEmpty(condition.getStorageType())) {
            hql.append(" and o.storageType = ? ");
            args.add(condition.getStorageType());
        }
        if (StringUtils.isNotEmpty(condition.getStorageCode())) {
            hql.append(" and o.storageCode like ? ");
            args.add("%" + condition.getStorageCode() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getStorageName())) {
            hql.append(" and o.storageName like ? ");
            args.add("%" + condition.getStorageName() + "%");
        }
        hql.append(" order by createDt desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<Storage> getList(String partnerId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" from Storage o where supplierId =? ");
        args.add(partnerId);
        hql.append(" and nvl(invalidDate,?) >= ? ");
        Date newdate = DateUtils.now();
        args.add(DateUtils.getEndTime());
        args.add(newdate);
        return this.baseDao.findEntity(hql.toString(), args.toArray(), Storage.class);
    }

    public void update(Storage obj) {
        this.baseDao.update((Object)obj);
    }

    public void updateDate(String id) {
        Storage s = (Storage)this.baseDao.get(Storage.class, (Serializable)((Object)id));
        s.setInvalidDate(DateUtils.now());
        this.baseDao.update((Object)s);
    }

    public boolean findCode(String supplierId, String storageCode, String id) {
        Storage storage;
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from Storage o where supplierId =? and storageCode =? ");
        args.add(supplierId);
        args.add(storageCode);
        if (StringUtils.isNotNull(id)) {
            hql.append(" and id != ? ");
            args.add(id);
        }
        return StringUtils.isNotNull(storage = (Storage)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), Storage.class));
    }

    public Storage getStorage(String partnerId) {
        StringBuffer hql = new StringBuffer(" from Storage o where supplierId =? and isAcquiesce = 'Y' ");
        return (Storage)this.baseDao.findFirstEntity(hql.toString(), new Object[]{partnerId}, Storage.class);
    }

    public boolean findIsAcquiesce(String supplierId, String id) {
        Storage storage;
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from Storage o where supplierId =? and isAcquiesce = 'Y' ");
        args.add(supplierId);
        if (StringUtils.isNotNull(id)) {
            hql.append(" and id != ? ");
            args.add(id);
        }
        return StringUtils.isNotNull(storage = (Storage)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), Storage.class));
    }

    public Storage getCodeBySupplier(String code) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from Storage o where storageCode = ? ");
        args.add(code);
        return (Storage)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), Storage.class);
    }

    public boolean isCodeBySupplier(String code) {
        return !StringUtils.isNotNull(this.getCodeBySupplier(code));
    }

    public void addStorage(String partnerId, Employee me) {
        Storage storage = new Storage();
        storage.fillInitData(me);
        storage.setStorageName("\u9ed8\u8ba4\u4ed3");
        storage.setAddress("\u9ed8\u8ba4\u4ed3");
        storage.setStorageBelongs("OWNER");
        storage.setStorageType("PRODUCT");
        storage.setIsAcquiesce("Y");
        storage.setStorageCode("1001");
        storage.setSupplierId(partnerId);
        this.baseDao.save((Object)storage);
        this.cache.initStorages();
    }
}

