/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.target;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PactMbo;
import com.tcbj.crm.entity.Target;
import com.tcbj.crm.entity.TargetData;
import com.tcbj.crm.entity.TargetSplit;
import com.tcbj.crm.pactMain.PactMainService;
import com.tcbj.crm.target.TargetCondition;
import com.tcbj.crm.target.TargetPartnerWrap;
import com.tcbj.crm.target.TargetWrap;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TargetService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    private PactMainService pactMainService;
    @Autowired
    private PersonnelService personnelService;

    public TargetWrap queryByEmployee(TargetCondition condition, Employee emp) {
        List<Target> targetList = this.queryTargetByEmployee(condition, emp);
        List<TargetData> targetDataList = this.queryTargetDataByEmployee(condition, emp);
        TargetWrap tw = new TargetWrap();
        tw.addTargetList(targetList);
        tw.addTargetDataList(targetDataList);
        return tw;
    }

    public List<TargetWrap> queryByCustomer(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        TargetWrap tw;
        String customerId;
        HashMap<String, TargetWrap> map = new HashMap<String, TargetWrap>();
        List<Target> targetList = this.queryTargetByCustomer(condition, emp, pageNo, rowsize);
        List<TargetData> targetDataList = this.queryTargetDataByCustomer(condition, emp, pageNo, rowsize);
        condition.setYear(String.valueOf(Integer.valueOf(condition.getYear()) - 1));
        List<Target> targetList2 = this.queryTargetByCustomer(condition, emp, pageNo, rowsize);
        List<TargetData> targetDataList2 = this.queryTargetDataByCustomer(condition, emp, pageNo, rowsize);
        for (Target target : targetList) {
            customerId = this.getCustomerId(target);
            tw = (TargetWrap)map.get(customerId);
            if (tw == null) {
                tw = new TargetWrap();
                map.put(customerId, tw);
            }
            tw.addTarget(target);
        }
        for (TargetData targetData : targetDataList) {
            customerId = String.valueOf(targetData.getUnionId()) + targetData.getApplyerId();
            tw = (TargetWrap)map.get(customerId);
            if (tw == null) continue;
            tw.addTargetData(targetData);
        }
        for (Target target : targetList2) {
            customerId = this.getCustomerId(target);
            tw = (TargetWrap)map.get(customerId);
            if (tw == null) continue;
            tw.addTarget2(target);
        }
        for (TargetData targetData : targetDataList2) {
            customerId = String.valueOf(targetData.getUnionId()) + targetData.getApplyerId();
            tw = (TargetWrap)map.get(customerId);
            if (tw == null) continue;
            tw.addTargetData2(targetData);
        }
        ArrayList<TargetWrap> list = new ArrayList<TargetWrap>();
        list.addAll(map.values());
        return list;
    }

    public List<TargetPartnerWrap> queryByPartner(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        TargetPartnerWrap tw;
        String customerId;
        List<PactMbo> pactMboList = this.pactMainService.getPactMbos(condition, emp, pageNo, rowsize);
        condition.setPartner(true);
        List<TargetData> targetDataList = this.queryTargetDataByCustomer(condition, emp, pageNo, rowsize);
        HashMap<String, TargetPartnerWrap> map = new HashMap<String, TargetPartnerWrap>();
        for (PactMbo pactMbo : pactMboList) {
            customerId = pactMbo.getYear() + pactMbo.getTargetType();
            tw = (TargetPartnerWrap)map.get(customerId);
            if (tw == null) {
                tw = new TargetPartnerWrap();
                map.put(customerId, tw);
            }
            tw.addTarget(pactMbo);
        }
        for (TargetData targetData : targetDataList) {
            customerId = targetData.getYear() + targetData.getType();
            tw = (TargetPartnerWrap)map.get(customerId);
            if (tw == null) continue;
            tw.addTargetData(targetData);
        }
        ArrayList<TargetPartnerWrap> list = new ArrayList<TargetPartnerWrap>();
        list.addAll(map.values());
        return list;
    }

    public List<TargetWrap> queryByBigarea(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        TargetWrap tw;
        String bigareaId;
        List<Target> targetList = this.queryTargetByCustomer(condition, emp, pageNo, rowsize);
        List<TargetData> targetDataList = this.queryTargetDataByCustomer(condition, emp, pageNo, rowsize);
        HashMap<String, TargetWrap> map = new HashMap<String, TargetWrap>();
        for (Target target : targetList) {
            bigareaId = this.getBigareaId(target);
            tw = (TargetWrap)map.get(bigareaId);
            if (tw == null) {
                tw = new TargetWrap();
                map.put(bigareaId, tw);
            }
            tw.addTarget(target);
        }
        for (TargetData targetData : targetDataList) {
            bigareaId = String.valueOf(targetData.getUnionId()) + targetData.getBigareaId();
            tw = (TargetWrap)map.get(bigareaId);
            if (tw == null) continue;
            tw.addTargetData(targetData);
        }
        ArrayList<TargetWrap> list = new ArrayList<TargetWrap>();
        list.addAll(map.values());
        return list;
    }

    public List<TargetWrap> queryBySalesman(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        TargetWrap tw;
        String bigareaId;
        List<Target> targetList = this.queryTargetBySalesman(condition, emp, pageNo, rowsize);
        List<TargetData> targetDataList = this.queryTargetDataBySalesman(condition, emp, pageNo, rowsize);
        HashMap<String, TargetWrap> map = new HashMap<String, TargetWrap>();
        for (Target target : targetList) {
            bigareaId = String.valueOf(target.getUnionId()) + target.getObjectId();
            tw = (TargetWrap)map.get(bigareaId);
            if (tw == null) {
                tw = new TargetWrap();
                map.put(bigareaId, tw);
            }
            tw.addTarget(target);
        }
        for (TargetData targetData : targetDataList) {
            bigareaId = String.valueOf(targetData.getUnionId()) + targetData.getUserId();
            tw = (TargetWrap)map.get(bigareaId);
            if (tw == null) continue;
            tw.addTargetData(targetData);
        }
        ArrayList<TargetWrap> list = new ArrayList<TargetWrap>();
        list.addAll(map.values());
        return list;
    }

    public List<TargetWrap> queryByTarget(TargetCondition condition, Employee emp, String type, int pageNo, int rowsize) {
        TargetWrap tw;
        String customerId;
        HashMap<String, TargetWrap> map = new HashMap<String, TargetWrap>();
        List<Target> targetList = this.queryAllTargetByCustomer(condition, emp, pageNo, rowsize);
        List<TargetData> targetDataList = this.queryAllTargetDataByCustomer(condition, emp, pageNo, rowsize);
        for (Target target : targetList) {
            customerId = "";
            if ("0".equals(type)) {
                customerId = this.getCus(target);
            } else if ("1".equals(type)) {
                customerId = this.getCustomerId(target);
            } else if ("2".equals(type)) {
                customerId = this.getAreaId(target);
            } else if ("3".equals(type)) {
                customerId = this.getBigareaId(target);
            } else if ("4".equals(type)) {
                customerId = this.getChannelId(target);
            } else if ("5".equals(type)) {
                customerId = target.getUnionId();
            }
            tw = (TargetWrap)map.get(customerId);
            if (tw == null) {
                tw = new TargetWrap();
                map.put(customerId, tw);
            }
            tw.addTarget(target);
        }
        for (TargetData targetData : targetDataList) {
            customerId = "";
            if ("0".equals(type)) {
                customerId = String.valueOf(targetData.getUnionId()) + targetData.getProductSubType() + "-" + targetData.getProductType();
            } else if ("1".equals(type)) {
                customerId = String.valueOf(targetData.getUnionId()) + targetData.getApplyerId();
            } else if ("2".equals(type)) {
                customerId = String.valueOf(targetData.getUnionId()) + targetData.getAreaId();
            } else if ("3".equals(type)) {
                customerId = String.valueOf(targetData.getUnionId()) + targetData.getBigareaId();
            } else if ("4".equals(type)) {
                customerId = String.valueOf(targetData.getUnionId()) + targetData.getChannelId();
            } else if ("5".equals(type)) {
                customerId = targetData.getUnionId();
            }
            tw = (TargetWrap)map.get(customerId);
            if (tw == null) continue;
            tw.addTargetData(targetData);
        }
        ArrayList<TargetWrap> list = new ArrayList<TargetWrap>();
        list.addAll(map.values());
        return list;
    }

    public String getChannelTypeId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getCustomer().getPartnerChnlType();
        }
        List customers = this.baseDao.findEntity(" from Customer c where c.cityManagerId = ? and c.supplierId = ? and startdate > ? and (enddate < ? or enddate is null )", new Object[]{target.getObjectId(), target.getPartnerId()}, Customer.class);
        if (customers.size() > 0) {
            Customer customer = (Customer)customers.get(0);
            return String.valueOf(target.getUnionId()) + customer.getPartnerChnlType();
        }
        return null;
    }

    public String getBigAreaId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getCustomer().getBigAreaCode();
        }
        List customers = this.baseDao.findEntity(" from Customer c where c.cityManagerId = ? and c.supplierId = ? and startdate > ? and (enddate < ? or enddate is null )", new Object[]{target.getObjectId(), target.getPartnerId()}, Customer.class);
        if (customers.size() > 0) {
            Customer customer = (Customer)customers.get(0);
            return String.valueOf(target.getUnionId()) + customer.getBigAreaCode();
        }
        return null;
    }

    public String getAreaId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getCustomer().getAreaCode();
        }
        List customers = this.baseDao.findEntity(" from Customer c where c.cityManagerId = ? and c.supplierId = ? and startdate > ? and (enddate < ? or enddate is null )", new Object[]{target.getObjectId(), target.getPartnerId()}, Customer.class);
        if (customers.size() > 0) {
            Customer customer = (Customer)customers.get(0);
            return String.valueOf(target.getUnionId()) + customer.getAreaCode();
        }
        return null;
    }

    public String getPersonId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getCustomer().getCityManagerId();
        }
        return String.valueOf(target.getUnionId()) + target.getObjectId();
    }

    public String getCus(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getProductSubType() + "-" + target.getProductType();
        }
        return null;
    }

    public String getCustomerId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getObjectId();
        }
        return null;
    }

    public String getBigareaId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getBigareaId();
        }
        return null;
    }

    public String getChannelId(Target target) {
        if ("\u5ba2\u6237".equals(target.getObjectType())) {
            return String.valueOf(target.getUnionId()) + target.getChannelId();
        }
        return null;
    }

    public List<Target> queryTargetByEmployee(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t where t.partnerId = ? t.objectId = ? and t.objectType = '\u4eba\u5458'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        args.add(emp.getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Target.class);
        return list;
    }

    public List<Target> queryTargetByCustomer(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t,Customer c where t.partnerId = ? and c.supplierId = t.partnerId and c.applyerId = t.objectId and t.objectType = '\u5ba2\u6237'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        String regions = this.personnelService.getFRegionsByUserId(emp.getId());
        hql.append(" and ( t.areaId in  (");
        hql.append(regions);
        hql.append(" )");
        hql.append("or t.bigareaId in(");
        hql.append(regions);
        hql.append(") )");
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and c.partnerChnlType = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            hql.append(" and c.applyerName like ? ");
            args.add("%" + condition.getCustomerName() + "%");
        }
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rowsize, pageNo);
        return page.getList();
    }

    public List<TargetData> queryTargetDataByEmployee(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from TargetData t where t.supplierId = ? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), TargetData.class);
        return list;
    }

    public List<TargetData> queryTargetDataByCustomer(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from TargetData t,Partner p,Customer c where t.userId is null and p.id = t.supplierId and c.supplierId = t.supplierId and c.applyerId = t.applyerId ");
        ArrayList<Object> args = new ArrayList<Object>();
        String regions = this.personnelService.getFRegionsByUserId(emp.getId());
        hql.append(" and ( t.areaId in  (");
        hql.append(regions);
        hql.append(" )");
        hql.append("or t.bigareaId in(");
        hql.append(regions);
        hql.append(") )");
        if (condition.isPartner()) {
            hql.append(" and t.applyerId = ? ");
        } else {
            hql.append(" and t.supplierId = ? ");
        }
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.userId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and c.partnerChnlType = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            hql.append(" and c.applyerName like ? ");
            args.add("%" + condition.getCustomerName() + "%");
        }
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rowsize, pageNo);
        return page.getList();
    }

    private List<Target> queryTargetBySalesman(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t where t.partnerId = ? and t.objectType = '\u4eba\u5458'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        hql.append(" order by t.objectId ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rowsize, pageNo);
        return page.getList();
    }

    private List<TargetData> queryTargetDataBySalesman(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from TargetData t where t.userId <> null and t.supplierId = ? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.userId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        hql.append(" order by t.type ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rowsize, pageNo);
        return page.getList();
    }

    public Page getTargetPageByCustomer(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t,Partner p,Customer c where p.id = c.applyerId and t.partnerId = ? and c.supplierId = t.partnerId and c.applyerId = t.objectId and t.objectType = '\u5ba2\u6237'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.parseLong(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and p.saleChannelTypeCode = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            hql.append(" and c.applyerName like ? ");
            args.add("%" + condition.getCustomerName() + "%");
        }
        hql.append(" order by t.objectId ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize() == null ? Constant.DEFAULT_ROWS : condition.getRowsize(), condition.getPageno().intValue());
        return page;
    }

    public List<Target> getTargetListByCustomer(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t,Partner p,Customer c where p.id = c.applyerId and t.partnerId = ? and c.supplierId = t.partnerId and c.applyerId = t.objectId and t.objectType = '\u5ba2\u6237'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.parseLong(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and p.saleChannelTypeCode = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            hql.append(" and c.applyerName like ? ");
            args.add("%" + condition.getCustomerName() + "%");
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Target.class);
        return list;
    }

    public Page getTargetPageByPerson(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select distinct t from Target t,PartnerContact e where t.objectId = e.id and t.partnerId = ? and t.objectType = '\u4eba\u5458'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.parseLong(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and t.channelId = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and t.bigareaId = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and t.areaId = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getPersonName())) {
            hql.append(" and e.name like ? ");
            args.add("%" + condition.getPersonName() + "%");
        }
        hql.append(" order by t.objectId ");
        Page page = this.baseDao.searchForPager2(hql.toString(), args.toArray(), condition.getRowsize() == null ? Constant.DEFAULT_ROWS : condition.getRowsize(), condition.getPageno().intValue());
        return page;
    }

    public List<Target> getTargetListByPerson(TargetCondition condition, Employee emp) {
        StringBuffer hql = new StringBuffer();
        hql.append("select distinct t from Target t,PartnerContact e where t.objectId = e.id and t.partnerId = ? and t.objectType = '\u4eba\u5458'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.parseLong(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and t.channelId = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and t.bigareaId = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and t.areaId = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getPersonName())) {
            hql.append(" and e.name like ? ");
            args.add("%" + condition.getPersonName() + "%");
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Target.class);
        return list;
    }

    public void update(List<Target> targetList, String delIds, Employee me) {
        String[] ids;
        Target oldTarget = null;
        String[] stringArray = ids = delIds.split(",");
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtils.isEmpty(id)) {
                Object[] args = new Object[]{id};
                oldTarget = (Target)this.baseDao.get(Target.class, (Serializable)((Object)id));
                this.deletePersonTarget(oldTarget);
                this.baseDao.executeHQL("delete Target where id= ?", args);
            }
            ++n2;
        }
        for (Target target : targetList) {
            target.fillInitData(me);
            target.setPartnerId(me.getCurrentPartner().getId());
            if (target.getBigareaId() != null) {
                target.setChannelId(Cache.getRegions(target.getBigareaId()).getParentId());
            }
            if (StringUtils.isEmpty(target.getId())) {
                try {
                    this.baseDao.save((Object)target);
                    this.addPersonTarget(target);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                oldTarget = (Target)this.baseDao.get(Target.class, (Serializable)((Object)target.getId()));
                this.updatePersonTarget(oldTarget, target);
                ArrayList<Object> args = new ArrayList<Object>();
                String sql = " update CX_TARGET set PARTNER_ID = ? ,year = ?,type = ?,CHANNEL_ID = ?,BIGAREA_ID = ?,AREA_ID = ?,OBJECT_ID = ?,PRODUCT_TYPE = ?,PRODUCT_SUB_TYPE = ?,";
                args.add(target.getPartnerId());
                args.add(target.getYear());
                args.add(target.getType());
                args.add(target.getChannelId());
                args.add(target.getBigareaId());
                args.add(target.getAreaId());
                args.add(target.getObjectId());
                args.add(target.getProductType());
                args.add(target.getProductSubType());
                sql = String.valueOf(sql) + "M1 = ?,";
                args.add(TargetService.vaildataNull(target.getM1()));
                sql = String.valueOf(sql) + "M2 = ?,";
                args.add(TargetService.vaildataNull(target.getM2()));
                sql = String.valueOf(sql) + "M3 = ?,";
                args.add(TargetService.vaildataNull(target.getM3()));
                sql = String.valueOf(sql) + "M4 = ?,";
                args.add(TargetService.vaildataNull(target.getM4()));
                sql = String.valueOf(sql) + "M5 = ?,";
                args.add(TargetService.vaildataNull(target.getM5()));
                sql = String.valueOf(sql) + "M6 = ?,";
                args.add(TargetService.vaildataNull(target.getM6()));
                sql = String.valueOf(sql) + "M7 = ?,";
                args.add(TargetService.vaildataNull(target.getM7()));
                sql = String.valueOf(sql) + "M8 = ?,";
                args.add(TargetService.vaildataNull(target.getM8()));
                sql = String.valueOf(sql) + "M9 = ?,";
                args.add(TargetService.vaildataNull(target.getM9()));
                sql = String.valueOf(sql) + "M10 = ?,";
                args.add(TargetService.vaildataNull(target.getM10()));
                sql = String.valueOf(sql) + "M11 = ?,";
                args.add(TargetService.vaildataNull(target.getM11()));
                sql = String.valueOf(sql) + "M12 = ?,";
                args.add(TargetService.vaildataNull(target.getM12()));
                sql = String.valueOf(sql) + " OBJECT_TYPE = ? where ROW_ID = ? ";
                args.add(target.getObjectType());
                args.add(target.getId());
                this.baseDao.executeSQL(sql, args.toArray());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void deletePersonTarget(Target oldTarget) {
        if ("\u4eba\u5458".equals(oldTarget.getObjectType())) {
            return;
        }
        List list = this.baseDao.findEntity("from TargetSplit t where t.orgId = ? and t.partnerId = ? and year = ? and type = ? ", new Object[]{oldTarget.getPartnerId(), oldTarget.getObjectId(), String.valueOf(oldTarget.getYear()), oldTarget.getType()}, TargetSplit.class);
        for (TargetSplit ts : list) {
            ArrayList<Object> args = new ArrayList<Object>();
            String hql = "from Target t where t.objectType = '\u4eba\u5458' and t.partnerId = ? and t.year = ? and t.type = ? and t.objectId = ? ";
            args.add(oldTarget.getPartnerId());
            args.add(oldTarget.getYear());
            args.add(oldTarget.getType());
            args.add(ts.getUserId());
            if (StringUtils.isNotEmpty(oldTarget.getProductType())) {
                hql = String.valueOf(hql) + " and t.productType = ? ";
                args.add(oldTarget.getProductType());
            } else {
                hql = String.valueOf(hql) + " and t.productType is null ";
            }
            if (StringUtils.isNotEmpty(oldTarget.getProductSubType())) {
                hql = String.valueOf(hql) + " and t.productSubType = ? ";
                args.add(oldTarget.getProductSubType());
            } else {
                hql = String.valueOf(hql) + " and t.productSubType is null ";
            }
            Target personTarget = (Target)this.baseDao.findFirstEntity(hql, args.toArray(), Target.class);
            if (personTarget == null) continue;
            personTarget.setM1(personTarget.getM1() - ts.getM1() * oldTarget.getM1() / 100.0);
            personTarget.setM2(personTarget.getM2() - ts.getM2() * oldTarget.getM2() / 100.0);
            personTarget.setM3(personTarget.getM3() - ts.getM3() * oldTarget.getM3() / 100.0);
            personTarget.setM4(personTarget.getM4() - ts.getM4() * oldTarget.getM4() / 100.0);
            personTarget.setM5(personTarget.getM5() - ts.getM5() * oldTarget.getM5() / 100.0);
            personTarget.setM6(personTarget.getM6() - ts.getM6() * oldTarget.getM6() / 100.0);
            personTarget.setM7(personTarget.getM7() - ts.getM7() * oldTarget.getM7() / 100.0);
            personTarget.setM8(personTarget.getM8() - ts.getM8() * oldTarget.getM8() / 100.0);
            personTarget.setM9(personTarget.getM9() - ts.getM9() * oldTarget.getM9() / 100.0);
            personTarget.setM10(personTarget.getM10() - ts.getM10() * oldTarget.getM10() / 100.0);
            personTarget.setM11(personTarget.getM11() - ts.getM11() * oldTarget.getM11() / 100.0);
            personTarget.setM12(personTarget.getM12() - ts.getM12() * oldTarget.getM12() / 100.0);
            this.baseDao.update((Object)personTarget);
        }
    }

    public void updatePersonTarget(Target oldTarget, Target target) {
        if ("\u4eba\u5458".equals(oldTarget.getObjectType())) {
            return;
        }
        List list = this.baseDao.findEntity("from TargetSplit t where t.orgId = ? and t.partnerId = ? and year = ? and type = ? ", new Object[]{target.getPartnerId(), target.getObjectId(), String.valueOf(target.getYear()), target.getType()}, TargetSplit.class);
        for (TargetSplit ts : list) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(oldTarget.getPartnerId());
            args.add(oldTarget.getYear());
            args.add(oldTarget.getType());
            args.add(ts.getUserId());
            String hql = "from Target t where t.objectType = '\u4eba\u5458' and t.partnerId = ? and t.year = ? and t.type = ? and t.objectId = ? ";
            if (StringUtils.isNotEmpty(oldTarget.getProductType())) {
                hql = String.valueOf(hql) + " and t.productType = ? ";
                args.add(oldTarget.getProductType());
            } else {
                hql = String.valueOf(hql) + " and t.productType is null ";
            }
            if (StringUtils.isNotEmpty(oldTarget.getProductSubType())) {
                hql = String.valueOf(hql) + " and t.productSubType = ? ";
                args.add(oldTarget.getProductSubType());
            } else {
                hql = String.valueOf(hql) + " and t.productSubType is null ";
            }
            Target personTarget = (Target)this.baseDao.findFirstEntity(hql, args.toArray(), Target.class);
            if (personTarget != null) {
                personTarget.setM1(personTarget.getM1() + ts.getM1() * TargetService.vaildataNull(target.getM1()) / 100.0 - ts.getM1() * oldTarget.getM1() / 100.0);
                personTarget.setM2(personTarget.getM2() + ts.getM2() * TargetService.vaildataNull(target.getM2()) / 100.0 - ts.getM2() * oldTarget.getM2() / 100.0);
                personTarget.setM3(personTarget.getM3() + ts.getM3() * TargetService.vaildataNull(target.getM3()) / 100.0 - ts.getM3() * oldTarget.getM3() / 100.0);
                personTarget.setM4(personTarget.getM4() + ts.getM4() * TargetService.vaildataNull(target.getM4()) / 100.0 - ts.getM4() * oldTarget.getM4() / 100.0);
                personTarget.setM5(personTarget.getM5() + ts.getM5() * TargetService.vaildataNull(target.getM5()) / 100.0 - ts.getM5() * oldTarget.getM5() / 100.0);
                personTarget.setM6(personTarget.getM6() + ts.getM6() * TargetService.vaildataNull(target.getM6()) / 100.0 - ts.getM6() * oldTarget.getM6() / 100.0);
                personTarget.setM7(personTarget.getM7() + ts.getM7() * TargetService.vaildataNull(target.getM7()) / 100.0 - ts.getM7() * oldTarget.getM7() / 100.0);
                personTarget.setM8(personTarget.getM8() + ts.getM8() * TargetService.vaildataNull(target.getM8()) / 100.0 - ts.getM8() * oldTarget.getM8() / 100.0);
                personTarget.setM9(personTarget.getM9() + ts.getM9() * TargetService.vaildataNull(target.getM9()) / 100.0 - ts.getM9() * oldTarget.getM9() / 100.0);
                personTarget.setM10(personTarget.getM10() + ts.getM10() * TargetService.vaildataNull(target.getM10()) / 100.0 - ts.getM10() * oldTarget.getM10() / 100.0);
                personTarget.setM11(personTarget.getM11() + ts.getM11() * TargetService.vaildataNull(target.getM11()) / 100.0 - ts.getM11() * oldTarget.getM11() / 100.0);
                personTarget.setM12(personTarget.getM12() + ts.getM12() * TargetService.vaildataNull(target.getM12()) / 100.0 - ts.getM12() * oldTarget.getM12() / 100.0);
                this.baseDao.update((Object)personTarget);
                continue;
            }
            if (target == null) continue;
            this.addPersonTarget(target);
        }
    }

    public void addPersonTarget(Target newTarget) {
        if ("\u4eba\u5458".equals(newTarget.getObjectType())) {
            return;
        }
        List list = this.baseDao.findEntity("from TargetSplit t where t.orgId = ? and t.partnerId = ? and year = ? and type = ? ", new Object[]{newTarget.getPartnerId(), newTarget.getObjectId(), String.valueOf(newTarget.getYear()), newTarget.getType()}, TargetSplit.class);
        for (TargetSplit ts : list) {
            ArrayList<Object> updateArgs;
            ArrayList<Object> args2 = new ArrayList<Object>();
            ArrayList<Object> args = new ArrayList<Object>();
            args2.add(newTarget.getPartnerId());
            args2.add(newTarget.getYear());
            args2.add(newTarget.getType());
            args2.add(ts.getUserId());
            args.add(newTarget.getPartnerId());
            args.add(newTarget.getYear());
            args.add(newTarget.getType());
            args.add(ts.getUserId());
            String hql = "from Target t where t.objectType = '\u4eba\u5458' and t.partnerId = ? and t.year = ? and t.type = ? and t.objectId = ? ";
            if (StringUtils.isNotEmpty(newTarget.getProductType())) {
                hql = String.valueOf(hql) + " and t.productType = ? ";
                args2.add(newTarget.getProductType());
            } else {
                hql = String.valueOf(hql) + " and t.productType is null ";
            }
            if (StringUtils.isNotEmpty(newTarget.getProductSubType())) {
                hql = String.valueOf(hql) + " and t.productSubType = ? ";
                args2.add(newTarget.getProductSubType());
            } else {
                hql = String.valueOf(hql) + " and t.productSubType is null ";
            }
            Target _target = (Target)this.baseDao.findFirstEntity(hql, args2.toArray(), Target.class);
            if (_target != null) {
                updateArgs = new ArrayList<Object>();
                updateArgs.add(_target.getM1() + ts.getM1() * TargetService.vaildataNull(newTarget.getM1()) / 100.0);
                updateArgs.add(_target.getM2() + ts.getM2() * TargetService.vaildataNull(newTarget.getM2()) / 100.0);
                updateArgs.add(_target.getM3() + ts.getM3() * TargetService.vaildataNull(newTarget.getM3()) / 100.0);
                updateArgs.add(_target.getM4() + ts.getM4() * TargetService.vaildataNull(newTarget.getM4()) / 100.0);
                updateArgs.add(_target.getM5() + ts.getM5() * TargetService.vaildataNull(newTarget.getM5()) / 100.0);
                updateArgs.add(_target.getM6() + ts.getM6() * TargetService.vaildataNull(newTarget.getM6()) / 100.0);
                updateArgs.add(_target.getM7() + ts.getM7() * TargetService.vaildataNull(newTarget.getM7()) / 100.0);
                updateArgs.add(_target.getM8() + ts.getM8() * TargetService.vaildataNull(newTarget.getM8()) / 100.0);
                updateArgs.add(_target.getM9() + ts.getM9() * TargetService.vaildataNull(newTarget.getM9()) / 100.0);
                updateArgs.add(_target.getM10() + ts.getM10() * TargetService.vaildataNull(newTarget.getM10()) / 100.0);
                updateArgs.add(_target.getM11() + ts.getM11() * TargetService.vaildataNull(newTarget.getM11()) / 100.0);
                updateArgs.add(_target.getM12() + ts.getM12() * TargetService.vaildataNull(newTarget.getM12()) / 100.0);
                updateArgs.addAll(args);
                this.baseDao.executeSQL(" update CX_TARGET set m1 = ? ,m2 = ? ,m3 = ? ,m4 = ? ,m5 = ? ,m6 = ? ,m7 = ? ,m8 = ? ,m9 = ? ,m10 = ?,m11 = ? ,m12 = ?  where OBJECT_TYPE = '\u4eba\u5458' and PARTNER_ID = ? and YEAR = ? and TYPE = ? and OBJECT_ID = ? ", updateArgs.toArray());
                continue;
            }
            updateArgs = new ArrayList();
            updateArgs.add(ts.getM1() * TargetService.vaildataNull(newTarget.getM1()) / 100.0);
            updateArgs.add(ts.getM2() * TargetService.vaildataNull(newTarget.getM2()) / 100.0);
            updateArgs.add(ts.getM3() * TargetService.vaildataNull(newTarget.getM3()) / 100.0);
            updateArgs.add(ts.getM4() * TargetService.vaildataNull(newTarget.getM4()) / 100.0);
            updateArgs.add(ts.getM5() * TargetService.vaildataNull(newTarget.getM5()) / 100.0);
            updateArgs.add(ts.getM6() * TargetService.vaildataNull(newTarget.getM6()) / 100.0);
            updateArgs.add(ts.getM7() * TargetService.vaildataNull(newTarget.getM7()) / 100.0);
            updateArgs.add(ts.getM8() * TargetService.vaildataNull(newTarget.getM8()) / 100.0);
            updateArgs.add(ts.getM9() * TargetService.vaildataNull(newTarget.getM9()) / 100.0);
            updateArgs.add(ts.getM10() * TargetService.vaildataNull(newTarget.getM10()) / 100.0);
            updateArgs.add(ts.getM11() * TargetService.vaildataNull(newTarget.getM11()) / 100.0);
            updateArgs.add(ts.getM12() * TargetService.vaildataNull(newTarget.getM12()) / 100.0);
            updateArgs.add("\u4eba\u5458");
            updateArgs.add(UUIDUtils.getId());
            updateArgs.add("0-2");
            updateArgs.add(new Date());
            updateArgs.add("0-2");
            updateArgs.add(new Date());
            args.addAll(updateArgs);
            args.add(newTarget.getChannelId() == null ? " " : newTarget.getChannelId());
            args.add(newTarget.getBigareaId() == null ? " " : newTarget.getBigareaId());
            args.add(newTarget.getAreaId() == null ? " " : newTarget.getAreaId());
            System.out.println(args.toArray());
            this.baseDao.executeSQL(" insert into CX_TARGET (PARTNER_ID,year,type,OBJECT_ID,M1,M2,M3,M4,M5,M6,M7,M8,M9,M10,M11,M12,OBJECT_TYPE,ROW_ID,CREATED_BY,CREATED,LAST_UPD_BY,LAST_UPD,CHANNEL_ID,BIGAREA_ID,AREA_ID) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ", args.toArray());
        }
    }

    public void updatePersonTarget(List<Target> targetList, String delIds, Employee me) {
        String[] ids;
        String[] stringArray = ids = delIds.split(",");
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtils.isEmpty(id)) {
                Object[] args = new Object[]{id};
                this.baseDao.executeHQL("delete Target where id= ?", args);
            }
            ++n2;
        }
        for (Target target : targetList) {
            target.fillInitData(me);
            target.setPartnerId(me.getCurrentPartner().getId());
            if (target.getBigareaId() != null) {
                target.setChannelId(Cache.getRegions(target.getBigareaId()).getParentId());
            }
            this.validataTarget(target);
            if (StringUtils.isNotEmpty(target.getId())) {
                this.baseDao.update((Object)target);
                continue;
            }
            this.baseDao.save((Object)target);
        }
    }

    private void validataTarget(Target target) {
        target.setM1(TargetService.vaildataNull(target.getM1()));
        target.setM2(TargetService.vaildataNull(target.getM2()));
        target.setM3(TargetService.vaildataNull(target.getM3()));
        target.setM4(TargetService.vaildataNull(target.getM4()));
        target.setM5(TargetService.vaildataNull(target.getM5()));
        target.setM6(TargetService.vaildataNull(target.getM6()));
        target.setM7(TargetService.vaildataNull(target.getM7()));
        target.setM8(TargetService.vaildataNull(target.getM8()));
        target.setM9(TargetService.vaildataNull(target.getM9()));
        target.setM10(TargetService.vaildataNull(target.getM10()));
        target.setM11(TargetService.vaildataNull(target.getM11()));
        target.setM12(TargetService.vaildataNull(target.getM12()));
    }

    public static boolean excels(List<Target> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u76ee\u6807\u7c7b\u578b", "\u5ba2\u6237\u52a9\u8bb0\u7801", "\u5ba2\u6237", "\u4ea7\u54c1\u7c7b\u578b", "\u4ea7\u54c1\u5b50\u7c7b\u578b", "\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            Target stu = list.get(i);
            row.createCell(0).setCellValue(stu.getTypeName());
            row.createCell(1).setCellValue(stu.getApplyerCode());
            row.createCell(2).setCellValue(stu.getApplyerName());
            row.createCell(3).setCellValue(stu.getProductTypeName());
            row.createCell(4).setCellValue(stu.getProductSubTypeName());
            row.createCell(5).setCellValue(TargetService.vaildataNull(stu.getM1()).doubleValue());
            row.createCell(6).setCellValue(TargetService.vaildataNull(stu.getM2()).doubleValue());
            row.createCell(7).setCellValue(TargetService.vaildataNull(stu.getM3()).doubleValue());
            row.createCell(8).setCellValue(TargetService.vaildataNull(stu.getM4()).doubleValue());
            row.createCell(9).setCellValue(TargetService.vaildataNull(stu.getM5()).doubleValue());
            row.createCell(10).setCellValue(TargetService.vaildataNull(stu.getM6()).doubleValue());
            row.createCell(11).setCellValue(TargetService.vaildataNull(stu.getM7()).doubleValue());
            row.createCell(12).setCellValue(TargetService.vaildataNull(stu.getM8()).doubleValue());
            row.createCell(13).setCellValue(TargetService.vaildataNull(stu.getM9()).doubleValue());
            row.createCell(14).setCellValue(TargetService.vaildataNull(stu.getM10()).doubleValue());
            row.createCell(15).setCellValue(TargetService.vaildataNull(stu.getM11()).doubleValue());
            row.createCell(16).setCellValue(TargetService.vaildataNull(stu.getM12()).doubleValue());
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean excelsPerson(List<Target> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u76ee\u6807\u7c7b\u578b", "\u5e74\u4efd", "\u4eba\u5458", "\u4ea7\u54c1\u7c7b\u522b", "\u4ea7\u54c1\u5b50\u7c7b\u522b", "\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            Target stu = list.get(i);
            String[] vals = new String[]{stu.getTypeName(), String.valueOf(stu.getYear()), stu.getEmployeeName(), stu.getProductTypeName(), stu.getProductSubTypeName(), String.valueOf(TargetService.vaildataNull(stu.getM1())), String.valueOf(TargetService.vaildataNull(stu.getM2())), String.valueOf(TargetService.vaildataNull(stu.getM3())), String.valueOf(TargetService.vaildataNull(stu.getM4())), String.valueOf(TargetService.vaildataNull(stu.getM5())), String.valueOf(TargetService.vaildataNull(stu.getM6())), String.valueOf(TargetService.vaildataNull(stu.getM7())), String.valueOf(TargetService.vaildataNull(stu.getM8())), String.valueOf(TargetService.vaildataNull(stu.getM9())), String.valueOf(TargetService.vaildataNull(stu.getM10())), String.valueOf(TargetService.vaildataNull(stu.getM11())), String.valueOf(TargetService.vaildataNull(stu.getM12()))};
            int j = 0;
            while (j < vals.length) {
                row.createCell(j).setCellValue(vals[j]);
                ++j;
            }
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean exportCustomer(List<TargetWrap> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(String.valueOf(DateUtils.getCurrentDate((String)"yyyyMMdd")) + ".xls");
        HSSFCellStyle style = wb.createCellStyle();
        style.setVerticalAlignment((short)1);
        style.setAlignment((short)2);
        HSSFRow row = sheet.createRow(0);
        HSSFRow row2 = sheet.createRow(1);
        String[] name1 = new String[]{"\u76ee\u6807\u7c7b\u578b", "\u5355\u4f4d", "\u5e74\u4efd", "\u6e20\u9053", "\u5927\u533a", "\u533a\u57df", "\u5ba2\u6237"};
        String[] name2 = new String[]{"\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u7b2c\u4e00\u5b63\u5ea6", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u7b2c\u4e8c\u5b63\u5ea6", "\u524d\u534a\u5e74", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u7b2c\u4e09\u5b63\u5ea6", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708", "\u7b2c\u56db\u5b63\u5ea6", "\u540e\u534a\u5e74", "\u5168\u5e74"};
        String[] name3 = new String[]{"\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u53bb\u5e74\u5b8c\u6210\u7387", "\u4eca\u5e74\u5b8c\u6210\u7387", "\u589e\u957f\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387", "\u53bb\u5e74\u5b8c\u6210\u7387", "\u4eca\u5e74\u5b8c\u6210\u7387", "\u589e\u957f\u7387", "\u76ee\u6807", "\u5b9e\u9645", "\u5b8c\u6210\u7387"};
        int i = 0;
        while (i < name1.length) {
            sheet.addMergedRegion(new CellRangeAddress(0, 1, i, (int)((short)i)));
            HSSFCell cell = (HSSFCell)row.createCell((int)((short)i));
            cell.setCellValue(name1[i]);
            cell.setCellStyle(style);
            ++i;
        }
        int ce = name1.length;
        int i2 = 0;
        while (i2 < name2.length) {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, ce + i2 * 3, (short)ce + i2 * 3 + 2));
            HSSFCell cell = (HSSFCell)row.createCell((int)((short)(ce + i2 * 3)));
            cell.setCellValue(name2[i2]);
            cell.setCellStyle(style);
            ++i2;
        }
        i2 = 0;
        while (i2 < name3.length) {
            HSSFCell s1 = (HSSFCell)row2.createCell((short)ce + i2);
            s1.setCellValue(name3[i2]);
            s1.setCellStyle(style);
            ++i2;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private static Double vaildataNull(Double db) {
        if (db == null) {
            db = 0.0;
        }
        return db;
    }

    public List<Target> queryAllTargetByCustomer(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from Target t,Customer c where t.partnerId = ? and c.supplierId = t.partnerId and c.applyerId = t.objectId and t.objectType = '\u5ba2\u6237'");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(emp.getCurrentPartner().getId());
        String regions = this.personnelService.getFRegionsByUserId(emp.getId());
        hql.append(" and ( t.areaId in  (");
        hql.append(regions);
        hql.append(" )");
        hql.append("or t.bigareaId in(");
        hql.append(regions);
        hql.append(") )");
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.objectId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and c.partnerChnlType = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            hql.append(" and c.applyerName like ? ");
            args.add("%" + condition.getCustomerName() + "%");
        }
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rowsize, pageNo);
        return page.getList();
    }

    public List<TargetData> queryAllTargetDataByCustomer(TargetCondition condition, Employee emp, int pageNo, int rowsize) {
        StringBuffer hql = new StringBuffer();
        hql.append("select t from TargetData t,Partner p,Customer c where t.userId is null and p.id = t.supplierId and c.supplierId = t.supplierId and c.applyerId = t.applyerId ");
        ArrayList<Object> args = new ArrayList<Object>();
        String regions = this.personnelService.getFRegionsByUserId(emp.getId());
        hql.append(" and ( t.areaId in  (");
        hql.append(regions);
        hql.append(" )");
        hql.append("or t.bigareaId in(");
        hql.append(regions);
        hql.append(") )");
        if (condition.isPartner()) {
            hql.append(" and t.applyerId = ? ");
        } else {
            hql.append(" and t.supplierId = ? ");
        }
        args.add(emp.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(condition.getTargetType())) {
            hql.append(" and t.type = ? ");
            args.add(condition.getTargetType());
        }
        if (StringUtils.isNotEmpty(condition.getYear())) {
            hql.append(" and t.year = ? ");
            args.add(Long.valueOf(condition.getYear()));
        }
        if (StringUtils.isNotEmpty(condition.getObjectId())) {
            hql.append(" and t.userId = ? ");
            args.add(condition.getObjectId());
        }
        if (StringUtils.isNotEmpty(condition.getChannelType())) {
            hql.append(" and c.partnerChnlType = ? ");
            args.add(condition.getChannelType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getCustomerName())) {
            hql.append(" and c.applyerName like ? ");
            args.add("%" + condition.getCustomerName() + "%");
        }
        Page page = this.baseDao.search(hql.toString(), args.toArray(), rowsize, pageNo);
        return page.getList();
    }
}

