/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.targetdata;

import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.TargetData;
import com.tcbj.crm.targetdata.TargetDataCondition;
import com.tcbj.crm.targetdatae.TargetDataeService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.ProductCategory;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import com.tcbj.util.ValidataUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="targetDataService")
public class TargetDataService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    TargetDataeService targetDataeService;

    public TargetData get(String id) {
        return (TargetData)this.baseDao.get(TargetData.class, (Serializable)((Object)id));
    }

    public List<TargetData> getList(String supplierId, Long year) {
        StringBuffer hql = new StringBuffer();
        hql.append(" from TargetData o where o.supplierId = ? and o.year = ? and o.userId is null ");
        return this.baseDao.findEntity(hql.toString(), new Object[]{supplierId, year}, TargetData.class);
    }

    public TargetData findTargetData(String type, Long year, String applyerId, String productType, String productSubType) {
        StringBuffer hql = new StringBuffer("from TargetData where type = ? and year = ? and applyerId = ? and userId is null ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(type);
        args.add(year);
        args.add(applyerId);
        if (StringUtils.isNotEmpty(productType)) {
            hql.append(" and productType = ? ");
            args.add(productType);
        } else {
            hql.append(" and productType is null ");
        }
        if (StringUtils.isNotEmpty(productSubType)) {
            hql.append(" and productSubType = ? ");
            args.add(productSubType);
        } else {
            hql.append(" and productSubType is null ");
        }
        return (TargetData)this.baseDao.findFirstEntity(hql.toString(), args.toArray(), TargetData.class);
    }

    public void save(TargetData obj) {
        this.baseDao.save((Object)obj);
    }

    public Page getPage(String orgid, int pageno, TargetDataCondition condition) {
        String sb = this.personnelService.getFRegionsByUserId(condition.getUserId());
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("select o from TargetData o,Customer c where o.supplierId = ? and o.userId is null ");
        args.add(condition.getPartnerId());
        hql.append(" and o.applyerId = c.applyerId ");
        hql.append(" and (c.bigAreaCode in ( ");
        hql.append(sb);
        hql.append(") or c.areaCode in ( ");
        hql.append(sb);
        hql.append(" ))");
        if (StringUtils.isNotNull(condition.getYear())) {
            hql.append(" and o.year = ? ");
            args.add(condition.getYear());
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getType())) {
            hql.append(" and o.type = ? ");
            args.add(condition.getType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        hql.append(" order by o.year desc desc");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public List<TargetData> getList(String orgid, TargetDataCondition condition) {
        String sb = this.personnelService.getFRegionsByUserId(condition.getUserId());
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("select o from TargetData o,Customer c where o.supplierId = ? and o.userId is null ");
        args.add(condition.getPartnerId());
        hql.append(" and o.applyerId = c.applyerId ");
        hql.append(" and (c.bigAreaCode in ( ");
        hql.append(sb);
        hql.append(") or c.areaCode in ( ");
        hql.append(sb);
        hql.append(" ))");
        if (StringUtils.isNotNull(condition.getYear())) {
            hql.append(" and o.year = ? ");
            args.add(condition.getYear());
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getType())) {
            hql.append(" and o.type = ? ");
            args.add(condition.getType());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ? ");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and c.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        hql.append(" order by o.year desc desc");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), TargetData.class);
    }

    public void update(TargetData obj) {
        this.baseDao.update((Object)obj);
    }

    public void update(String hql) {
        this.baseDao.executeHQL(hql);
    }

    public void delete(String id) {
        TargetData targetData = (TargetData)this.baseDao.get(TargetData.class, (Serializable)((Object)id));
        this.baseDao.deleteById(TargetData.class, (Serializable)((Object)id));
        this.targetDataeService.delete(targetData);
    }

    public void update(List<TargetData> list, Long year, Employee me, Map<String, TargetData> map) {
        TargetData t1 = null;
        TargetData t2 = null;
        this.targetDataeService.add(list, me);
        int k = 0;
        while (k < list.size()) {
            String updateHql = "";
            t1 = list.get(k);
            String s1 = String.valueOf(t1.getType()) + t1.getYear().toString() + t1.getApplyerId() + (t1.getProductType() == "" ? "null" : t1.getProductType()) + (t1.getProductSubType() == "" ? "null" : t1.getProductSubType());
            if (map.get(s1) == null) {
                this.baseDao.save((Object)t1);
            } else {
                t2 = map.get(s1);
                if (!(updateHql = String.valueOf(updateHql) + this.addHql(t1, t2)).equals("")) {
                    this.baseDao.executeSQL(updateHql);
                }
            }
            ++k;
        }
    }

    private String addHql(TargetData t1, TargetData t2) {
        StringBuffer hql = new StringBuffer("");
        String hql2 = "";
        boolean change = false;
        if (Double.compare(t1.getM1(), t2.getM1()) != 0) {
            hql.append(" m1 = '").append(String.valueOf(t1.getM1())).append("',");
            change = true;
        }
        if (Double.compare(t1.getM2(), t2.getM2()) != 0) {
            hql.append(" m2 = '").append(t1.getM2()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM3(), t2.getM3()) != 0) {
            hql.append(" m3 = '").append(t1.getM3()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM4(), t2.getM4()) != 0) {
            hql.append(" m4 = '").append(t1.getM4()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM5(), t2.getM5()) != 0) {
            hql.append(" m5 = '").append(t1.getM5()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM6(), t2.getM6()) != 0) {
            hql.append(" m6 = '").append(t1.getM6()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM7(), t2.getM7()) != 0) {
            hql.append(" m7 = '").append(t1.getM7()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM8(), t2.getM8()) != 0) {
            hql.append(" m8 = '").append(t1.getM8()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM9(), t2.getM9()) != 0) {
            hql.append(" m9 = '").append(t1.getM9()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM10(), t2.getM10()) != 0) {
            hql.append(" m10 = '").append(t1.getM10()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM11(), t2.getM11()) != 0) {
            hql.append(" m11 = '").append(t1.getM11()).append("',");
            change = true;
        }
        if (Double.compare(t1.getM12(), t2.getM12()) != 0) {
            hql.append(" m12 = '").append(t1.getM12()).append("',");
            change = true;
        }
        if (change) {
            hql2 = "update CX_TARGET_DATA set ";
            hql2 = String.valueOf(hql2) + hql.toString().substring(0, hql.toString().length() - 1);
            hql2 = String.valueOf(hql2) + " where row_id = '" + t2.getId() + "'";
        }
        return hql2;
    }

    public void update(List<TargetData> targetDatas, String delIds, Employee me) {
        try {
            String[] ids;
            String[] stringArray = ids = delIds.split(",");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (!StringUtils.isEmpty(id)) {
                    Object[] args = new Object[]{id};
                    TargetData targetData = this.get(id);
                    this.baseDao.executeHQL("delete TargetData where id= ?", args);
                    this.targetDataeService.delete(targetData);
                }
                ++n2;
            }
            for (TargetData targetData : targetDatas) {
                targetData.fillInitData(me);
                targetData.setSupplierId(me.getCurrentPartner().getId());
                targetData.setChannelId(Cache.getRegions(targetData.getBigareaId()).getParentId());
                if (StringUtils.isEmpty(targetData.getId())) {
                    this.baseDao.save((Object)targetData);
                    continue;
                }
                this.baseDao.update((Object)targetData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> getCustomerMap(String parentId) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append("from Customer where supplierId = ? ");
        Object[] args = new Object[]{parentId};
        List list = this.baseDao.findEntity(sb.toString(), args, Customer.class);
        for (Customer customer : list) {
            map.put(customer.getApplyerCode(), customer.getApplyerId());
        }
        return map;
    }

    public List<AdjustStockUtil> validate(Long year, List<List<Object>> readExcelList, Employee emp, List<TargetData> list) {
        ArrayList<AdjustStockUtil> msglist = new ArrayList<AdjustStockUtil>();
        Map<String, String> customerMap = this.getCustomerMap(emp.getCurrentPartner().getId());
        List<DictionaryItem> items = Cache.getItems("TCBJ_PACT_TARGET_TYPE");
        HashMap<String, String> itemsMap = new HashMap<String, String>();
        for (DictionaryItem dictionaryItem : items) {
            itemsMap.put(dictionaryItem.getVal(), dictionaryItem.getName());
        }
        List pcs = this.baseDao.findEntity("from ProductCategory", ProductCategory.class);
        HashMap<String, String> pcsMap = new HashMap<String, String>();
        for (ProductCategory productCategory : pcs) {
            pcsMap.put(productCategory.getName(), productCategory.getId());
        }
        int j = 0;
        while (j < readExcelList.size()) {
            List<Object> data = readExcelList.get(j);
            String result = null;
            String message = null;
            TargetData targetData = new TargetData();
            int i = 0;
            while (i < data.size()) {
                switch (i) {
                    case 0: {
                        message = ValidataUtils.validataMap((Object)data.get(i), itemsMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u76ee\u6807\u7c7b\u578b \uff1a" + message;
                            break;
                        }
                        targetData.setType((String)itemsMap.get(data.get(i).toString().trim()));
                        break;
                    }
                    case 1: {
                        targetData.setYear(year);
                        break;
                    }
                    case 2: {
                        message = ValidataUtils.validataMap((Object)data.get(i), customerMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u5ba2\u6237\u52a9\u8bb0\u7801 \uff1a" + message;
                            break;
                        }
                        targetData.setApplyerId(customerMap.get(data.get(i).toString().trim()));
                        break;
                    }
                    case 4: {
                        message = ValidataUtils.validateMapOrNull((Object)data.get(i), pcsMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u4ea7\u54c1\u7c7b\u522b \uff1a" + message;
                            break;
                        }
                        targetData.setProductType(pcsMap.get(data.get(i).toString().trim()) == null ? "" : (String)pcsMap.get(data.get(i).toString().trim()));
                        break;
                    }
                    case 5: {
                        message = ValidataUtils.validateMapOrNull((Object)data.get(i), pcsMap);
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " \u4ea7\u54c1\u5b50\u7c7b\u522b \uff1a" + message;
                            break;
                        }
                        targetData.setProductSubType(pcsMap.get(data.get(i).toString().trim()) == null ? "" : (String)pcsMap.get(data.get(i).toString().trim()));
                        break;
                    }
                    case 6: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 1\u6708 \uff1a" + message;
                        } else {
                            targetData.setM1(this.toDouble(data.get(i)));
                        }
                    }
                    case 7: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 2\u6708 \uff1a" + message;
                        } else {
                            targetData.setM2(this.toDouble(data.get(i)));
                        }
                    }
                    case 8: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 3\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM3(this.toDouble(data.get(i)));
                        break;
                    }
                    case 9: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 4\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM4(this.toDouble(data.get(i)));
                        break;
                    }
                    case 10: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 5\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM5(this.toDouble(data.get(i)));
                        break;
                    }
                    case 11: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 6\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM6(this.toDouble(data.get(i)));
                        break;
                    }
                    case 12: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 7\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM7(this.toDouble(data.get(i)));
                        break;
                    }
                    case 13: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 8\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM8(this.toDouble(data.get(i)));
                        break;
                    }
                    case 14: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 9\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM9(this.toDouble(data.get(i)));
                        break;
                    }
                    case 15: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 10\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM10(this.toDouble(data.get(i)));
                        break;
                    }
                    case 16: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 11\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM11(this.toDouble(data.get(i)));
                        break;
                    }
                    case 17: {
                        message = ValidataUtils.validataDouble((Object)data.get(i));
                        if (message != null) {
                            result = String.valueOf(result == null ? "" : result) + " 12\u6708 \uff1a" + message;
                            break;
                        }
                        targetData.setM12(this.toDouble(data.get(i)));
                        break;
                    }
                }
                ++i;
            }
            if (result != null) {
                msglist.add(new AdjustStockUtil("\u7b2c" + (j + 2) + "\u884c:" + result));
            }
            Customer customer = Cache.getCustomer(String.valueOf(emp.getCurrentPartner().getId()) + "-" + targetData.getApplyerId());
            targetData.setChannelId(Cache.getRegions(customer.getBigAreaCode()).getParentId());
            targetData.setBigareaId(customer.getBigAreaCode());
            targetData.setAreaId(customer.getAreaCode());
            targetData.setSupplierId(emp.getCurrentPartner().getId());
            list.add(targetData);
            ++j;
        }
        TargetData t1 = null;
        TargetData t2 = null;
        String s1 = null;
        String s2 = null;
        int k = 0;
        while (k < list.size()) {
            t1 = list.get(k);
            s1 = String.valueOf(t1.getType()) + (t1.getYear() == null ? "0" : t1.getYear().toString()) + t1.getApplyerId() + t1.getProductType() + t1.getProductSubType();
            int k2 = k + 1;
            while (k2 < list.size()) {
                t2 = list.get(k2);
                s2 = String.valueOf(t2.getType()) + (t2.getYear() == null ? "0" : t2.getYear().toString()) + t2.getApplyerId() + t2.getProductType() + t2.getProductSubType();
                if (s1.equals(s2)) {
                    msglist.add(new AdjustStockUtil("\u7b2c" + (k + 1) + "\u548c" + (k2 + 1) + "\u884c\u6570\u636e\u91cd\u590d"));
                }
                ++k2;
            }
            ++k;
        }
        return msglist;
    }

    private Double toDouble(Object object) {
        return Double.parseDouble(String.valueOf(object).trim() == null || "".equals(String.valueOf(object).trim()) ? "0" : String.valueOf(object).trim());
    }

    public boolean excels(List<TargetData> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u76ee\u6807\u7c7b\u578b", "\u5e74\u4efd", "\u5ba2\u6237\u52a9\u8bb0\u7801", "\u5ba2\u6237\u540d\u79f0", "\u4ea7\u54c1\u7c7b\u522b", "\u4ea7\u54c1\u5b50\u7c7b\u522b", "\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            TargetData stu = list.get(i);
            String[] vals = new String[]{stu.getTypeName(), String.valueOf(stu.getYear()), stu.getApplyerCode(), stu.getApplyerName(), stu.getProductTypeName(), stu.getProductSubTypeName(), this.vaildataNull(stu.getM1()), this.vaildataNull(stu.getM2()), this.vaildataNull(stu.getM3()), this.vaildataNull(stu.getM4()), this.vaildataNull(stu.getM5()), this.vaildataNull(stu.getM6()), this.vaildataNull(stu.getM7()), this.vaildataNull(stu.getM8()), this.vaildataNull(stu.getM9()), this.vaildataNull(stu.getM10()), this.vaildataNull(stu.getM11()), this.vaildataNull(stu.getM12())};
            int j = 0;
            while (j < vals.length) {
                row.createCell(j).setCellValue(vals[j]);
                ++j;
            }
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private String vaildataNull(Double db) {
        if (db == null) {
            return "0";
        }
        return String.valueOf(db);
    }
}

