/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.targetdatae;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.TargetData;
import com.tcbj.crm.targetdatae.TargetDataeCondition;
import com.tcbj.crm.targetdatae.TargetDataeService;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/targetdatae"})
public class TargetDataeController
extends BaseController {
    @Autowired
    TargetDataeService service;

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, TargetDataeCondition condition, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        if (condition.getYear() == null) {
            condition.setYear(Long.valueOf(DateUtils.getYear()));
        }
        condition.setPartnerId(e.getCurrentPartner().getId());
        model.addAttribute("list", this.service.getList(condition));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        return "targetdatae/list.ftl";
    }

    @RequestMapping(value={"batchedit.do"}, method={RequestMethod.GET})
    public String editsGet() {
        return "targetdatae/batchedit.ftl";
    }

    @RequestMapping(value={"/editTarget.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page editGifts(TargetDataeCondition condition, int pageno) {
        Employee e = this.getCurrentEmployee();
        condition.setPartnerId(e.getCurrentPartner().getId());
        return this.service.getPage(e.getCurrentPartner().getId(), pageno, condition);
    }

    @RequestMapping(value={"/editTarget.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPostGrd(@Valid @RequestBody TargetDataeCondition wrap) throws Exception {
        Employee me = this.getCurrentEmployee();
        String delIds = wrap.getDelIds();
        List<TargetData> targetData = wrap.getTargetDatae();
        this.service.update(targetData, delIds, me);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String addGet(Model model, HttpServletRequest request) throws Exception {
        model.addAttribute("date", (Object)DateUtils.formartDate((Date)new Date(), (String)"yyyy"));
        return "targetdatae/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    public String addPost(Long year, Model model, HttpServletRequest request) {
        String rtn = null;
        String url = "";
        List<IUploadFile> filelist = this.uploadFile(request, "targetdatae");
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        ArrayList<TargetData> list = new ArrayList<TargetData>();
        List<AdjustStockUtil> msglist = this.getFileReadyExcel(year, list, url);
        if (list.size() <= 0 && msglist.size() <= 0) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        this.service.saveOrUpdate(list, this.getCurrentEmployee().getCurrentPartner().getId(), year);
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:"));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String editGet(String id, Model model, HttpServletRequest request) throws Exception {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        TargetData targetData = this.service.get(id);
        model.addAttribute("master", (Object)targetData);
        return "targetdatae/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPost(@Valid @RequestBody TargetData targetData, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        targetData.fillInitData(e);
        this.service.update(targetData);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String deleteGet(String id, Model model, HttpServletRequest request) {
        this.service.delete(id);
        return "redirect:/targetdatae/list.do";
    }

    public List<AdjustStockUtil> getFileReadyExcel(Long year, List<TargetData> list, String url) {
        Employee emp = this.getCurrentEmployee();
        LinkedList<List<Object>> readExcelList = new LinkedList();
        readExcelList = ExcelHandle.readExcel(url);
        List<AdjustStockUtil> msglist = this.service.validate(year, readExcelList, emp, list);
        return msglist;
    }

    @RequestMapping(value={"/listExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void excel(TargetDataeCondition condition, HttpServletRequest request, HttpServletResponse response) {
        Employee e = this.getCurrentEmployee();
        if (condition.getYear() == null) {
            condition.setYear(Long.valueOf(DateUtils.getYear()));
        }
        condition.setPartnerId(e.getCurrentPartner().getId());
        List<TargetData> list = this.service.getList(condition);
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "target");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.service.excel(list, dir.getPath(), String.valueOf(e.getCurrentPartner().getNo()) + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
    }
}

