/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.targetover;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.client.ClientCondition;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.entity.TargeteOver;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.targetover.TargeteOverCondition;
import com.tcbj.crm.targetover.TargeteOverService;
import com.tcbj.framework.util.Page;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/targetover"})
public class TargeteOverController
extends BaseController {
    @Autowired
    TargeteOverService service;
    @Autowired
    ClientService clientService;

    @RequestMapping(value={"list.do"})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, ClientCondition con, Model model) {
        con.setPartnerId(this.getCurrentEmployee().getCurrentPartner().getId());
        con.setEmployeeId(this.getCurrentEmployee().getId());
        Page page = this.service.findPartnerApplysValid(con, pageno);
        model.addAttribute("page", (Object)page);
        model.addAttribute("con", (Object)con);
        return "targetover/list.ftl";
    }

    @RequestMapping(value={"edit.do"}, method={RequestMethod.GET})
    public String edit_get(TargeteOverCondition con, String returnYear, String partnerId, Model model) {
        con.setPartnerId(partnerId);
        con.setOrgId(this.getCurrentEmployee().getCurrentPartner().getId());
        if (StringUtils.isEmpty(returnYear)) {
            con.setYear(String.valueOf(DateUtils.getYear()));
        } else {
            con.setYear(returnYear);
        }
        List<TargeteOver> tss = this.service.getTargetSplits(con);
        model.addAttribute("overList", (Object)JSON.toJSONString(tss));
        model.addAttribute("con", (Object)con);
        return "targetover/edit.ftl";
    }

    @RequestMapping(value={"edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post(@Valid @RequestBody TargeteOverCondition con, BindingResult errors, Model model, HttpServletRequest request) {
        if (StringUtils.isNotEmpty(con.getDelIds())) {
            String[] stringArray = con.getDelIds().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.service.del(id);
                ++n2;
            }
        }
        List<TargeteOver> list = con.getOverList();
        for (TargeteOver ts : list) {
            boolean isExist = this.service.isExist(con.getPartnerId(), con.getYear(), ts.getType(), ts.getUserId(), ts.getId());
            if (!isExist) continue;
            throw new AppException("0010", "\u8be5\u7ecf\u9500\u5546\u540c\u4e00\u5e74\u4efd\u3001\u540c\u4e00\u76ee\u6807\u7c7b\u578b\u7684\u4eba\u5458\u5206\u89e3\u6bd4\u5217\u4e0d\u552f\u4e00\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        this.service.saveAndUpdate(con, this.getCurrentEmployee());
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"del.do"})
    public String del(String id) {
        this.service.del(id);
        return "redirect:list.do";
    }
}

